/*
 * Decompiled with CFR 0.152.
 */
package img2md;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import img2md.ImageInsertSettingsPanel;
import img2md.ImageUtils;
import img2md.QiniuUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class PasteImageFromClipboard
extends AnAction {
    private static final String DOC_BASE_NAME = "{document_name}";

    public void actionPerformed(AnActionEvent e) {
        System.out.println("\u52a0\u8f7daction" + new Date().toString());
        Image imageFromClipboard = ImageUtils.getImageFromClipboard();
        Editor ed = (Editor)e.getData(PlatformDataKeys.EDITOR);
        if (ed == null) {
            return;
        }
        if (imageFromClipboard == null) {
            DialogBuilder builder = new DialogBuilder();
            builder.setCenterPanel((JComponent)new JLabel("Clipboard does not contain any image"));
            builder.setDimensionServiceKey("PasteImageFromClipboard.NoImage");
            builder.setTitle("No image in Clipboard");
            builder.removeAllActions();
            builder.addOkAction();
            builder.show();
            return;
        }
        boolean yes = PropertiesComponent.getInstance().getBoolean("yes");
        String callback_url = PropertiesComponent.getInstance().getValue("CALLBACK_URL");
        if (yes) {
            Document currentDoc = FileEditorManager.getInstance((Project)ed.getProject()).getSelectedTextEditor().getDocument();
            VirtualFile currentFile = FileDocumentManager.getInstance().getFile(currentDoc);
            try {
                File curDocument = new File(currentFile.getPath());
                BufferedImage bufferedImage = ImageUtils.toBufferedImage(imageFromClipboard);
                if (bufferedImage == null) {
                    return;
                }
                String imageName = "";
                String mdBaseName = curDocument.getName().replace(".md", "").replace(".Rmd", "");
                String dirPattern = "images";
                File imageDir = new File(curDocument.getParent(), dirPattern.replace(DOC_BASE_NAME, mdBaseName));
                if (!imageDir.exists() || !imageDir.isDirectory()) {
                    imageDir.mkdirs();
                }
                File imageFile = new File(imageDir, imageName + ".png");
                ImageUtils.save(bufferedImage, imageFile, "png");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
                String temp = sdf.format(new Date());
                String imagepath = imageName + temp + ".png";
                String imageurl = callback_url + imagepath;
                QiniuUtil.putFile("images", "images/" + imagepath, imageFile.getPath());
                this.insertImageElement(ed, imageurl);
            }
            catch (Exception eee) {
                eee.printStackTrace();
            }
        } else {
            Document currentDoc = FileEditorManager.getInstance((Project)ed.getProject()).getSelectedTextEditor().getDocument();
            VirtualFile currentFile = FileDocumentManager.getInstance().getFile(currentDoc);
            File curDocument = new File(currentFile.getPath());
            BufferedImage bufferedImage = ImageUtils.toBufferedImage(imageFromClipboard);
            if (bufferedImage == null) {
                return;
            }
            Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            ImageInsertSettingsPanel insertSettingsPanel = PasteImageFromClipboard.showDialog(curDocument, dimension);
            if (insertSettingsPanel == null) {
                return;
            }
            String imageName = insertSettingsPanel.getNameInput().getText();
            boolean whiteAsTransparent = insertSettingsPanel.getWhiteCheckbox().isSelected();
            boolean roundCorners = insertSettingsPanel.getRoundCheckbox().isSelected();
            double scalingFactor = (double)((Integer)insertSettingsPanel.getScaleSpinner().getValue()).intValue() * 0.01;
            if (whiteAsTransparent) {
                bufferedImage = ImageUtils.toBufferedImage(ImageUtils.whiteToTransparent(bufferedImage));
            }
            if (roundCorners) {
                bufferedImage = ImageUtils.toBufferedImage(ImageUtils.makeRoundedCorner(bufferedImage, 20));
            }
            if (scalingFactor != 1.0) {
                bufferedImage = ImageUtils.scaleImage(bufferedImage, (int)Math.round((double)bufferedImage.getWidth() * scalingFactor), (int)Math.round((double)bufferedImage.getHeight() * scalingFactor));
            }
            String mdBaseName = curDocument.getName().replace(".md", "").replace(".Rmd", "");
            String dirPattern = insertSettingsPanel.getDirectoryField().getText();
            File imageDir = new File(curDocument.getParent(), dirPattern.replace(DOC_BASE_NAME, mdBaseName));
            if (!imageDir.exists() || !imageDir.isDirectory()) {
                imageDir.mkdirs();
            }
            File imageFile = new File(imageDir, imageName + ".png");
            ImageUtils.save(bufferedImage, imageFile, "png");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
            String temp = sdf.format(new Date());
            String imagepath = imageName + temp + ".png";
            QiniuUtil.putFile("images", "images/" + imagepath, imageFile.getPath());
            String imageurl = callback_url + imagepath;
            try {
                File file = new File(System.getProperty("user.dir"));
                URL url = file.toURI().toURL();
                URLClassLoader loader = new URLClassLoader(new URL[]{url});
                System.out.println("loader");
                Class<?> cls = loader.loadClass("Main");
                Object obj = cls.newInstance();
                Method method = cls.getMethod("sendpic", String.class);
                method.invoke(obj, imagepath);
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
            this.insertImageElement(ed, imageurl);
            VirtualFile fileByPath = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(imageFile);
            assert (fileByPath != null);
            AbstractVcs usedVcs = ProjectLevelVcsManager.getInstance((Project)ed.getProject()).getVcsFor(fileByPath);
            if (usedVcs != null && usedVcs.getCheckinEnvironment() != null) {
                usedVcs.getCheckinEnvironment().scheduleUnversionedFilesForAddition(Collections.singletonList(fileByPath));
            }
            PropertiesComponent.getInstance().setValue("PI__LAST_DIR_PATTERN", dirPattern);
            PropertiesComponent.getInstance().setValue("PI__DIR_PATTERN_FOR_" + currentFile.getPath(), dirPattern);
        }
    }

    private void insertImageElement(@NotNull Editor editor, String imageurl) {
        if (editor == null) {
            PasteImageFromClipboard.$$$reportNull$$$0(0);
        }
        Runnable r = () -> {
            if (editor == null) {
                PasteImageFromClipboard.$$$reportNull$$$0(1);
            }
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("![](" + imageurl + ")"));
        };
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (Runnable)r);
    }

    private static ImageInsertSettingsPanel showDialog(File curDocument, final Dimension imgDim) {
        boolean isOk;
        DialogBuilder builder = new DialogBuilder();
        final ImageInsertSettingsPanel contentPanel = new ImageInsertSettingsPanel();
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double scalingFactor = (double)((Integer)contentPanel.getScaleSpinner().getValue()).intValue() * 0.1;
                JLabel targetSizeLabel = contentPanel.getTargetSizeLabel();
                if (scalingFactor == 100.0) {
                    targetSizeLabel.setText(imgDim.getWidth() + " x " + imgDim.getHeight());
                } else {
                    long newWidth = Math.round(imgDim.getWidth() * scalingFactor);
                    long newHeight = Math.round(imgDim.getHeight() * scalingFactor);
                    targetSizeLabel.setText(newWidth + " x " + newHeight);
                }
            }
        };
        listener.stateChanged(null);
        contentPanel.getScaleSpinner().addChangeListener(listener);
        String dirPattern = "images";
        contentPanel.getDirectoryField().setText(dirPattern);
        contentPanel.getNameInput().setText(UUID.randomUUID().toString().substring(0, 8));
        builder.setCenterPanel((JComponent)contentPanel);
        builder.setDimensionServiceKey("GrepConsoleSound");
        builder.setTitle("Paste Image Settings");
        builder.removeAllActions();
        builder.addOkAction();
        builder.addCancelAction();
        builder.setPreferredFocusComponent((JComponent)contentPanel.getNameInput());
        boolean bl = isOk = builder.show() == 0;
        if (!isOk) {
            return null;
        }
        return contentPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "editor";
        objectArray2[1] = "img2md/PasteImageFromClipboard";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertImageElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$insertImageElement$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

