
cd ~/Library/MobileDevice/Provisioning\ Profiles

file=(`find . -name "*.mobileprovision" -print`)

for item in ${file[@]}
do

plist="${item}.plist"
ePlist="${item}.Entitlements.plist"

echo `security cms -D -i ${item}` > $plist

entitlements=`/usr/libexec/PlistBuddy -x -c "Print :Entitlements" ${plist}`
echo "${entitlements}" > ${ePlist}

fileName=`/usr/libexec/PlistBuddy -c "Print :Name" ${plist}`
teamName=`/usr/libexec/PlistBuddy -c "Print :TeamName" ${plist}`
uuid=`/usr/libexec/PlistBuddy -c "Print :UUID" ${plist}`
bundleID=`/usr/libexec/PlistBuddy -c "Print :application-identifier" ${ePlist}`
environment=`/usr/libexec/PlistBuddy -c "Print :aps-environment" ${ePlist}`
teamID=`/usr/libexec/PlistBuddy -c "Print :com.apple.developer.team-identifier" ${ePlist}`
bundleID="${bundleID#*.}"
getTaskAllow=`/usr/libexec/PlistBuddy -c "Print :get-task-allow" ${ePlist}`

if [ "$environment" = "" ]; then

    if [ "$getTaskAllow" = "true" ]; then
        environment="development"
    fi

    if [ "$getTaskAllow" = "false" ]; then
        environment="production"
    fi
fi

echo "${bundleID}&${environment}&${fileName}&${uuid}&${teamName}&${teamID}"

rm $plist
#rm ${ePlist}

done
