<?php
namespace gateway\wx_pay;

use app\common\lib\Plugin;
use gateway\wx_pay\lib\PaymentService;
use think\facade\Db;

class WxPay extends Plugin
{
    // 插件基础信息
    public $info = array(
        'name'        => 'WxPay', // 必填 插件标识(唯一)
        'title'       => '微信支付', // 必填 插件显示名称
        'description' => '微信支付', // 必填 插件功能描述
        'author'      => '智简魔方', // 必填 插件作者
        'version'     => '1.0.0',  // 必填 插件版本
        'help_url'    => '', // 选填 申请链接
        'author_url'  => '', // 选填 作者链接
        'url'         => '', // 选填 图标地址(可以自定义支付图片地址)
    );

    // 临时订单生成规则,1:毫秒时间戳+8位随机数(21-22位长度订单号,默认规则),2:时间戳+8位随机数(18位长度订单号),3:10位随机数(10位长度订单号)
    public $orderRule=1;

    // 插件安装
    public function install()
    {
        return true;//安装成功返回true，失败false
    }

    // 插件卸载
    public function uninstall()
    {
        // 在这里不要try catch数据库异常，直接抛出上层会处理异常后回滚的
        return true;//卸载成功返回true，失败false
    }

    public function WxPayHandle($param)
    {
        $config = $this->config();

        if(in_array('wap', $config['product']) && $this->isMobile() && strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')===false){
            return $this->wapPay($config, $param);
        }elseif(in_array('native', $config['product'])){
            return $this->nativePay($config, $param);
        }elseif(in_array('jsapi', $config['product'])){
            return $this->jsapiPay($config, $param);
        }else{
            throw new \Exception('未选择任何可用的支付产品');
        }
    }

    private function nativePay($config, $param){
        
        $domain = configuration('website_url');

        $subject = $param['product'][0]??('订单'.$param['out_trade_no']);

        $params = [
            'body' => $subject,
            'out_trade_no' => $param['out_trade_no'],
            'total_fee' => strval($param['finance']['total']*100),
            'spbill_create_ip' => get_client_ip(),
            'notify_url' => $domain . '/gateway/wx_pay/index/notifyHandle',
            'product_id' => '01001',
        ];
        $client = new PaymentService($config);
        try{
            $result = $client->nativePay($params);
            $code_url = $result['code_url'];
        }catch(\Exception $e){
            throw new \Exception('微信支付下单失败:'.$e->getMessage());
        }

        require_once 'lib/phpqrcode.php';
        $response = \QRcode::png($code_url,false,0,4,0,false);
        $base64 = 'data:png;base64,' . base64_encode($response->getData());

        return '<img src="'. $base64 .'" alt="" width="120" height="120">';
    }

    private function jsapiPay($config, $param){
        cache('wxjspay_'.$param['out_trade_no'], $param, 600);

        $domain = configuration('website_url');
        $url = $domain . '/gateway/wx_pay/index/jsapipay?orderid='.$param['out_trade_no'];

        if(strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger')!==false){
            $html_text = '<a href="'.$url.'" target="_blank" class="btn btn-success el-button el-button--success" id="submitpay">立即支付</a>';
            return $html_text;
        }else{
            require_once 'lib/phpqrcode.php';
            $response = \QRcode::png($url,false,0,4,0,false);
            $base64 = 'data:png;base64,' . base64_encode($response->getData());

            return '<img src="'. $base64 .'" alt="" width="120" height="120">';
        }
    }

    private function wapPay($config, $param){
        
        $domain = configuration('website_url');

        $subject = isset($param['product'][0])?$param['product'][0]:'商品';

        $scene_info = [
            'h5_info' => [
                'type' => 'Wap',
                'wap_url' => $domain,
                'wap_name' => configuration('company_name')
            ]
        ];
        $params = [
            'body' => $subject,
            'out_trade_no' => $param['out_trade_no'],
            'total_fee' => strval($param['finance']['total']*100),
            'spbill_create_ip' => get_client_ip(),
            'notify_url' => $domain . '/gateway/wx_pay/index/notifyHandle',
            'scene_info' => json_encode($scene_info, JSON_UNESCAPED_UNICODE),
        ];
        $client = new PaymentService($config);
        try{
            $result = $client->h5Pay($params);
            $redirect_url = $domain . '/gateway/wx_pay/index/returnHandle';
            $url = $result['mweb_url'].'&redirect_url='.urlencode($redirect_url);
        }catch(\Exception $e){
            throw new \Exception('微信支付下单失败:'.$e->getMessage());
        }

        $html_text = '<a href="'.$url.'" target="_blank" class="btn btn-success el-button el-button--success" id="submitpay">立即支付</a>';
        return $html_text;
    }

    public function WxPayHandleRefund($param)
    {
        $config = $this->config();

        $params = [
            'transaction_id' => $param['transaction_number'],
            'out_refund_no' => $param['out_request_no'],
            'total_fee' => strval($param['total_fee']*100),
            'refund_fee' => strval($param['amount']*100),
        ];
        $client = new PaymentService($config);
        try{
            $result = $client->refund($params);
            
            return ['status'=>200,'msg'=>'退款成功','data'=>['trade_no'=>$result['transaction_id']]];
        }catch(\Exception $e){
            return ['status'=>400,'msg'=>$e->getMessage()];
        }
    }

    public function config()
    {
        $config = Db::name('plugin')->where('name', $this->info['name'])->value('config');
        if (!empty($config) && $config != "null") {
            $config = json_decode($config, true);
        } else {
            throw new \Exception('请先将配置好商户信息');
        }

        $product = [];
        if($config['ProductNative'] == 1) $product[] = 'native';
        if($config['ProductJsapi'] == 1) $product[] = 'jsapi';
        if($config['ProductWap'] == 1) $product[] = 'wap';
        
        return [
            'appid' => $config['AppId'],
            'mchid' => $config['MerchantId'],
            'apikey' => $config['Key'],
            'appsecret' => $config['AppSecret'],
            'product' => $product,
            'sslcert_path' => IDCSMART_ROOT.'config/apiclient_cert.pem',
            'sslkey_path' => IDCSMART_ROOT.'config/apiclient_key.pem',
        ];
    }

    private function isMobile()
    {
        $useragent = strtolower($_SERVER['HTTP_USER_AGENT']);
        $ualist = array('android', 'midp', 'nokia', 'mobile', 'iphone', 'ipod', 'blackberry', 'windows phone');
        foreach($ualist as $ua){
            if(strpos($useragent, $ua)!==false){
                return true;
            }
        }
        return false;
    }

}