<?php
namespace gateway\wx_pay\controller;

use app\home\controller\BaseController;
use gateway\wx_pay\AliPay;
use gateway\wx_pay\WxPay;
use gateway\wx_pay\lib\PaymentService;
use gateway\wx_pay\lib\JsApiTool;
use think\facade\View;

class IndexController extends BaseController
{
    /**
     * 微信JSAPI支付
     */
    public function jsapipay()
    {
        $orderid = input('orderid');
        if(!$orderid) return $this->showerrmsg('no orderid');
        $param = cache('wxjspay_'.$orderid);
        if(!$param) return $this->showerrmsg('订单不存在或已超时');

        $class = new WxPay();
        $config = $class->Config();

        try{
			$tools = new JsApiTool($config['appid'], $config['appsecret']);
			$openid = $tools->GetOpenid();
		}catch(\Exception $e){
            return $this->showerrmsg($e->getMessage());
		}

        $domain = configuration('website_url');

        $subject = isset($param['product'][0])?$param['product'][0]:'商品';

        $params = [
            'body' => $subject,
            'out_trade_no' => $param['out_trade_no'],
            'total_fee' => strval($param['finance']['total']*100),
            'spbill_create_ip' => get_client_ip(),
            'notify_url' => $domain . '/gateway/wx_pay/index/notifyHandle',
            'openid' => $openid,
        ];
        $client = new PaymentService($config);
        try{
            $result = $client->jsapiPay($params);
            $jsapidata = json_encode($result);
        }catch(\Exception $e){
            return $this->showerrmsg('微信支付下单失败:'.$e->getMessage());
        }

        View::assign('company_name', configuration('website_name'));
        View::assign('jsapidata', $jsapidata);
        $tpl_path = WEB_ROOT.'plugins/gateway/wx_pay/template/jsapipay.tpl';
        return View::fetch($tpl_path);
    }

    private function showerrmsg($msg){
        View::assign('company_name', configuration('website_name'));
        View::assign('msg', $msg);
        $tpl_path = WEB_ROOT.'plugins/gateway/wx_pay/template/errmsg.tpl';
        return View::fetch($tpl_path);
    }

    /**
     * 异步回调
     */
    public function notifyHandle()
    {
        $isSuccess = true;
        $errmsg = null;
        $class = new WxPay();
        $config = $class->config();
        
        try{
			$client = new PaymentService($config);
			$result = $client->notify();

            $this->orderHandle($result);

            if(cache('wxjspay_'.$result['out_trade_no'])){
                cache('wxjspay_'.$result['out_trade_no'], null);
            }

		}catch(\Exception $e){
			$isSuccess = false;
			$errmsg = $e->getMessage();
		}

		$client->replyNotify($isSuccess, $errmsg);
        exit;

    }

    /**
     * 同步回调
     */
    public function returnHandle()
    {
        return redirect('/finance.htm');
    }

    /**
     * 处理订单
     */
    private function orderHandle($data)
    {
        $up_data = [];
        $up_data['tmp_order_id'] = $data['out_trade_no'];   // 订单ID
        $up_data['amount'] = $data['total_fee']/100;         // 订单总价
        $up_data['trans_id'] = $data['transaction_id'];           // 交易流水号
        $up_data['currency'] = $data['fee_type'] ?? 'CNY';  // 货币
        $up_data['paid_time'] = $data['time_end'];       // 支付时间
        $up_data['gateway'] = 'WxPay';                  // 支付网关名称
        order_pay_handle($up_data);
    }

}