<?php
namespace oauth\qyweixin\sdk;

/**
 * Prpcrypt class
 *
 * 提供接收和推送给公众平台消息的加解密接口.
 */
class Prpcrypt
{
    public $key;
    public $iv;
    public function __construct($k)
    {
        $this->key = base64_decode($k . "=");
        $this->iv = substr($this->key, 0, 16);
    }
    public function encrypt($text, $receiveId)
    {
        try {
            $text = $this->getRandomStr() . pack("N", strlen($text)) . $text . $receiveId;
            $pkc_encoder = new PKCS7Encoder();
            $text = $pkc_encoder->encode($text);
            if (function_exists("openssl_encrypt")) {
                $encrypted = openssl_encrypt($text, "AES-256-CBC", $this->key, OPENSSL_ZERO_PADDING, $this->iv);
            } else {
                $encrypted = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $this->key, base64_decode($text), MCRYPT_MODE_CBC, $this->iv);
            }
            return [ErrorCode::$OK, $encrypted];
        } catch (\Exception $e) {
            return [MyErrorCode::$EncryptAESError, NULL];
        }
    }
    public function decrypt($encrypted, $receiveId)
    {
        try {
            if (function_exists("openssl_decrypt")) {
                $decrypted = openssl_decrypt($encrypted, "AES-256-CBC", $this->key, OPENSSL_ZERO_PADDING, $this->iv);
            } else {
                $decrypted = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $this->key, base64_decode($encrypted), MCRYPT_MODE_CBC, $this->iv);
            }
        } catch (\Exception $e) {
            return [ErrorCode::$DecryptAESError, NULL];
        }
        try {
            $pkc_encoder = new PKCS7Encoder();
            $result = $pkc_encoder->decode($decrypted);
            if (strlen($result) < 16) {
                return [];
            }
            $content = substr($result, 16, strlen($result));
            $len_list = unpack("N", substr($content, 0, 4));
            $xml_len = $len_list[1];
            $xml_content = substr($content, 4, $xml_len);
            $from_receiveId = substr($content, $xml_len + 4);
        } catch (\Exception $e) {
            return [ErrorCode::$IllegalBuffer, NULL];
        }
        if ($from_receiveId != $receiveId) {
            return [ErrorCode::$ValidateCorpidError, NULL];
        }
        return [0, $xml_content];
    }
    private function getRandomStr()
    {
        $str = "";
        $str_pol = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyl";
        $max = strlen($str_pol) - 1;
        for ($i = 0; $i < 16; $i++) {
            $str .= $str_pol[mt_rand(0, $max)];
        }
        return $str;
    }
}

?>