<?php
namespace addons\activity_hongbao\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config;
    private $validate;
    public function initialize()
    {
        parent::initialize();
        $con = (require dirname(__DIR__) . "/config/config.php");
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $this->validate = new \addons\activity_hongbao\validate\ActivityHongbaoValidate();
    }
    public function index()
    {
        $params = $this->request->param();
        $page = !empty($params["page"]) ? intval($params["page"]) : config("page");
        $limit = !empty($params["limit"]) ? intval($params["limit"]) : config("limit");
        $describe = lang("STATUS_DESCRIBE");
        $res = \think\Db::name("activity_hongbao")->order("date", "DESC")->withAttr("date", function ($value) {
            return $value ? date("Y-m-d H:i", $value) : "N/A";
        })->field("id,uid,money,date")->page($page)->limit($limit)->select()->toArray();
        $count = \think\Db::name("activity_hongbao")->count("id");
        $page_info = [];
        $page_info["count"] = $count;
        $page_info["limit"] = $limit;
        $page_info["page"] = ceil($count / $limit);
        $page_info["pages"] = range(1, $page_info["page"]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("pageInfo", $page_info);
        $this->assign("list", $res);
        $this->assign("domain", $domain);
        return $this->fetch("/index");
    }
    public function setting()
    {
        $res = \think\Db::name("plugin")->where("name", "ActivityHongbao")->find();
        $system = json_decode($res["config"], true);
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $system["is_open"] = $param["is_open"] ?? 0;
            $system["redbagnumber"] = $param["redbagnumber"] ?: $system["redbagnumber"];
            $system["tips"] = $param["tips"] ?: $system["tips"];
            $dataArr["config"] = json_encode($system);
            if (!$res) {
                $error_msg = lang("PLUGIN_INSTALL_ERROR");
                $this->assign("ErrorMsg", $error_msg);
            } else {
                \think\Db::name("plugin")->where("name", "ActivityHongbao")->update($dataArr);
                $success_msg = lang("CHANGE_SUCCESS");
                $this->assign("SuccessMsg", $success_msg);
            }
        }
        $this->assign("system", $system);
        return $this->fetch("/setting");
    }
    public function Delete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("activity_hongbao")->where("id", $param["id"])->delete();
            return json(["status" => 200, "msg" => "删除成功~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
}

?>