<?php
namespace addons\agent_discount;

class AgentDiscountPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "AgentDiscount", "title" => "代理折扣", "description" => "代理折扣可设置不同的等级不同的折扣，一次设置全站的折扣", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "lang" => ["chinese" => "代理折扣", "chinese_tw" => "代理折扣", "english" => "Agent Discount"]];
    public function uninstall()
    {
        return true;
    }
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open", "type" => "VARCHAR(255)"], ["name" => "api", "type" => "VARCHAR(255)"], ["name" => "apiid", "type" => "VARCHAR(255)"], ["name" => "apikey", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "sitename", "type" => "VARCHAR(255)"], ["name" => "webmasteremail", "type" => "VARCHAR(255)"], ["name" => "webmasterqq", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "level", "type" => "VARCHAR(255)"], ["name" => "value", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "uid", "type" => "VARCHAR(255)"], ["name" => "orderid", "type" => "VARCHAR(255)"], ["name" => "invoiceid", "type" => "VARCHAR(255)"], ["name" => "total", "type" => "VARCHAR(255)"], ["name" => "amounts", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "hostid", "type" => "VARCHAR(255)"], ["name" => "channel", "type" => "VARCHAR(255)"], ["name" => "groupid", "type" => "VARCHAR(255)"], ["name" => "value", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_agent_discount_config";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_agent_discount_rules";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_agent_discount_record";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function shoppingCartSettle($params)
    {
        $client_ip = get_client_ip();
        $invoiceid = $params["invoiceid"];
        $orderid = $params["orderid"];
        $total = $params["total"];
        $hostid = $params["hostid"][0];
        $Info = \Think\Db::name("invoices")->where("id", $invoiceid)->find();
        $groupid = \Think\Db::name("clients")->where("id", $Info["uid"])->value("groupid");
        $group_name = \Think\Db::name("client_groups")->where("id", $groupid)->value("group_name");
        $streamInfoExists = \Think\Db::name("host")->where("id", $hostids)->value("stream_info");
        $config = \Think\Db::name("agent_discount_config")->where("id", 1)->find();
        $api = $config["api"];
        if ($config["open"] == 1) {
            if ($api == 1) {
                if ($streamInfoExists && $groupid != 0) {
                    $groupInfo = \Think\Db::name("agent_discount_rules")->where("level", $groupid)->find();
                    if ($groupInfo) {
                        $amounts = $total * $groupInfo["value"] / 100;
                        $amount = number_format($amounts, 2, ".", "");
                        \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $amount, "subtotal" => $amount]);
                        \Think\Db::name("host")->where("id", $hostid)->update(["firstpaymentamount" => $amount, "amount" => $amount]);
                        \Think\Db::name("orders")->where("invoiceid", $invoiceid)->update(["amount" => $amount]);
                        $preferential = $total - $amount;
                        $newDescription = "【 " . $group_name . " 客户优惠A " . $preferential . " 元 】";
                        $data = ["invoice_id" => $invoiceid, "uid" => $Info["uid"], "type" => "discount", "rel_id" => $hostid, "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                        \Think\Db::name("invoice_items")->insert($data);
                        $record = ["uid" => $Info["uid"], "orderid" => $orderid, "invoiceid" => $invoiceid, "total" => $total, "amounts" => $amount, "amount" => $preferential, "hostid" => $hostid, "channel" => "1", "groupid" => $groupid, "value" => $groupInfo["value"], "status" => "0"];
                        \Think\Db::name("agent_discount_record")->insert($record);
                    }
                }
            } else {
                if ($api == 0) {
                    if ($streamInfoExists) {
                        if ($groupid != 0) {
                            $groupInfo = \Think\Db::name("agent_discount_rules")->where("level", $groupid)->find();
                            if ($groupInfo) {
                                $amounts = $total * $groupInfo["value"] / 100;
                                $amount = number_format($amounts, 2, ".", "");
                                \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $amount, "subtotal" => $amount]);
                                \Think\Db::name("host")->where("id", $hostid)->update(["firstpaymentamount" => $amount, "amount" => $amount]);
                                \Think\Db::name("orders")->where("invoiceid", $invoiceid)->update(["amount" => $amount]);
                                $preferential = $total - $amount;
                                $newDescription = "【 " . $group_name . " 客户优惠B " . $preferential . " 元 】";
                                $data = ["invoice_id" => $invoiceid, "uid" => $Info["uid"], "type" => "discount", "rel_id" => $hostid, "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                \Think\Db::name("invoice_items")->insert($data);
                                $record = ["uid" => $Info["uid"], "orderid" => $orderid, "invoiceid" => $invoiceid, "total" => $total, "amounts" => $amount, "amount" => $preferential, "hostid" => $hostid, "channel" => "1", "groupid" => $groupid, "value" => $groupInfo["value"], "status" => "0"];
                                \Think\Db::name("agent_discount_record")->insert($record);
                            }
                        }
                    } else {
                        if ($groupid != 0) {
                            $groupInfo = \Think\Db::name("agent_discount_rules")->where("level", $groupid)->find();
                            if ($groupInfo) {
                                $amounts = $total * $groupInfo["value"] / 100;
                                $amount = number_format($amounts, 2, ".", "");
                                \Think\Db::name("invoices")->where("id", $invoiceid)->update(["total" => $amount, "subtotal" => $amount]);
                                \Think\Db::name("host")->where("id", $hostid)->update(["firstpaymentamount" => $amount, "amount" => $amount]);
                                \Think\Db::name("orders")->where("invoiceid", $invoiceid)->update(["amount" => $amount]);
                                $preferential = $total - $amount;
                                $newDescription = "【 " . $group_name . " 客户优惠C " . $preferential . " 元 】";
                                $data = ["invoice_id" => $invoiceid, "uid" => $Info["uid"], "type" => "discount", "rel_id" => $hostid, "description" => $newDescription, "description2" => $newDescription, "amount" => "-" . $preferential, "due_time" => time()];
                                \Think\Db::name("invoice_items")->insert($data);
                                $record = ["uid" => $Info["uid"], "orderid" => $orderid, "invoiceid" => $invoiceid, "total" => $total, "amounts" => $amount, "amount" => $preferential, "hostid" => $hostid, "channel" => "0", "groupid" => $groupid, "value" => $groupInfo["value"], "status" => "0"];
                                \Think\Db::name("agent_discount_record")->insert($record);
                            }
                        }
                    }
                }
            }
        }
    }
    public function invoicePaid($params)
    {
        $invoiceid = $params["invoiceid"];
        if (!empty($invoiceid)) {
            \Think\Db::name("agent_discount_record")->where("invoiceid", $invoiceid)->where("status", "0")->update(["status" => 1]);
        }
    }
}

?>