<?php
namespace addons\agent_discount\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function setting()
    {
        $configData = \Think\Db::name("agent_discount_config")->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $apiid = isset($data["apiid"]) ? $data["apiid"] : NULL;
        $apikey = isset($data["apikey"]) ? $data["apikey"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $api = isset($data["api"]) ? $data["api"] : NULL;
        $dbConfig = ["open" => $open, "apiid" => $apiid, "apikey" => $apikey, "sitename" => $sitename, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "authorize" => $authorize, "api" => $api, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("agent_discount_config")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("agent_discount_config")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置更新成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置更新出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("agent_discount_config")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $this->assign("client_groups", $clientGroups);
        $this->assign("Title", "设置折扣");
        return $this->fetch("/index");
    }
    public function submitActivitys()
    {
        $data = $this->request->post();
        $value = isset($data["value"]) ? $data["value"] : [];
        $client_group_id = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $prev_productresult = \Think\Db::name("agent_discount_rules")->where("level", "<", $client_group_id)->order("level", "desc")->find();
        $next_productresult = \Think\Db::name("agent_discount_rules")->where("level", ">", $client_group_id)->order("level", "asc")->find();
        if (empty($data["value"])) {
            $response = ["code" => 400, "msg" => "请输入折扣值"];
            return json($response);
        }
        $groupsname = \Think\Db::name("client_groups")->where("id", $client_group_id)->find();
        $rulesresult = \Think\Db::name("agent_discount_rules")->where(["level" => $client_group_id])->find();
        if ($rulesresult) {
            $response = ["code" => 400, "msg" => "【" . $groupsname["group_name"] . "】等级已存在，请重新选择其他等级"];
            return json($response);
        }
        $dbData = ["level" => $client_group_id, "value" => $value];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("agent_discount_rules")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function records()
    {
        $rules = \Think\Db::name("agent_discount_record")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("domain", $domain);
        $this->assign("data", $rules);
        $this->assign("Title", "订单记录");
        return $this->fetch("/records");
    }
    public function level()
    {
        $rules = \Think\Db::name("agent_discount_rules")->select();
        $resultWithNames = [];
        foreach ($rules as $record) {
            $levelid = $record["level"];
            $levelname = \Think\Db::name("client_groups")->where("id", $levelid)->find();
            if ($levelname !== NULL) {
                $record["group_name"] = $levelname["group_name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("data", $resultWithNames);
        $this->assign("Title", "等级列表");
        return $this->fetch("/level");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("agent_discount_rules")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>