<?php
namespace addons\agent_goods_profit\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function index()
    {
        $params = $this->request->param();
        $start = !empty($params["start"]) ? strtotime($params["start"] . " 00:00:00") : strtotime(date("Y-m-01 00:00:00"));
        $end = !empty($params["end"]) ? strtotime($params["end"] . " 23:59:59") : strtotime(date("Y-m-d 23:59:59"));
        $zjmf_api_id = !empty($params["zjmf_api_id"]) ? intval($params["zjmf_api_id"]) : 0;
        $page = !empty($params["page"]) ? intval($params["page"]) : config("page");
        $limit = 20;
        $count = \think\Db::name("invoices")->alias("i")->field("h.uid,c.username,ii.amount as subtotal,h.upstream_cost,i.id as invoice_id,h.id as host_id,p.name,h.dedicatedip,i.type")->leftjoin("invoice_items ii", "ii.invoice_id=i.id")->leftjoin("host h", "h.id=ii.rel_id")->leftjoin("clients c", "h.uid=c.id")->leftJoin("products p", "p.id = h.productid")->where("( i.type='product' or i.type='renew' ) AND ( i.status='Paid' AND h.upstream_cost>0 ) AND ii.rel_id>0")->where(function (\think\db\Query $query) use($start, $end) {
            if ($start && $end) {
                $query->where("i.create_time>=" . $start . " AND i.create_time<=" . $end);
            }
            if ($zjmf_api_id) {
                $query->where("p.zjmf_api_id|p.upper_reaches_id", $zjmf_api_id);
            }
        })->count();
        $list = \think\Db::name("invoices")->alias("i")->field("h.uid,c.username,ii.amount as subtotal,h.upstream_cost,i.id as invoice_id,h.id as host_id,p.name,h.dedicatedip,i.type,i.create_time")->leftjoin("invoice_items ii", "ii.invoice_id=i.id")->leftjoin("host h", "h.id=ii.rel_id")->leftjoin("clients c", "h.uid=c.id")->leftJoin("products p", "p.id = h.productid")->where("( i.type='product' or i.type='renew' ) AND ( i.status='Paid' AND h.upstream_cost>0 ) AND ii.rel_id>0")->where(function (\think\db\Query $query) use($start, $end) {
            if ($start && $end) {
                $query->where("i.create_time>=" . $start . " AND i.create_time<=" . $end);
            }
            if ($zjmf_api_id) {
                $query->where("p.zjmf_api_id|p.upper_reaches_id", $zjmf_api_id);
            }
        })->page($page)->limit($limit)->order("i.create_time", "desc")->select()->toArray();
        $income = \think\Db::name("invoices")->alias("i")->leftjoin("invoice_items ii", "ii.invoice_id=i.id")->leftjoin("host h", "h.id=ii.rel_id")->leftJoin("products p", "p.id = h.productid")->where("( i.type='product' or i.type='renew' ) AND ( i.status='Paid' AND h.upstream_cost>0 ) AND ii.rel_id>0")->where(function (\think\db\Query $query) use($start, $end) {
            if ($start && $end) {
                $query->where("i.create_time>=" . $start . " AND i.create_time<=" . $end);
            }
            if ($zjmf_api_id) {
                $query->where("p.zjmf_api_id|p.upper_reaches_id", $zjmf_api_id);
            }
        })->sum("ii.amount");
        $cost = \think\Db::name("invoices")->alias("i")->leftjoin("invoice_items ii", "ii.invoice_id=i.id")->leftjoin("host h", "h.id=ii.rel_id")->leftJoin("products p", "p.id = h.productid")->where("( i.type='product' or i.type='renew' ) AND ( i.status='Paid' AND h.upstream_cost>0 ) AND ii.rel_id>0")->where(function (\think\db\Query $query) use($start, $end) {
            if ($start && $end) {
                $query->where("i.create_time>=" . $start . " AND i.create_time<=" . $end);
            }
            if ($zjmf_api_id) {
                $query->where("p.zjmf_api_id|p.upper_reaches_id", $zjmf_api_id);
            }
        })->sum("h.upstream_cost");
        $profit = $income - $cost;
        $invoice_type_all = config("invoice_type_all");
        $currency = \think\Db::name("currencies")->where("default", 1)->find();
        foreach ($list as $key => &$value) {
            $value["type_zh"] = $invoice_type_all[$value["type"]];
            $value["profit"] = $value["subtotal"] - $value["upstream_cost"];
            $value["subtotal"] = $currency["prefix"] . $value["subtotal"] . $currency["suffix"];
            $value["upstream_cost"] = $currency["prefix"] . $value["upstream_cost"] . $currency["suffix"];
            $value["profit"] = $currency["prefix"] . $value["profit"] . $currency["suffix"];
            $value["url1"] = $this->request->domain() . "/" . adminAddress() . "#/customer-view/product-innerpage?id=" . $value["uid"] . "&hid=" . $value["host_id"] . "&fa=productList";
            $value["url2"] = $this->request->domain() . "/" . adminAddress() . "#/customer-view/abstract?id=" . $value["uid"];
            $value["url3"] = $this->request->domain() . "/" . adminAddress() . "#/bill-detail?id=" . $value["invoice_id"];
            $value["create_time"] = date("Y-m-d H:i:s", $value["create_time"]);
        }
        $page_info = [];
        $page_info["count"] = $count;
        $page_info["limit"] = $limit;
        $page_info["page"] = 0 < ceil($count / $limit) ? ceil($count / $limit) : 1;
        $page_info["pages"] = range(1, $page_info["page"]);
        $page_info["curPage"] = $page;
        $page_info["prev"] = 0 < $page - 1 ? $page - 1 : 1;
        $page_info["next"] = $page + 1 < $page_info["page"] ? $page + _1 : $page_info["page"];
        $zjmf_finance_api = \think\Db::name("zjmf_finance_api")->field("id,name")->select()->toArray();
        $this->assign("start", $params["start"] ?: date("Y-m-01"));
        $this->assign("end", $params["end"] ?: date("Y-m-d"));
        $this->assign("zjmf_api_id", $zjmf_api_id);
        $this->assign("zjmf_finance_api", $zjmf_finance_api);
        $this->assign("pageInfo", $page_info);
        $this->assign("list", $list);
        $this->assign("income", $currency["prefix"] . $income . $currency["suffix"]);
        $this->assign("cost", $currency["prefix"] . $cost . $currency["suffix"]);
        $this->assign("profit", $currency["prefix"] . $profit . $currency["suffix"]);
        $this->assign("Title", "代理商品利润计算");
        return $this->fetch("/index");
    }
}

?>