<?php
require dirname(__FILE__) . "/vendor/autoload.php";
class aliyun_cloud_gzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ClassName = "qcloudCloudGzhxClass";
    public $Discount = 100;
    private $request;
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    public function get($action, $option = [])
    {
        AlibabaCloud\Client\AlibabaCloud::accessKeyClient($this->uid, $this->APiKey)->regionId($option["Region"] ?: "cn-hangzhou")->asDefaultClient();
        $option["RegionId"] = $option["Region"] ?: "cn-hangzhou";
        $this->request = AlibabaCloud\Client\AlibabaCloud::rpc();
        try {
            $result = $this->request->product($option["product"] ?: "ecs")->version($option["version"] ?: "2014-05-26")->action($action)->method("POST")->host(($option["product"] ?: "ecs") . ".aliyuncs.com")->options(["query" => $option])->request();
            return ["status" => 1, "info" => $result->toArray()];
        } catch (AlibabaCloud\Client\Exception\ClientException $exception) {
            return ["status" => 0, "info" => "[" . $action . "]" . $exception->getMessage()];
        } catch (AlibabaCloud\Client\Exception\ServerException $exception) {
            return ["status" => 0, "info" => "[" . $action . "]" . str_ireplace("\"", "", "错误信息：" . $exception->getMessage() . ",错误代码：" . $exception->getErrorCode() . ",信息ID：" . $exception->getRequestId() . "，错误原因：" . $exception->getErrorMessage())];
        }
    }
    public function BssOpenApi($action, $option = [])
    {
        AlibabaCloud\Client\AlibabaCloud::accessKeyClient($this->uid, $this->APiKey)->regionId($option["RegionId"] ?: "cn-hangzhou")->asDefaultClient();
        $this->request = AlibabaCloud\Client\AlibabaCloud::rpc();
        try {
            $result = $this->request->product("BssOpenApi")->version("2017-12-14")->action($action)->method("POST")->host("business.aliyuncs.com")->options(["query" => $option])->request();
            return ["status" => 1, "info" => $result->toArray()];
        } catch (AlibabaCloud\Client\Exception\ClientException $exception) {
            return ["status" => 0, "info" => $exception->getMessage()];
        } catch (AlibabaCloud\Client\Exception\ServerException $exception) {
            return ["status" => 0, "info" => "错误信息：" . $exception->getMessage() . ",错误代码：" . $exception->getErrorCode() . ",信息ID：" . $exception->getRequestId() . "，错误原因：" . $exception->getErrorMessage()];
        }
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function setCache($file, $data)
    {
        if (!is_dir(CMF_DATA . "gzhx/" . $this->ClassName . "/")) {
            mkdir(CMF_DATA . "gzhx/" . $this->ClassName . "/", 493, true);
        }
        file_put_contents(CMF_DATA . "gzhx/" . $this->ClassName . "/" . $file, serialize(["time" => time(), "list" => $data]));
    }
    public function MonitorData($DomainInfo, $set)
    {
        $Limit = intval($set["limit"]) ?: 11;
        $Period = intval($set["period"]) ?: 60;
        if (!empty($set["st"])) {
            $StartTime = strtotime($set["st"]);
            if (time() - $StartTime < $Period * $Limit) {
                $StartTime = time() - $Period * $Limit;
            }
        } else {
            $StartTime = time() - $Period * $Limit;
        }
        $EndTime = $StartTime + $Period * $Limit;
        if (time() - $EndTime < 0) {
            $EndTime = time();
        }
        $option = ["InstanceId" => $DomainInfo["vid"], "StartTime" => date("Y-m-d\\TH:i:00\\Z", strtotime("-8 hour", $StartTime)), "EndTime" => date("Y-m-d\\TH:i:00\\Z", strtotime("-8 hour", $EndTime)), "Period" => $Period];
        $rr = $this->get("DescribeInstanceMonitorData", $option);
        $MetricArray = ["CPU", "IOPSRead", "IOPSWrite", "BPSRead", "BPSWrite"];
        $MetricData = [];
        $MonitorDataDate = [];
        foreach ($rr["info"]["MonitorData"]["InstanceMonitorData"] as $k => $v) {
            $MonitorDataDate[] = date("H:i", strtotime($v["TimeStamp"]));
            foreach ($MetricArray as $kk => $vv) {
                $MetricData[$vv]["value"][] = $v[$vv] ?: 0;
            }
        }
        foreach ($MetricArray as $kk => $vv) {
            $MetricData[$vv]["date"] = $MonitorDataDate;
        }
        return ["status" => 1, "info" => ["Period" => $Period, "data" => $MetricData, "name" => ["CPU" => ["name" => "CPU 使用率(%)", "unit" => "%"], "IOPSRead" => ["name" => "I/O读操作", "unit" => "次/s"], "IOPSWrite" => ["name" => "I/O写操作", "unit" => "次/s"], "BPSRead" => ["name" => "磁盘读带宽", "unit" => "Byte/s"], "BPSWrite" => ["name" => "磁盘写带宽", "unit" => "Byte/s"]]]];
    }
    public function InternetMonitorData($DomainInfo, $set)
    {
        $Limit = intval($set["limit"]) ?: 11;
        $Period = intval($set["period"]) ?: 60;
        if (!empty($set["st"])) {
            $StartTime = strtotime($set["st"]);
            if (time() - $StartTime < $Period * $Limit) {
                $StartTime = time() - $Period * $Limit;
            }
        } else {
            $StartTime = time() - $Period * $Limit;
        }
        $EndTime = $StartTime + $Period * $Limit;
        if (time() - $EndTime < 0) {
            $EndTime = time();
        }
        $option = ["InstanceId" => $DomainInfo["vid"], "StartTime" => date("Y-m-d\\TH:i:00\\Z", strtotime("-8 hour", $StartTime)), "EndTime" => date("Y-m-d\\TH:i:00\\Z", strtotime("-8 hour", $EndTime)), "Period" => $Period];
        $rr = $this->get("DescribeInstanceMonitorData", $option);
        $MetricArray = ["InternetBandwidth", "InternetTX", "InternetRX", "IntranetBandwidth", "IntranetTX", "IntranetRX"];
        $MetricData = [];
        $MonitorDataDate = [];
        foreach ($rr["info"]["MonitorData"]["InstanceMonitorData"] as $k => $v) {
            $MonitorDataDate[] = date("H:i", strtotime($v["TimeStamp"]));
            foreach ($MetricArray as $kk => $vv) {
                $MetricData[$vv]["value"][] = $v[$vv] ?: 0;
            }
        }
        foreach ($MetricArray as $kk => $vv) {
            $MetricData[$vv]["date"] = $MonitorDataDate;
        }
        return ["status" => 1, "info" => ["Period" => $Period, "data" => $MetricData, "name" => ["InternetBandwidth" => ["name" => "公网带宽", "unit" => "kbits/s"], "InternetTX" => ["name" => "发送的公网数据流量", "unit" => "kbits"], "InternetRX" => ["name" => "接收的公网数据流量", "unit" => "kbits"], "IntranetBandwidth" => ["name" => "内网带宽", "unit" => "kbits/s"], "IntranetTX" => ["name" => "发送的内网数据流量", "unit" => "kbits"], "IntranetRX" => ["name" => "接收的内网数据流量", "unit" => "kbits"]]]];
    }
    public function getCache($file, $time = 86400)
    {
        if (!is_dir(CMF_DATA . "gzhx/" . $this->ClassName . "/")) {
            mkdir(CMF_DATA . "gzhx/" . $this->ClassName . "/", 493, true);
        }
        $data = unserialize(file_get_contents(CMF_DATA . "gzhx/" . $this->ClassName . "/" . $file));
        if ($data["time"] && time() - $data["time"] < $time) {
            return $data["list"];
        }
        return NULL;
    }
    public function DescribeRegions()
    {
        $rr = $this->get("DescribeRegions", []);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $data = [];
        foreach ($rr["info"]["Regions"]["Region"] as $k => $v) {
            $data[$v["RegionId"]] = $v["LocalName"];
        }
        return ["status" => 1, "info" => $data];
    }
    public function DescribeDisksCategory($query)
    {
        $resultVpc = $this->get("DescribeZones", ["Region" => $query["region"], "InstanceChargeType" => "PrePaid", "AcceptLanguage" => "zh-CN", "Product" => "cbs"]);
        if ($resultVpc["status"] != 1) {
            return $resultVpc;
        }
        $config = ["cloud" => "普通云硬盘", "cloud_efficiency" => "高性能云硬盘", "cloud_ssd" => "SSD云硬盘", "cloud_essd" => "ESSD云盘"];
        $list = [];
        foreach ($resultVpc["info"]["Zones"]["Zone"] as $item) {
            if ($item["ZoneId"] == $query["zone"]) {
                foreach ($item["AvailableDiskCategories"]["DiskCategories"] as $kk => $vv) {
                    $list[$vv] = $config[$vv];
                }
                $result = ["status" => 1, "info" => ["list" => $list, "min" => 0, "max" => 1000]];
                $this->setCache("DescribeDisksCategory-" . $query["zone"], $result);
                return $result;
            }
        }
    }
    public function Period()
    {
        return ["1" => "1个月", "2" => "2个月", "3" => "3个月", "6" => "半年", "12" => "一年"];
    }
    public function Service()
    {
        return ["基础服务" => "基础服务"];
    }
    public function Vpc($query)
    {
        $resultVpc = $this->get("DescribeVpcs", ["Region" => $query["region"], "product" => "vpc", "version" => "2016-04-28", "vpcName" => "gz-vpc"]);
        if ($resultVpc["status"] != 1) {
            return $resultVpc;
        }
        $vpcId = $resultVpc["info"]["Vpcs"]["Vpc"][0]["VpcId"];
        if (empty($vpcId)) {
            $addVpc = $this->get("CreateVpc", ["Region" => $query["region"], "VpcName" => "gz-vpc", "CidrBlock" => "10.0.0.0/16", "product" => "vpc", "version" => "2016-04-28"]);
            if ($addVpc["status"] != 1) {
                return $addVpc;
            }
            $vpcId = $addVpc["info"]["VpcId"];
        }
        $resultSubnets = $this->get("DescribeVSwitches", ["Region" => $query["region"], "VSwitchName" => "gz-subnets", "ZoneId" => $query["zone"], "product" => "vpc", "version" => "2016-04-28", "VpcId" => $vpcId]);
        if ($resultSubnets["status"] != 1) {
            return $resultSubnets;
        }
        $subnetsId = $resultSubnets["info"]["VSwitches"]["VSwitch"][0]["VSwitchId"];
        if (empty($subnetsId)) {
            $addSubnets = $this->get("CreateVSwitch", ["Region" => $query["region"], "VSwitchName" => "gz-subnets", "CidrBlock" => "10.0.188.0/24", "VpcId" => $vpcId, "product" => "vpc", "version" => "2016-04-28", "ZoneId" => $query["zone"]]);
            if ($addSubnets["status"] != 1) {
                return $addSubnets;
            }
            $subnetsId = $addSubnets["info"]["VSwitchId"];
        }
        $resultSecurityGroups = $this->get("DescribeSecurityGroups", ["Region" => $query["region"], "VpcId" => $vpcId, "SecurityGroupName" => "guizhouhuixun-security"]);
        if ($resultSecurityGroups["status"] != 1) {
            return $resultSecurityGroups;
        }
        $securityGroupsId = $resultSecurityGroups["info"]["SecurityGroups"]["SecurityGroup"][0]["SecurityGroupId"];
        if (empty($securityGroupsId)) {
            $addSecurityGroups = $this->get("CreateSecurityGroup", ["Region" => $query["region"], "VpcId" => $vpcId, "SecurityGroupName" => "guizhouhuixun-security", "Description" => "guizhouhuixun-security"]);
            if ($addSecurityGroups["status"] != 1) {
                return $addSecurityGroups;
            }
            $securityGroupsId = $addSecurityGroups["info"]["SecurityGroupId"];
            $ModifySecurityGroupRule = $this->get("AuthorizeSecurityGroup", ["Region" => $query["region"], "SecurityGroupId" => $securityGroupsId, "IpProtocol" => "all", "PortRange" => "-1/-1", "SourceCidrIp" => "0.0.0.0/0", "SourcePortRange" => "-1/-1", "Policy" => "accept", "Priority" => 1, "NicType" => "internet"]);
        }
        return ["status" => 1, "vpc" => $vpcId, "subnets" => $subnetsId, "security" => $securityGroupsId];
    }
    public function RunInstances($query)
    {
        $vpc = $this->Vpc($query);
        sleep(2);
        if ($vpc["status"] == 0) {
            return $vpc;
        }
        $Period = intval($query["period"]);
        if ($Period % 12 == 0) {
            $PriceUnit = "Year";
            $Period = ceil($Period / 12);
        } else {
            $PriceUnit = "Month";
        }
        $Option = ["Region" => $query["region"], "Period" => $Period, "PeriodUnit" => $PriceUnit, "ZoneId" => $query["zone"], "InstanceName" => $query["InstanceName"], "Password" => $query["password"], "SecurityGroupId" => $vpc["security"], "VSwitchId" => $vpc["subnets"], "ImageId" => $query["osId"], "InternetChargeType" => "PayByBandwidth", "InstanceChargeType" => "PrePaid", "InstanceType" => $query["Instance"], "SystemDisk.Category" => $query["osDisk"], "InternetMaxBandwidthOut" => intval($query["bindWidth"]), "Amount" => 1];
        if (0 < intval($query["dataSize"])) {
            if (intval($query["dataSize"]) < 20) {
                $query["dataSize"] = 20;
            }
            $Option["DataDisk.1.Category"] = $query["dataType"];
            $Option["DataDisk.1.Size"] = intval($query["dataSize"]);
        }
        $endTime = date("Y-m-d H:i:s", strtotime("+" . $query["period"] . " month", time()));
        $result = $this->get("RunInstances", $Option);
        if ($result["status"] === 1) {
            $InstanceIdSets = $result["info"]["InstanceIdSets"]["InstanceIdSet"];
            $save = ["status" => 1, "info" => ["vid" => $InstanceIdSets[0]]];
            return $save;
        }
        return $result;
    }
    public function DescribePrice($query)
    {
        $Period = intval($query["period"]);
        if ($Period % 12 == 0) {
            $PriceUnit = "Year";
            $Period = ceil($Period / 12);
        } else {
            $PriceUnit = "Month";
        }
        $Option = ["Region" => $query["region"], "ResourceType" => "instance", "ZoneId" => $query["zone"], "ImageId" => $query["osId"], "InternetChargeType" => "PayByBandwidth", "InstanceChargeType" => "PrePaid", "Period" => $Period, "PriceUnit" => $PriceUnit, "InstanceType" => $query["Instance"], "SystemDisk.Category" => $query["osDisk"], "InternetMaxBandwidthOut" => intval($query["bindWidth"]), "Amount" => 1];
        if (0 < intval($query["dataSize"])) {
            if (intval($query["dataSize"]) < 20) {
                $query["dataSize"] = 20;
            }
            $Option["DataDisk.1.Category"] = $query["dataType"];
            $Option["DataDisk.1.Size"] = intval($query["dataSize"]);
        }
        $rr = $this->get("DescribePrice", $Option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $OriginalPrice = $rr["info"]["PriceInfo"]["Price"]["OriginalPrice"];
        $Price = ceil(floatval($OriginalPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function AttachDisks($data)
    {
        return ["status" => 1, "info" => "成功"];
    }
    public function DescribeImages($query)
    {
        $resultOSList = $this->getCache("DescribeImages-" . $query["region"] . "-" . $query["InstanceType"], 8640000);
        if (!empty($resultOSList)) {
            return $resultOSList;
        }
        $resultOSList = $this->get("DescribeImages", ["Region" => $query["region"], "InstanceType" => $query["InstanceType"], "ImageOwnerAlias" => "system", "PageSize" => 100]);
        if ($resultOSList["status"] != 1) {
            return $resultOSList;
        }
        $osList = ["windows" => [], "linux" => []];
        foreach ($resultOSList["info"]["Images"]["Image"] as $k => $v) {
            if ($v["OSType"] == "windows") {
                $osList["windows"][] = ["id" => $v["ImageId"], "name" => $v["ImageName"]];
            } else {
                $osList["linux"][] = ["id" => $v["ImageId"], "name" => $v["OSName"]];
            }
        }
        $result = ["status" => 1, "info" => $osList];
        $this->setCache("DescribeImages-" . $query["region"] . "-" . $query["InstanceType"], $result);
        return $result;
    }
    public function Instance($query)
    {
        $rr = $this->getCache("Instance-" . $query["zone"]);
        if (!empty($rr)) {
            return $rr;
        }
        $rZone = $this->get("DescribeZones", ["Region" => $query["region"], "AcceptLanguage" => "zh-CN", "InstanceChargeType" => "PrePaid"]);
        if ($rZone["status"] != 1) {
            return $rr;
        }
        $zone = NULL;
        foreach ($rZone["info"]["Zones"]["Zone"] as $k => $v) {
            if ($v["ZoneId"] == $query["zone"]) {
                $zone = $v;
                if (empty($zone)) {
                    return ["status" => 0, "info" => "当前可用区不可用"];
                }
                $AvailableInstanceTypes = $zone["AvailableResources"]["ResourcesInfo"][0]["InstanceTypes"]["supportedInstanceType"];
                $InstanceTypeFamilies = $zone["InstanceTypeFamilies"]["supportedInstanceTypeFamily"];
                $rr = $this->get("DescribeInstanceTypes", ["Region" => $query["region"]]);
                if ($rr["status"] != 1) {
                    return $rr;
                }
                $data = [];
                $Cpu = [];
                $Memory = [];
                foreach ($rr["info"]["InstanceTypes"]["InstanceType"] as $k => $v) {
                    if (in_array($v["InstanceTypeId"], $AvailableInstanceTypes)) {
                        $data[] = ["InstanceType" => $v["InstanceTypeId"], "Cpu" => $v["CpuCoreCount"], "Memory" => $v["MemorySize"], "Zone" => $query["zone"]];
                        if (!in_array($v["CpuCoreCount"], $Cpu)) {
                            $Cpu[] = $v["CpuCoreCount"];
                        }
                        if (!in_array($v["MemorySize"], $Memory)) {
                            $Memory[] = $v["MemorySize"];
                        }
                    }
                }
                asort($Cpu);
                asort($Memory);
                $vCpu = [];
                $vMemory = [];
                foreach ($Cpu as $item) {
                    $vCpu[] = $item;
                }
                foreach ($Memory as $item) {
                    $vMemory[] = $item;
                }
                $result = ["status" => 1, "info" => ["list" => $data, "cpu" => $vCpu, "memory" => $vMemory]];
                $this->setCache("Instance-" . $query["zone"], $result);
                return $result;
            }
        }
    }
    public function Zone($query)
    {
        $rr = $this->getCache("zone-" . $query["region"]);
        if (!empty($rr)) {
            return $rr;
        }
        $rr = $this->get("DescribeZones", ["Region" => $query["region"], "AcceptLanguage" => "zh-CN", "InstanceChargeType" => "PrePaid"]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $data = [];
        foreach ($rr["info"]["Zones"]["Zone"] as $k => $v) {
            $data[$v["ZoneId"]] = $v["LocalName"];
        }
        $result = ["status" => 1, "info" => $data];
        $this->setCache("zone-" . $query["region"], $result);
        return $result;
    }
    public function RenewInstances($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $Period = intval($op["years"]);
        if ($Period % 12 == 0) {
            $PriceUnit = "Year";
            $Period = ceil($Period / 12);
        } else {
            $PriceUnit = "Month";
        }
        $Option = ["Region" => $query["region"], "InstanceId" => $query["vid"], "Period" => $Period, "PeriodUnit" => $PriceUnit];
        $rr = $this->get("RenewInstance", $Option);
        return $rr;
    }
    public function DiskBuy($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        if (intval($op["size"]) < 20) {
            $op["size"] = 20;
        }
        $Option = ["Region" => $query["region"], "InstanceId" => $query["vid"], "DiskCategory" => $op["type"], "Size" => intval($op["size"])];
        $rr = $this->get("CreateDisk", $Option);
        if ($rr["status"] == 1) {
            return ["status" => 1, "info" => $rr["info"]["DiskIdSet"][0]];
        }
        return $rr;
    }
    public function Bandwidth($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $option = ["Region" => $query["region"], "PageNumber" => 1, "PageSize" => 100];
        if (!empty($query["vid"])) {
            $option["InstanceIds"] = json_encode([$query["vid"]]);
        }
        $rr = $this->get("DescribeInstances", $option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        if ($rr["info"]["TotalCount"] < 1) {
            return ["status" => 0, "info" => "主机不存在"];
        }
        $bw = $rr["info"]["Instances"]["Instance"][0]["InternetMaxBandwidthOut"];
        if (intval($op["Bandwidth"]) == intval($bw)) {
            return ["status" => 0, "info" => "没有增值"];
        }
        $Option = ["Region" => $query["region"], "InstanceId" => $query["vid"], "InternetMaxBandwidthOut" => intval($op["Bandwidth"]), "NetworkChargeType" => "PayByBandwidth"];
        $rr = $this->get("ModifyInstanceNetworkSpec", $Option);
        return $rr;
    }
    public function BandwidthPrice($query, $op)
    {
        $option = ["Region" => $query["region"], "PageNumber" => 1, "PageSize" => 100];
        if (!empty($query["vid"])) {
            $option["InstanceIds"] = json_encode([$query["vid"]]);
        }
        $rr = $this->get("DescribeInstances", $option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        if ($rr["info"]["TotalCount"] < 1) {
            return ["status" => 0, "info" => "主机不存在"];
        }
        $bw = $rr["info"]["Instances"]["Instance"][0]["InternetMaxBandwidthOut"];
        $Bandwidth = (intval($op["Bandwidth"]) - intval($bw)) * 1024;
        $result = $this->BssOpenApi("GetSubscriptionPrice", ["RegionId" => $query["region"], "OrderType" => "Upgrade", "ProductCode" => "ecs", "SubscriptionType" => "Subscription", "InstanceId" => $query["vid"], "ModuleList.1.ModuleCode" => "InternetMaxBandwidthOut", "ModuleList.1.Config" => "InternetMaxBandwidthOut:" . $Bandwidth . ",InternetMaxBandwidthOut.IsFlowType:5,NetworkType:1", "ModuleList.1.ModuleStatus" => "2"]);
        $OriginalPrice = $result["info"]["Data"]["ModuleDetails"]["ModuleDetail"][0]["OriginalCost"];
        $Price = ceil(floatval($OriginalPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function Vnc($query, $op)
    {
        if ($op["opp"] == "hard") {
            $result = $this->get("ModifyInstanceVncPasswd", ["Region" => $query["region"], "InstanceId" => $query["vid"], "VncPassword" => $op["password"]]);
            if ($result["status"] !== 1) {
                return ["status" => 0, "info" => "密码长度必须是六位字符，必须且仅能包含大写、小写英文字母及阿拉伯数字三种字符"];
            }
        }
        $result = $this->get("DescribeInstanceVncUrl", ["Region" => $query["region"], "InstanceId" => $query["vid"]]);
        if ($result["status"] === 1) {
            $result["info"]["RemoteServerUrl"] = "https://g.alicdn.com/aliyun/ecs-console-vnc2/0.0.8/index.html?instanceId=" . $query["vid"] . "&isWindows=True&password=" . $op["password"] . "&vncUrl=" . $result["info"]["VncUrl"];
        }
        return $result;
    }
    public function password($query, $op)
    {
        $rr = $this->get("ModifyInstanceAttribute", ["Region" => $query["region"], "InstanceId" => $query["vid"], "Password" => $op["password"]]);
        if ($rr["status"] != 1 && strstr($rr["info"], "state of")) {
            preg_match("/the state of `([a-zA-Z\\-]+)`/isu", $rr["info"], $match);
            strtoupper($match[1]);
            switch (strtoupper($match[1])) {
                case "PENDING":
                    $Status = "创建中";
                    break;
                case "LAUNCH_FAILED":
                    $Status = "创建失败";
                    break;
                case "RUNNING":
                    $Status = "运行中";
                    break;
                case "STOPPED":
                    $Status = "关机";
                    break;
                case "STARTING":
                    $Status = "开机中";
                    break;
                case "STOPPING":
                    $Status = "关机中";
                    break;
                case "REBOOTING":
                    $Status = "重启中";
                    break;
                case "SHUTDOWN":
                    $Status = "停止待销毁";
                    break;
                case "TERMINATING":
                    $Status = "销毁中";
                    break;
                default:
                    $Status = "未知";
                    return ["status" => 0, "info" => "请先关机完成后再重置密码,当前状态：" . $Status];
            }
        } else {
            if ($rr["status"] == 1) {
                sleep(1);
                $rr = $this->get("RebootInstance", ["Region" => $query["region"], "InstanceId" => $query["vid"]]);
            }
            return $rr;
        }
    }
    public function reloadOS($query, $op)
    {
        $rr = $this->get("ReplaceSystemDisk", ["Region" => $query["region"], "InstanceId" => $query["vid"], "ImageId" => $op["os"], "Password" => $op["password"]]);
        if (strstr($rr["info"], "IncorrectInstanceStatus")) {
            return ["status" => 0, "info" => "请先关机完成后再重置系统："];
        }
        return $rr;
    }
    public function Op($query, $op)
    {
        $Option = ["Region" => $query["region"], "InstanceId" => $query["vid"]];
        switch ($op["op"]) {
            case "start":
                $opBtn = "StartInstance";
                break;
            case "reboot":
                $opBtn = "RebootInstance";
                if ($op["opp"] == "hard") {
                    $Option["ForceStop"] = "true";
                }
                break;
            case "stop":
                $opBtn = "StopInstance";
                if ($op["opp"] == "hard") {
                    $Option["ForceStop"] = "true";
                }
                $rr = $this->get($opBtn, $Option);
                return $rr;
                break;
            default:
                return ["status" => 0, "info" => "不支持的操作"];
        }
    }
    public function DescribeInstanceFull($query)
    {
        $rr = $this->get("DescribeInstances", ["Region" => $query["region"], "InstanceIds" => [$query["vid"]], "PageNumber" => 1, "PageSize" => 100]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $ResultData = $rr["info"]["Instances"]["Instance"][0];
        switch ($ResultData["Status"]) {
            case "Pending":
                $Status = "创建中";
                break;
            case "Running":
                $Status = "运行中";
                break;
            case "Stopped":
                $Status = "关机";
                break;
            case "Starting":
                $Status = "开机中";
                break;
            case "Stopping":
                $Status = "关机中";
                break;
            default:
                $Status = "未知";
                $ip = $ResultData["PublicIpAddress"]["IpAddress"];
                if (count($ip) < 1) {
                    $ip = [$ResultData["EipAddress"]["IpAddress"]];
                    $bw = $ResultData["EipAddress"]["Bandwidth"];
                } else {
                    $bw = $ResultData["InternetMaxBandwidthOut"];
                }
                $Info = ["ID" => $ResultData["InstanceId"], "工作区" => $ResultData["ZoneId"], "购买时间" => date("Y-m-d H:i:s", strtotime($ResultData["StartTime"])), "到期时间" => date("Y-m-d H:i:s", strtotime($ResultData["ExpiredTime"])), "内网IP" => implode(",", $ResultData["VpcAttributes"]["PrivateIpAddress"]["IpAddress"]), "公网IP" => implode(",", $ip), "Cpu" => $ResultData["Cpu"], "内存" => $ResultData["Memory"], "带宽" => $bw, "状态" => $Status];
                $Info["操作系统"] = $ResultData["OSName"];
                $DescribeDisks = $this->get("DescribeDisks", ["Region" => $query["region"], "InstanceId" => $query["vid"], "PageNumber" => 1, "PageSize" => 100]);
                $DiskConfig = ["cloud" => "普通云硬盘", "cloud_efficiency" => "高性能云硬盘", "cloud_ssd" => "SSD云硬盘", "cloud_essd" => "ESSD云盘"];
                $Disk = [];
                foreach ($DescribeDisks["info"]["Disks"]["Disk"] as $item) {
                    $Disk[] = ["name" => $item["Type"] == "system" ? "系统盘" : "数据盘", "id" => $item["DiskId"], "type" => $DiskConfig[$item["Category"]], "size" => $item["Size"]];
                }
                return ["status" => 1, "info" => ["info" => $Info, "disk" => $Disk, "os" => $ResultData["ImageId"], "status" => $Status, "InstanceType" => $ResultData["InstanceType"], "config" => $ResultData]];
        }
    }
    public function InquiryPriceResizeDisk($query)
    {
        $Disk = $this->get("DescribeDisks", ["Region" => $query["region"], "DiskIds" => json_encode([$query["disk"]])]);
        if ($Disk["status"] != 1) {
            return $Disk;
        }
        $Size = $Disk["info"]["Disks"]["Disk"][0]["Size"];
        if (floatval($query["size"]) < 20) {
            $query["size"] = 20;
        }
        $Option = ["Region" => $query["region"], "InstanceId" => $Disk["info"]["Disks"]["Disk"][0]["InstanceId"], "DataDisk.1.Category" => $Disk["info"]["Disks"]["Disk"][0]["Category"], "DataDisk.1.Size" => $query["size"]];
        $rr = $this->get("DescribeInstanceModificationPrice", $Option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $OriginalPrice = $rr["info"]["PriceInfo"]["Price"]["OriginalPrice"];
        $Price = ceil(floatval($OriginalPrice * $this->Discount)) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function ResizeDisk($data)
    {
        $query = $data["query"];
        $op = $data["data"];
        $Disk = $this->get("DescribeDisks", ["Region" => $query["region"], "DiskIds" => json_encode([$op["disk"]])]);
        if ($Disk["status"] != 1) {
            return $Disk;
        }
        $Size = $Disk["info"]["Disks"]["Disk"][0]["Size"];
        if (floatval($op["size"]) < 20) {
            $op["size"] = 20;
        }
        $Option = ["Region" => $query["region"], "DiskId" => $op["disk"], "Product" => "cbs", "NewSize" => intval($op["size"] + $Size)];
        $rr = $this->get("ResizeDisk", $Option);
        return $rr;
    }
    public function InquiryPriceCreateDisks($query)
    {
        $OutMonth = (date("Y", strtotime($query["end_time"])) - date("Y")) * 12 + intval(date("m", strtotime($query["end_time"]))) - intval(date("m"));
        $endMonth = strtotime("+" . $OutMonth . " month", time());
        if ($endMonth <= strtotime($query["end_time"])) {
            $OutMonth = $OutMonth + 1;
        }
        if (floatval($query["DiskSize"]) < 20) {
            $query["DiskSize"] = 20;
        }
        $Option = ["Region" => $query["region"], "InstanceId" => $query["vid"], "DataDisk.1.Category" => $query["DiskType"], "DataDisk.1.Size" => $query["DiskSize"]];
        $rr = $this->get("DescribeInstanceModificationPrice", $Option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $OriginalPrice = $rr["info"]["PriceInfo"]["Price"]["OriginalPrice"];
        $Price = ceil(floatval($OriginalPrice * $this->Discount)) / 100;
        return ["status" => 1, "info" => ceil($Price * 100) / 100];
    }
    public function DescribeInstance($query)
    {
        $option = ["Region" => $query["region"], "PageNumber" => 1, "PageSize" => 100];
        if (!empty($query["vid"])) {
            $option["InstanceIds"] = json_encode([$query["vid"]]);
        }
        $rr = $this->get("DescribeInstances", $option);
        if ($rr["status"] != 1) {
            return $rr;
        }
        if ($rr["info"]["TotalCount"] < 1) {
            return ["status" => 0, "info" => "主机不存在"];
        }
        $ip = $rr["info"]["Instances"]["Instance"][0]["PublicIpAddress"]["IpAddress"];
        if (count($ip) < 0) {
            $ip = [$rr["info"]["Instances"]["Instance"][0]["EipAddress"]["IpAddress"]];
            $bw = $rr["info"]["Instances"]["Instance"][0]["EipAddress"]["Bandwidth"];
        } else {
            $bw = $rr["info"]["Instances"]["Instance"][0]["InternetMaxBandwidthOut"];
        }
        return ["status" => 1, "info" => ["vid" => $rr["info"]["Instances"]["Instance"][0]["InstanceId"], "start_time" => date("Y-m-d H:i:s", strtotime($rr["info"]["Instances"]["Instance"][0]["CreationTime"])), "end_time" => date("Y-m-d H:i:s", strtotime($rr["info"]["Instances"]["Instance"][0]["ExpiredTime"])), "domain" => implode(",", $ip), "templete_info" => $rr["info"]["Instances"]["Instance"][0]["CpuOptions"]["CoreCount"] . "核" . $rr["info"]["Instances"]["Instance"][0]["Memory"] . "M带宽" . $bw . "M"], "end_time" => $rr["info"]["Instances"]["Instance"][0]["ExpiredTime"]];
    }
    public function InquiryPriceRenewInstances($query)
    {
        $Period = intval($query["period"]);
        if ($Period % 12 == 0) {
            $PriceUnit = "Year";
            $Period = $Period / 12;
        } else {
            $PriceUnit = "Month";
        }
        $rr = $this->get("DescribeRenewalPrice", ["Region" => $query["region"], "ResourceId" => $query["vid"], "Period" => $Period, "PriceUnit" => $PriceUnit, "ResourceType" => "instance"]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $OriginalPrice = $rr["info"]["PriceInfo"]["Price"]["OriginalPrice"];
        $Price = ceil(floatval($OriginalPrice) * $this->Discount) / 100;
        return ["status" => 1, "info" => $Price];
    }
    public function DescribeInstances($query, $page = 1)
    {
        $rr = $this->get("DescribeInstances", ["Region" => $query["Region"], "PageNumber" => $page, "PageSize" => 100]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $data = [];
        foreach ($rr["info"]["Instances"]["Instance"] as $k => $v) {
            $ip = $v["PublicIpAddress"]["IpAddress"];
            if (count($ip) < 1) {
                $ip = [$v["EipAddress"]["IpAddress"]];
                $bw = $v["EipAddress"]["Bandwidth"];
            } else {
                $bw = $v["InternetMaxBandwidthOut"];
            }
            $data[$v["InstanceId"]] = ["vid" => $v["InstanceId"], "start_time" => date("Y-m-d H:i:s", strtotime($v["CreationTime"])), "end_time" => date("Y-m-d H:i:s", strtotime($v["ExpiredTime"])), "domain" => implode(",", $ip), "templete_info" => $v["CpuOptions"]["CoreCount"] . "核" . $v["Memory"] . "M带宽" . $bw . "M"];
        }
        return ["status" => 1, "info" => ["list" => $data, "TotalCount" => $rr["info"]["TotalCount"]]];
    }
    private function SaveRegistrantProfile($query)
    {
        if (!empty($query["RegistrantProfileId"])) {
            $rr = $this->get("DeleteTemplate", ["TemplateId" => $query["RegistrantProfileId"]]);
            if ($rr["status"] != 1) {
                return $rr;
            }
        }
        switch ($query["IdentityCredentialType"]) {
            case "XYDM":
                $f_type_org = "TYDMZ";
                break;
            default:
                $f_type_org = $query["IdentityCredentialType"];
                $rr = $this->get("UploadImage", ["ImageFile" => "data:image/jpeg;base64," . $query["RegistrantProfilePic"]]);
                if ($rr["status"] != 1) {
                    return $rr;
                }
                $post = ["ContactInfo" => ["RegistrantType" => $query["RegistrantType"] == 1 ? "I" : "E", "OrganizationNameCN" => $query["ZhRegistrantOrganization"], "OrganizationName" => $query["RegistrantOrganization"], "RegistrantNameCN" => $query["ZhRegistrantName"], "RegistrantName" => $query["RegistrantName"], "ProvinceCN" => $query["ZhProvince"], "CityCN" => $query["ZhCity"], "StreetCN" => $query["ZhAddress"], "Street" => $query["Address"], "ZipCode" => $query["PostalCode"], "CountryCN" => "中国", "Telephone" => $query["Telephone"], "Email" => $query["Email"], "Province" => $query["Province"], "City" => $query["City"], "Country" => "CN"], "CertificateInfo" => ["CertificateCode" => $query["IdentityCredentialNo"], "CertificateType" => $f_type_org, "ImgUrl" => $rr["info"]["AccessUrl"]]];
                $r = $this->get("CreateTemplate", $post);
                if ($r["status"] == 1) {
                    $r["info"]["RegistrantProfileId"] = $r["info"]["Template"]["TemplateId"];
                }
                return $r;
        }
    }
    private function QueryDomainList($query)
    {
        $r = $this->get("DescribeDomainBaseInfo", ["Domain" => $query["DomainName"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $r["info"]["DomainInfo"]["DomainId"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["DomainInfo"]["ExpirationDate"], "RegistrationDate" => $r["info"]["DomainInfo"]["CreationDate"]]]]]];
        return $result;
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $arr = ["Domains" => [$query["DomainName"]], "Period" => intval($query["Period"]), "TemplateId" => $query["RegistrantProfileId"], "PayMode" => 1];
        if (!empty($query["Dns1"]) && !empty($query["Dns2"])) {
            $arr["dns_host1"] = $query["Dns1"];
            $arr["dns_host2"] = $query["Dns2"];
        }
        $r = $this->get("CreateDomainBatch", $arr);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "注册中";
        $r["info"]["TaskNo"] = $r["info"]["LogId"];
        return $r;
    }
    private function QueryTaskDetailList($query)
    {
        $r = $this->get("DescribeBatchOperationLogDetails", ["LogId" => intval($query["TaskNo"])]);
        $Status = "执行中";
        switch ($r["info"]["DomainBatchDetailSet"][0]["Status"]) {
            case "doing":
                $Status = "执行中";
                break;
            case "failed":
                $Status = $r["info"]["DomainBatchDetailSet"][0]["Reason"];
                break;
            case "success":
                $Status = "执行成功";
                break;
            default:
                $Status = "等待执行";
                $result = ["status" => 1, "info" => $Status];
                return $result;
        }
    }
}

?>