<?php
class aliyun_dominbygzhx_class
{
    private $request;
    private $accId = "";
    private $accKey = "";
    private $autoload = [];
    public function __construct()
    {
        $this->autoload = get_declared_classes();
    }
    public function destruct()
    {
    }
    public function setConfig($data)
    {
        $this->accId = $data["aid"];
        $this->accKey = $data["ak"];
    }
    public function config()
    {
        return ["discount" => 1, "integral" => 0];
    }
    public function get($action, $option = [])
    {
        AlibabaCloud\Client\AlibabaCloud::accessKeyClient($this->accId, $this->accKey)->regionId("cn-hangzhou")->asDefaultClient();
        $option["RegionId"] = "cn-hangzhou";
        $this->request = AlibabaCloud\Client\AlibabaCloud::rpc();
        try {
            $result = $this->request->product("Domain")->version("2018-01-29")->action($action)->method("POST")->host("domain.aliyuncs.com")->options(["query" => $option])->request();
            $this->destruct();
            return ["status" => 1, "info" => $result->toArray()];
        } catch (AlibabaCloud\Client\Exception\ClientException $exception) {
            $this->destruct();
            return ["status" => 0, "info" => $exception->getMessage()];
        } catch (AlibabaCloud\Client\Exception\ServerException $exception) {
            $this->destruct();
            return ["status" => 0, "info" => str_ireplace("\"", "", "错误信息：" . $exception->getMessage() . ",错误代码：" . $exception->getErrorCode() . ",信息ID：" . $exception->getRequestId() . "，错误原因：" . $exception->getErrorMessage())];
        }
    }
    public function AliYunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = [])
    {
        $result = $this->{$Action}($query);
        return $result;
    }
    private function CheckDomain($query)
    {
        $DomainName = $query["DomainName"];
        $option = ["DomainName" => $DomainName, "Lang" => "zh"];
        $result = $this->AliYunApi("CheckDomain", $option, []);
        return $result;
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $arr = ["DomainName" => $query["DomainName"], "SubscriptionDuration" => $query["Period"], "RegistrantProfileId" => $query["RegistrantProfileId"], "Lang" => "zh"];
        if (!empty($query["Dns1"]) && !empty($query["Dns2"])) {
            $arr["dns_host1"] = $query["Dns1"];
            $arr["dns_host2"] = $query["Dns2"];
        }
        $result = $this->AliYunApi("SaveSingleTaskForCreatingOrderActivate", $arr, []);
        if ($result["status"] != 1) {
            return $result;
        }
        return $result;
    }
    private function QueryTaskDetailList($query)
    {
        $result = $this->AliYunApi("QueryTaskDetailList", ["TaskNo" => $query["TaskNo"], "PageNum" => 1, "PageSize" => 100, "Lang" => "zh"], []);
        $Status = "执行中";
        switch ($result["info"]["Data"]["TaskDetail"][0]["TaskStatus"]) {
            case "EXECUTING":
                $Status = "执行中";
                break;
            case "EXECUTE_FAILURE":
                $Status = $result["Data"]["TaskDetail"][0]["ErrorMsg"];
                break;
            case "EXECUTE_SUCCESS":
                $Status = "执行成功";
                break;
            default:
                $Status = "等待执行";
                $result = ["status" => 1, "info" => $Status];
                return $result;
        }
    }
    public function EmailVerification($email)
    {
        $result = $this->AliYunApi("SubmitEmailVerification", ["Email" => $email, "Lang" => "zh"], []);
        return $result;
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $result = $this->AliYunApi("QueryDomainList", ["Lang" => "zh", "PageNum" => $Offset + 1, "PageSize" => 100], []);
        if ($result["status"] != 1) {
            return $result;
        }
        $data = [];
        foreach ($result["info"]["Data"]["Domain"] as $item) {
            $data[] = ["DomainId" => $item["InstanceId"], "DomainName" => $item["DomainName"], "CreationDate" => $item["RegistrationDate"], "ExpirationDate" => $item["ExpirationDate"], "BuyStatus" => "ok"];
        }
        return ["status" => 1, "info" => ["DomainSet" => $data, "TotalCount" => $result["info"]["TotalItemNum"]]];
    }
    private function QueryDomainList($query)
    {
        $result = $this->AliYunApi("QueryDomainList", ["DomainName" => $query["DomainName"], "Lang" => "zh", "PageNum" => 1, "PageSize" => 100], []);
        if ($result["status"] != 1) {
            return $result;
        }
        $info = $result["info"]["Data"]["Domain"][0];
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $info["InstanceId"], "DomainName" => $query["DomainName"], "ExpirationDate" => $info["ExpirationDate"], "RegistrationDate" => $info["RegistrationDate"]]]]]];
        return $result;
    }
    public function DescribeDomainBaseInfo($query)
    {
        $DomainInfo = $this->QueryDomainList(["DomainName" => $query["DomainName"]]);
        if ($DomainInfo["status"] != 1) {
            return $DomainInfo;
        }
        $rr = $this->AliYunApi("QueryContactInfo", ["ContactType" => "registrant", "DomainName" => $query["DomainName"]]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $Info = $rr["info"];
        return ["status" => 1, "info" => ["域名" => $query["DomainName"], "注册时间" => $DomainInfo["info"]["Data"]["Domain"][0]["RegistrationDate"], "到期时间" => $DomainInfo["info"]["Data"]["Domain"][0]["ExpirationDate"], "所有中（中文）" => $Info["ZhRegistrantOrganization"], "所有者（英文）" => $Info["RegistrantOrganization"], "电子邮箱" => $Info["Email"], "手机号" => $Info["Telephone"]]];
    }
    private function TemplateData($data)
    {
        $status = "未知";
        strval($data["RealNameStatus"]);
        switch (strval($data["RealNameStatus"])) {
            case "NONAUDIT":
                $status = "未实名认证";
                break;
            case "AUDITING":
                $status = "审核中";
                break;
            case "SUCCEED":
                $status = "已实名认证";
                break;
            case "FAILED":
                $status = "实名失败";
                break;
            default:
                $info = ["TemplateId" => $data["RegistrantProfileId"], "Email" => $data["Email"], "RegistrantType" => $data["RegistrantType"], "ZhRegistrantOrganization" => $data["ZhRegistrantOrganization"], "ZhRegistrantName" => (string) $data["ZhRegistrantName"], "RegistrantOrganization" => $data["RegistrantOrganization"], "RegistrantName" => (string) $data["RegistrantName"], "Province" => "zhe jiang", "City" => "hang zhou shi", "Address" => "zhe jiang sheng hang zhou shi shang cheng qu 10001 hao", "Country" => "CN", "TelArea" => "86", "Telephone" => $data["Telephone"], "TelExt" => "1234", "PostalCode" => "310024", "IdentityCredentialType" => "", "IdentityCredentialNo" => "", "RegistrantProfilePic" => "", "AuditStatus" => $status];
                return $info;
        }
    }
    public function SaveRegistrantProfile($query)
    {
        $result = $this->AliYunApi("ListEmailVerification", ["Lang" => "zh", "PageNum" => 1, "PageSize" => 100, "Email" => $query["Email"]], []);
        if ($result["status"] != 1) {
            return $result;
        }
        if ($result["info"]["TotalItemNum"] < 1 || $result["info"]["Data"][0]["VerificationStatus"] != 1) {
            return ["status" => 0, "info" => "email"];
        }
        $post = ["RegistrantType" => $query["RegistrantType"], "ZhRegistrantOrganization" => $query["ZhRegistrantOrganization"], "ZhRegistrantName" => $query["ZhRegistrantName"], "RegistrantOrganization" => $query["RegistrantOrganization"], "RegistrantName" => $query["RegistrantName"], "Country" => "CN", "TelArea" => "86", "ZhProvince" => $query["ZhProvince"], "ZhCity" => $query["ZhCity"], "ZhAddress" => $query["ZhAddress"], "PostalCode" => $query["PostalCode"], "TelExt" => $query["TelExt"], "Telephone" => $query["Telephone"], "Email" => $query["Email"], "Lang" => "zh", "Province" => $query["Province"], "City" => $query["City"], "Address" => $query["Address"]];
        if (!empty($query["RegistrantProfileId"])) {
            $post["RegistrantProfileId"] = $query["RegistrantProfileId"];
        }
        $r = $this->AliYunApi("SaveRegistrantProfile", $post, []);
        if ($r["status"] != 1) {
            return $r;
        }
        $upload = $this->AliYunApi("RegistrantProfileRealNameVerification", ["RegistrantProfileID" => $r["info"]["RegistrantProfileId"], "IdentityCredentialNo" => $query["IdentityCredentialNo"], "IdentityCredentialType" => $query["IdentityCredentialType"], "IdentityCredential" => $query["RegistrantProfilePic"], "Lang" => "zh"]);
        if ($upload["status"] != 1) {
            return ["status" => 0, "RegistrantProfileId" => $r["info"]["RegistrantProfileId"], "info" => "证件上传错误" . $upload["info"]];
        }
        return $r;
    }
    private function QueryRegistrantProfileRealNameVerificationInfo($query)
    {
        $result = $this->AliYunApi("QueryRegistrantProfileRealNameVerificationInfo", ["Lang" => "zh", "RegistrantProfileId" => $query["RegistrantProfileId"]], []);
        if ($result["status"] != 1) {
            return $result;
        }
        return ["status" => 1, "IdentityCredentialType" => $result["info"]["IdentityCredentialType"], "IdentityCredentialNo" => $result["info"]["IdentityCredentialNo"]];
    }
    public function DescribeTemplate($query)
    {
        $result = $this->AliYunApi("QueryRegistrantProfiles", ["Lang" => "zh", "RegistrantProfileId" => $query["vid"], "PageNum" => 1, "PageSize" => 100], []);
        if ($result["status"] != 1) {
            return $result;
        }
        if ($result["status"] == 1) {
            $status = "未知";
            strval($result["info"]["RegistrantProfiles"]["RegistrantProfile"][0]["RealNameStatus"]);
            switch (strval($result["info"]["RegistrantProfiles"]["RegistrantProfile"][0]["RealNameStatus"])) {
                case "NONAUDIT":
                    $status = "未实名认证";
                    break;
                case "AUDITING":
                    $status = "审核中";
                    break;
                case "SUCCEED":
                    $status = "已实名认证";
                    break;
                case "FAILED":
                    $status = "实名失败";
                    break;
                default:
                    $result["AuditStatus"] = $status;
                    $RegistrantProfiles = $this->TemplateData($result["info"]["RegistrantProfiles"]["RegistrantProfile"][0]);
                    $QueryRegistrantProfileRealNameVerificationInfo = $this->QueryRegistrantProfileRealNameVerificationInfo(["RegistrantProfileId" => $query["vid"]]);
                    if ($QueryRegistrantProfileRealNameVerificationInfo["status"] != 1) {
                        return $QueryRegistrantProfileRealNameVerificationInfo;
                    }
                    $RegistrantProfiles = array_merge($RegistrantProfiles, $QueryRegistrantProfileRealNameVerificationInfo);
                    return ["status" => 1, "AuditStatus" => $status, "info" => $RegistrantProfiles];
            }
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $result = $this->AliYunApi("QueryRegistrantProfiles", ["Lang" => "zh", "PageNum" => $Offset + 1, "PageSize" => 100], []);
        if ($result["status"] != 1) {
            return $result;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $result["info"]["TotalItemNum"]]];
        foreach ($result["info"]["RegistrantProfiles"]["RegistrantProfile"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    public function DescribeDomainNs($query)
    {
        $result = $this->AliYunApi("QueryAdvancedDomainList", ["KeyWord" => $query["DomainName"], "Lang" => "zh", "PageNum" => 1, "PageSize" => 100], []);
        if ($result["status"] != 1) {
            return $result;
        }
        $Domains = $result["info"]["Data"]["Domain"];
        $Domains = array_column($Domains, NULL, "DomainName");
        $Domain = $Domains[$query["DomainName"]];
        $DnsList = $Domain["DnsList"]["Dns"];
        return ["status" => 1, "info" => $DnsList];
    }
    public function SaveBatchTaskForModifyingDomainDns($query)
    {
        $QueryDomainList = $this->QueryDomainList($query);
        return $QueryDomainList;
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $QueryDomainList = $this->QueryDomainList(["DomainName" => $query["OrderRenewParam.1.DomainName"]]);
        if ($QueryDomainList["status"] != 1) {
            return $QueryDomainList;
        }
        $query["OrderRenewParam.1.CurrentExpirationDate"] = strtotime($QueryDomainList["info"]["Data"]["Domain"][0]["ExpirationDate"]) * 1000;
        $result = $this->AliYunApi("SaveBatchTaskForCreatingOrderRenew", $query, []);
        if ($result["status"] == 1) {
            $result["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($QueryDomainList["info"]["Data"]["Domain"][0]["ExpirationDate"])));
        }
        return $result;
    }
}

?>