<?php
class aliyun_dominbygzhx_dns
{
    private $request;
    private $accId = "";
    private $accKey = "";
    private $autoload = [];
    public $ttl = 600;
    public function __construct()
    {
        $this->autoload = get_declared_classes();
    }
    public function destruct()
    {
    }
    public function setConfig($data)
    {
        $this->accId = $data["aid"];
        $this->accKey = $data["ak"];
    }
    public function config()
    {
        return ["discount" => 1, "integral" => 0];
    }
    public function get($action, $option = [])
    {
        AlibabaCloud\Client\AlibabaCloud::accessKeyClient($this->accId, $this->accKey)->regionId("cn-hangzhou")->asDefaultClient();
        $option["RegionId"] = "cn-hangzhou";
        $this->request = AlibabaCloud\Client\AlibabaCloud::rpc();
        try {
            $result = $this->request->product("alidns")->version("2015-01-09")->action($action)->method("POST")->host("dns.aliyuncs.com")->options(["query" => $option])->request();
            $this->destruct();
            return ["status" => 1, "info" => $result->toArray()];
        } catch (AlibabaCloud\Client\Exception\ClientException $exception) {
            $this->destruct();
            return ["status" => 0, "info" => $exception->getMessage()];
        } catch (AlibabaCloud\Client\Exception\ServerException $exception) {
            $this->destruct();
            return ["status" => 0, "info" => str_ireplace("\"", "", "错误信息：" . $exception->getMessage() . ",错误代码：" . $exception->getErrorCode() . ",信息ID：" . $exception->getRequestId() . "，错误原因：" . $exception->getErrorMessage())];
        }
    }
    public function detail($RegionId, $InstanceIds)
    {
        $DescribeDisks = $this->get("DescribeDisks", ["RegionId" => $RegionId, "InstanceId" => $InstanceIds, "PageSize" => 100]);
        if ($DescribeDisks["status"] !== 1) {
            $DescribeDisks["disk"] = 1;
            return $DescribeDisks;
        }
        $query = ["RegionId" => $RegionId, "InstanceIds" => [$InstanceIds]];
        $DescribeInstances = $this->get("DescribeInstances", $query);
        if ($DescribeInstances["status"] !== 1) {
            return $DescribeInstances;
        }
        if ($DescribeInstances["info"]["TotalCount"] < 1) {
            return ["status" => 0, "info" => "产品不存在"];
        }
        $DescribeInstances["info"]["DiskInfo"] = $DescribeDisks["info"];
        $eip = $DescribeInstances["info"]["Instances"]["Instance"][0]["EipAddress"]["IpAddress"];
        $ip = $DescribeInstances["info"]["Instances"]["Instance"][0]["PublicIpAddress"]["IpAddress"][0];
        $eTime = date("Y-m-d H:i:s", strtotime($DescribeInstances["info"]["Instances"]["Instance"][0]["ExpiredTime"]));
        $DescribeInstances["info"]["otherInfo"]["username"] = $InstanceIds;
        $DescribeInstances["info"]["otherInfo"]["domainstatus"] = "Active";
        $DescribeInstances["info"]["otherInfo"]["dedicatedip"] = $eip ?: $ip;
        $DescribeInstances["info"]["otherInfo"]["nextduedate"] = strtotime($eTime);
        $DescribeInstances["info"]["otherInfo"]["regdate"] = strtotime(date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s", strtotime($DescribeInstances["info"]["Instances"]["Instance"][0]["StartTime"])))));
        return $DescribeInstances;
    }
    public function AliYunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data)
    {
        $result = $this->AliYunApi($Action, $query, $data["product"]);
        return $result;
    }
    public function Line()
    {
        return ["default" => "默认", "telecom" => "中国电信", "unicom" => "中国联通", "mobile" => "中国移动", "oversea" => "海外", "edu" => "教育网", "search" => "搜索引擎", "google" => "谷歌", "baidu" => "百度"];
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT", "AAAA" => "AAAA", "SRV" => "SRV", "CAA" => "CAA"];
    }
    public function DeleteDomainRecord($query)
    {
        $result = $this->AliYunApi("DeleteDomainRecord", $query, []);
        return $result;
    }
    public function UpdateDomainRecord($query)
    {
        $result = $this->AliYunApi(empty($query["RecordId"]) ? "AddDomainRecord" : "UpdateDomainRecord", $query, []);
        return $result;
    }
    public function SetDomainRecordStatus($query)
    {
        $result = $this->AliYunApi("SetDomainRecordStatus", $query, []);
        return $result;
    }
    public function AddDomainRecord($query)
    {
        $result = $this->AliYunApi(empty($query["RecordId"]) ? "AddDomainRecord" : "UpdateDomainRecord", $query, []);
        return $result;
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $result = $this->AliYunApi("DescribeDomainRecords", ["DomainName" => $DomainName, "Lang" => "zh", "PageNumber" => $page, "PageSize" => 20], []);
        if ($result["status"] != 1) {
            return $result;
        }
        $r = ["status" => 1, "info" => ["records" => [], "count" => $result["info"]["TotalCount"]]];
        foreach ($result["info"]["DomainRecords"]["Record"] as $k => $v) {
            if (strtoupper($v["type"]) != "NS") {
                $r["info"]["records"][] = ["RR" => $v["RR"], "Line" => $this->Line()[$v["line"]], "Type" => $v["Type"], "Value" => $v["Value"], "TTL" => $v["TTL"], "Status" => $v["Status"], "RecordId" => $v["RecordId"], "Priority" => $v["Priority"]];
            }
        }
        return $r;
    }
}

?>