<?php
namespace addons\auto_level\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function setting()
    {
        $configData = \Think\Db::name("auto_levels_config")->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $apiid = isset($data["apiid"]) ? $data["apiid"] : NULL;
        $apikey = isset($data["apikey"]) ? $data["apikey"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $batch = isset($data["batch"]) ? $data["batch"] : NULL;
        $cycle = isset($data["cycle"]) ? $data["cycle"] : NULL;
        $defaultlevel = isset($data["defaultlevel"]) ? $data["defaultlevel"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $mintotal = isset($data["mintotal"]) ? $data["mintotal"] : NULL;
        $dbConfig = ["open" => $open, "mintotal" => $mintotal, "apiid" => $apiid, "apikey" => $apikey, "sitename" => $sitename, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "authorize" => $authorize, "batch" => $batch, "cycle" => $cycle, "defaultlevel" => $defaultlevel, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("auto_levels_config")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("auto_levels_config")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置更新成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置更新出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("auto_levels_config")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function index()
    {
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $this->assign("client_groups", $clientGroups);
        $this->assign("Title", "设置等级");
        return $this->fetch("/index");
    }
    public function submitActivitys()
    {
        $data = $this->request->post();
        $total = isset($data["total"]) ? $data["total"] : [];
        $client_group_id = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $prev_productresult = \Think\Db::name("auto_levels_rules")->where("level", "<", $client_group_id)->order("level", "desc")->find();
        $next_productresult = \Think\Db::name("auto_levels_rules")->where("level", ">", $client_group_id)->order("level", "asc")->find();
        if (empty($data["total"])) {
            $response = ["code" => 400, "msg" => "消费金额是必填的"];
            return json($response);
        }
        $groupsname = \Think\Db::name("client_groups")->where("id", $client_group_id)->find();
        $rulesresult = \Think\Db::name("auto_levels_rules")->where(["level" => $client_group_id])->find();
        if ($rulesresult) {
            $response = ["code" => 400, "msg" => "【" . $groupsname["group_name"] . "】等级已存在，请重新选择其他等级"];
            return json($response);
        }
        $min_total = $prev_productresult ? $prev_productresult["total"] + 1 : 1;
        $max_total = $next_productresult ? $next_productresult["total"] - 1 : PHP_INT_MAX;
        if ($next_productresult) {
            if ($total <= $prev_productresult["total"] || $next_productresult["total"] <= $total) {
                $response = ["code" => 400, "msg" => "周期内消费金额应在 " . $min_total . " 元至 " . $max_total . " 元之间，如需要调整，请删除前后等级再重新设置"];
                return json($response);
            }
        } else {
            if ($total <= $prev_productresult["total"]) {
                $response = ["code" => 400, "msg" => "周期内消费金额应大于 " . $prev_productresult["total"] . " 元，如需要调整，请删除前一等级重新设置"];
                return json($response);
            }
        }
        $dbData = ["level" => $client_group_id, "total" => $total];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("auto_levels_rules")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function records()
    {
        $rules = \Think\Db::name("auto_levels_record")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($rules as $record) {
            $oldlevel = $record["oldlevel"];
            $newlevel = $record["newlevel"];
            $oldlevelname = \Think\Db::name("client_groups")->where("id", $oldlevel)->find();
            $newlevelname = \Think\Db::name("client_groups")->where("id", $newlevel)->find();
            if ($oldlevelname !== NULL) {
                $record["oldlevelname"] = $oldlevelname["group_name"];
            }
            if ($newlevelname !== NULL) {
                $record["newlevelname"] = $newlevelname["group_name"];
            }
            $resultWithNames[] = $record;
        }
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("domain", $domain);
        $this->assign("data", $resultWithNames);
        $this->assign("fen", $rules);
        $this->assign("Title", "调整记录");
        return $this->fetch("/records");
    }
    public function level()
    {
        $rules = \Think\Db::name("auto_levels_rules")->select();
        $resultWithNames = [];
        foreach ($rules as $record) {
            $levelid = $record["level"];
            $levelname = \Think\Db::name("client_groups")->where("id", $levelid)->find();
            if ($levelname !== NULL) {
                $record["group_name"] = $levelname["group_name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("data", $resultWithNames);
        $this->assign("Title", "等级列表");
        return $this->fetch("/level");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("auto_levels_rules")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>