<?php
namespace addons\auto_level;

class AutoLevelPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "AutoLevel", "title" => "自动代理级别", "description" => "自动代理级别可以统计代理会员在指定时间段内的消费金额进行自动调整不同等级", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.3", "module" => "addons", "lang" => ["chinese" => "自动代理级别", "chinese_tw" => "自动代理级别", "english" => "Auto Level"]];
    public function uninstall()
    {
        return true;
    }
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open", "type" => "VARCHAR(255)"], ["name" => "mintotal", "type" => "VARCHAR(255)"], ["name" => "apiid", "type" => "VARCHAR(255)"], ["name" => "apikey", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "sitename", "type" => "VARCHAR(255)"], ["name" => "webmasteremail", "type" => "VARCHAR(255)"], ["name" => "webmasterqq", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "VARCHAR(255)"], ["name" => "batch", "type" => "VARCHAR(255)"], ["name" => "cycle", "type" => "VARCHAR(255)"], ["name" => "defaultlevel", "type" => "VARCHAR(255)"], ["name" => "last", "type" => "int(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "level", "type" => "VARCHAR(255)"], ["name" => "total", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "uid", "type" => "VARCHAR(255)"], ["name" => "cycle", "type" => "VARCHAR(255)"], ["name" => "total", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "oldlevel", "type" => "VARCHAR(255)"], ["name" => "newlevel", "type" => "VARCHAR(255)"], ["name" => "times", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_auto_levels_config";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_auto_levels_rules";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_auto_levels_record";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function afterCron()
    {
        $config = \Think\Db::name("auto_levels_config")->find();
        $cycle = $config["cycle"];
        $batchSize = $config["batch"];
        $lastProcessedUserId = \Think\Db::name("auto_levels_config")->value("last");
        if (is_null($lastProcessedUserId)) {
            $lastProcessedUserId = 0;
        }
        $open = $config["open"];
        if ($open == "1") {
            $users = \Think\Db::name("clients")->where("id", ">", $lastProcessedUserId)->limit($batchSize)->select();
        } else {
            $users = \Think\Db::name("clients")->where("id", ">", $lastProcessedUserId)->where("groupid", "<>", 0)->limit($batchSize)->select();
        }
        $con = 0;
        foreach ($users as $user) {
            $totalAmount = \Think\Db::name("invoices")->where("uid", $user["id"])->where("paid_time", ">=", strtotime("-" . $cycle . " days"))->where("status", "Paid")->where("type", "<>", "recharge")->sum("subtotal");
            $groupConfig = \Think\Db::name("auto_levels_rules")->order("total")->select();
            $auto_levels = \Think\Db::name("auto_levels_config")->find();
            $newGroup = $auto_levels["defaultlevel"];
            foreach ($groupConfig as $groupconfig) {
                if ($groupconfig["total"] <= $totalAmount) {
                    $newGroup = $groupconfig["level"];
                } else {
                    if (!($open == 1 && $user["groupid"] == 0 && $totalAmount < $config["mintotal"])) {
                        $groupExists = \Think\Db::name("client_groups")->where("id", $newGroup)->find();
                        if ($newGroup != $user["groupid"] && $groupExists) {
                            $con++;
                            echo "用户ID " . $user["id"] . " - 周期 " . $cycle . " 天消费金额 " . $totalAmount . " 元 - 自动调整到等级: " . $groupExists["group_name"] . " (" . $newGroup . ")" . ":" . date("Y-m-d H:i:s") . "\n";
                            $lastNewLevel = \Think\Db::name("clients")->where("id", $user["id"])->value("groupid");
                            if ($lastNewLevel === NULL) {
                                $lastNewLevel = $newGroup;
                            }
                            if ($lastNewLevel < $newGroup) {
                                $status = 1;
                            } else {
                                $status = 0;
                            }
                            $data = ["uid" => $user["id"], "total" => $totalAmount, "oldlevel" => $lastNewLevel, "newlevel" => $newGroup, "status" => $status, "times" => time(), "cycle" => $cycle];
                            \Think\Db::name("auto_levels_record")->insert($data);
                            \Think\Db::name("clients")->where("id", $user["id"])->update(["groupid" => $newGroup]);
                        }
                    }
                }
            }
        }
        if ($con == 0) {
            echo "【自动代理级别】本次没有需要调整的用户，更新到ID：" . ($user["id"] ?? "0") . "：" . date("Y-m-d H:i:s") . "\n";
        }
        $lastProcessedUserId = $user["id"];
        \Think\Db::name("auto_levels_config")->where("id", 1)->update(["last" => $lastProcessedUserId]);
    }
}

?>