<?php
namespace addons\balance_withdrawal\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \Think\Db::name("balance_withdrawal_config");
        $configData = $configurationsModel->find();
        $withdrawalmethod = explode(",", $configData["withdrawalmethod"]);
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("withdrawalmethod", $withdrawalmethod);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $zzemail = isset($data["zzemail"]) ? $data["zzemail"] : NULL;
        $zzqq = isset($data["zzqq"]) ? $data["zzqq"] : NULL;
        $mfauth = isset($data["mfauth"]) ? $data["mfauth"] : NULL;
        $settings = isset($data["settings"]) ? $data["settings"] : NULL;
        $realname = isset($data["realname"]) ? $data["realname"] : NULL;
        $withdrawalmethod = isset($data["types"]) ? $data["types"] : NULL;
        $minimumamount = isset($data["minimumamount"]) ? $data["minimumamount"] : NULL;
        $maximumamount = isset($data["maximumamount"]) ? $data["maximumamount"] : NULL;
        $cyclelimit = isset($data["cyclelimit"]) ? $data["cyclelimit"] : NULL;
        $available = isset($data["available"]) ? $data["available"] : NULL;
        $commissiontype = isset($data["commissiontype"]) ? $data["commissiontype"] : NULL;
        $commissionrate = isset($data["commissionrate"]) ? $data["commissionrate"] : NULL;
        $instructions = isset($data["instructions"]) ? $data["instructions"] : NULL;
        $agent = isset($data["agent"]) ? $data["agent"] : NULL;
        $dbConfig = ["zzemail" => $zzemail, "zzqq" => $zzqq, "mfauth" => $mfauth, "settings" => $settings, "realname" => $realname, "withdrawalmethod" => $withdrawalmethod, "minimumamount" => $minimumamount, "maximumamount" => $maximumamount, "cyclelimit" => $cyclelimit, "available" => $available, "commissiontype" => $commissiontype, "commissionrate" => $commissionrate, "instructions" => $instructions, "agent" => $agent, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("balance_withdrawal_config")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("balance_withdrawal_config")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置更新成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置更新出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("balance_withdrawal_config")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function withdrawallist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $withdrawallist = \Think\Db::name("balance_withdrawal_list")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("Title", "提现列表");
        $this->assign("domain", $domain);
        $this->assign("listpage", $withdrawallistpage);
        return $this->fetch("/withdrawallist", ["data" => $withdrawallist]);
    }
    public function withdrawalagree()
    {
        $data = $this->request->post();
        $id = isset($data["id"]) ? $data["id"] : NULL;
        $dbConfig = ["status" => 1, "audittime" => time(), "rejection" => "已通过"];
        $updateResult = \Think\Db::name("balance_withdrawal_list")->where("id", $id)->update($dbConfig);
        $affiliates = ["type" => 2, "admin_id" => 1, "update_time" => time(), "status" => 2, "reason" => "来源：余额提现【提现成功】"];
        \Think\Db::name("affiliates_withdraw")->where("withdrawalid", $id)->update($affiliates);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $client_ip = $_SERVER["REMOTE_ADDR"];
        $client_port = $_SERVER["REMOTE_PORT"];
        $result = \Think\Db::name("balance_withdrawal_list")->where("id", $id)->find();
        $admin_id = cmf_get_current_admin_id();
        $adminuser = \Think\Db::name("user")->where("id", $admin_id)->value("user_nickname");
        $activity_log = ["uid" => $result["userid"], "description" => "后台【" . $adminuser . " (ID:" . $admin_id . ")】管理审核提现--通过，<a href=\"#/customer-view/abstract?id=" . $result["userid"] . "\">User ID:" . $result["userid"] . "</a> ，提现列表ID：" . $id . " ，<a href=\"" . $domain . "/addons?_plugin=balance_withdrawal&_controller=admin_index&_action=withdrawallist&languagesys=CN\">查看提现列表</a>", "user" => $adminuser, "port" => $client_port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 0, "activeid" => $admin_id, "usertype" => "Admin", "type_data_id" => ""];
        \Think\Db::name("activity_log")->insert($activity_log);
        if ($updateResult !== false) {
            $response = ["code" => 200, "msg" => "提现处理成功"];
        } else {
            $response = ["code" => 500, "msg" => "提现处理失败"];
        }
        return json($response);
    }
    public function withdrawalreject()
    {
        $data = $this->request->post();
        $id = isset($data["id"]) ? $data["id"] : NULL;
        $reason = isset($data["reason"]) ? $data["reason"] : NULL;
        $result = \Think\Db::name("balance_withdrawal_list")->where("id", $id)->find();
        $dbConfig = ["status" => 2, "audittime" => time(), "rejection" => $reason];
        $updateResult = \Think\Db::name("balance_withdrawal_list")->where("id", $id)->update($dbConfig);
        $affiliates = ["type" => 2, "admin_id" => 1, "update_time" => time(), "status" => 3, "reason" => "来源：余额提现【提现拒绝】 " . $reason . " "];
        \Think\Db::name("affiliates_withdraw")->where("withdrawalid", $id)->update($affiliates);
        $clientCredit = \Think\Db::name("clients")->where("id", $result["userid"])->value("credit");
        $newCredit = $clientCredit + $result["amount"];
        $fan = ["credit" => $newCredit];
        $updateResult = \Think\Db::name("clients")->where("id", $result["userid"])->update($fan);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $client_ip = $_SERVER["REMOTE_ADDR"];
        $client_port = $_SERVER["REMOTE_PORT"];
        $admin_id = cmf_get_current_admin_id();
        $adminuser = \Think\Db::name("user")->where("id", $admin_id)->value("user_nickname");
        $activity_log = ["uid" => $result["userid"], "description" => "后台【" . $adminuser . " (ID:" . $admin_id . ")】管理审核提现--拒绝，<a href=\"#/customer-view/abstract?id=" . $result["userid"] . "\">User ID:" . $result["userid"] . "</a> 提现列表ID：" . $id . " ，拒绝原因：" . $reason . " ，" . $result["amount"] . "元已退回可用余额，<a href=\"" . $domain . "/addons?_plugin=balance_withdrawal&_controller=admin_index&_action=withdrawallist&languagesys=CN\">查看提现列表</a>", "user" => $adminuser, "port" => $client_port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 0, "activeid" => $admin_id, "usertype" => "Admin", "type_data_id" => ""];
        \Think\Db::name("activity_log")->insert($activity_log);
        $name = \Think\Db::name("clients")->where("id", $result["userid"])->value("username");
        $credit = ["uid" => $result["userid"], "amount" => $result["amount"], "balance" => $newCredit, "create_time" => time(), "description" => "用户" . $name . " [" . $result["userid"] . "] 申请提现，提现列表ID：" . $id . " ，提现已驳回，已返还" . $result["amount"] . "元 ", "notes" => "来源：余额提现【申请被驳回】原因：" . $reason . " "];
        \Think\Db::name("credit")->insert($credit);
        if ($updateResult !== false) {
            $response = ["code" => 200, "msg" => "提现申请已驳回成功，" . $result["amount"] . "元已退回可用余额"];
        } else {
            $response = ["code" => 500, "msg" => "提现申请驳回失败"];
        }
        return json($response);
    }
}

?>