<?php
namespace addons\balance_withdrawal\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function index()
    {
        $user_id = request()->uid;
        $configurationsModel = \Think\Db::name("balance_withdrawal_config");
        $configData = $configurationsModel->find();
        $withdrawalmethod = explode(",", $configData["withdrawalmethod"]);
        $clientCredit = \Think\Db::name("clients")->where("id", $user_id)->value("credit");
        $this->assign("data", $configData);
        $this->assign("clientCredit", $clientCredit);
        $this->assign("withdrawalmethod", $withdrawalmethod);
        $this->assign("Title", "预存款提现中心");
        return $this->fetch("/index");
    }
    public function withdrawal()
    {
        if ($this->request->isPost()) {
            $postdata = $this->request->post();
            $uid = input("uid");
            $withdrawalamount = $postdata["withdrawalamount"];
            $qrcode = $postdata["qrcode"];
            $accountnumber = $postdata["accountnumber"];
            $realname = $postdata["realname"];
            $withdrawalmethod = $postdata["withdrawalmethod"];
            $clients = \Think\Db::name("clients")->where("id", $uid)->find();
            $withdrawal = \Think\Db::name("balance_withdrawal_config")->where("id", 1)->find();
            if (!$withdrawal) {
                $response = ["code" => 400, "msg" => "提现配置功能不完整，请先后台设置"];
                return json($response);
            }
            if ($withdrawal["commissiontype"] === "percent") {
                $percent = $withdrawal["commissionrate"];
                $brokerage = $percent / 100 * $withdrawalamount;
            } else {
                if ($withdrawal["commissiontype"] === "fixed") {
                    $fixedAmount = $withdrawal["commissionrate"];
                    $brokerage = $fixedAmount;
                }
            }
            $receivedamount = round($withdrawalamount - $brokerage, 2);
            if (empty($uid)) {
                $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
                return json($response);
            }
            if (empty($postdata["withdrawalamount"])) {
                $response = ["code" => 400, "msg" => "请输入提现金额"];
                return json($response);
            }
            if (empty($postdata["realname"])) {
                $response = ["code" => 400, "msg" => "请输入收款账户真实姓名"];
                return json($response);
            }
            if (empty($postdata["accountnumber"])) {
                $response = ["code" => 400, "msg" => "请输入收款账户，收款码收款请输入收款码账户绑定的手机号"];
                return json($response);
            }
            if (empty($postdata["realname"])) {
                $response = ["code" => 400, "msg" => "请输入收款账户真实姓名"];
                return json($response);
            }
            if ($clients["credit"] < $postdata["withdrawalamount"]) {
                $response = ["code" => 400, "msg" => "提现金额不允许大于账户可用余额，您账户最多可提现 " . $clients["credit"] . " 元"];
                return json($response);
            }
            if ($postdata["withdrawalamount"] < $withdrawal["minimumamount"]) {
                $response = ["code" => 400, "msg" => "最小提现金额不能小于" . $withdrawal["minimumamount"] . "元"];
                return json($response);
            }
            if (0 < $withdrawal["maximumamount"] && $withdrawal["maximumamount"] < $postdata["withdrawalamount"]) {
                $response = ["code" => 400, "msg" => "最大提现金额不能大于" . $withdrawal["maximumamount"] . "元"];
                return json($response);
            }
            if ($receivedamount <= 0) {
                $response = ["code" => 400, "msg" => "提现后到账金额不能小于等于0元【扣除手续费后 " . $receivedamount . " 元】"];
                return json($response);
            }
            $certification = $withdrawal["realname"];
            if ($certification != 0) {
                if ($certification == 1) {
                    $certifi_person = \Think\Db::name("certifi_person")->where("auth_user_id", $uid)->find();
                    $certifi_company = \Think\Db::name("certifi_company")->where("auth_user_id", $uid)->find();
                    $can_receive = false;
                    if ($certifi_person) {
                        $can_receive = $certifi_person["status"] == 1;
                    }
                    if (!$can_receive && $certifi_company) {
                        $can_receive = $certifi_company["status"] == 1;
                    }
                    if (!$certifi_person && !$certifi_company) {
                        return json(["code" => 403, "msg" => "请实名认证后再申请提现！"]);
                    }
                    if (!$can_receive) {
                        return json(["code" => 403, "msg" => "请等待实名认证通过后再申请提现！"]);
                    }
                }
            }
            $fouser = $withdrawal["agent"];
            if ($fouser != 0) {
                if ($fouser == 1) {
                    $isyes = \Think\Db::name("clients")->where("id", $uid)->find();
                    $group_id = \Think\Db::name("clients")->where("id", $uid)->value("groupid");
                    $groupname = \Think\Db::name("client_groups")->where("id", $group_id)->value("group_name");
                    if ($group_id != 0) {
                        return json(["code" => 400, "msg" => "提现功能仅对普通用户开放，您的等级为：" . $groupname]);
                    }
                }
            }
            $cycleLimit = $withdrawal["cyclelimit"];
            $availableLimit = $withdrawal["available"];
            $cycleMap = ["day" => "今天", "weekly" => "本周", "monthly" => "本月"];
            $currentDate = new \DateTime();
            $cycleStartDate = NULL;
            $cycleEndDate = $currentDate;
            if ($cycleLimit === "day") {
                $cycleStartDate = clone $currentDate;
                $cycleStartDate->modify("-24 hours");
            } else {
                if ($cycleLimit === "weekly") {
                    $cycleStartDate = clone $currentDate;
                    $cycleStartDate->modify("-7 days");
                } else {
                    if ($cycleLimit === "monthly") {
                        $cycleStartDate = clone $currentDate;
                        $cycleStartDate->modify("-1 month");
                    }
                }
            }
            $withdrawalCount = \Think\Db::name("balance_withdrawal_list")->where("userid", $uid)->whereBetweenTime("created_at", $cycleStartDate->format("Y-m-d H:i:s"), $cycleEndDate->format("Y-m-d H:i:s"))->count();
            if (0 < $availableLimit && $availableLimit <= $withdrawalCount) {
                $nextWithdrawalTime = $this->getNextWithdrawalTime();
                $response = ["code" => 400, "msg" => $cycleMap[$cycleLimit] . "已达到提现次数限制，无法继续提现。下次最早可提现时间为：" . $nextWithdrawalTime . " "];
                return json($response);
            }
            $dbConfig = ["userid" => $uid, "username" => $clients["username"], "realname" => $realname, "amount" => $withdrawalamount, "commissiontype" => $withdrawal["commissiontype"], "brokerage" => $brokerage, "commissionrate" => $withdrawal["commissionrate"], "receivedamount" => $receivedamount, "withdrawalmethod" => $withdrawalmethod, "accountnumber" => $accountnumber, "qrcode" => $qrcode, "creationtime" => time(), "status" => 0];
            \Think\Db::name("balance_withdrawal_list")->insert($dbConfig);
            $insertId = \Think\Db::getLastInsID();
            $affiliates = ["uid" => $uid, "num" => $withdrawalamount, "create_time" => time(), "status" => 1, "reason" => "来源：余额提现【申请提现】，请前往-插件-余额提现处理", "withdrawalid" => $insertId];
            \Think\Db::name("affiliates_withdraw")->insert($affiliates);
            $responseData = ["code" => 200, "msg" => "提现成功，扣除手续费后预计到账 " . $receivedamount . " 元，请等待审核"];
            $newcredit = $clients["credit"] - $withdrawalamount;
            \Think\Db::name("clients")->where("id", $uid)->update(["credit" => $newcredit]);
            $clientInfo = \Think\Db::name("clients")->where("id", $uid)->field("email, username")->find();
            $recipientEmail = $clientInfo["email"];
            $email = $clientInfo["email"];
            $name = $clientInfo["username"];
            $client_ip = $_SERVER["REMOTE_ADDR"];
            $client_port = $_SERVER["REMOTE_PORT"];
            $activity_log = ["uid" => $uid, "description" => "用户申请提现，<a href=\"#/customer-view/abstract?id=" . $uid . "\">User ID:" . $uid . "</a> 提现金额：" . $withdrawalamount . " 元，提现列表ID：" . $insertId . " ", "user" => $name, "port" => $client_port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 1, "activeid" => $uid, "usertype" => "Client", "type_data_id" => ""];
            \Think\Db::name("activity_log")->insert($activity_log);
            $credit = ["uid" => $uid, "amount" => "-" . $withdrawalamount, "balance" => $newcredit, "create_time" => time(), "description" => "用户" . $name . " [" . $uid . "] 在 " . date("Y-m-d H:i:s", time()) . " 申请提现，提现列表ID：" . $insertId . " ", "notes" => "来源：余额提现【申请提现】"];
            \Think\Db::name("credit")->insert($credit);
            return json($responseData);
        }
        $responseData = ["code" => 400, "msg" => "请求方法不支持"];
        return json($responseData);
    }
    private function getNextWithdrawalTime()
    {
        $uid = input("uid");
        $withdrawal = \Think\Db::name("balance_withdrawal_config")->where("id", 1)->find();
        $cycleLimit = $withdrawal["cyclelimit"];
        $currentDate = new \DateTime();
        $cycleLimit = $withdrawal["cyclelimit"];
        $cycleStartDate = NULL;
        $cycleEndDate = $currentDate;
        if ($cycleLimit === "day") {
            $cycleStartDate = clone $currentDate;
            $cycleStartDate->modify("-24 hours");
        } else {
            if ($cycleLimit === "weekly") {
                $cycleStartDate = clone $currentDate;
                $cycleStartDate->modify("-7 days");
            } else {
                if ($cycleLimit === "monthly") {
                    $cycleStartDate = clone $currentDate;
                    $cycleStartDate->modify("-1 month");
                }
            }
        }
        $latestWithdrawal = \Think\Db::name("balance_withdrawal_list")->where("userid", $uid)->whereBetweenTime("created_at", $cycleStartDate->format("Y-m-d H:i:s"), $cycleEndDate->format("Y-m-d H:i:s"))->order("created_at DESC")->find();
        if ($latestWithdrawal) {
            $nextWithdrawalTime = new \DateTime($latestWithdrawal["created_at"]);
            if ($cycleLimit === "day") {
                $nextWithdrawalTime->modify("+1 day");
            } else {
                if ($cycleLimit === "weekly") {
                    $nextWithdrawalTime->modify("+7 days");
                } else {
                    if ($cycleLimit === "monthly") {
                        $nextWithdrawalTime->modify("+1 month");
                    }
                }
            }
            return $nextWithdrawalTime->format("Y-m-d H:i:s");
        }
        return "";
    }
    private function getNextWithdrawalTime00()
    {
        $currentDate = new \DateTime();
        $withdrawal = \Think\Db::name("balance_withdrawal_config")->where("id", 1)->find();
        $cycleLimit = $withdrawal["cyclelimit"];
        if ($cycleLimit === "weekly") {
            $nextWithdrawalTime = clone $currentDate;
            $nextWithdrawalTime->modify("+1 week");
        } else {
            if ($cycleLimit === "monthly") {
                $nextWithdrawalTime = clone $currentDate;
                $nextWithdrawalTime->modify("+1 month");
            } else {
                $nextWithdrawalTime = "";
            }
        }
        return $nextWithdrawalTime->format("Y-m-d");
    }
    public function indexlist00()
    {
        $user_id = request()->uid;
        $configData = \Think\Db::name("balance_withdrawal_list")->where("userid", $user_id)->find();
        $clientCredit = \Think\Db::name("clients")->where("id", $user_id)->value("credit");
        $this->assign("data", $configData);
        $this->assign("clientCredit", $clientCredit);
        $this->assign("Title", "提现中心");
        return $this->fetch("/indexlist");
    }
    public function indexlist()
    {
        $user_id = request()->uid;
        $page = input("page", 1);
        $pageSize = 10;
        $configData = \Think\Db::name("balance_withdrawal_list")->where("userid", $user_id)->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $clientCredit = \Think\Db::name("clients")->where("id", $user_id)->value("credit");
        $this->assign("data", $configData);
        $this->assign("clientCredit", $clientCredit);
        $this->assign("Title", "提现列表");
        return $this->fetch("/indexlist");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>