<?php
namespace addons\balance_withdrawal;

class BalanceWithdrawalPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "BalanceWithdrawal", "title" => "余额提现", "description" => "余额提现插件，适用于魔方财务预存款提现，提现金额，周期提现次数，提现是否需要实名，代理是否允许提现，自动计算手续费等等", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.8", "module" => "addons", "lang" => ["chinese" => "余额提现", "chinese_tw" => "余额提现", "english" => "Balance Withdrawal"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "zzqq", "type" => "VARCHAR(255)"], ["name" => "zzemail", "type" => "VARCHAR(255)"], ["name" => "mfauth", "type" => "VARCHAR(255)"], ["name" => "settings", "type" => "VARCHAR(255)"], ["name" => "realname", "type" => "VARCHAR(255)"], ["name" => "withdrawalmethod", "type" => "VARCHAR(255)"], ["name" => "minimumamount", "type" => "INT"], ["name" => "maximumamount", "type" => "INT"], ["name" => "cyclelimit", "type" => "VARCHAR(255)"], ["name" => "available", "type" => "INT"], ["name" => "commissiontype", "type" => "ENUM('percent', 'fixed')"], ["name" => "commissionrate", "type" => "VARCHAR(255)"], ["name" => "agent", "type" => "VARCHAR(255)"], ["name" => "instructions", "type" => "TEXT"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "userid", "type" => "VARCHAR(255)"], ["name" => "username", "type" => "VARCHAR(255)"], ["name" => "realname", "type" => "VARCHAR(255)"], ["name" => "commissiontype", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "DECIMAL(10, 2)"], ["name" => "commissionrate", "type" => "VARCHAR(255)"], ["name" => "brokerage", "type" => "DECIMAL(10, 2)"], ["name" => "receivedamount", "type" => "DECIMAL(10, 2)"], ["name" => "withdrawalmethod", "type" => "VARCHAR(255)"], ["name" => "accountnumber", "type" => "VARCHAR(255)"], ["name" => "qrcode", "type" => "VARCHAR(255)"], ["name" => "creationtime", "type" => "VARCHAR(255)"], ["name" => "audittime", "type" => "VARCHAR(255)"], ["name" => "status", "type" => "VARCHAR(255)"], ["name" => "rejection", "type" => "VARCHAR(255)"], ["name" => "serialnumber", "type" => "VARCHAR(255)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable3 = [["name" => "withdrawalid", "type" => "VARCHAR(255)"]];
        $tableName1 = "shd_balance_withdrawal_config";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_balance_withdrawal_list";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_affiliates_withdraw";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        $sql = [];
        foreach ($sql as $v) {
            \think\Db::execute($v);
        }
        return true;
    }
}

?>