<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{$Title}</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.5.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="/plugins/addons/balance_withdrawal/assets/layer.js"></script>
</head>



<body style="background-color: #f5f5f5;">
    <div class="container mt-5">
        <div class="card shadow-lg p-4 bg-white rounded">
            <h2 class="text-center">{$Title}</h2>
            
            <form method="post" id="data">


                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="clientCredit" class="form-label">可提现金额</label>
                        <div class="input-group">
                            <input type="text"  value="{$clientCredit}" class="form-control" id="clientCredit" name="clientCredit" readonly>
                            <span class="input-group-text">$</span>
                        </div>
                    </div>
                    <!--
                    <div class="col-md-6 mb-3">
                        <label for="commission" class="form-label">手续费</label>
                        <?php if ($data['commissiontype'] === 'percent'): ?>
                            <input type="text" value="{$data.commissionrate}%" class="form-control" id="commission" name="commission" readonly>
                        <?php elseif ($data['commissiontype'] === 'fixed'): ?>
                            <input type="text" value="{$data.commissionrate} 元/次" class="form-control" id="commission" name="commission" readonly>
                        <?php endif; ?>
                    </div>
                    </div>
                    -->
                    
                    <div class="col-md-6 mb-3">
                        <label for="commission" class="form-label">手续费</label>
                        <?php if ($data['commissiontype'] === 'percent'): ?>
                            <?php if ($data['commissionrate'] == 0): ?>
                                <input type="text" value="免手续费" class="form-control" id="commission" name="commission" readonly>
                            <?php else: ?>
                                <input type="text" value="{$data['commissionrate']}%" class="form-control" id="commission" name="commission" readonly>
                            <?php endif; ?>
                        <?php elseif ($data['commissiontype'] === 'fixed'): ?>
                            <?php if ($data['commissionrate'] == 0): ?>
                                <input type="text" value="免手续费" class="form-control" id="commission" name="commission" readonly>
                            <?php else: ?>
                                <input type="text" value="{$data['commissionrate']} 元/次" class="form-control" id="commission" name="commission" readonly>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                    
                    <!--
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="cyclelimit" class="form-label">提现周期</label>
                        <?php if ($data['cyclelimit'] == 'day'): ?>
                            <input type="text" value="每天 {$data.available}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                        <?php elseif ($data['cyclelimit'] == 'weekly'): ?>
                            <input type="text" value="每周 {$data.available}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                        <?php elseif ($data['cyclelimit'] == 'monthly'): ?>
                            <input type="text" value="每月 {$data.available}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                        <?php endif; ?>
                    </div>
                    -->

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="cyclelimit" class="form-label">提现周期</label>
                        <?php if ($data['cyclelimit'] == 'day'): ?>
                            <?php if ($data['available'] == 0): ?>
                                <input type="text" value="每天不限次数" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php else: ?>
                                <input type="text" value="每天{$data['available']}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php endif; ?>
                        <?php elseif ($data['cyclelimit'] == 'weekly'): ?>
                            <?php if ($data['available'] == 0): ?>
                                <input type="text" value="每周不限次数" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php else: ?>
                                <input type="text" value="每周{$data['available']}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php endif; ?>
                        <?php elseif ($data['cyclelimit'] == 'monthly'): ?>
                            <?php if ($data['available'] == 0): ?>
                                <input type="text" value="每月不限次数" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php else: ?>
                                <input type="text" value="每月{$data['available']}次" class="form-control" id="cyclelimit" name="cyclelimit" readonly>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    
                    
                    
                    <div class="col-md-6 mb-3">
                        <label for="account" class="form-label">是否需要实名</label>
                        <input type="text" value="<?php echo ($data['realname'] == 1) ? '需要' : '不需要'; ?>" class="form-control" id="realname" name="realname" readonly>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <label for="minimumamount" class="form-label">最小提现金额</label>
                        <div class="input-group">
                            <input type="text" value="{$data.minimumamount}"  class="form-control" id="minimumamount" name="minimumamount" readonly>
                            <span class="input-group-text">$</span>
                        </div>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="maximumamount" class="form-label">最大提现金额</label>
                        <div class="input-group">
                            <input type="text" value="{$data.maximumamount}"  class="form-control" id="maximumamount" name="maximumamount" readonly>
                            <span class="input-group-text">$</span>
                        </div>
                    </div>
                </div>
                
                <div class="mb-3">
                    <label for="withdrawal-way" class="form-label">提现方式</label>
                            <select class="form-control" name="withdrawalmethod" id="withdrawal-way">
            				{if in_array('alipay', $withdrawalmethod)}<option value="alipay">支付宝</option>{/if}
            				{if in_array('wxpay', $withdrawalmethod)}<option value="wxpay">微信</option>{/if}
            				{if in_array('qqpay', $withdrawalmethod)}<option value="qqpay">QQ钱包</option>{/if}
            				{if in_array('bank', $withdrawalmethod)}<option value="bank">银行卡</option>{/if}
        				</select>
                    <small class="form-text" style="color: red;">请选择提现方式</small>
                </div>
                <div class="mb-3">
                    <label for="withdrawalamount" class="form-label">提现金额</label>
                    <div class="input-group">
                        <input type="text" class="form-control" id="withdrawalamount" name="withdrawalamount" required placeholder="请输入提现金额">
                        <span class="input-group-text">$</span>
                        
                    </div>
                    <small class="form-text" style="color: red;">请输入您的要提现金额。</small>
                </div>
                <div class="mb-3">
                    <label for="realname" class="form-label">真实姓名</label>
                    <input type="text" class="form-control" id="realname" name="realname" required placeholder="请输入收款账户真实姓名">
                    <small class="form-text" style="color: red;">请输入收款账户真实姓名。</small>
                </div>
                <div class="mb-3">
                    <label for="accountnumber" class="form-label">提现账户</label>
                    <input type="text" class="form-control" id="accountnumber" name="accountnumber" required placeholder="请输入提现账户，二维码收款请输入二维码账户绑定的手机号">
                    <small class="form-text" style="color: red;">请输入您的提现账户信息。</small>
                </div>
                <div class="mb-3">
                    <label for="qrcode" class="form-label">收款码</label>
                    <input type="text" class="form-control" id="qrcode" name="qrcode" required placeholder="推荐！推荐！！请输入二维码图片地址">
                    <small class="form-text" style="color: red;">请输入收款码图片链接。<a href="https://imgse.com/" target="_blank">推荐图床1</a>。<a href="http://imgse.com/" target="_blank">推荐图床2</a>。<a href="https://www.baidu.com/s?wd=%E5%9B%BE%E5%BA%8A&" target="_blank">百度搜索图床</a></small>
                </div>
                <button type="button" onclick="submitto()" class="btn btn-primary"><i class="fas fa-money-bill-wave"></i> 提交提现请求</button>
                
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.5.0/dist/js/bootstrap.min.js"></script>
    
<script>
  function submitto() {
    var url = window.location.href;
    var data = $("#data").serialize();
    var load = layer.load();
    
    $.ajax({
        url: "/addons?_plugin=balance_withdrawal&_controller=index&_action=withdrawal"
        ,type: 'post'
        ,data: data
        ,dataType: 'json'
        ,success: function(data){
            layer.close(load);
            if(data.code != 200)
            {
                layer.alert(data.msg,{icon:2});
                return false;
            }else{
                layer.alert(data.msg,{icon:1},function(){
                    location.reload();
                });
            }
        }
        ,error: function(){
            layer.close(load);
            layer.msg('请求失败');
        }
    })
}
</script>

</body>
</html>
