<?php
namespace addons\beartools\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config;
    private $validate;
    public function initialize()
    {
        parent::initialize();
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $this->validate = new \addons\beartools\validate\BeartoolsValidate();
    }
    public function tongji()
    {
        $getdata["client"] = \think\Db::name("clients")->field("id,username,credit,is_open_credit_limit,credit_limit,credit_limit_balance,credit_limit_create_time,create_time")->select()->toArray();
        $res2 = \think\Db::name("certifi_person")->where("status", "1")->select()->toArray();
        $getdata["certifi_person"] = $res2;
        $res3 = \think\Db::name("certifi_company")->where("status", "1")->select()->toArray();
        $getdata["certifi_company"] = $res3;
        $url = $_SERVER["REQUEST_URI"];
        $getdata["domain"] = dirname($url);
        $this->assign("Title", "统计");
        $params = $this->request->param();
        return $this->fetch("/tongji", $getdata);
    }
    public function manage()
    {
        return $this->fetch("/manage");
    }
    public function highmanage()
    {
        return $this->fetch("/highmanage");
    }
    public function invoice()
    {
        return $this->fetch("/invoice");
    }
    public function invoicedelete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("invoices")->where("status", "Unpaid")->delete();
            return json(["status" => 200, "msg" => "已对所有状态为未支付的账单进行了清理~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function user()
    {
        return $this->fetch("/user");
    }
    public function userdelete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("clients")->where("status", "2")->delete();
            return json(["status" => 200, "msg" => "已对所有状态为已关闭的用户进行了清理~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function order()
    {
        if ($this->request->isPost()) {
            $param = $this->request->param();
            if ($param["type"] == "orderaccept") {
                $action["status"] = "Active";
                \think\Db::name("orders")->where("status", "Pending")->update($action);
                $success_msg = "已将未核验订单全部设置为已核验~";
                $this->assign("SuccessMsg", $success_msg);
            }
        }
        return $this->fetch("/order");
    }
    public function orderdelete()
    {
        try {
            $param = $this->request->param();
            $model = \think\Db::name("orders")->where("status", "Terminated")->delete();
            return json(["status" => 200, "msg" => "已对所有状态为已删除的订单进行了清理~"]);
        } catch (\Throwable $e) {
            return json(["status" => 400, "msg" => $e->getMessage()]);
        }
    }
    public function upload()
    {
        $res = \think\Db::name("plugin")->where("name", "Beartools")->find();
        $system = json_decode($res["config"], true);
        if ($this->request->isPost()) {
            $param = $this->request->param();
            $base64encrypt = base64_encode($param["uploadkey"]);
            $system["uploadkey"] = $base64encrypt ?: $system["uploadkey"];
            $dataArr["config"] = json_encode($system);
            if (!$res) {
                $error_msg = lang("PLUGIN_INSTALL_ERROR");
                $this->assign("ErrorMsg", $error_msg);
            } else {
                \think\Db::name("plugin")->where("name", "Beartools")->update($dataArr);
                $file = $_SERVER["DOCUMENT_ROOT"] . "/plugins/addons/beartools/upload/Upload.Key";
                file_put_contents($file, $base64encrypt);
                $success_msg = lang("CHANGE_SUCCESS");
                $this->assign("SuccessMsg", $success_msg);
            }
        }
        $this->assign("system", $system);
        return $this->fetch("/upload");
    }
}

?>