<?php
namespace addons\bill_notifyrobot;

class BillNotifyrobotPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "BillNotifyrobot", "title" => "账单支付通知【机器人版】", "description" => "账单支付通知，支持开启购买产品支付通知，充值支付通知，续费通知，支持钉钉机器人，飞书机器人，企业微信机器人", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.4", "module" => "addons"];
    public function install()
    {
        $fieldsToAdd = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "webname", "type" => "VARCHAR(255)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "zzqq", "type" => "VARCHAR(255)"], ["name" => "zzemail", "type" => "VARCHAR(255)"], ["name" => "mfauth", "type" => "VARCHAR(255)"], ["name" => "amount", "type" => "VARCHAR(255)"], ["name" => "feishuswitch", "type" => "VARCHAR(255)"], ["name" => "feishuurl", "type" => "VARCHAR(255)"], ["name" => "dingswitch", "type" => "VARCHAR(255)"], ["name" => "dingurl", "type" => "VARCHAR(255)"], ["name" => "wechatswitch", "type" => "VARCHAR(255)"], ["name" => "wechaturl", "type" => "VARCHAR(255)"], ["name" => "tgswitch", "type" => "VARCHAR(255)"], ["name" => "tgtoken", "type" => "VARCHAR(255)"], ["name" => "tgchatid", "type" => "VARCHAR(255)"], ["name" => "chongzhi", "type" => "TEXT"], ["name" => "chanpin", "type" => "TEXT"], ["name" => "xufei", "type" => "TEXT"]];
        $tableName = "shd_bill_notifyrobot";
        $tableExists = \Think\Db::query("SHOW TABLES LIKE '" . $tableName . "'");
        if (empty($tableExists)) {
            $sql = "\n            CREATE TABLE " . $tableName . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAdd)) . "\n            );\n        ";
            \Think\Db::execute($sql);
        } else {
            foreach ($fieldsToAdd as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql = "\n                    ALTER TABLE " . $tableName . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function invoicePaid($params)
    {
        $invoiceid = $params["invoiceid"];
        if (!empty($invoiceid)) {
            $invoicesInfo = \Think\Db::name("invoices")->where("id", $invoiceid)->field("id, uid, type, notes, payment, credit, subtotal, create_time, paid_time")->find();
            $id = $invoicesInfo["id"];
            $notes = $invoicesInfo["notes"];
            $uid = $invoicesInfo["uid"];
            $subtotal = $invoicesInfo["subtotal"];
            $create_time = date("Y-m-d H:i:s", $invoicesInfo["create_time"]);
            $paid_time = date("Y-m-d H:i:s", $invoicesInfo["paid_time"]);
            $type = $invoicesInfo["type"];
            $text = $type == "recharge" ? "充值" : ($type == "product" ? "产品" : ($type == "renew" ? "续费" : "未知类型"));
            $payment = $invoicesInfo["subtotal"] == $invoicesInfo["credit"] ? "余额支付" : ($invoicesInfo["credit"] != "0.00" ? "余额+" . (\Think\Db::name("plugin")->where("name", $invoicesInfo["payment"])->value("title") ?: $invoicesInfo["payment"]) : (\Think\Db::name("plugin")->where("name", $invoicesInfo["payment"])->value("title") ?: $invoicesInfo["payment"]));
            $uidInfo = \Think\Db::name("clients")->where("id", $invoicesInfo["uid"])->field("username, email")->find();
            $ename = $uidInfo["username"];
            $email = $uidInfo["email"];
            $invoicestem = \Think\Db::name("invoice_items")->where("invoice_id", $invoiceid)->field("description")->find();
            $description = $invoicestem["description"];
            $sjname = "账单支付通知";
            if ($text == "充值") {
                $sjname = "【充值通知】用户" . $ename . "充值支付到账！";
            } else {
                if ($text == "产品") {
                    $sjname = "【购买通知】用户" . $ename . "购买产品支付成功！";
                } else {
                    if ($text == "续费") {
                        $sjname = "【续费通知】用户" . $ename . "续费成功通知！";
                    } else {
                        $sjname = "【未知类型】账单支付到账通知";
                    }
                }
            }
            $notifyField = "";
            if ($type == "recharge") {
                $notifyField = "chongzhi";
            } else {
                if ($type == "product") {
                    $notifyField = "chanpin";
                } else {
                    if ($type == "renew") {
                        $notifyField = "xufei";
                    }
                }
            }
            if (!empty($notifyField)) {
                $notifyInfo = \Think\Db::name("bill_notifyrobot")->field($notifyField . ", feishuurl, dingurl, wechaturl, webname")->where("id", 1)->find();
            }
            $notifyValue = $notifyInfo[$notifyField];
            $webname = $notifyInfo["webname"];
            $message = " " . $sjname . " \n用户编号：" . $uid . " \n用户名称：" . $ename . " \n用户邮箱：" . $email . " \n账单编号：" . $id . " \n账单金额：" . $subtotal . "  元\n账单类型：" . $text . " \n创建时间：" . $create_time . " \n支付时间：" . $paid_time . " \n支付方式：" . $payment . " \n账单信息：" . $description . " \n\n消息来源【" . $webname . " 】账单支付通知【机器人版】";
            $current_time = date("Y-m-d H:i:s");
            $feishumessage = ["msg_type" => "interactive", "card" => ["elements" => [["tag" => "column_set", "flex_mode" => "bisect", "background_style" => "grey", "columns" => [["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**👤用户ID：**\n" . $uid, "text_align" => "center"]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**👤用户名称：**\n" . $ename, "text_align" => "center"]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**✉ 电子邮箱：**\n" . $email, "text_align" => "center"]]]]], ["tag" => "column_set", "flex_mode" => "bisect", "background_style" => "grey", "columns" => [["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**📂 账单类型：**\n" . $text, "text_align" => "center"]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**💰账单金额：**\n" . $subtotal . " 元", "text_align" => "center"]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**✔支付方式：**\n" . $payment, "text_align" => "center"]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**🔼 账单编号：**\n" . $id, "text_align" => "center"]]]]], ["tag" => "column_set", "flex_mode" => "none", "background_style" => "default", "columns" => [["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "div", "text" => ["content" => "**🕐创建时间：**\n" . $create_time, "tag" => "lark_md"]]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "div", "text" => ["content" => "**🕐支付时间：**\n" . $paid_time, "tag" => "lark_md"]]]], ["tag" => "column", "width" => "weighted", "weight" => 1, "vertical_align" => "top", "elements" => [["tag" => "markdown", "content" => "**🕐通知时间：**\n" . $current_time]]]]], ["tag" => "markdown", "content" => "**账单信息：**\n" . $description], ["tag" => "hr"], ["tag" => "note", "elements" => [["tag" => "plain_text", "content" => "消息来源【" . $webname . " 】账单支付通知【机器人版】"]]]], "header" => ["template" => "wathet", "title" => ["content" => (string) $sjname, "tag" => "plain_text"]]]];
            $message_json2239 = "{\n\t\"msg_type\": \"interactive\",\n\t\"card\": {\n  \"elements\": [\n    {\n      \"tag\": \"column_set\",\n      \"flex_mode\": \"bisect\",\n      \"background_style\": \"grey\",\n      \"columns\": [\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**👤用户ID：**\\n1￥\",\n              \"text_align\": \"center\"\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**👤用户名称：**\\n易支付-微信支付\",\n              \"text_align\": \"center\"\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**✉ 电子邮箱：**\\n800989\",\n              \"text_align\": \"center\"\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"tag\": \"column_set\",\n      \"flex_mode\": \"bisect\",\n      \"background_style\": \"grey\",\n      \"columns\": [\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**📂 账单类型：**\\n充值\",\n              \"text_align\": \"center\"\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**💰账单金额：**\\n￥1元\",\n              \"text_align\": \"center\"\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**✔支付方式：**\\n易支付-微信支付\",\n              \"text_align\": \"center\"\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**🔼 账单编号：**\\n800989\",\n              \"text_align\": \"center\"\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"tag\": \"column_set\",\n      \"flex_mode\": \"none\",\n      \"background_style\": \"default\",\n      \"columns\": [\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"div\",\n              \"text\": {\n                \"content\": \"**🕐创建时间：**\\n2023-02-23 20:17:51\",\n                \"tag\": \"lark_md\"\n              }\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"div\",\n              \"text\": {\n                \"content\": \"**🕐支付时间：**\\n2023-02-23 20:17:51\",\n                \"tag\": \"lark_md\"\n              }\n            }\n          ]\n        },\n        {\n          \"tag\": \"column\",\n          \"width\": \"weighted\",\n          \"weight\": 1,\n          \"vertical_align\": \"top\",\n          \"elements\": [\n            {\n              \"tag\": \"markdown\",\n              \"content\": \"**🕐通知时间：**\\n2023-02-23 20:17:51\"\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"tag\": \"markdown\",\n      \"content\": \"**账单信息：**\\n  用户充值\"\n    },\n    {\n      \"tag\": \"hr\"\n    },\n    {\n      \"tag\": \"note\",\n      \"elements\": [\n        {\n          \"tag\": \"plain_text\",\n          \"content\": \"来自【测试站】账单支付通知\"\n        }\n      ]\n    }\n  ],\n  \"header\": {\n    \"template\": \"wathet\",\n    \"title\": {\n      \"content\": \"【充值通知】来自用户 大师大师的 的充值\",\n      \"tag\": \"plain_text\"\n    }\n  }\n}\n}";
            $feishumessage_json = json_encode($feishumessage);
            $Switch = \Think\Db::name("bill_notifyrobot")->where(["id" => 1])->find();
            $sendToDingTalk = $Switch["dingswitch"] == 1;
            $sendToFeishu = $Switch["feishuswitch"] == 1;
            $sendToWeChat = $Switch["wechatswitch"] == 1;
            $sendToTGChat = $Switch["wechatswitch"] == 1;
            $TGtoken = $Switch["tgtoken"];
            $TGchatid = $Switch["tgchatid"];
            if ($notifyValue != 1) {
                return false;
            }
            $specifiedAmount = $Switch["amount"];
            if ($specifiedAmount <= $subtotal) {
                try {
                    if ($sendToFeishu) {
                        $feishuWebhookUrl = $notifyInfo["feishuurl"];
                        $feishuData = json_encode(["msg_type" => "text", "content" => ["text" => $message]]);
                        $this->sendWebhookNotification($feishuWebhookUrl, $feishuData);
                    }
                    if ($sendToDingTalk) {
                        $dingtalkWebhookUrl = $notifyInfo["dingurl"];
                        $dingtalkData = ["msgtype" => "text", "text" => ["content" => $message]];
                        $this->sendWebhookNotification($dingtalkWebhookUrl, json_encode($dingtalkData));
                    }
                    if ($sendToWeChat) {
                        $wechatWebhookUrl = $notifyInfo["wechaturl"];
                        $wechatData = ["msgtype" => "text", "text" => ["content" => $message]];
                        $this->sendWebhookNotification($wechatWebhookUrl, json_encode($wechatData));
                    }
                    if ($sendToTGChat) {
                        $telegramBotToken = $TGtoken;
                        $telegramChatId = $TGchatid;
                        $telegramMessage = urlencode($message);
                        $telegramUrl = "https://api.telegram.org/bot" . $telegramBotToken . "/sendMessage?chat_id=" . $telegramChatId . "&text=" . $telegramMessage;
                        $this->sendTelegramNotification($telegramUrl);
                    }
                    return true;
                } catch (\PHPMailer\PHPMailer\Exception $e) {
                    return false;
                }
            }
        }
    }
    private function sendWebhookNotification($webhookUrl, $data)
    {
        $ch = curl_init($webhookUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
        $response = curl_exec($ch);
        curl_close($ch);
    }
    private function sendTelegramNotification($telegramUrl)
    {
        $ch = curl_init($telegramUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        $response = curl_exec($ch);
        curl_close($ch);
    }
}

?>