<?php
class biz_CreateClass
{
    public function __construct($option)
    {
        foreach ($option as $key => $item) {
            $this->{$key} = $item;
        }
    }
}
class biz_dominbygzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.bizcn.com/rrpservices/";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($option)
    {
        $wsdl1 = "https://api.bizcn.com/rrpservices/" . $option["Service"] . "Service?wsdl";
        $client = new SoapClient($wsdl1);
        $user = new biz_CreateClass(["name" => $this->uid, "password" => strtolower(md5($this->APiKey))]);
        $params = ["user" => $user];
        foreach ($option["data"] as $key => $value) {
            if (is_array($value)) {
                $params[$key] = new biz_CreateClass($value);
            } else {
                $params[$key] = $value;
            }
        }
        $checkDomainsCommand = new biz_CreateClass($option["data"]);
        try {
            $response = $client->__soapCall($option["method"], [$params]);
            $response = json_decode(json_encode($response), true);
            return $response;
        } catch (Exception $e) {
            return ["response" => ["result" => ["code" => 500, "msg" => $e->getMessage()]]];
        }
    }
    private function get($Action, $option)
    {
        $Service = $option["Service"];
        unset($option["Service"]);
        if (empty($Service)) {
            $Service = $Action;
        }
        $r = ["method" => $Action, "data" => $option, "Service" => $Service];
        $result = $this->curl($r);
        $myarray = $result;
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("response", $myarray)) {
            return ["status" => 0, "info" => "没有参数【response】"];
        }
        if (!array_key_exists("result", $myarray["response"])) {
            return ["status" => 0, "info" => "没有参数【result】"];
        }
        if ($myarray["response"]["result"]["code"] != "200") {
            return ["status" => 0, "info" => $myarray["response"]["result"]["msg"]];
        }
        return ["status" => 1, "info" => $myarray["response"]];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    private function CheckDomain($query)
    {
        $DomainName = $query["DomainName"];
        $r = $this->get("checkDomains", ["check" => ["name" => [$DomainName]]]);
        if ($r["status"] == 1) {
            $r["info"]["Avail"] = $r["info"]["domains"]["domain"]["avail"];
        }
        return $r;
    }
    public function SaveRegistrantProfile($query)
    {
        if (!empty($query["RegistrantProfileId"])) {
            $r = $this->get("delTemplate", ["domaintemplateinfo" => ["contid" => $query["RegistrantProfileId"]], "Service" => "domainTemplate"]);
            if ($r["status"] != 1) {
                return $r;
            }
        }
        $contid_new = "T" . date("YmdHis") . $query["RegistrantType"];
        $contid_new = mb_substr($contid_new . mt_rand(0, 0), 0, 16, "UTF-8");
        $post = ["contid" => $contid_new, "templatename" => $query["RegistrantProfileId"] ?: $contid_new, "templatetype" => $query["RegistrantType"] == 1 ? "2" : "1", "companytype" => "PU", "org_e" => str_ireplace(" ", "", $query["RegistrantOrganization"]), "org_m" => $query["ZhRegistrantOrganization"], "name_e2" => explode(" ", $query["RegistrantName"])[0], "name_e1" => explode(" ", $query["RegistrantName"])[1], "name_m2" => mb_substr($query["ZhRegistrantName"], 0, 1, "UTF-8"), "name_m1" => mb_substr($query["ZhRegistrantName"], 1, NULL, "UTF-8"), "country_e" => "cn", "province_m" => $query["ZhProvince"], "province_e" => $query["Province"], "city_m" => $query["ZhCity"], "city_e" => $query["City"], "address_m" => $query["ZhAddress"], "address_e" => $query["Address"], "postcode" => $query["PostalCode"], "telephone" => "+86." . $query["Telephone"], "fax" => "+86." . $query["Telephone"], "email" => $query["Email"]];
        switch ($query["IdentityCredentialType"]) {
            case "SFZ":
                $f_type_org = "GR";
                break;
            case "HZ":
                $f_type_org = "GR";
                break;
            case "TXZ":
                $f_type_org = "GR";
                break;
            case "YYZZ":
                $f_type_org = "YYZZ";
                break;
            case "ORG":
                $f_type_org = "ORG";
                break;
            case "TYDMZ":
                $f_type_org = "YYZZ";
                break;
            default:
                if ($f_type_org == "GR") {
                    $post["file_3"] = $query["RegistrantProfilePic"];
                    $post["file_3_name"] = $query["ZhRegistrantOrganization"];
                    $post["file_3_code"] = $query["IdentityCredentialNo"];
                }
                if ($f_type_org == "YYZZ") {
                    $post["file_2"] = $query["RegistrantProfilePic"];
                    $post["file_2_name"] = $query["ZhRegistrantOrganization"];
                    $post["file_2_code"] = $query["IdentityCredentialNo"];
                }
                if ($f_type_org == "ORG") {
                    $post["file_1"] = $query["RegistrantProfilePic"];
                    $post["file_1_name"] = $query["ZhRegistrantOrganization"];
                    $post["file_1_code"] = $query["IdentityCredentialNo"];
                }
                $r = $this->get("addTemplate", ["domaintemplateinfo" => $post, "Service" => "domainTemplate"]);
                if ($r["status"] != 1) {
                    return $r;
                }
                if ($r["status"] == 1) {
                    $r["info"]["RegistrantProfileId"] = $r["info"]["contid"];
                    $r["info"]["TipMsg"] = "请注意邮箱中收到的验证邮件并且确认邮箱信息！";
                }
                return $r;
        }
    }
    private function TemplateData($data)
    {
        $status = "未知";
        strval($data["auditstatus"]);
        switch (strval($data["auditstatus"])) {
            case "cnnicauditing":
                $status = "审核中";
                break;
            case "pass":
                $status = "已实名认证";
                break;
            case "unpass":
                $status = "实名失败";
                break;
            default:
                $status = "未实名认证";
                $info = ["TemplateId" => $data["tname"], "Email" => $data["uemail"], "RegistrantType" => $data["utype"] == "P" ? 1 : 2, "ZhRegistrantName" => (string) $data["uname1"], "AuditStatus" => $status, "RegistrantName" => $data["uname2"], "Province" => $data["uprov"], "City" => $data["ucity2"], "Address" => $data["uaddr2"], "Country" => "CN", "TelArea" => "86", "Telephone" => $data["uteln"], "TelExt" => "1234", "PostalCode" => $data["uzip"]];
                if ($status == "实名失败" && !empty($data["auditUnpassReason"])) {
                    $info["AuditStatus"] = (string) $data["auditUnpassReason"];
                }
                return $info;
        }
    }
    public function DescribeTemplate($query)
    {
        $r = $this->get("queryTemplateAuthStatus", ["contid" => $query["vid"], "Service" => "domainTemplate"]);
        if ($r["status"] == 1) {
            $status = "未知";
            strval($r["info"]["auditstatus"]);
            switch (strval($r["info"]["auditstatus"])) {
                case "cnnicauditing":
                    $status = "审核中";
                    break;
                case "pass":
                    $status = "已实名认证";
                    break;
                case "unpass":
                    $status = "实名失败";
                    break;
                default:
                    $status = "未实名认证";
                    $r["AuditStatus"] = $status;
                    return ["status" => 1, "AuditStatus" => $status, "info" => $this->TemplateData($r["info"])];
            }
        } else {
            return $r;
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $r = $this->get("/audit/?act=auditlist", ["pageno" => $Offset + 1, "pagesize" => 100]);
        if ($r["status"] != 1) {
            return $r;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $r["info"]["data"]["pagelist"]["total"]]];
        foreach ($r["info"]["data"]["info"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $r = $this->get("/domain/?act=getdomains&limit=100&pageno=" . ($Offset + 1), []);
        if ($r["status"] != 1) {
            return $r;
        }
        $data = [];
        foreach ($r["info"]["data"]["items"] as $item) {
            $data[] = ["DomainId" => $item["domain"], "DomainName" => $item["domain"], "CreationDate" => $item["regdate"], "ExpirationDate" => $item["expdate"], "BuyStatus" => "ok"];
        }
        return ["status" => 1, "info" => ["DomainSet" => $data, "TotalCount" => $r["info"]["data"]["total"]]];
    }
    public function DescribeDomainBaseInfo($query)
    {
        $rr = $this->get("infoDomainWhois", ["infoDomainWhois" => ["domainname" => $query["DomainName"], "detailed" => "true"], "Service" => "infoDomainWhois"]);
        if ($rr["status"] != 1) {
            return $rr;
        }
        $Info = $rr["info"];
        return ["status" => 1, "info" => ["域名" => $query["DomainName"], "注册时间" => $Info["reg_date"], "到期时间" => $Info["expire_date"], "所有中（中文）" => $Info["dom_org_m"], "所有者（英文）" => $Info["dom_org"], "电子邮箱" => $Info["dom_em"], "手机号" => $Info["dom_ph"]]];
    }
    public function QueryDomainList($query)
    {
        $r = $this->get("infoDomainWhois", ["infoDomainWhois" => ["domainname" => $query["DomainName"]], "Service" => "infoDomainWhois"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $query["DomainName"], "DomainId" => $query["DomainName"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["expire_date"] . " " . $r["info"]["expirationtime"], "RegistrationDate" => $r["info"]["reg_date"] . " " . $r["info"]["expirationtime"]]]]]];
        return $result;
    }
    public function beforeReg($query)
    {
        $r = $this->DescribeTemplate(["vid" => $query["RegistrantProfileId"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["AuditStatus"] != "已实名认证") {
            return ["status" => 0, "info" => "当前信息模版" . $r["AuditStatus"] . "，暂时无法注册域名"];
        }
        return $r;
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $r = $this->get("addDomainByID", ["domainname" => $query["DomainName"], "term" => $query["Period"], "dns_host1" => "ns7.cnmsn.net", "dns_host2" => "ns8.cnmsn.net", "contid" => $query["RegistrantProfileId"], "Service" => "domain", "price" => $query["Price"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "正常";
        return $r;
    }
    public function SaveBatchTaskForModifyingDomainDns($query)
    {
        $arr = ["domain" => $query["DomainName.1"]];
        if (!empty($query["DomainNameServer.1"]) && !empty($query["DomainNameServer.2"])) {
            $arr["dns1"] = $query["DomainNameServer.1"];
            $arr["dns2"] = $query["DomainNameServer.2"];
        } else {
            $arr["dns1"] = "ns7.cnmsn.net";
            $arr["dns2"] = "ns8.cnmsn.net";
        }
        $r = $this->get("modDomainDns", ["moddomaindns" => ["domainname" => $query["DomainName.1"], "dnsname1" => $arr["dns1"], "dnsname2" => $arr["dns2"]], "Service" => "modChineseDomainDns"]);
        return $r;
    }
    public function DescribeDomainNs($query)
    {
        $r = $this->get("infoDomainWhois", ["infoDomainWhois" => ["domainname" => $query["DomainName"]], "Service" => "infoDomainWhois"]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => [$r["info"]["dns_host1"], $r["info"]["dns_host2"]]];
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $r = $this->get("renewDomain", ["renew" => ["domain" => $query["OrderRenewParam.1.DomainName"], "price" => $query["Price"], "term" => intval($query["OrderRenewParam.1.SubscriptionDuration"])], "Service" => "renewDomain"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($rr["info"]["data"]["rexpiredate"])));
        return $r;
    }
}

?>