<?php
class biz_dominbygzhx_dns
{
    public $ttl = 900;
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "https://api.bizcn.com/rrpservices/";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = $data["ak"];
    }
    private function curl($option)
    {
        $wsdl1 = "https://api.bizcn.com/rrpservices/" . $option["Service"] . "Service?wsdl";
        $client = new SoapClient($wsdl1);
        $user = new biz_CreateClass(["name" => $this->uid, "password" => strtolower(md5($this->APiKey))]);
        $params = ["user" => $user];
        foreach ($option["data"] as $key => $value) {
            if (is_array($value)) {
                $params[$key] = new biz_CreateClass($value);
            } else {
                $params[$key] = $value;
            }
        }
        $checkDomainsCommand = new biz_CreateClass($option["data"]);
        try {
            $response = $client->__soapCall($option["method"], [$params]);
            $response = json_decode(json_encode($response), true);
            return $response;
        } catch (Exception $e) {
            return ["response" => ["result" => ["code" => 500, "msg" => $e->getMessage()]]];
        }
    }
    private function get($Action, $option)
    {
        $Service = $option["Service"];
        unset($option["Service"]);
        if (empty($Service)) {
            $Service = $Action;
        }
        $r = ["method" => $Action, "data" => $option, "Service" => $Service];
        $result = $this->curl($r);
        $myarray = $result;
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("response", $myarray)) {
            return ["status" => 0, "info" => "没有参数【response】"];
        }
        if (!array_key_exists("result", $myarray["response"])) {
            return ["status" => 0, "info" => "没有参数【result】"];
        }
        if ($myarray["response"]["result"]["code"] != "200") {
            return ["status" => 0, "info" => $myarray["response"]["result"]["msg"]];
        }
        return ["status" => 1, "info" => $myarray["response"]];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT"];
    }
    public function Line()
    {
        return ["default" => "默认"];
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $r = $this->get("infoDnsRecord", ["domainname" => $DomainName]);
        if ($r["status"] != 1) {
            return $r;
        }
        if (is_array($r["info"]["records"]["record"])) {
            $r["info"]["records"] = $r["info"]["records"]["record"];
        }
        $records = [];
        foreach ($r["info"]["records"] as $k => $v) {
            $records[] = ["RR" => $v["host"], "Line" => "default", "Type" => $v["type"], "Value" => $v["value"], "TTL" => 900, "Status" => "ENABLE", "RecordId" => base64_encode($v["host"] . "#" . $v["type"]), "Priority" => $v["mxlevel"]];
        }
        $r["info"]["records"] = $records;
        return $r;
    }
    public function DescribeDomainRecords($query)
    {
        $r = $this->GetRecords($query["DomainName"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $totalpages = $r["info"]["totalpages"];
        $Records = $r["info"];
        if (1 < $totalpages) {
            for ($i = 2; $i <= $totalpages; $i++) {
                $rr = $this->GetRecords($query["DomainName"], $i);
                if ($rr["status"] == 1) {
                    $Records = array_merge($Records, $rr["info"]);
                }
            }
        }
        return ["status" => 1, "info" => ["DomainRecords" => ["Record" => $Records]]];
    }
    public function AddDomainRecord($query)
    {
        $r = $this->get("addDnsRecord", ["add" => ["domainname" => $query["DomainName"], "resolvetype" => $query["Type"], "resolvehost" => $query["RR"] ?: "@", "resolvevalue" => $query["Value"], "mxlevel" => $query["Priority"] ?: 10]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => base64_encode(($query["RR"] ?: "@") . "#" . $query["Type"])]];
    }
    public function UpdateDomainRecord($query)
    {
        $DescribeDomainRecords = $this->GetRecords($query["DomainName"]);
        if ($DescribeDomainRecords["status"] != 1) {
            return $DescribeDomainRecords;
        }
        $Records = array_column($DescribeDomainRecords["info"]["records"], NULL, "RecordId");
        $RecordInfo = explode("#", base64_decode($query["RecordId"]));
        $r = $this->get("modDnsRecord", ["mod" => ["domainname" => $query["DomainName"], "resolvetype" => $query["Type"], "resolvehost" => $query["RR"] ?: "@", "resolvevalue" => $query["Value"], "resolveoldvalue" => $Records[$query["RecordId"]]["Value"], "mxlevel" => $query["Priority"] ?: 10]]);
        return $r;
    }
    public function SetDomainRecordStatus($query)
    {
        return ["status" => 0, "info" => "不支持"];
    }
    public function DeleteDomainRecord($query)
    {
        $DescribeDomainRecords = $this->GetRecords($query["DomainName"]);
        if ($DescribeDomainRecords["status"] != 1) {
            return $DescribeDomainRecords;
        }
        $Records = array_column($DescribeDomainRecords["info"]["records"], NULL, "RecordId");
        $RecordInfo = explode("#", base64_decode($query["RecordId"]));
        $r = $this->get("delDnsRecord", ["del" => ["domainname" => $query["DomainName"], "resolvetype" => $Records[$query["RecordId"]]["Type"], "resolvehost" => $Records[$query["RecordId"]]["RR"] ?: "@", "resolveoldvalue" => $Records[$query["RecordId"]]["Value"], "mxlevel" => $Records[$query["RecordId"]]["Priority"] ?: 10]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "删除成功"];
    }
    public function DescribeDomainNs($query)
    {
        return ["status" => 1, "info" => ["ExpectDnsServers" => ["ExpectDnsServer" => ["", ""]]]];
    }
    public function AddDomain($query)
    {
        return ["status" => 0, "info" => "新网解析只允许西部数码的域名，请联系客服处理"];
    }
}

?>