<?php
namespace addons\black\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function submit()
    {
        $data = $_POST;
        foreach ($data as $setting => $value) {
            \think\Db::name("configuration")->where("setting", $setting)->update(["value" => $value, "update_time" => time()]);
        }
        exit(json_encode(["code" => 200, "msg" => "修改成功"]));
    }
    public function config()
    {
        $data["violations_notice"] = \think\Db::name("configuration")->where("setting", "violations_notice")->value("value");
        $this->assign("Data", $data);
        $this->assign("Title", "用户公示设置");
        return $this->fetch("/config");
    }
    public function list()
    {
        $list = \think\Db::name("violations")->select()->toArray();
        $this->assign("Title", "违规列表");
        $this->assign("List", $list);
        return $this->fetch("/list");
    }
    public function black()
    {
        $this->assign("Title", "违规添加");
        return $this->fetch("/black");
    }
    public function add()
    {
        $data = $_POST;
        if (empty($data["user"])) {
            exit(json_encode(["code" => 100, "msg" => "用户名不能为空！"]));
        }
        if (empty($data["describe"])) {
            exit(json_encode(["code" => 100, "msg" => "违规内容详情不能为空！"]));
        }
        $data["time"] = time();
        \think\Db::name("violations")->insert($data);
        exit(json_encode(["code" => 200, "msg" => "添加成功！", "data" => $data]));
    }
    public function clear()
    {
        $data = \think\Db::name("violations")->delete(true);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "清空成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "清空失败！"]));
    }
    public function delete()
    {
        $id = $_POST["id"];
        $data = \think\Db::name("violations")->where("id", $id)->delete();
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "删除成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "删除失败！"]));
    }
}

?>