<script src="https://www.layuicdn.com/layer/layer.js"></script>
  <section class="admin-main">
    <div class="container-fluid">
      <div class="page-container">
        <div class="card">
          <div class="card-body">
            <div class="card-title row"> <div style="padding:0 15px;">{$Title}</div>
              <div class="col-lg-8 col-md-12 col-sm-12">
                {foreach $PluginsAdminMenu as $v}
                  {if $v['custom']}
                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                  {else/}
                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                  {/if}
                {/foreach}
                <button onclick="clear()" type="button" class="btn btn-xs btn-success btn-sm">清空</button>
              </div>
            </div>
            <div class="tab-content mt-4">
              <div class="table-body table-responsive">
                <table class="table table-bordered table-hover">
                  <thead class="thead-light">
                    <tr>
                      <th class="center t1">ID </th>
                      <th>用户名</th>
                      <th>违规说明</th>
                      <th class="center">处理方法</th>
                      <th>时间</th>
                      <th>操作</th>
                    </tr>
                  </thead>
                  <tbody>
                  {volist name='List' id='v'}
                    <tr>
                      <td class="center">{$v.id}</td>
                      <td>{$v.user}</td>
                      <td>{$v.describe}</td>
                      <td class="center">
                      {if $v.status==0}
                        <button class="btn btn-warning btn-sm">警告</button>
                      {else}
                        <button class="btn btn-danger btn-sm">清退/封禁</button>
                      {/if}
                      </td>
                      <td>{:date('Y-m-d H:i:s',$v['time'])}</td>
                      <td>
                        <button type="button" class="btn btn-link red" onclick="del('{$v.id}')"><i class="fas fa-times-circle"></i> 删除</button>
                      </td>
                    </tr>
                    {/volist}
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<script>
function del(id) {
    var load = layer.load();
    $.ajax({
        url: "{:shd_addon_url('Black://AdminIndex/delete')}"
        ,type: 'post'
        ,data: {id:id}
        ,dataType: 'json'
        ,success: function(data){
            layer.close(load);
            if(data.code != 200)
            {
                layer.alert(data.msg,{icon:2});
                return false;
            }else{
                layer.alert(data.msg,{icon:1},function(){
                    location.reload();
                });
            }
        }
        ,error: function(){
            layer.close(load);
            layer.msg('请求失败');
        }
    })
}
function clear() {
    var load = layer.load();
    $.ajax({
        url: "{:shd_addon_url('Black://AdminIndex/clear')}"
        ,type: 'post'
        ,data: {}
        ,dataType: 'json'
        ,success: function(data){
            layer.close(load);
            if(data.code != 200)
            {
                layer.alert(data.msg,{icon:2});
                return false;
            }else{
                layer.alert(data.msg,{icon:1},function(){
                    location.reload();
                });
            }
        }
        ,error: function(){
            layer.close(load);
            layer.msg('请求失败');
        }
    })
}
</script>