<?php
namespace addons\buy_give\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \Think\Db::name("buy_give_config");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        $this->assign("Title", "功能设置");
        return $this->fetch("/setting");
    }
    public function submit()
    {
        $data = $this->request->post();
        $apiid = isset($data["apiid"]) ? $data["apiid"] : NULL;
        $apikey = isset($data["apikey"]) ? $data["apikey"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $dbConfig = ["apiid" => $apiid, "apikey" => $apikey, "open" => $open, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "authorize" => $authorize, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("buy_give_config")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("buy_give_config")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("buy_give_config")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function addactivity()
    {
        $products = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $filteredProducts = [];
        foreach ($products as $key => $product) {
            $name = \Think\Db::name("products")->where("id", $product["id"])->find();
            $name1 = \Think\Db::name("products")->where(["id" => $product["id"], "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if (!$fanProducts) {
                $product["api_name"] = $zjmf_finance_api["name"];
                $product["hidden"] = $name["hidden"];
                $filteredProducts[] = $product;
            }
        }
        $this->assign("keproducts", $filteredProducts);
        $this->assign("Title", "添加活动");
        return $this->fetch("/addactivity");
    }
    public function addactivitysubmit()
    {
        $data = $this->request->post();
        $productid = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $day = isset($data["day"]) ? $data["day"] : NULL;
        $billingcycle = isset($data["billingcycle"]) ? $data["billingcycle"] : NULL;
        $start_time = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $end_time = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $productresult = \Think\Db::name("buy_give_rules")->where("productid", $productid)->where(function ($query) use($start_time, $end_time) {
            $query->where("starttime", "<=", $end_time)->where("endtime", ">=", $start_time);
        })->find();
        if ($productresult) {
            $response = ["code" => 400, "msg" => "该产品在当前设置的活动时间已存在，请修改活动时间"];
            return json($response);
        }
        if (empty($start_time) || empty($end_time)) {
            $response = ["code" => 400, "msg" => "活动开始时间或结束时间未设置"];
            return json($response);
        }
        if ($end_time < $start_time) {
            $response = ["code" => 400, "msg" => "活动开始时间不能晚于结束时间"];
            return json($response);
        }
        if (!empty($end_time) && $end_time < time()) {
            $response = ["code" => 400, "msg" => "活动结束时间不能早于当前时间"];
            return json($response);
        }
        $dbData = ["productid" => $productid, "day" => $day, "billingcycle" => $billingcycle, "starttime" => $start_time, "endtime" => $end_time];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("buy_give_rules")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function index()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $lists = \Think\Db::name("buy_give_rules")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($lists as $record) {
            $productid = $record["productid"];
            $hostid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("Title", "活动列表");
        $this->assign("fen", $lists);
        return $this->fetch("/index", ["data" => $resultWithNames]);
    }
    public function xiu()
    {
        $id = input("get.id");
        $configurationsModel = \Think\Db::name("buy_give_rules");
        $configData = $configurationsModel->where("id", $id)->find();
        $productid = $configData["productid"];
        $products = \Think\Db::name("products")->where("p.id", $productid)->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $this->assign("products", $products);
        $this->assign("Data", $configData);
        $this->assign("Title", "修改活动");
        return $this->fetch("/xiu");
    }
    public function xiusubmit()
    {
        $data = $this->request->post();
        $activityid = isset($data["id"]) ? $data["id"] : NULL;
        $productid = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $day = isset($data["day"]) ? $data["day"] : NULL;
        $billingcycle = isset($data["billingcycle"]) ? $data["billingcycle"] : NULL;
        $start_time = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $end_time = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $productresult = \Think\Db::name("buy_give_rules")->where("productid", $productid)->where(function ($query) use($start_time, $end_time) {
            $query->where("starttime", "<=", $end_time)->where("endtime", ">=", $start_time);
        })->where("id", "<>", $activityid)->find();
        if ($productresult) {
            $response = ["code" => 400, "msg" => "该产品在当前设置的活动时间已存在，请修改活动时间"];
            return json($response);
        }
        if (empty($start_time) || empty($end_time)) {
            $response = ["code" => 400, "msg" => "活动开始时间或结束时间未设置"];
            return json($response);
        }
        if ($end_time < $start_time) {
            $response = ["code" => 400, "msg" => "活动开始时间不能晚于结束时间"];
            return json($response);
        }
        if (!empty($end_time) && $end_time < time()) {
            $response = ["code" => 400, "msg" => "活动结束时间不能早于当前时间"];
            return json($response);
        }
        $dbData = ["productid" => $productid, "day" => $day, "billingcycle" => $billingcycle, "starttime" => $start_time, "endtime" => $end_time];
        $result = \Think\Db::name("buy_give_rules")->where("id", $activityid)->update($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置修改成功。"];
        } else {
            $response = ["code" => 400, "msg" => "配置没有变化，修改失败。"];
        }
        return json($response);
    }
    public function records()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $records = \Think\Db::name("buy_give_record")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $resultWithNames = [];
        foreach ($records as $record) {
            $productid = $record["productid"];
            $hostid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("info", $resultWithNames);
        $this->assign("domain", $domain);
        $this->assign("data", $records);
        $this->assign("Title", "活动记录");
        return $this->fetch("/records");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("buy_give_rules")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>