<?php
namespace addons\buy_give;

class BuyGivePlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "BuyGive", "title" => "买就送", "description" => "买就送适用于自营业务，购买指定产品免费增加指定使用时间", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "lang" => ["chinese" => "买就送", "chinese_tw" => "買就送", "english" => "Buy and get free time"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY", "comment" => "配置ID"], ["name" => "open", "type" => "VARCHAR(255)", "comment" => "是否开启功能"], ["name" => "apiid", "type" => "VARCHAR(255)", "comment" => "APIID"], ["name" => "apikey", "type" => "VARCHAR(255)", "comment" => "APIKEY"], ["name" => "weburl", "type" => "VARCHAR(255)", "comment" => "授权域名"], ["name" => "sitename", "type" => "VARCHAR(255)", "comment" => "网站名称"], ["name" => "webmasteremail", "type" => "VARCHAR(255)", "comment" => "站长邮箱"], ["name" => "webmasterqq", "type" => "VARCHAR(255)", "comment" => "站长QQ"], ["name" => "authorize", "type" => "VARCHAR(255)", "comment" => "魔方授权码"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP", "comment" => "创建时间"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "comment" => "更新时间"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY", "comment" => "配置ID"], ["name" => "productid", "type" => "VARCHAR(255)", "comment" => "商品ID"], ["name" => "billingcycle", "type" => "VARCHAR(255)", "comment" => "付款周期"], ["name" => "day", "type" => "VARCHAR(255)", "comment" => "赠送时间"], ["name" => "starttime", "type" => "VARCHAR(255)", "comment" => "开始时间"], ["name" => "endtime", "type" => "VARCHAR(255)", "comment" => "结束时间"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP", "comment" => "创建时间"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "comment" => "更新时间"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY", "comment" => "配置ID"], ["name" => "uid", "type" => "VARCHAR(255)", "comment" => "用户ID"], ["name" => "productid", "type" => "VARCHAR(255)", "comment" => "产品ID"], ["name" => "orderid", "type" => "VARCHAR(255)", "comment" => "订单号"], ["name" => "invoiceid", "type" => "VARCHAR(255)", "comment" => "账单号"], ["name" => "hostid", "type" => "VARCHAR(255)", "comment" => "主机ID"], ["name" => "initialtime", "type" => "VARCHAR(255)", "comment" => "原到期时间"], ["name" => "day", "type" => "VARCHAR(255)", "comment" => "赠送天数"], ["name" => "latesttime", "type" => "VARCHAR(255)", "comment" => "赠送后到期时间"], ["name" => "execution_time", "type" => "VARCHAR(255)", "comment" => "执行时间"], ["name" => "status", "type" => "VARCHAR(255)", "comment" => "赠送状态，0未赠送，1已赠送"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP", "comment" => "创建时间"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP", "comment" => "更新时间"]];
        $tableName1 = "shd_buy_give_config";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_buy_give_rules";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_buy_give_record";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n                    CREATE TABLE " . $tableName3 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n                    );\n                ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                            ALTER TABLE " . $tableName3 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function afterModuleCreate($params)
    {
        foreach ($params as $value) {
            $hostid = $value["hostid"];
            $domain = $value["domain"];
            $productid = $value["productid"];
            $uid = $value["uid"];
            $billingcycle = $value["billingcycle"];
            $regdate = $value["regdate"];
            $nextduedate = $value["nextduedate"];
        }
        $currentTime = time();
        $config = \Think\Db::name("buy_give_config")->where("id", 1)->find();
        $rule = \Think\Db::name("buy_give_rules")->where("productid", $productid)->where("starttime", "<=", $currentTime)->where("endtime", ">=", $currentTime)->find();
        $orderid = \Think\Db::name("host")->where("id", $hostid)->value("orderid");
        $invoiceid = \Think\Db::name("orders")->where("id", $orderid)->value("invoiceid");
        $productname = \Think\Db::name("products")->where("id", $productid)->value("name");
        if ($config["open"] == 1 && $rule && $rule["billingcycle"] == $billingcycle) {
            $record = \Think\Db::name("buy_give_record")->where("hostid", $hostid)->value("hostid");
            if (!$record) {
                \Think\Db::startTrans();
                try {
                    $newnextduedate = $nextduedate + $rule["day"] * 86400;
                    \Think\Db::name("host")->where("id", $hostid)->update(["nextduedate" => $newnextduedate]);
                    $data = ["uid" => $uid, "orderid" => $orderid, "invoiceid" => $invoiceid, "hostid" => $hostid, "productid" => $productid, "initialtime" => $nextduedate, "day" => $rule["day"], "latesttime" => $newnextduedate, "status" => "1", "execution_time" => time()];
                    \Think\Db::name("buy_give_record")->insert($data);
                    $datainvoices = ["uid" => $uid, "create_time" => time(), "due_time" => time(), "paid_time" => time(), "update_time" => time(), "subtotal" => "0", "total" => "0", "payment" => "UserCustom", "status" => "Paid", "type" => "renew"];
                    \Think\Db::name("invoices")->insert($datainvoices);
                    $insertedId = \Think\Db::name("invoices")->getLastInsID();
                    $datainvoice_items = ["invoice_id" => $insertedId, "uid" => $uid, "type" => "renew", "rel_id" => $hostid, "due_time" => time(), "description" => "买就送活动购买" . $productname . "(主机ID：" . $hostid . "--" . $domain . ") 增加时长" . $rule["day"] . "天", "description2" => "买就送活动购买" . $productname . "(主机ID：" . $hostid . "--" . $domain . ") 增加时长" . $rule["day"] . "天", "amount" => "0"];
                    \Think\Db::name("invoice_items")->insert($datainvoice_items);
                    \Think\Db::commit();
                } catch (\Exception $e) {
                    \Think\Db::rollback();
                }
            }
        }
    }
}

?>