<?php
namespace addons\card_kami;

class CardKamiPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "CardKami", "title" => "卡密充值", "description" => "通过卡密充值插件可生成卡密、充值、管理、导出卡密等操作", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.7", "module" => "addons", "lang" => ["chinese" => "卡密充值", "chinese_tw" => "卡密增值", "english" => "Recharge"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "batch", "type" => "varchar(500)"], ["name" => "cami", "type" => "varchar(500)"], ["name" => "money", "type" => "DECIMAL(10, 2)"], ["name" => "status", "type" => "varchar(500)"], ["name" => "uid", "type" => "varchar(500)"], ["name" => "username", "type" => "varchar(500)"], ["name" => "generationtime", "type" => "varchar(500)"], ["name" => "usagetime", "type" => "varchar(500)"], ["name" => "producerid", "type" => "varchar(500)"], ["name" => "producer", "type" => "varchar(500)"], ["name" => "memo", "type" => "varchar(500)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open", "type" => "varchar(500)"], ["name" => "sitename", "type" => "varchar(500)"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "authorize", "type" => "varchar(500)"], ["name" => "webmasteremail", "type" => "varchar(500)"], ["name" => "webmasterqq", "type" => "varchar(500)"], ["name" => "notice", "type" => "varchar(500)"], ["name" => "buyurl", "type" => "varchar(500)"], ["name" => "notes", "type" => "varchar(500)"], ["name" => "dingTalkswitch", "type" => "varchar(500)"], ["name" => "dingTalkhook", "type" => "varchar(500)"], ["name" => "feishuswitch", "type" => "varchar(500)"], ["name" => "feishuhook", "type" => "varchar(500)"], ["name" => "wechatswitch", "type" => "varchar(500)"], ["name" => "wechathook", "type" => "varchar(500)"], ["name" => "tgswitch", "type" => "varchar(500)"], ["name" => "tgtoken", "type" => "varchar(500)"], ["name" => "tgchatid", "type" => "varchar(500)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $tableName1 = "shd_card_kami_list";
        $tableExists1 = \think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n                    CREATE TABLE " . $tableName1 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n                    );\n                ";
            \think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                            ALTER TABLE " . $tableName1 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_card_kami_set";
        $tableExists2 = \think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n                    CREATE TABLE " . $tableName2 . " (\n                        " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n                    );\n                ";
            \think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                            ALTER TABLE " . $tableName2 . "\n                            ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                        ";
                    \think\Db::execute($sql2);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
}

?>