<?php
namespace addons\card_kami\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function setting()
    {
        $configurationsModel = \think\Db::name("card_kami_set");
        $configData = $configurationsModel->find();
        $isMismatch = false;
        $mismatchMessage = "恭喜您，授权成功";
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function settings()
    {
        $data = $this->request->post();
        $open = isset($data["open"]) ? $data["open"] : NULL;
        $sitename = isset($data["sitename"]) ? $data["sitename"] : NULL;
        $authorize = isset($data["authorize"]) ? $data["authorize"] : NULL;
        $webmasteremail = isset($data["webmasteremail"]) ? $data["webmasteremail"] : NULL;
        $webmasterqq = isset($data["webmasterqq"]) ? $data["webmasterqq"] : NULL;
        $notice = isset($data["notice"]) ? $data["notice"] : NULL;
        $buyurl = isset($data["buyurl"]) ? $data["buyurl"] : NULL;
        $notes = isset($data["notes"]) ? $data["notes"] : NULL;
        $dingTalkswitch = isset($data["dingTalkswitch"]) ? $data["dingTalkswitch"] : NULL;
        $dingTalkhook = isset($data["dingTalkhook"]) ? $data["dingTalkhook"] : NULL;
        $feishuswitch = isset($data["feishuswitch"]) ? $data["feishuswitch"] : NULL;
        $feishuhook = isset($data["feishuhook"]) ? $data["feishuhook"] : NULL;
        $wechatswitch = isset($data["wechatswitch"]) ? $data["wechatswitch"] : NULL;
        $wechathook = isset($data["wechathook"]) ? $data["wechathook"] : NULL;
        $tgswitch = isset($data["tgswitch"]) ? $data["tgswitch"] : NULL;
        $tgtoken = isset($data["tgtoken"]) ? $data["tgtoken"] : NULL;
        $tgchatid = isset($data["tgchatid"]) ? $data["tgchatid"] : NULL;
        $dbConfig = ["open" => $open, "sitename" => $sitename, "authorize" => $authorize, "webmasteremail" => $webmasteremail, "webmasterqq" => $webmasterqq, "notice" => $notice, "buyurl" => $buyurl, "notes" => $notes, "dingTalkswitch" => $dingTalkswitch, "dingTalkhook" => $dingTalkhook, "feishuswitch" => $feishuswitch, "feishuhook" => $feishuhook, "wechatswitch" => $wechatswitch, "wechathook" => $wechathook, "tgswitch" => $tgswitch, "tgtoken" => $tgtoken, "tgchatid" => $tgchatid, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \think\Db::name("card_kami_set")->where("id", 1)->find();
        if ($result) {
            $updateResult = \think\Db::name("card_kami_set")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \think\Db::name("card_kami_set")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function addkami()
    {
        $this->assign("Title", "自定义生成卡密");
        return $this->fetch("/addkami");
    }
    public function addkamis()
    {
        $adminId = cmf_get_current_admin_id();
        if (!empty($adminId)) {
            $this->assign("admin_id", $adminId);
        }
        $user_login = \think\Db::name("user")->where("id", $adminId)->value("user_login");
        $data = $this->request->post();
        $batch = isset($data["batch"]) ? $data["batch"] : NULL;
        $cami = isset($data["cami"]) ? $data["cami"] : NULL;
        $money = isset($data["money"]) ? $data["money"] : NULL;
        $memo = isset($data["memo"]) ? $data["memo"] : NULL;
        if (empty($data["cami"])) {
            $response = ["code" => 400, "msg" => "卡密不能为空值。"];
            return json($response);
        }
        if (empty($data["money"])) {
            $response = ["code" => 400, "msg" => "请输入面值。"];
            return json($response);
        }
        $existingKami = \think\Db::name("card_kami_list")->where("cami", $cami)->find();
        if ($existingKami) {
            $response = ["code" => 400, "msg" => "该卡密已存在"];
        } else {
            $data = ["batch" => $batch, "cami" => $cami, "money" => $money, "status" => 0, "generationtime" => time(), "producerid" => $adminId, "producer" => $user_login, "memo" => $memo];
            $result = \think\Db::name("card_kami_list")->insert($data);
            if ($result !== false) {
                $response = ["code" => 200, "msg" => "卡密生成成功"];
            } else {
                $response = ["code" => 400, "msg" => "卡密生成失败"];
            }
        }
        return json($response);
    }
    public function addrandkami()
    {
        $this->assign("Title", "随机生成卡密");
        return $this->fetch("/addrandkami");
    }
    public function addrandkamis()
    {
        $adminId = cmf_get_current_admin_id();
        if (!empty($adminId)) {
            $this->assign("admin_id", $adminId);
        }
        $user_login = \think\Db::name("user")->where("id", $adminId)->value("user_login");
        $data = $this->request->post();
        $batch = isset($data["batch"]) ? $data["batch"] : NULL;
        $length = isset($data["length"]) ? $data["length"] : NULL;
        $money = isset($data["money"]) ? $data["money"] : NULL;
        $amount = isset($data["amount"]) ? $data["amount"] : NULL;
        $memo = isset($data["memo"]) ? $data["memo"] : NULL;
        if (!empty($batch) && !preg_match("/^[a-zA-Z0-9]+\$/", $batch)) {
            $response = ["code" => 400, "msg" => "卡密前缀必须是字母和数字的组合。"];
            return json($response);
        }
        if (empty($data["length"])) {
            $response = ["code" => 400, "msg" => "卡密长度不能为空。"];
            return json($response);
        }
        if (empty($data["money"])) {
            $response = ["code" => 400, "msg" => "请输入面值。"];
            return json($response);
        }
        if (empty($amount)) {
            $response = $this->generateAndStoreKami($batch, $length, $money, $adminId, $user_login, $memo);
        } else {
            $responses = $this->generateMultipleKamis($batch, $length, $money, $amount, $adminId, $user_login, $memo);
            $generatedCount = count($responses);
            $response = ["code" => 200, "msg" => "卡密生成成功，本次共生成了 " . $generatedCount . " 张卡密", "data" => $responses];
        }
        return json($response);
    }
    private function generateAndStoreKami($batch, $length, $money, $adminId, $user_login, $memo)
    {
        $cami = $this->generateRandomKami($length);
        if (!empty($batch)) {
            $cami = $batch . $cami;
        }
        $existingKami = \think\Db::name("card_kami_list")->where("cami", $cami)->find();
        if ($existingKami) {
            return ["code" => 400, "msg" => "该卡密已存在"];
        }
        $dataToInsert = ["batch" => $batch, "cami" => $cami, "money" => $money, "status" => 0, "generationtime" => time(), "producerid" => $adminId, "producer" => $user_login, "memo" => $memo];
        $result = \think\Db::name("card_kami_list")->insert($dataToInsert);
        if ($result !== false) {
            return ["code" => 200, "msg" => "卡密生成成功"];
        }
        return ["code" => 400, "msg" => "卡密生成失败"];
    }
    private function generateMultipleKamis($batch, $length, $money, $amount, $adminId, $user_login, $memo)
    {
        $responses = [];
        for ($i = 0; $i < $amount; $i++) {
            $response = $this->generateAndStoreKami($batch, $length, $money, $adminId, $user_login, $memo);
            $responses[] = $response;
        }
        return $responses;
    }
    private function generateRandomKami($length)
    {
        $characters = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $cami = "";
        for ($i = 0; $i < $length; $i++) {
            $cami .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $cami;
    }
    public function kamilist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $camilist = \think\Db::name("card_kami_list")->alias("ck")->leftJoin("clients c", "ck.uid = c.id")->field("ck.*, c.username AS user_name")->paginate($pageSize, false, ["page" => $page]);
        $this->assign("kamilist", $camilist);
        $this->assign("domain", $domain);
        $this->assign("Title", "全部卡密");
        return $this->fetch("/kamilist");
    }
    public function kamiuserlist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $camiuserlist = \think\Db::name("card_kami_list")->alias("ck")->join("clients c", "ck.uid = c.id")->where("ck.status", "<>", 0)->field("ck.*, c.username")->paginate($pageSize, false, ["page" => $page]);
        $this->assign("kamiuserlist", $camiuserlist);
        $this->assign("domain", $domain);
        $this->assign("Title", "已使用卡密");
        return $this->fetch("/kamiuserlist");
    }
    public function kaminolist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $caminolist = \think\Db::name("card_kami_list")->where("status", "<>", 1)->paginate($pageSize, false, ["page" => $page]);
        $this->assign("kaminolist", $caminolist);
        $this->assign("Title", "未使用卡密");
        return $this->fetch("/kaminolist");
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $status = \think\Db::name("card_kami_list")->where("id", $id)->value("status");
            if ($status === NULL) {
                return json(["code" => 500, "msg" => "卡密不存在"]);
            }
            if ($status == 0) {
                $result = \think\Db::name("card_kami_list")->where("id", $id)->delete();
                if ($result !== false) {
                    return json(["code" => 200, "msg" => "卡密删除成功"]);
                }
                return json(["code" => 500, "msg" => "卡密删除失败"]);
            }
            if ($status == 1) {
                return json(["code" => 500, "msg" => "已使用的卡密禁止删除"]);
            }
        }
    }
    public function exportkamilist()
    {
        $caminolist = \think\Db::name("card_kami_list")->select();
        $timestamp = date("Y-m-d_H-i-s");
        $csvFileName = "kamilist_" . $timestamp . ".csv";
        $csvFile = fopen("php://temp/maxmemory:5242880", "r+");
        fwrite($csvFile, "﻿");
        fputcsv($csvFile, ["序列号", "卡批号", "卡号", "面值", "状态", "使用者ID", "使用者", "生成时间", "使用时间", "操作者ID", "操作者", "备注"]);
        foreach ($caminolist as $item) {
            $statusText = $item["status"] == 1 ? "已使用" : "未使用";
            $generationtime = date("Y-m-d H:i:s", $item["generationtime"]);
            $usagetime = date("Y-m-d H:i:s", $item["usagetime"]);
            fputcsv($csvFile, [$item["id"], $item["batch"], $item["cami"], $item["money"], $statusText, $item["uid"], $item["username"], $generationtime, $usagetime, $item["producerid"], $item["producer"], $item["memo"]]);
        }
        rewind($csvFile);
        $csvContent = stream_get_contents($csvFile);
        fclose($csvFile);
        header("Content-Type: text/csv; charset=utf-8");
        header("Content-Disposition: attachment; filename=\"" . $csvFileName . "\"");
        header("Content-Length: " . strlen($csvContent));
        echo $csvContent;
        exit;
    }
    public function exportkaminolist()
    {
        $caminolist = \think\Db::name("card_kami_list")->where("status", 0)->select();
        $timestamp = date("Y-m-d_H-i-s");
        $csvFileName = "kaminolist_" . $timestamp . ".csv";
        $csvFile = fopen("php://temp/maxmemory:5242880", "r+");
        fwrite($csvFile, "﻿");
        fputcsv($csvFile, ["序列号", "卡批号", "卡号", "面值", "状态", "生成时间", "操作者ID", "操作者", "备注"]);
        foreach ($caminolist as $item) {
            $statusText = $item["status"] == 1 ? "已使用" : "未使用";
            $generationtime = date("Y-m-d H:i:s", $item["generationtime"]);
            fputcsv($csvFile, [$item["id"], $item["batch"], $item["cami"], $item["money"], $statusText, $generationtime, $item["producerid"], $item["producer"], $item["memo"]]);
        }
        rewind($csvFile);
        $csvContent = stream_get_contents($csvFile);
        fclose($csvFile);
        header("Content-Type: text/csv; charset=utf-8");
        header("Content-Disposition: attachment; filename=\"" . $csvFileName . "\"");
        header("Content-Length: " . strlen($csvContent));
        echo $csvContent;
        exit;
    }
    public function exportkamiuserlist()
    {
        $caminolist = \think\Db::name("card_kami_list")->where("status", 1)->select();
        $timestamp = date("Y-m-d_H-i-s");
        $csvFileName = "kamiuserlist_" . $timestamp . ".csv";
        $csvFile = fopen("php://temp/maxmemory:5242880", "r+");
        fwrite($csvFile, "﻿");
        fputcsv($csvFile, ["序列号", "卡批号", "卡号", "面值", "状态", "使用者ID", "使用者", "生成时间", "使用时间", "操作者ID", "操作者", "备注"]);
        foreach ($caminolist as $item) {
            $statusText = $item["status"] == 1 ? "已使用" : "未使用";
            $generationtime = date("Y-m-d H:i:s", $item["generationtime"]);
            $usagetime = date("Y-m-d H:i:s", $item["usagetime"]);
            fputcsv($csvFile, [$item["id"], $item["batch"], $item["cami"], $item["money"], $statusText, $item["uid"], $item["username"], $generationtime, $usagetime, $item["producerid"], $item["producer"], $item["memo"]]);
        }
        rewind($csvFile);
        $csvContent = stream_get_contents($csvFile);
        fclose($csvFile);
        header("Content-Type: text/csv; charset=utf-8");
        header("Content-Disposition: attachment; filename=\"" . $csvFileName . "\"");
        header("Content-Length: " . strlen($csvContent));
        echo $csvContent;
        exit;
    }
    public function addhelp()
    {
        if ($this->lang == "chinese") {
            $title = "Demo样式1";
        } else {
            if ($this->lang == "english") {
                $title = "Demo Style 1";
            } else {
                if ($this->lang == "chinese_tw") {
                    $title = "Demo樣式1";
                }
            }
        }
        $this->assign("Title", $title);
        return $this->fetch("/addhelp");
    }
    public function customerdetail1()
    {
        $this->assign("Title", "Demo样式2");
        return $this->fetch("/customerdetail1");
    }
    public function customerdetail2()
    {
        $this->assign("Title", "Demo样式3");
        return $this->fetch("/customerdetail2");
    }
    public function customerdetail3()
    {
        $this->assign("Title", "Demo样式4");
        return $this->fetch("/customerdetail3");
    }
    public function customerdetail4()
    {
        $this->assign("Title", "Demo样式5");
        return $this->fetch("/customerdetail4");
    }
    public function helplist()
    {
        $this->assign("Title", "Demo样式6");
        return $this->fetch("/helplist");
    }
}

?>