<?php
namespace addons\cash_out\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function apply()
    {
        if (empty($_POST)) {
            $data["open"] = \think\Db::name("configuration")->where("setting", "withdraw_is")->value("value");
            $data["real"] = \think\Db::name("configuration")->where("setting", "withdraw_is_real")->value("value");
            $data["zfb"] = \think\Db::name("configuration")->where("setting", "withdraw_is_zfb")->value("value");
            $data["wx"] = \think\Db::name("configuration")->where("setting", "withdraw_is_wx")->value("value");
            $data["qq"] = \think\Db::name("configuration")->where("setting", "withdraw_is_qq")->value("value");
            $data["bank"] = \think\Db::name("configuration")->where("setting", "withdraw_is_bank")->value("value");
            $data["notice"] = \think\Db::name("configuration")->where("setting", "withdraw_notice")->value("value");
            $data["charge"] = \think\Db::name("configuration")->where("setting", "withdraw_charge")->value("value");
            $this->assign("Data", $data);
            $this->assign("Title", "申请提现");
            return $this->fetch("/apply");
        }
        $data = $_POST;
        if (empty($data["way"]) || empty($data["num"]) || empty($data["username"]) || empty($data["name"])) {
            exit(json_encode(["code" => 100, "msg" => "除收款码外，其他都不能为空！"]));
        }
        $charge = \think\Db::name("configuration")->where("setting", "withdraw_charge")->value("value");
        $is_real = \think\Db::name("configuration")->where("setting", "withdraw_is_real")->value("value");
        $user = \think\Db::name("clients")->find($data["uid"]);
        $end_money = $user["credit"] - $data["num"];
        $user_pr = \think\Db::name("certifi_person")->where("auth_user_id", $data["uid"])->value("status");
        $user_cr = \think\Db::name("certifi_company")->where("auth_user_id", $data["uid"])->value("status");
        if ($user["credit"] < $data["num"]) {
            exit(json_encode(["code" => 100, "msg" => "提现金额大于可提现金额！"]));
        }
        if ($is_real == 1 && $user_pr !== 1 && $user_cr !== 1) {
            exit(json_encode(["code" => 100, "msg" => "您还未通过实名认证，暂时无法提现！"]));
        }
        if ($data["way"] == "zfb") {
            $way = "支付宝";
        } else {
            if ($data["way"] == "wx") {
                $way = "微信";
            } else {
                if ($data["way"] == "qq") {
                    $way = "QQ";
                } else {
                    $way = "银行卡";
                }
            }
        }
        $sxf = $data["num"] * $charge / 100;
        $info = ["uid" => $data["uid"], "num" => $data["num"], "create_time" => time(), "username" => $data["username"], "qrcode" => $data["qrcode"], "way" => $way, "name" => $data["name"], "charge" => $sxf, "status" => 1];
        $sql = \think\Db::name("affiliates_withdraw")->insert($info);
        $sql2 = \think\Db::name("clients")->where("id", $data["uid"])->update(["credit" => $end_money]);
        if ($sql && $sql2) {
            exit(json_encode(["code" => 200, "msg" => "提交成功！"]));
        }
        exit(json_encode(["code" => 100, "msg" => "提交失败！"]));
    }
    public function list()
    {
        $uid = $_GET["uid"];
        $s["already"] = \think\Db::name("affiliates_withdraw")->where("uid", $uid)->where("status", 2)->sum("num");
        $s["is"] = \think\Db::name("affiliates_withdraw")->where("uid", $uid)->where("status", 1)->sum("num");
        $s["refuse"] = \think\Db::name("affiliates_withdraw")->where("uid", $uid)->where("status", 3)->sum("num");
        $s["can"] = \think\Db::name("clients")->where("id", $uid)->value("credit");
        $list = \think\Db::name("affiliates_withdraw")->where("uid", $uid)->order("id", "desc")->select()->toArray();
        $this->assign("s", $s);
        $this->assign("List", $list);
        $this->assign("Title", "提现列表");
        return $this->fetch("/list");
    }
}

?>