<?php
namespace addons\cash_out\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function submit()
    {
        $data = $_POST;
        if (empty($data["charge"])) {
            exit(json_encode(["code" => 100, "msg" => "手续费百分比不能为空！"]));
        }
        foreach ($data as $setting => $value) {
            \think\Db::name("configuration")->where("setting", "withdraw_" . $setting)->update(["value" => $value]);
        }
        exit(json_encode(["code" => 200, "msg" => "修改成功"]));
    }
    public function config()
    {
        $data["is"] = \think\Db::name("configuration")->where("setting", "withdraw_is")->value("value");
        $data["is_real"] = \think\Db::name("configuration")->where("setting", "withdraw_is_real")->value("value");
        $data["is_wx"] = \think\Db::name("configuration")->where("setting", "withdraw_is_wx")->value("value");
        $data["is_qq"] = \think\Db::name("configuration")->where("setting", "withdraw_is_qq")->value("value");
        $data["is_zfb"] = \think\Db::name("configuration")->where("setting", "withdraw_is_zfb")->value("value");
        $data["is_bank"] = \think\Db::name("configuration")->where("setting", "withdraw_is_bank")->value("value");
        $data["notice"] = \think\Db::name("configuration")->where("setting", "withdraw_notice")->value("value");
        $data["charge"] = \think\Db::name("configuration")->where("setting", "withdraw_charge")->value("value");
        $this->assign("Data", $data);
        $this->assign("Title", "提现设置");
        return $this->fetch("/config");
    }
    public function list()
    {
        $list = \think\Db::name("affiliates_withdraw")->select()->toArray();
        foreach ($list as $key => $value) {
            $user = \think\Db::name("clients")->find($list["uid"]);
            $list[$key]["user"] = $user["username"];
        }
        $this->assign("Title", "提现列表");
        $this->assign("List", $list);
        return $this->fetch("/list");
    }
    public function pass()
    {
        $id = $_POST["id"];
        if (empty($id)) {
            exit(json_encode(["code" => 100, "msg" => "提现ID不存在！"]));
        }
        $data = \think\Db::name("affiliates_withdraw")->where("id", $id)->update(["status" => 2, "update_time" => time()]);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "提现申请通过成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "提现申请通过失败！"]));
    }
    public function refuse()
    {
        $id = $_POST["id"];
        $reason = $_POST["reason"];
        if (empty($id)) {
            exit(json_encode(["code" => 100, "msg" => "提现ID不存在！"]));
        }
        if (empty($reason)) {
            exit(json_encode(["code" => 100, "msg" => "理由不能为空！"]));
        }
        $data = \think\Db::name("affiliates_withdraw")->find($id);
        $sql = \think\Db::name("affiliates_withdraw")->where("id", $id)->update(["status" => 3, "reason" => $reason, "update_time" => time()]);
        $user = \think\Db::name("clients")->find($data["uid"]);
        $end_money = $user["credit"] + $data["num"];
        $sql2 = \think\Db::name("clients")->where("id", $data["uid"])->update(["credit" => $end_money]);
        if ($sql) {
            exit(json_encode(["code" => 200, "msg" => "提现申请驳回成功，已退回余额"]));
        }
        exit(json_encode(["code" => 100, "msg" => "提现申请驳回失败！", "data" => $id]));
    }
}

?>