<script src="https://www.layuicdn.com/layer/layer.js"></script>
  <section class="admin-main">
    <div class="container-fluid">
      <div class="page-container">
        <div class="card">
          <div class="card-body">
            <div class="card-title row"> <div style="padding:0 15px;">{$Title}</div>
              <div class="col-lg-8 col-md-12 col-sm-12">
                {foreach $PluginsAdminMenu as $v}
                  {if $v['custom']}
                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                  {else/}
                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                  {/if}
                {/foreach}
              </div>
            </div>
            <div class="tab-content mt-4">
              <div class="table-body table-responsive">
                <table class="table table-bordered table-hover">
                  <thead class="thead-light">
                    <tr>
                      <th class="center t1">ID </th>
                      <th>用户/公司名</th>
                      <th>提现金额</th>
                      <th>手续费</th>
                      <th>扣除手续费后</th>
                      <th>真实姓名</th>
                      <th>提现方式</th>
                      <th>提现账号/银行卡号</th>
                      <th>收款码</th>
                      <th>提交时间</th>
                      <th class="center">状态</th>
                      <th class="center t5">操作</th>
                    </tr>
                  </thead>
                  <tbody>
                  {volist name='List' id='v'}
                    <tr>
                      <td class="center">{$v.id}</td>
                      <td>{$v.user}</td>
                      <td>{$v.num}</td>
                      <td>{$v.charge}</td>
                      <td>{$v.num-$v.charge}</td>
                      <td>{$v.name}</td>
                      <td>{$v.way}</td>
                      <td>{$v.username}</td>
                      <td><img src="{$v.qrcode}"  height="30" class="img-rounded"></td>
                      <td>{:date('Y-m-d H:i:s',$v['create_time'])}</td>
                      <td class="center">
                      {if $v.status == 1}
                        <button type="button" class="btn btn-xs btn-warning btn-sm">待审核</button>
                      {elseif $v.status == 2}
                        <button type="button" class="btn btn-success btn-sm">审核通过</button>
                      {else}
                        <button type="button" class="btn btn-danger btn-sm">已驳回</button>
                      {/if}
                      </td>
                      <td>
                      {if $v.status == 1}
                        <button type="button" class="btn btn-link" onclick="qrcode('{$v.qrcode}','{$v.name}')"><i class="fas fa-eye"></i> 查看收款码</button>
                        <button type="button" class="btn btn-link green" onclick="pass('{$v.id}')"><i class="fas fa-check-circle"></i> 通过</button>
                        <button type="button" class="btn btn-link red" onclick="refuse('{$v.id}')"><i class="fas fa-times-circle"></i> 驳回</button>
                      {/if}
                      </td>
                    </tr>
                    {/volist}
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
<script>
function qrcode(url,name) {
    layer.open({
        title: name+'的收款码',
        content: '<img title="收款码" width="100%" height="100%" alt="收款码" src="'+url+'">'
    });
}
function pass(id) {
    var load = layer.load();
    $.ajax({
        url: "{:shd_addon_url('CashOut://AdminIndex/pass')}"
        ,type: 'post'
        ,data: {id:id}
        ,dataType: 'json'
        ,success: function(data){
            layer.close(load);
            if(data.code != 200)
            {
                layer.alert(data.msg,{icon:2});
                return false;
            }else{
                layer.alert(data.msg,{icon:1},function(){
                    location.reload();
                });
            }
        }
        ,error: function(){
            layer.close(load);
            layer.msg('请求失败');
        }
    })
}
function refuse(id) {
    layer.prompt({title: '输入提现申请驳回的理由，并确认', formType: 2}, function(reason, index){
        layer.close(index);
        var load = layer.load();
        $.ajax({
            url: "{:shd_addon_url('CashOut://AdminIndex/refuse')}"
            ,type: 'post'
            ,data: {id:id,reason:reason}
            ,dataType: 'json'
            ,success: function(data){
                layer.close(load);
                if(data.code != 200)
                {
                    layer.alert(data.msg,{icon:2});
                    return false;
                }else{
                    layer.alert(data.msg,{icon:1},function(){
                        location.reload();
                    });
                }
            }
            ,error: function(){
                layer.close(load);
                layer.msg('请求失败');
            }
        })
    });    
}
</script>