<?php
namespace addons\check\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function submit()
    {
        $data = $_POST;
        foreach ($data as $setting => $value) {
            \think\Db::name("configuration")->where("setting", $setting)->update(["value" => $value, "update_time" => time()]);
        }
        exit(json_encode(["code" => 200, "msg" => "修改成功"]));
    }
    public function config()
    {
        $data["check_is"] = \think\Db::name("configuration")->where("setting", "check_is")->value("value");
        $data["check_value"] = \think\Db::name("configuration")->where("setting", "check_value")->value("value");
        $this->assign("Data", $data);
        $this->assign("Title", "签到设置");
        return $this->fetch("/config");
    }
    public function log()
    {
        $list = \think\Db::name("check_log")->order("id", "desc")->select()->toArray();
        foreach ($list as $key => $value) {
            $user = \think\Db::name("clients")->find($list["uid"]);
            $list[$key]["user"] = $user["username"];
        }
        $this->assign("Title", "签到日志");
        $this->assign("List", $list);
        return $this->fetch("/log");
    }
    public function clear()
    {
        $data = \think\Db::name("check_log")->delete(true);
        if ($data) {
            exit(json_encode(["code" => 200, "msg" => "签到日志清空成功"]));
        }
        exit(json_encode(["code" => 100, "msg" => "签到日志清空失败！"]));
    }
}

?>