<?php
namespace addons\clean_order;

class CleanOrderPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "CleanOrder", "title" => "定时清理订单", "description" => "手动、定时任务清理对接上游已删除的订单将本站订单更新为删除状态", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.0.0", "module" => "addons", "not_install" => true];
    public function install()
    {
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function afterCron()
    {
        \Think\Db::name("run_maping")->where("from_type", 400)->where("active_type", "in", [2])->where("description", "like", "%只有激活和暂停状态才能暂停%")->where("status", 0)->update(["active_type" => 4]);
        $rowsToUpdate = \Think\Db::name("run_maping")->where("from_type", 400)->where("active_type", "in", [4])->where("status", 0)->field("id, description")->select();
        foreach ($rowsToUpdate as $row) {
            $newDescription = $row["description"];
            if (strpos($newDescription, "【自动任务已更新为删除】: ") !== 0) {
                $newDescription = "【自动任务已更新为删除】: " . $newDescription;
                \Think\Db::name("run_maping")->where("id", $row["id"])->update(["description" => $newDescription]);
            }
        }
        $affectedRows = \Think\Db::name("run_maping")->where("from_type", 400)->where("active_type", "in", [4])->where("status", 0)->update(["status" => 1]);
        $hostIds = \Think\Db::name("run_maping")->where("from_type", 400)->where("active_type", 4)->where("status", 1)->column("host_id");
        if (!empty($hostIds)) {
            \Think\Db::name("host")->whereIn("id", $hostIds)->update(["domainstatus" => "Deleted"]);
        }
    }
}

?>