<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">
                        <div class="table-tools domain-table-tools">
                            <a href="./addons?_plugin=dominbygzhx&_controller=admin_index&_action=template" class="btn btn-success w-sm nohide add-activity">
                                <i class="fas fa-plus-circle"></i> 注册域名信息模版
                            </a>


                        </div>
                        <div class="table-body auto-login-content">
                            <table class="table table-bordered table-hover">
                                <caption>选中的项目：<input type="text" name="distributeusername" id="distributeusername" value="" placeholder="用户名"> <button type="button" class="btn btn-danger btn-sm update-files">批量分配</button></caption>
                                <thead class="thead-light">
                                <tr>
                                    <th class="checkbox">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="customCheckHead" name="headCheckbox">
                                            <label class="custom-control-label" for="customCheckHead">&nbsp;</label>
                                        </div>
                                    </th>
                                    <th>接口</th>
                                    <th>ID</th>
                                    <th>所有者</th>
                                    <th>证件类型</th>
                                    <th>分配用户</th>
                                    <th>状态</th>
                                    <th>处理</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>
                                        <td class="checkbox">
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input row-checkbox" data-file='{$item|json_encode}' id="customCheck{$key}">
                                                <label class="custom-control-label" for="customCheck{$key}">&nbsp;</label>
                                            </div>
                                        </td>
                                        <td>{$item.name}</td>
                                        <td>{$item.vid}</td>
                                        <td>{$item.organization_name}</td>
                                        <td> {switch $item.certificate_type }
                                            {case SFZ} 身份证{/case}
                                            {case HZ} 护照{/case}
                                            {case TXZ} 中国港澳居民来往内地通行证{/case}
                                            {case TWSFZ} 中国台湾居民来往大陆通行证{/case}
                                            {case GWSFZ} 外国人永久居留身份证{/case}
                                            {case ORG} 组织机构代码证{/case}
                                            {case YYZZ} 工商营业执照{/case}
                                            {case TYDMZ} 统一社会信用代码证书{/case}
                                            {case BDDH} 部队代号{/case}
                                            {case JDXKZ} 军队单位对外有偿服务许可证{/case}
                                            {case SYZS} 事业单位法定代表人证书{/case}
                                            {case GWCZDJZ} 外国企业常驻代表机构登记证{/case}
                                            {case STDJZ} 社会团体法定代表人登记证书{/case}
                                            {case ZJDJZ} 宗教活动场所登记证{/case}
                                            {case MBDJZ} 民办非企业单位登记证书{/case}
                                            {case JJDJZ} 基金会法定代表人登记证书{/case}
                                            {case LSXKZ} 律师事务所执业许可证{/case}
                                            {case GWZHDJZ} 外国在华文化中心登记证{/case}
                                            {case GWLYDJZ} 外国政府旅游部门常驻代表机构批准登记证{/case}
                                            {case SFXKZ} 司法鉴定许可证{/case}
                                            {case GWJGZJ} 外国机构证件{/case}
                                            {case SHFWJGZ} 社会服务机构登记证书{/case}
                                            {case MBXXXKZ} 民办学校办学许可证{/case}
                                            {case YLJGXKZ} 医疗机构执业许可证{/case}
                                            {case GAJZZ} 中国港澳居住证{/case}
                                            {case TWJZZ} 中国台湾居住证{/case}
                                            {case QTTYDM} 其他-统一社会信用代码证书{/case}
                                            {case GZJGZY} 公证机构执业证{/case}
                                            {default /}未知证件
                                            {/switch}</td>
                                        <td>
                                            <div style="display: flex;">
                                                <input type="text" name="distributeusername" value="{$item.username}" placeholder="用户名" style="border-right: 0;border-bottom-right-radius: 0;border-top-right-radius: 0;"> <button type="button" class="btn btn-danger btn-sm update-file" style="border-left: 0;border-bottom-left-radius: 0;border-top-left-radius: 0;" data-id="{$item.id}">分配</button>
                                            </div>

                                        </td>
                                        <td>{$item.status}</td>
                                        <td>{switch $item.status }
                                            {case 审核中}<a href="javascript:;" class="btn btn-primary btn-Refresh-Data" data-id="{$item.id}" style="color: #fff!important;"><i class="fas fa-cogs"></i> 刷新状态</a>{/case}

                                            {case 已实名认证}{/case}

                                            {default /}<a href="./addons?_plugin=dominbygzhx&_controller=admin_index&_action=template&vid={$item.id}" class="btn btn-danger" style="color: #fff!important;"><i class="fas fa-folder-plus"></i> 修改提交</a>
                                            {/switch}</td>
                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>
                        <div class="table-body">文档说明：<a href="https://html5code.org/type/zjmf.html" target="_blank">https://html5code.org/type/zjmf.html</a> </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/dominbygzhx/template/js/pagination.js"></script>
<script src="/plugins/addons/dominbygzhx/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {



                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) option.error(t.info);
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) option.error("网络错误，请重试");
                }
            }
        );
    }
    $(function (){
        $('#customCheckHead').off("click").on('click',function () {
            let checked=$(this).prop("checked");
            $(this).closest('table').find('input[type="checkbox"]').prop("checked",checked);
        })
        let update=function (data,username,callback,error){
            ajax({
                data:{
                    action:'set',
                    username:username,
                    domain:JSON.stringify(data)
                },
                success:function (r){
                    callback();

                },error:function (r){
                    layer.msg(r);
                    if(error){
                        error(r);
                    }
                }
            })
        }
        $('.update-files').off("click").on("click",function (){
            $('#renewMsg').html('');
            let self=$(this),data=[],username=$('#distributeusername').val();
            if(!username){
                layer.msg('请输入要分配的用户名');
                return false;
            }
            self.closest('table').find('input[data-file][type="checkbox"]:checked').each(function (item){
                let s= $(this).data("file");
                data.push(s.id);

            })

            if(data.length<1){
                layer.msg('请选择要分配的域名');
                return false;
            }
            update(data,username,function (){
                self.closest('table').find('input[data-file][type="checkbox"]:checked').each(function (item){
                    $(this).closest('tr').find('td:eq(5)').find("input").val(username);


                })

            });
        })
        $('.update-file').off("click").on("click",function (){
            $('#renewMsg').html('');
            let self=$(this),data=[],username=self.prev("input").val();
            if(!username){
                layer.msg.html('请输入要分配的用户名');
                return false;
            }
            data.push(self.data("id"));

            if(data.length<1){
                layer.msg('请选择要分配的域名');
                return false;
            }
            update(data,username,function (){
                layer.msg("转移成功");
            },function (r){
                layer.msg(r);
            });
            // update(0,count);
        })
        $('.btn-Refresh-Data').off("click").on("click",function (){
            let id=$(this).data("id");
            ajax({
                data:{
                    action:'Refresh',
                    id:id
                },success:function (r){
                    window.location.reload();
                },error:function (r){
                    layer.msg(r);
                }
            })
        });
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            limit:20,
            last:'末页',
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    })
</script>