<?php
namespace addons\cloud_gzhx\controller;
use app\admin\controller\PluginAdminBaseController;
use Think\Db;

class AdminIndexController extends PluginAdminBaseController
{
    public $data,$pluginName="cloud_gzhx";
    public function initialize()
    {
        parent::initialize();

        $this->assign('GzhxPluginPath',$this->pluginName);

        $this->data=$_POST;
    }
    public function success($arr){
        echo json_encode([
            'status'=>1,
            'encrypt'=>1,
            'info'=>$arr
        ]);die;
    }
    public function error($arr){
        echo json_encode([
            'status'=>0,
            'info'=>$arr
        ]);die;
    }

    public function index(){
        $M=Db::name('gzhx_cloud')->alias("a")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->join("products b","b.config_option2=a.region")
            ->where("b.upper_reaches_id=c.id");
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "":{
                    $this->error("参数错误");
                    break;
                }


                default:{
                    $User=Db::name("clients")->where("username","=",$this->data["username"])->find();
                    if(empty($User)){
                        $this->error("用户不存在");die;
                    }
                    $domain=json_decode($this->data['domain'],true);

                    Db::startTrans();
                    try{
                        Db::name("gzhx_cloud")
                            ->where('id',"IN",$domain)
                        ->update([
                            'uid'=>$User['id']
                        ]);
                        Db::commit();
                        $this->success($this->data['data']);
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }


                    //  var_dump($this->data);die;

                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;


        if(!empty($_GET['day'])&&intval($_GET['day'])>0){
            if(intval($_GET['day'])==1){
                $count=$M->where("a.end_time","LT", date("Y-m-d"))
                    ->count();

                $DomainList=$M->where("a.end_time","LT", date("Y-m-d"))
                    ->field("c.name,b.name as region_name,a.*")
                    ->order("a.start_time desc,a.id desc")
                    ->page("{$Page},20")
                    ->select()->toArray();
            }else{
                $count=$M->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                    ->where("a.end_time","GT", date("Y-m-d"))

                    ->count();

                $DomainList=$M->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                    ->where("a.end_time","GT", date("Y-m-d"))
                    ->field("c.name,b.name as region_name,a.*")
                    ->order("a.start_time desc,a.id desc")
                    ->page("{$Page},20")
                    ->select()->toArray();
            }

        }else{
            $count=$M->count();

            $DomainList=$M->field("c.name,b.name as region_name,a.*")
                ->order("a.start_time desc,a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }


        foreach ($DomainList as $k=>&$v){
            $v['username']=Db::name("clients")->where("id","=",$v["uid"])->value("username");
        }


        $this->assign('DomainList',$DomainList);
      //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','主机列表');

        $domainCount=[
            [
                'day'=>'全部主机',
                'num'=>'',
                'count'=>$M->count()?:0
            ],
            [
                'day'=>'3天内过期',
                'num'=>3,
                'count'=>$this->DomainCount(3,$M)
            ],
            [
                'day'=>"7天内过期",
                'num'=>7,
                'count'=>$this->DomainCount(7,$M)
            ],
            [
                'day'=>'已过期',
                'num'=>1,
                'count'=>$M
                    ->where("a.end_time","LT", date("Y-m-d"))
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);
        return $this->fetch('/index');
    }
    public function DomainCount($day,$M){
        return $M
            ->where("a.end_time","LT", date("Y-m-d",strtotime("+{$day} day",time())) )
            ->where("a.end_time","GT", date("Y-m-d"))
            ->count()?:0;
    }
    public function manual(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "getRegistrantInfo":{

                    $DomainList=Db::name('gzhx_cloud_manual')->alias("d")
                        ->field("a.id as cloud_id,b.username,c.name,c.username as api_aid,c.password as api_ak,c.hostname,a.region,a.vid,d.*")
                        ->join("gzhx_cloud_log f","f.id=d.aid")
                        ->join("gzhx_cloud a","a.id=f.aid")
                        ->join("clients b","a.uid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("d.id","=",$this->data["id"])
                    ->find();



                    if(empty($DomainList)){
                        $this->error("产品不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $query=[
                        'region'=>$DomainList['region']
                    ];
                    if($DomainList['status']=="购买处理中"){
                        if(empty($this->data['vid'])){
                            $this->error("请输入产品标志");
                        }
                        $query['vid']=$this->data['vid'];
                    }else{
                        $query['vid']=$DomainList['vid'];
                    }
                    $result=$domain_api->DescribeInstance($query);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $save=$result['info'];
                    $save['active']='正常';
                    Db::name("gzhx_cloud")->where("id","=",$DomainList['cloud_id'])->update($save);
                    Db::name("gzhx_cloud_log")->where("id","=",$DomainList['aid'])->update([
                        'status'=>'执行完成'
                    ]);
                    Db::name("gzhx_cloud_manual")->where("id","=",$DomainList['id'])->update([
                        'status'=>'执行完成'
                    ]);

                    $this->success("OK");
                    break;
                }


                default:{
                    $this->error("参数错误");
                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $count=Db::name('gzhx_cloud_manual')->alias("d")
            ->join("gzhx_cloud_log f","f.id=d.aid")
            ->join("gzhx_cloud a","a.id=f.aid")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")

            ->count();

        $DomainList=Db::name('gzhx_cloud_manual')->alias("d")
            ->field("b.username,c.name,a.vid,a.domain,d.*")
            ->join("gzhx_cloud_log f","f.id=d.aid")
            ->join("gzhx_cloud a","a.id=f.aid")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->order("d.id desc")
            ->page("{$Page},20")
            ->select()->toArray();

        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','手动主机处理');
        return $this->fetch('/manual');
    }
    public function TemplateList(){
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "Refresh":{
                    $post=$this->data['data'];

                    $DomainList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("c.hostname,c.username as api_aid,c.password as api_ak,a.*")

                        ->join("zjmf_finance_api c","a.api_id=c.id")

                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    $outTime=time()-strtotime($DomainList['last_update']);
                    if($outTime<120){
                        $this->error("请在".(120-$outTime)."秒后再试");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $result=$domain_api->DescribeTemplate($DomainList);

                    if($result['status']==0){
                        $this->error($result['info']);
                    }
                    Db::name("gzhx_domain_template")
                        ->where("id","=",$this->data['id'])
                        ->update([
                            'config'=>serialize($result['info']),
                            'last_update'=>date("Y-m-d H:i:s")
                        ]);
                    if($result['AuditStatus']=="审核中"){
                        $this->error("模版仍在审核中");
                    }
                    $save=[
                        'config'=>serialize($result['info']),
                        'status'=>$result['AuditStatus']
                    ];
                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain_template")
                            ->where("id","=",$this->data['id'])
                            ->update($save);
                        Db::commit();
                        $this->success("OK");
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }

                    break;
                }


                default:{

                    $User=Db::name("clients")->where("username","=",$this->data["username"])->find();
                    if(empty($User)){
                        $this->error("用户不存在");die;
                    }
                    $domain=json_decode($this->data['domain'],true);

                    Db::startTrans();
                    try{
                        Db::name("gzhx_domain_template")
                            ->where('id',"IN",$domain)
                            ->update([
                                'uid'=>$User['id']
                            ]);
                        Db::commit();
                        $this->success($this->data['data']);
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }



                    //  var_dump($this->data);die;

                    break;
                }
            }

        }

        $Page=isset($_GET['page'])?intval($_GET['page']):1;

        $count=Db::name('gzhx_domain_template')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")

            ->count();

        $DomainList=Db::name('gzhx_domain_template')->alias("a")
            ->field("b.username,c.name,a.*")
            ->join("clients b","a.uid=b.id")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->order("a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();

        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);

        $this->assign('Title','域名信息模版列表');
        return $this->fetch('/template');
    }

    public function Template(){

        $templateList=null;
        if(!empty($_GET['vid'])){
            $templateList=Db::name('gzhx_domain_template')->alias("a")
                ->field("c.hostname,c.username as api_aid,c.password as api_ak,b.username as clients_username,a.*")
                ->join("clients b","a.uid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")

                ->where("a.id","=",$_GET['vid'])
                ->find();
            if(empty($templateList)){
                $this->assign('msg',"接口不存在");
                return $this->fetch('/error');
            }
            $templateList['config']=unserialize($templateList['config']);
            if($templateList['status']=="审核中"||$templateList['status']=="已实名认证"){
                $this->assign('msg',"当前信息{$templateList['status']}，无法修改");
                return $this->fetch('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "newRegistrantOrganization":{
                    $post=$this->data['data'];

                    $DomainList=Db::name("zjmf_finance_api")
                        ->where('id','=',$post['api_id'])->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    preg_match('/^data:image\/(.+?);base64,(.+?)$/isu',$this->data['data']['IdentityCredential'],$match);
                    if(!is_dir(CMF_DATA."IdentityCredential/")){
                        mkdir(CMF_DATA."IdentityCredential/",0755,true);
                    }
                    $fname="IdentityCredential/{$post['IdentityCredentialNo']}.jpg";
                    file_put_contents(CMF_DATA.$fname,base64_decode($match[2]));
                    $post['IdentityCredential']=$fname;
                    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
                    $url ="{$protocol}{$_SERVER['HTTP_HOST']}/addons?_plugin=dominbygzhx&_controller=index&_action=card&No={$fname}";
                    $SaveRegistrantProfile=[
                        'Email' => $post['Email'],
                        'Lang'=>'zh',
                        'RegistrantType'=>$post['RegistrantType'],
                        'ZhRegistrantOrganization'=>$post['ZhRegistrantOrganization'],
                        'ZhRegistrantName'=>$post['ZhRegistrantName'],
                        'ZhProvince'=>'浙江',
                        'ZhCity'=>'杭州市',
                        'ZhAddress'=>'浙江省杭州市上城区10001号',
                        'RegistrantOrganization'=>$post['RegistrantOrganization'],
                        'RegistrantName'=>$post['RegistrantName'],
                        'Province'=>'zhe jiang',
                        'City'=>'hang zhou shi',
                        'Address'=>'zhe jiang sheng hang zhou shi shang cheng qu 10001 hao',
                        'Country'=>'CN',
                        'TelArea'=>'86',
                        'Telephone'=>$post['Telephone'],
                        'TelExt'=>'1234',
                        'PostalCode'=>'310024',
                        'IdentityCredentialType'=>$post['IdentityCredentialType'],
                        'IdentityCredentialNo'=>$post['IdentityCredentialNo'],
                        'RegistrantProfilePic'=>base64_encode(file_get_contents(CMF_DATA.$fname))
                    ];

                    if(!empty($templateList)){
                        $SaveRegistrantProfile['RegistrantProfileId']=$templateList['vid'];
                    }

                    $resultSaveRegistrantProfile=$domain_api->init("SaveRegistrantProfile",$SaveRegistrantProfile,[]);
                    if($resultSaveRegistrantProfile['status']==0){
                        $this->error($resultSaveRegistrantProfile['info']);
                    }
                    $save=[
                        'config'=>serialize($post),
                        'vid'=>$resultSaveRegistrantProfile['info']['RegistrantProfileId'],
                        'api_id'=>$post['api_id'],
                        'organization_name'=>$post['ZhRegistrantOrganization'],
                        'certificate_type'=>$post['IdentityCredentialType'],
                        'uid'=>0,
                        'status'=>"审核中"
                    ];
                    Db::startTrans();
                    try{
                        if(empty($templateList)){
                            Db::name("gzhx_domain_template")
                                ->insert($save,true);
                            Db::commit();
                        }else{
                            Db::name("gzhx_domain_template")
                                ->where("id","=",$templateList['id'])
                                ->update([
                                    'vid'=>$save['vid'],
                                    'status'=>'审核中'
                                ]);
                            Db::commit();
                        }

                        $this->success("OK");
                    }catch (Exception $e){
                        Db::rollback();
                        $this->error("添加错误".var_export($e,true));
                    }
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        if(!empty($templateList['api_id'])){
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('id','=',$templateList['api_id'])
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }else{
            $server_groups=Db::name("zjmf_finance_api")
                ->field("id,name")
                ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();

        }

        $this->assign('templateList',$templateList);
        $this->assign('DomainList',$server_groups);
        $this->assign('Title','注册信息模版管理');
        return $this->fetch('/template_add');

    }
    public function Suffix(){

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "set_suffix":{
                    $save=[];
                    foreach ($this->data['suffix'] as $item){
                        $save[]=[
                          'uid'=>0,
                          'suffix'=>$item
                        ];
                    }
                    Db::name("gzhx_domain_suffix")->insertAll($save);
                    $this->success("OK");
                }
                case "status":{
                    if(intval($this->data['status'] )==2){
                        $count=Db::name("gzhx_domain_suffix")->where("checked","=",2)->count()?:0;
                        if($count>=5){
                            $this->error("最多设置5个默认选中");
                        }
                    }

                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->update([
                       'checked'=>$this->data['status']
                    ]);
                    $this->success("设置成功");die;
                }
                case "ord":{


                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->update([
                        'ord'=>$this->data['ord']
                    ]);
                    $this->success("设置成功");die;
                }
                case "delete":{
                    Db::name("gzhx_domain_suffix")->where("id","=",$this->data['id'])->delete();
                    $this->success("设置成功");die;
                }
                case "save":{
                    $post=$this->data['data'];
                    $configuration=Db::name("configuration")->where("setting","=","gzhx_domain_suffix")->find();
                    if(empty($configuration)){
                        Db::name("configuration")->insert([
                            'setting'=>"gzhx_domain_suffix",
                            'value'=>serialize([
                                'suffix'=>implode(",",$post),
                                'api'=>$this->data['api_id']
                            ])
                        ]);
                    }else{
                        Db::name("configuration")->where("setting","=","gzhx_domain_suffix")->update([
                            'value'=>serialize([
                                'suffix'=>implode(",",$post),
                                'api'=>$this->data['api_id']
                            ])
                        ]);
                    }
                    $this->success("OK");
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }

        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."gzhx_domain_suffix";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int NOT NULL AUTO_INCREMENT,`suffix` varchar(50) NULL,`ord` int(255) NULL DEFAULT 999,`checked` int(255) NULL DEFAULT 1,`uid` int NULL DEFAULT 0,PRIMARY KEY (`id`));");
        }


        $server_groups=Db::name("zjmf_finance_api")
            ->field("id,name")
            ->where('hostname','LIKE','%_dominbygzhx')->select()->toArray();
        if(!empty($server_groups)){
            $list=Db::name("products")->alias("a")
                ->field("a.*,b.annually,b.biennially,b.triennially,b.fourly,b.fively,CONCAT('.',name) as sell_domain")
                ->leftJoin("pricing b","a.id=b.relid")
                ->where("b.type","=","product")
                ->where("a.hidden","=",0)
                ->where("a.upper_reaches_id","IN",array_column($server_groups,"id"))
                ->order("a.name asc,a.id desc")
                ->select()->toArray();
        }
        $suffixList=Db::name("gzhx_domain_suffix")
            ->where("uid","=",0)->order("ord asc,id asc")->select()->toArray();

        $list=array_column($list,"sell_domain");
        $list=array_unique($list);
        $suffixList=array_column($suffixList,null,"suffix");
        $this->assign('sell_domain',$list);
        $this->assign('sell_server_groups',$server_groups);
        $this->assign('sell_configuration',$suffixList);

        $this->assign('Title','默认选中后缀');
        return $this->fetch('/suffix');
    }
    public function OperateLog(){


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "manual":{
                    $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                        ->field("a.*,b.region,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_cloud b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    $domainInfo=$domain_api->DescribeInstance([
                        'region'=>$DomainList['region'],
                        'vid'=>$DomainList['log_id']
                    ]);

                    if($domainInfo['status']!=1){
                        $this->error("获取信息失败：{$domainInfo['info']}");
                    }
                    $save=$domainInfo['info'];
                    $save['active']="正常";

                    Db::name("gzhx_cloud")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_cloud_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);
                    $this->success("OK");
                    break;
                }
                case "task":{
                    $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_cloud b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    $op=$operate['op'];
                    if($DomainList['status']!='执行中'){
                        $regResult=$domain_api->$op($operate['data']);

                        if($regResult['status']!=1){
                            $this->error("{$regResult['info']}");
                        }
                        Db::name("gzhx_cloud_log")->where("id","=",$DomainList['id'])->update([
                            'status'=>"执行中",
                            'log_id'=>$regResult['info']['vid']
                        ]);
                    }else{
                        $regResult['info']['vid']=$DomainList['log_id'];
                    }



                    $domainInfo=$domain_api->DescribeInstance([
                        'region'=>$operate['data']['region'],
                        'vid'=>$regResult['info']['vid']
                    ]);

                    if($domainInfo['status']!=1){
                        $this->error("获取商品信息失败：{$domainInfo['info']}");
                    }
                    $save=$domainInfo['info'];
                    $save['active']="正常";

                    Db::name("gzhx_cloud")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_cloud_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);

                    $this->success("OK");
                }
                case "Refresh":{


                    $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname")
                        ->join("gzhx_cloud b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    $domainInfo=$domain_api->DescribeInstance([
                        'region'=>$operate['data']['region'],
                        'vid'=>$DomainList['log_id']
                    ]);

                    if($domainInfo['status']!=1){
                        $this->error("获取域名信息失败：{$domainInfo['info']}");
                    }
                    $save=$domainInfo['info'];
                    $save['active']="正常";

                    Db::name("gzhx_cloud")->where("id","=",$DomainList['domain_id'])->update($save);
                    Db::name("gzhx_cloud_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);
                    $this->success("获取成功");
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }


        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        if(!empty($_GET['status'])){
            $count=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->count();

            $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }else{
            $count=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->count();

            $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")

                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }

        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','域名操作日志');

        $domainCount=[
            [
                'day'=>'',
                'num'=>'',
                'count'=>Db::name("gzhx_cloud_log")->count()?:0
            ],
            [
                'day'=>'等待执行',
                'num'=>30,
                'count'=>Db::name("gzhx_cloud_log")
                    ->where("status","=", '等待执行')
                    ->count()?:0
            ],
            [
                'day'=>"执行中",
                'num'=>7,
                'count'=>Db::name("gzhx_cloud_log")
                    ->where("status","=", '执行中')
                    ->count()?:0
            ],
            [
                'day'=>'执行完成',
                'num'=>1,
                'count'=>Db::name("gzhx_cloud_log")
                    ->where("status","=", '执行完成')
                    ->count()?:0
            ],
            [
                'day'=>'执行失败',
                'num'=>1,
                'count'=>Db::name("gzhx_cloud_log")
                    ->where("status","=", '执行失败')
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);

        return $this->fetch('/log');
    }
    public function specialoffer(){


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            if($action=="status"){
                $status=intval($this->data['status'])==2?'正常':'下架';
                Db::name("gzhx_cloud_specialoffer")
                    ->where('id','=',$this->data['id'])
                    ->update([
                        'status'=>$status
                    ]);
                $this->success("OK");
            }

            $data=$this->data['data'];
            if(empty($data['title'])){
                $this->error("请输入标题");
            }
            if(empty($data['setting'])){
                $this->error("请输入配置");
            }
            if(empty($data['period'])){
                $this->error("请输入时长");
            }
            if(empty($data['price'])||floatval($data['price'])<1){
                $this->error("请输入价格");
            }
            $data['status']="正常";

            Db::startTrans();
            try{


                if(empty($this->data['data']['id'])){

                    $data['id']=Db::name("gzhx_cloud_specialoffer")
                        ->insertGetId($data);
                }else{

                    Db::name("gzhx_cloud_specialoffer")
                        ->where('id','=',$this->data['data']['id'])
                        ->update($data);
                    $data['status']=Db::name("gzhx_cloud_specialoffer")
                        ->where('id','=',$this->data['data']['id'])->value("status");
                }
                $data['api']=$this->data['plugin'][ $data['api'] ];
                Db::commit();
                $this->success($data);
            }catch (Exception $e){
                Db::rollback();
                $this->error("添加错误");
            }

        }

        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."gzhx_cloud_specialoffer";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int NOT NULL AUTO_INCREMENT,`title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`stock` int(10) NULL DEFAULT 0,`api` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`setting` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`period` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`price` decimal(10, 2) NULL,`status` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',PRIMARY KEY (`id`))");
        }
        $specialofferTable=$DbConfig["prefix"]."gzhx_cloud_specialoffer_list";
        if( !in_array($specialofferTable,$tableList) ){
            Db::query("CREATE TABLE `{$specialofferTable}`  (`id` int NOT NULL AUTO_INCREMENT,`uid` int NULL DEFAULT 0,`aid` int NULL DEFAULT 0,`vid` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`status` varchar(50) CHARACTER SET utf8 NULL DEFAULT '',`add_time` datetime NULL,PRIMARY KEY (`id`))");
        }

        $server_groups=Db::name("zjmf_finance_api")
            ->where('hostname','LIKE','%_cloud_gzhx')->select()->toArray();
        $hostname=array_column($server_groups,'hostname');
        $hostnames=array_unique($hostname);
        $Pugins=[];
        foreach ($hostnames as $k=>$v){
            $PluginName=str_ireplace(" ","",ucwords(" ".str_ireplace("_"," ",$v)));

            if(file_exists(CMF_ROOT."public/plugins/addons/{$v}/{$PluginName}Plugin.php")){
                $App="\\addons\\{$v}\\{$PluginName}Plugin";
                $Api=new $App();
                $Pugins[$v]=$Api->info['title'];

            }
        }
        $List=Db::name("gzhx_cloud_specialoffer")->select()->toArray();
        foreach ($List as $key=>$item){
            $List[$key]['plugin_name']=$Pugins[ $item['api'] ];
        }
        $this->assign('DomainList',$List);
        $this->assign('Pugins',$Pugins);
        $this->assign('Title','特价销售机器');
        return $this->fetch('/specialoffer');
    }
    public function Specialofferorder(){


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            if($action=="Servers"){
                $DomainList=Db::name("gzhx_cloud_specialoffer_list")->alias("a")
                    ->field("a.status,c.username,b.*")
                    ->join("gzhx_cloud_specialoffer b","b.id=a.aid")
                    ->join("clients c","c.id=a.uid")
                    ->where("a.id","=",$this->data["id"])
                    ->find();
                if(empty($DomainList)){
                    $this->error("订单不存在");
                }
                $server_groups=Db::name("zjmf_finance_api")
                    ->where('hostname','=',$DomainList['api'])->select()->toArray();
                if(empty($server_groups)){
                    $this->error("接口不存在");
                }

                $this->success($server_groups);
            }
            if($action=="region"){

                $DomainList=Db::name("zjmf_finance_api")
                    ->where('id','=',$this->data['api_id'])->find();
                if(empty($DomainList)){
                    $this->error("接口不存在");
                }
                if( !class_exists("{$DomainList['hostname']}_class") ){
                    if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                        $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                    }
                    require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                }
                $domain_app="\\{$DomainList['hostname']}_class";
                $domain_api=new $domain_app();
                $domain_api->setConfig([
                    'aid'=>$DomainList['username'],
                    'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                ]);
                $r=$domain_api->DescribeRegions();
                if($r['status']!=1){
                    $this->error($r['info']);
                }
                $this->success($r['info']);
            }
            if($action=="check"){
                $find= Db::name("gzhx_cloud")
                    ->where('vid',"=",$this->data['vid'])
                    ->where("uid",">",0)
                    ->find();
                if(!empty($find)){
                    $this->success(true);
                }else{
                    $this->success(false);
                }
            }
            if($action=="info"){
                $BuyList=Db::name("gzhx_cloud_specialoffer_list")->alias("a")
                    ->field("a.id,a.uid")
                    ->join("gzhx_cloud_specialoffer b","b.id=a.aid")
                    ->join("clients c","c.id=a.uid")
                    ->where("a.id","=",$this->data['id'])
                    ->find();
                if(empty($BuyList)){
                    $this->error("订单不存在");
                }
                $DomainList=Db::name("zjmf_finance_api")
                    ->where('id','=',$this->data['api_id'])->find();
                if(empty($DomainList)){
                    $this->error("接口不存在");
                }
                if( !class_exists("{$DomainList['hostname']}_class") ){
                    if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                        $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                    }
                    require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                }
                $domain_app="\\{$DomainList['hostname']}_class";
                $domain_api=new $domain_app();
                $domain_api->setConfig([
                    'aid'=>$DomainList['username'],
                    'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                ]);
                $r=$domain_api->DescribeInstance($this->data);
                if($r['status']!=1){
                    $this->error($r['info']);
                }
                $r['info']['active']='正常';
                $r['info']['uid']=$BuyList['uid'];

                $r['info']['region']=$this->data['region'];
                $r['info']['api_id']=$this->data['api_id'];
                $find= Db::name("gzhx_cloud")
                    ->where('vid',"=",$this->data['vid'])
                    ->find();

                if(!empty($find)){
                    Db::name("gzhx_cloud")->where("id","=",$find['id'])->update($r['info']);
                }else{
                    Db::name("gzhx_cloud")->insert($r['info']);
                }
                Db::name("gzhx_cloud_specialoffer_list")->where("id","=",$BuyList['id'])->update([
                    'status'=>'已完成'
                ]);
                $this->success($r['info']);
            }
            $data=$this->data['data'];
            if(empty($data['title'])){
                $this->error("请输入标题");
            }
            if(empty($data['setting'])){
                $this->error("请输入配置");
            }
            if(empty($data['period'])){
                $this->error("请输入时长");
            }
            if(empty($data['price'])||floatval($data['price'])<1){
                $this->error("请输入价格");
            }
            $data['status']="正常";

            Db::startTrans();
            try{


                if(empty($this->data['data']['id'])){

                    $data['id']=Db::name("gzhx_cloud_specialoffer")
                        ->insertGetId($data);
                }else{

                    Db::name("gzhx_cloud_specialoffer")
                        ->where('id','=',$this->data['data']['id'])
                        ->update($data);
                    $data['status']=Db::name("gzhx_cloud_specialoffer")
                        ->where('id','=',$this->data['data']['id'])->value("status");
                }
                $data['api']=$this->data['plugin'][ $data['api'] ];
                Db::commit();
                $this->success($data);
            }catch (Exception $e){
                Db::rollback();
                $this->error("添加错误");
            }

        }

        $DbConfig=Db::getConfig();

        $CacheDbName=$DbConfig["prefix"]."gzhx_cloud_specialoffer";

        $tableList=Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='{$DbConfig['database']}'");
        $tableList=array_column($tableList,"table_name");
        if( !in_array($CacheDbName,$tableList) ){
            Db::query("CREATE TABLE `{$CacheDbName}`  (`id` int NOT NULL AUTO_INCREMENT,`title` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`stock` int(10) NULL DEFAULT 0,`api` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`setting` varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`period` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`price` decimal(10, 2) NULL,`status` varchar(30) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',PRIMARY KEY (`id`))");
        }
        $specialofferTable=$DbConfig["prefix"]."gzhx_cloud_specialoffer_list";
        if( !in_array($specialofferTable,$tableList) ){
            Db::query("CREATE TABLE `{$specialofferTable}`  (`id` int NOT NULL AUTO_INCREMENT,`uid` int NULL DEFAULT 0,`aid` int NULL DEFAULT 0,`vid` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '',`status` varchar(50) CHARACTER SET utf8 NULL DEFAULT '',`add_time` datetime NULL,PRIMARY KEY (`id`))");
        }

        $server_groups=Db::name("zjmf_finance_api")
            ->where('hostname','LIKE','%_cloud_gzhx')->select()->toArray();
        $hostname=array_column($server_groups,'hostname');
        $hostnames=array_unique($hostname);
        $Pugins=[];
        foreach ($hostnames as $k=>$v){
            $PluginName=str_ireplace(" ","",ucwords(" ".str_ireplace("_"," ",$v)));

            if(file_exists(CMF_ROOT."public/plugins/addons/{$v}/{$PluginName}Plugin.php")){
                $App="\\addons\\{$v}\\{$PluginName}Plugin";
                $Api=new $App();
                $Pugins[$v]=$Api->info['title'];

            }
        }
        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        $count=Db::name("gzhx_cloud_specialoffer_list")->alias("a")
            ->join("gzhx_cloud_specialoffer b","b.id=a.aid")
            ->join("clients c","c.id=a.uid")
            ->count();
        $List=Db::name("gzhx_cloud_specialoffer_list")->alias("a")
            ->field("a.status as specialoffer_status,a.id as a_id,c.username,b.*")
            ->join("gzhx_cloud_specialoffer b","b.id=a.aid")
            ->join("clients c","c.id=a.uid")
            ->order("a.id desc")
            ->page("{$Page},20")
            ->select()->toArray();

        foreach ($List as $key=>$item){
            $List[$key]['plugin_name']=$Pugins[ $item['api'] ];
        }
        $this->assign('DomainList',$List);
        $this->assign('Pugins',$Pugins);
        $this->assign('Title','特价机器订单');
        return $this->fetch('/specialofferorder');
    }
}