<?php
namespace addons\cloud_gzhx\controller\clientarea;

use app\home\controller\PluginHomeBaseController;
use Think\Db;

class IndexController extends PluginHomeBaseController
{
    public $data,$theme="/ajax",$pluginName="cloud_gzhx";
    public function initialize()
    {


        parent::initialize();

        $this->assign('GzhxPluginPath',$this->pluginName);
        $DbConfig=Db::getConfig();
        $COLUMNS=Db::name("zjmf_finance_api")->getTableFields();

        if(!in_array("gzhx_domain_rebet",$COLUMNS)){
            Db::query("ALTER TABLE `{$DbConfig["prefix"]}zjmf_finance_api` ADD COLUMN `gzhx_domain_rebet` int NULL DEFAULT 0;");
        }
        if(!in_array("gzhx_domain_grade",$COLUMNS)){
            Db::query("ALTER TABLE `{$DbConfig["prefix"]}zjmf_finance_api` ADD COLUMN `gzhx_domain_grade`  varchar(3000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL;");
        }
        $this->data=$_POST;
    }
    public function success($arr){
        echo json_encode([
            'status'=>1,
            'encrypt'=>1,
            'info'=>$arr
        ]);die;
    }
    public function error($arr){
        echo json_encode([
            'status'=>0,
            'info'=>$arr
        ]);die;
    }
    public function fetchTemplete($p){
        $content=$this->fetch($this->theme.$p);
        if(!empty($this->theme)){
            preg_match("/<GZHXPAGEBOX>([\s\S]*?)<\/GZHXPAGEBOX>/isu",$content,$mth);
            return $mth[1];
        }else{
            return $content;
        }

    }
 public function index(){

     $User=request()->uid;

     if(empty($User)){

         if(empty($User)){
             $this->assign('msg',"登录失效，请重新登录");
             return $this->fetch('/error');
         }
     }

     if(empty($_GET['cache'])){
         $this->assign('Title',"主机管理");
         return $this->fetch($this->theme.'/ajax');
     }
     $M=Db::name('gzhx_cloud')->alias("a")
         ->join("zjmf_finance_api c","a.api_id=c.id")
         ->join("products b","b.upper_reaches_id=c.id")
         ->where("b.config_option2=a.region")
     ->where("a.uid","=",$User);
     if(!empty($this->data)){
         $action=$this->data['action'];
         if(empty($action)) $action="";

         switch ($action){

             case "refresh":{
                 $DomainList=$M
                     ->field("c.name,c.id as api_id,c.hostname,c.username as api_aid,c.password as api_ak,a.*")
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("插件不存在");
                 }
                 $outTime=time()-strtotime($DomainList['last_update']);
                 if($outTime<120){
                     $this->error("请在".(120-$outTime)."秒后再试");
                 }
                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);
                 $regResult=$domain_api->DescribeInstance($DomainList);

                 if($regResult['status']!=1){
                     $this->error($regResult['info']);
                 }
                 $save=[
                     'vid'=>$regResult['info']['vid'],
                     'domain'=>$regResult['info']['domain'],
                     'start_time'=>$regResult['info']['start_time'],
                     'end_time'=>$regResult['info']['end_time'],
                     'templete_info'=>$regResult['info']['templete_info'],
                     'active'=>'正常',
                     'last_update'=>date("Y-m-d H:i:s")
                 ];

                 Db::name("gzhx_cloud")->where("id","=",$DomainList['id'])->update($save);
                 $this->success("OK");
                 break;
             }
             case "Renew":{



                 $DomainList=Db::name('gzhx_cloud')->alias("a")
                     ->field("d.config_option1,c.name,c.id as api_id,a.*,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet,c.gzhx_domain_grade")

                     ->join("zjmf_finance_api c","a.api_id=c.id")
                     ->join("products d","d.upper_reaches_id=c.id")
                     ->where("a.uid","=",$User)
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("主机不存在");
                 }

                 $logFind= Db::name("gzhx_cloud_log")
                     ->where("aid","=",$DomainList['id'])
                   //  ->where("type","=",'续费机器')
                     ->where("status","=",'执行失败')->find();

                 if(!empty($logFind)){
                     $this->error("当前有失败的任务，请联系客服处理后再续费");
                 }
                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);
                 $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
                 $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
                 if(intval($UserGroupid)>0){
                     $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
                     if(intval($gzhx_domain_grade[$UserGroupid])>0){
                         $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
                     }
                 }
                 $DescribeDomainPriceList= $domain_api->InquiryPriceRenewInstances([
                     "region"=>"{$DomainList["region"]}",
                     "vid"=>"{$DomainList['vid']}",
                     "Operation"=>"renew",
                     "period"=>$this->data['years'],

                 ]);
                 if($DescribeDomainPriceList['status']!=1){
                     $this->error($DescribeDomainPriceList['info']);
                 }
                 $PayPrice=$DescribeDomainPriceList['info'];



                 if(empty($PayPrice)||floatval($PayPrice)<1){
                     $this->error("续费价格出错");
                 }
                 $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                 if(floatval($UserMoney)-$PayPrice<0){
                     $this->error("余额不足，无法支付");die;
                 }
                 $operate=[
                     'op'=>'RenewInstances',
                     'data'=>[
                         'query'=>  $DomainList,
                         'data'=>$this->data,
                         'Price'=>$PayPrice
                     ]
                 ];
                 Db::startTrans();
                 try{

                     $InvoicesId=Db::name("Invoices")->insertGetId([
                         'uid'=>$User,
                         'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                         'create_time'=>time(),
                         'subtotal'=>$PayPrice,
                         'status'=>'Paid',
                         'credit'=>$PayPrice,
                         'payment'=>'UserCustom',
                         'type'=>'product',
                     ]);




                     $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                         'uid'=>$User,
                         'invoice_id'=>$InvoicesId,
                         'description'=>"续费机器{$DomainList["domain"]}年限{$domain_api->Period()[$this->data['years']]}",
                         'rel_id'=>0,
                         'amount'=>$PayPrice,
                         'payment'=>'UserCustom',
                         'type'=>'host',
                     ]);


                     $CreditId=Db::name("Credit")->insertGetId([
                         'uid'=>$User,

                         'create_time'=>time(),

                         'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                         'relid'=>$InvoicesId,
                         'amount'=>$PayPrice,

                     ]);


                     Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);
                     $operate['data']['invoice_id']=$InvoicesId;

                     $log=[
                         'log_id'=>$DomainList['vid'],
                         'aid'=>$DomainList['id'],
                         'type'=>'续费机器',
                         'add_time'=>date("Y-m-d H:i:s"),
                         'status'=>'执行中',
                         'domain'=>$DomainList['vid'],
                         'api_id'=>$DomainList['api_id'],
                         'op'=>serialize($operate)
                     ];
                     $logId= Db::name("gzhx_cloud_log")->insertGetId($log);
                     if(empty($DomainList['config_option1'])){
                         Db::name("gzhx_cloud_manual")->insert([
                             'aid'=>$logId,
                             'config'=>$this->data['manual'],
                             'status'=>'续费处理中',
                             'add_time'=>date("Y-m-d H:i:s")
                         ]);
                     }

                     Db::commit();
                     if(empty($DomainList['config_option1'])){
                         $this->success("当前为人工开通，请联系客服处理谢谢");
                     }
                 }catch (Exception $e){

                     Db::rollback();
                     $this->error(var_export($e,true));
                 }
                 $operate['data']['LogId']=$logId;
                 $regResult=$domain_api->RenewInstances($operate['data']);
                 if($regResult['status']!=1){

                     Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                         'status'=>'执行失败',
                         'msg'=>$regResult['info']
                     ]);

                     $this->success([
                         'success'=>false,
                     ]);
                 }
                 Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                     'status'=>'执行完成',
                     'msg'=>'执行完成'
                 ]);

                 $this->success([
                     'success'=>true,
                 ]);
             }
             case "Setting":{
                 $DomainList=Db::name("zjmf_finance_api")

                     ->where("id","=",$this->data["api_id"])
                     ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                 if(empty($DomainList)){
                     $this->error("接口不存在");die;
                 }

                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                         $this->error("插件不存在");

                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['username'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);

                 $this->success([
                     //  'DescribeDisksCategory'=>$domain_api->DescribeDisksCategory(),
                     'Period'=>$domain_api->Period(),
                 ]);
                 break;
             }
             case "renew_price":{
                 $DomainList=Db::name('gzhx_cloud')->alias("a")
                     ->field("c.name,c.id as api_id,a.*,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet,c.gzhx_domain_grade")

                     ->join("zjmf_finance_api c","a.api_id=c.id")
                     ->where("a.uid","=",$User)
                     ->where("a.id","=",$this->data['id'])
                     ->find();
                 if(empty($DomainList)){
                     $this->error("主机不存在");
                 }
                 if( !class_exists("{$DomainList['hostname']}_class") ){
                     if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                         $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                     }
                     require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                 }
                 $domain_app="\\{$DomainList['hostname']}_class";
                 $domain_api=new $domain_app();
                 $domain_api->setConfig([
                     'aid'=>$DomainList['api_aid'],
                     'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                 ]);
                 $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
                 $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
                 if(intval($UserGroupid)>0){
                     $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
                     if(intval($gzhx_domain_grade[$UserGroupid])>0){
                         $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
                     }
                 }
                 $DescribeDomainPriceList= $domain_api->InquiryPriceRenewInstances([
                     "region"=>"{$DomainList["region"]}",
                     "vid"=>"{$DomainList['vid']}",
                     "Operation"=>"renew",
                     "period"=>$this->data['Period'],

                 ]);
                 if($DescribeDomainPriceList['status']!=1){
                     $this->error($DescribeDomainPriceList['info']);
                 }
                 $price=$DescribeDomainPriceList['info'];
                 $this->success($price);
             }


             default:{
                 $this->error("参数不存在");
                 break;
             }
         }

     }
     $Page=isset($_GET['page'])?intval($_GET['page']):1;
     if(!empty($_GET['day'])&&intval($_GET['day'])>0){
         if(intval($_GET['day'])==1){
             $count=$M->where("a.end_time","LT", date("Y-m-d"))
                 ->count();

             $DomainList=$M->field("c.name,b.name as region_name,a.*")->where("a.end_time","LT", date("Y-m-d"))
                 ->order("a.start_time desc,a.id desc")
                 ->page("{$Page},20")
                 ->select()->toArray();
         }else{
             $count=$M->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                 ->where("a.end_time","GT", date("Y-m-d"))

                 ->count();

             $DomainList=$M->field("c.name,b.name as region_name,a.*")->where("a.end_time","LT", date("Y-m-d",strtotime("+{$_GET['day']} day",time())) )
                 ->where("a.end_time","GT", date("Y-m-d"))
                 ->order("a.start_time desc,a.id desc")
                 ->page("{$Page},20")
                 ->select()->toArray();
         }

     }else{
         $count=$M->count();

         $DomainList=$M->field("c.name,b.name as region_name,a.*")->order("a.start_time desc,a.id desc")
             ->page("{$Page},20")
             ->select()->toArray();
     }

     $this->assign('DomainList',$DomainList);
     //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
     $this->assign('count',$count);
     $this->assign('Page',$Page);
     $this->assign('Title','主机列表');

     $domainCount=[
         [
             'day'=>'全部主机',
             'num'=>'',
             'count'=>$M->count()?:0
         ],
        [
            'day'=>'3天内过期',
            'num'=>3,
            'count'=>$this->DomainCount(3,$M)
        ],
         [
             'day'=>"7天内过期",
             'num'=>7,
             'count'=>$this->DomainCount(7,$M)
         ],
         [
             'day'=>'已过期',
             'num'=>1,
             'count'=>$M->where("a.end_time","LT", date("Y-m-d"))
                 ->count()?:0
         ],
     ];
     $this->assign('domainCount',$domainCount);
     return $this->fetchTemplete('/index');
 }
     public function buy(){
        $_GET['_action']='index';
         $this->redirect("/addons?".http_build_query($_GET)."#_action=reg",301);die;
     }

    public function DomainCount($day,$M){
        return $M->where("a.end_time","LT", date("Y-m-d",strtotime("+{$day} day",time())) )
         ->where("a.end_time","GT", date("Y-m-d"))
         ->count()?:0;
    }

    public function encryption($file,$data){
       // var_dump("{$recordsCache}{$Page}");
       //
        $key=md5(time());
        if(file_exists(CMF_DATA."gzhx.cache")){
            $vkey= file_get_contents(CMF_DATA."gzhx.cache");
            if(!empty($vkey)&&mb_strlen($vkey,"UTF-8")==32){

                $key=$vkey;
            }else{
                file_put_contents(CMF_DATA."gzhx.cache",$key);
            }
        }else{
            file_put_contents(CMF_DATA."gzhx.cache",$key);
        }
        $data['cache_time']=time();
        file_put_contents($file,bin2hex(openssl_encrypt(serialize($data),'aes-128-cbc',  mb_substr($key,1,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16))));
    }
    public function Decrypt($file){
        $key=md5(time());
        if(file_exists(CMF_DATA."gzhx.cache")){

            $vkey= file_get_contents(CMF_DATA."gzhx.cache");
            if(!empty($vkey)&&mb_strlen($vkey,"UTF-8")==32){

                $key=$vkey;
            }else{
                file_put_contents(CMF_DATA."gzhx.cache",$key);
            }
        }else{
            file_put_contents(CMF_DATA."gzhx.cache",$key);
        }
        $info=unserialize( openssl_decrypt(hex2bin(file_get_contents($file)),'aes-128-cbc',  mb_substr($key,1,16) , true, mb_substr(md5("798yyhhhjio^*(uihkjh"),8,16)) );
        if($info&&$info['cache_time']&&time()-$info['cache_time']<5){
            return $info;
        }
        return null;
    }
    public function delCache($path){
        $dir=scandir($path);
        foreach ($dir as $item) {
            if($item!="."&&$item!=".."){
                @unlink($path.$item);
            }
        }
    }
    public function Domain(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_cloud')->alias("a")
            ->field("a.*,c.name as api_name,b.name as product_name,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet,c.gzhx_domain_grade")
            ->join("products b","a.region=b.config_option2")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.id","=",$_GET['id'])
            ->where("a.uid","=",$User)
            ->find();
        if(empty($DomainList)){
            $this->assign('msg',"产品不存在");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>86400*3 ){
            $this->assign('msg',"产品已过期，无法管理");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>0 ){
            $this->assign('msg',"产品已过期，请先续费");
            return $this->fetchTemplete('/error');
        }

        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/cloud/")){
            mkdir($CachePath."/cloud/",0755,true);
        }

        $CloudCache=$CachePath."/cloud/{$DomainList['id']}.cache";


        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);
        $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
        $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
        if(intval($UserGroupid)>0){
            $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
            if(intval($gzhx_domain_grade[$UserGroupid])>0){
                $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
            }
        }
        $data=$this->Decrypt("{$CloudCache}");

        if(empty($data)){
            $data=$domain_api->DescribeInstanceFull([
                'region'=>$DomainList['region'],
                'vid'=>$DomainList['vid']
            ]);


            if($data['status']==0){
                $this->assign('msg',$data['info']);
                return $this->fetchTemplete('/error');
            }

            if($data['info']['info']['到期时间']!=$DomainList['end_time']){
                Db::name('gzhx_cloud')->where("id","=",$DomainList['id'])
                    ->update([
                        'end_time'=>$data['info']['info']['到期时间']
                    ]);
            }

            $this->encryption("{$CloudCache}",$data);
        }


        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "op":{
                    $result=$domain_api->Op($DomainList,$this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']);
                    break;
                }
                case "myhostpassword":{
                    $password=$this->data['password'];
                    $result=$domain_api->myhostpassword($DomainList,[
                        'password'=>$password
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }

                    $this->success($result['info']);
                    break;
                }
                case "password":{
                    $password="GzLtd!".mt_rand(10000,9999999);
                    $result=$domain_api->password($DomainList,[
                        'password'=>$password
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }

                    Db::name('gzhx_cloud')->where("id","=",$DomainList['id'])
                        ->update([
                            'password'=>empty($result['info']['password'])?$password:$result['info']['password']
                        ]);
                    $this->success($result['info']);
                    break;
                }
                case "vnc":{
                    $result=$domain_api->Vnc($DomainList,$this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']['RemoteServerUrl']);
                    break;
                }
                case 'osList':{
                    if(method_exists($domain_api,"DescribeImagesReLoad")){
                        $result=$domain_api->DescribeImagesReLoad([
                            'region'=>$DomainList['region'],
                            'InstanceType'=>$data['info']['InstanceType'],
                            'rebet'=>$DomainList['gzhx_domain_rebet']
                        ]);
                    }else{
                        $result=$domain_api->DescribeImages([
                            'region'=>$DomainList['region'],
                            'InstanceType'=>$data['info']['InstanceType'],
                            'rebet'=>$DomainList['gzhx_domain_rebet']
                        ]);
                    }

                    if($result['status']!=1){
                        $this->error($result['info']);
                    }

                    $this->success($result['info']);

                    break;
                }
                case 'reloadOS':{
                    $password="GzLtd!".mt_rand(10000,9999999);
                    $result=$domain_api->reloadOS($DomainList,[
                        'os'=>$this->data['data']['os'],
                        'password'=>$password
                    ]);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    Db::name('gzhx_cloud')->where("id","=",$DomainList['id'])
                        ->update([
                            'password'=>$password
                        ]);
                    $this->success($result['info']);
                    break;
                }
                case 'BandwidthPrice':{
                    $this->data['data']['end_time']=$DomainList['end_time'];
                    $result=$domain_api->BandwidthPrice($DomainList,$this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $price=$result['info'];

                    $this->success($price);

                    break;
                }
                case "Bandwidth":{
                    $logFind= Db::name("gzhx_cloud_log")
                        ->where("aid","=",$DomainList['id'])
                        //  ->where("type","=",'续费机器')
                        ->where("status","=",'执行失败')->find();
                    if(!empty($logFind)){
                        $this->error("当前有失败的任务，请联系客服处理后再续费");
                    }
                    $this->data['data']['end_time']=$DomainList['end_time'];
                    $result=$domain_api->BandwidthPrice($DomainList,$this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $PayPrice=$result['info'];

                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("价格不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }

                    $operate=[
                        'op'=>'Bandwidth',
                        'data'=>[
                            'query'=>$DomainList,
                            'data'=>$this->data['data']
                        ]
                    ];
                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"增值带宽{$DomainList["domain"]}{$this->data['data']['Bandwidth']}",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);



                        $log=[
                            'log_id'=>$DomainList['vid'],
                            'aid'=>$DomainList['id'],
                            'type'=>'增值带宽',
                            'add_time'=>date("Y-m-d H:i:s"),
                            'status'=>'执行中',
                            'domain'=>$DomainList['vid'],
                            'api_id'=>$DomainList['api_id'],
                            'op'=>serialize($operate)
                        ];
                        $logId= Db::name("gzhx_cloud_log")->insertGetId($log);
                        Db::commit();

                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                    $regResult=$domain_api->Bandwidth($operate['data']);
                    if($regResult['status']!=1){

                        Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                            'status'=>'执行失败',
                            'msg'=>$regResult['info']
                        ]);

                        $this->success([
                            'success'=>false,
                        ]);
                    }
                    Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                        'status'=>'执行完成',
                        'msg'=>'执行完成'
                    ]);

                    $this->success([
                        'success'=>true,
                    ]);
                }
                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }

        if(empty($data['info']['info']['系统密码'])){
            $data['info']['info']['系统密码']=$DomainList['password'];
        }

        $DomainList['Info']=$data['info'];

        $this->assign('DomainList',$DomainList);
        $this->assign('CloudTag','domain');
        $this->assign('Title',"{$DomainList['domain']}");

        if(method_exists($domain_api,"Bandwidth")){
            $this->assign('AddBandwidth','yes');
        }

        return $this->fetchTemplete('/records');
    }
    public function Disk(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_cloud')->alias("a")
            ->field("a.*,c.name as api_name,b.name as product_name,c.hostname,c.username as api_aid,c.password as api_ak,c.gzhx_domain_rebet,gzhx_domain_grade")
            ->join("products b","a.region=b.config_option2")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.id","=",$_GET['id'])
            ->where("a.uid","=",$User)
            ->find();
        if(empty($DomainList)){
            $this->assign('msg',"产品不存在");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>86400*3 ){
            $this->assign('msg',"产品已过期，无法管理");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>0 ){
            $this->assign('msg',"产品已过期，请先续费");
            return $this->fetchTemplete('/error');
        }
        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/cloud/")){
            mkdir($CachePath."/cloud/",0755,true);
        }

        $CloudCache=$CachePath."/cloud/{$DomainList['id']}.cache";


        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);
        $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
        $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
        if(intval($UserGroupid)>0){
            $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
            if(intval($gzhx_domain_grade[$UserGroupid])>0){
                $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
            }
        }
        $data=$this->Decrypt("{$CloudCache}");

        if(empty($data)){
            $data=$domain_api->DescribeInstanceFull([
                'region'=>$DomainList['region'],
                'vid'=>$DomainList['vid']
            ]);


            if($data['status']==0){
                $this->assign('msg',$data['info']);
                return $this->fetchTemplete('/error');
            }
            $this->encryption("{$CloudCache}",$data);
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "Setting":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'zone'=>$data['info']['info']['工作区']
                    ];
                    $DescribeDisksCategory=$domain_api->DescribeDisksCategory($query);

                    if($DescribeDisksCategory['status']==0){
                        $this->error($DescribeDisksCategory['info']);
                    }

                    $this->success($DescribeDisksCategory['info']['list']);
                    break;
                }
                case "renew_price":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'zone'=>$data['info']['info']['工作区']
                    ];
                    $DescribeDisksCategory=$domain_api->DescribeDisksCategory($query);

                    if($DescribeDisksCategory['status']==0){
                        $this->error($DescribeDisksCategory['info']);
                    }
                    if(array_key_exists($this->data['type'],$DescribeDisksCategory['info'])){
                        $this->error("磁盘类型不正确");
                    }
                    $Instance=$domain_api->DescribeInstance([
                        'region'=>$DomainList['region'],
                        'vid'=>$DomainList['vid']
                    ]);
                    if($Instance['status']==0){
                        $this->error($Instance['info']);
                    }
                    $InquiryPriceResizeDisk=$domain_api->InquiryPriceCreateDisks([
                        'region'=>$DomainList['region'],
                        'vid'=>$DomainList['vid'],
                        'DiskType'=>$this->data['type'],
                        'DiskSize'=>intval($this->data['size']),
                        'end_time'=>$Instance['info']['end_time']
                    ]);
                    if($InquiryPriceResizeDisk['status']==0){
                        $this->error($InquiryPriceResizeDisk['info']);
                    }
                    $PayPrice=$InquiryPriceResizeDisk['info'];

                    $this->success($PayPrice);
                    break;
                }
                case "DiskBuy":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'zone'=>$data['info']['info']['工作区']
                    ];
                    $DescribeDisksCategory=$domain_api->DescribeDisksCategory($query);

                    if($DescribeDisksCategory['status']==0){
                        $this->error($DescribeDisksCategory['info']);
                    }
                    if(array_key_exists($this->data['type'],$DescribeDisksCategory['info'])){
                        $this->error("磁盘类型不正确");
                    }
                    $Instance=$domain_api->DescribeInstance([
                        'region'=>$DomainList['region'],
                        'vid'=>$DomainList['vid']
                    ]);
                    if($Instance['status']==0){
                        $this->error($Instance['info']);
                    }
                    $InquiryPriceResizeDisk=$domain_api->InquiryPriceCreateDisks([
                        'region'=>$DomainList['region'],
                        'DiskType'=>$this->data['type'],
                        'DiskSize'=>intval($this->data['size']),
                        'end_time'=>$Instance['info']['end_time']
                    ]);
                    if($InquiryPriceResizeDisk['status']==0){
                        $this->error($InquiryPriceResizeDisk['info']);
                    }
                    $PayPrice=$InquiryPriceResizeDisk['info'];


                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("价格不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }
                    $this->data['zone']=$data['info']['info']['工作区'];
                    $this->data['end_time']=$Instance['info']['end_time'];
                    $operate=[
                        'op'=>'DiskBuy',
                        'data'=>[
                            'query'=>$DomainList,
                            'data'=>$this->data
                        ]
                    ];
                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"{$DomainList["domain"]}购买磁盘{$this->data['size']}G",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);



                        $log=[
                            'log_id'=>$DomainList['vid'],
                            'aid'=>$DomainList['id'],
                            'type'=>'购买磁盘',
                            'add_time'=>date("Y-m-d H:i:s"),
                            'status'=>'执行中',
                            'domain'=>$DomainList['vid'],
                            'api_id'=>$DomainList['api_id'],
                            'op'=>serialize($operate)
                        ];
                        $logId= Db::name("gzhx_cloud_log")->insertGetId($log);

                        $logAttach=[
                            'log_id'=>$DomainList['vid'],
                            'aid'=>$DomainList['id'],
                            'type'=>'挂载磁盘',
                            'add_time'=>date("Y-m-d H:i:s"),
                            'status'=>'执行中',
                            'domain'=>$DomainList['vid'],
                            'api_id'=>$DomainList['api_id'],
                            'op'=>serialize($operate)
                        ];
                        $logAttachId= Db::name("gzhx_cloud_log")->insertGetId($logAttach);


                        Db::commit();

                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                    $regResult=$domain_api->DiskBuy($operate['data']);
                    if($regResult['status']!=1){

                        Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                            'status'=>'执行失败',
                            'msg'=>$regResult['info']
                        ]);

                        $this->success([
                            'success'=>false,
                        ]);
                    }
                    Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                        'status'=>'执行完成',
                        'msg'=>'执行完成'
                    ]);
                    $operate['data']['data']['disk']=$regResult['info'];
                    $operateAttachDisks=$operate;
                    $operateAttachDisks['op']="AttachDisks";
                    Db::name("gzhx_cloud_log")->where("id","=",$logAttachId)->update([
                        'op'=>serialize($operateAttachDisks)
                    ]);
                    $regAttachResult=$domain_api->AttachDisks($operateAttachDisks['data']);
                    if($regResult['status']!=1){

                        $this->success([
                            'success'=>false,
                        ]);
                    }
                    Db::name("gzhx_cloud_log")->where("id","=",$logAttachId)->update([
                        'status'=>'执行完成',
                        'msg'=>'执行完成'
                    ]);

                    $this->success([
                        'success'=>true,
                    ]);


                    break;
                }

                case 'resize_price':{
                    $query=[
                        'region'=>$DomainList['region'],
                        'disk'=>$this->data['disk'],
                        'size'=>$this->data['size'],
                        'vid'=>$DomainList['vid'],
                    ];
                    $InquiryPriceResizeDisk=$domain_api->InquiryPriceResizeDisk($query);

                    if($InquiryPriceResizeDisk['status']==0){
                        $this->error($InquiryPriceResizeDisk['info']);
                    }
                    $PayPrice=$InquiryPriceResizeDisk['info'];

                    $this->success($PayPrice);
                    break;
                }
                case "ResizeDisk":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'disk'=>$this->data['disk'],
                        'size'=>$this->data['size'],
                        'vid'=>$DomainList['vid'],
                    ];
                    $InquiryPriceResizeDisk=$domain_api->InquiryPriceResizeDisk($query);

                    if($InquiryPriceResizeDisk['status']==0){
                        $this->error($InquiryPriceResizeDisk['info']);
                    }
                    $PayPrice=$InquiryPriceResizeDisk['info'];

                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("价格不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }

                    $operate=[
                        'op'=>'ResizeDisk',
                        'data'=>[
                            'query'=>$DomainList,
                            'data'=>$this->data
                        ]
                    ];
                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"{$DomainList["domain"]}扩容磁盘{$this->data['size']}G",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);



                        $log=[
                            'log_id'=>$DomainList['vid'],
                            'aid'=>$DomainList['id'],
                            'type'=>'扩容磁盘',
                            'add_time'=>date("Y-m-d H:i:s"),
                            'status'=>'执行中',
                            'domain'=>$DomainList['vid'],
                            'api_id'=>$DomainList['api_id'],
                            'op'=>serialize($operate)
                        ];
                        $logId= Db::name("gzhx_cloud_log")->insertGetId($log);

                        Db::commit();

                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                    $regResult=$domain_api->ResizeDisk($operate['data']);
                    if($regResult['status']!=1){

                        Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                            'status'=>'执行失败',
                            'msg'=>$regResult['info']
                        ]);

                        $this->success([
                            'success'=>false,
                        ]);
                    }
                    Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                        'status'=>'执行完成',
                        'msg'=>'执行完成'
                    ]);


                    $this->success([
                        'success'=>true,
                    ]);

                }
                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }



        $DomainList['Info']=$data['info']['disk'];

        $this->assign('DomainList',$DomainList);
        $this->assign('CloudTag','disk');
        $this->assign('Title',"{$DomainList['domain']}");

        if(method_exists($domain_api,"ResizeDisk")){
            $this->assign('ResizeDisk','yes');
        }
        if(method_exists($domain_api,"DiskBuy")){
            $this->assign('DiskBuy','yes');
        }

        return $this->fetchTemplete('/disk');
    }
    public function Monitor(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_cloud')->alias("a")
            ->field("a.*,c.name as api_name,b.name as product_name,c.hostname,c.username as api_aid,c.password as api_ak")
            ->join("products b","a.region=b.config_option2")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.id","=",$_GET['id'])
            ->where("a.uid","=",$User)
            ->find();
        if(empty($DomainList)){
            $this->assign('msg',"产品不存在");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>86400*3 ){
            $this->assign('msg',"产品已过期，无法管理");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>0 ){
            $this->assign('msg',"产品已过期，请先续费");
            return $this->fetchTemplete('/error');
        }
        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/cloud/")){
            mkdir($CachePath."/cloud/",0755,true);
        }

        $CloudCache=$CachePath."/cloud/{$DomainList['id']}.cache";


        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);

        $data=$this->Decrypt("{$CloudCache}");

        if(empty($data)){
            $data=$domain_api->DescribeInstanceFull([
                'region'=>$DomainList['region'],
                'vid'=>$DomainList['vid']
            ]);


            if($data['status']==0){
                $this->assign('msg',$data['info']);
                return $this->fetchTemplete('/error');
            }
            $this->encryption("{$CloudCache}",$data);
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "MonitorData":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'zone'=>$data['info']['info']['工作区']
                    ];
                    $DescribeDisksCategory=$domain_api->MonitorData($DomainList,$this->data);

                    if($DescribeDisksCategory['status']==0){
                        $this->error($DescribeDisksCategory['info']);
                    }

                    $this->success($DescribeDisksCategory['info']);
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }



        $DomainList['Info']=$data['info']['disk'];

        $this->assign('DomainList',$DomainList);
        $this->assign('CloudTag','monitor');
        $this->assign('Title',"{$DomainList['domain']}");
        if(!method_exists($domain_api,"MonitorData")){
            $this->assign('msg','此主机不支持硬件监控');
            return $this->fetchTemplete('/monitorerror');
        }
        return $this->fetchTemplete('/monitor');
    }
    public function Internet(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $DomainList=Db::name('gzhx_cloud')->alias("a")
            ->field("a.*,c.name as api_name,b.name as product_name,c.hostname,c.username as api_aid,c.password as api_ak")
            ->join("products b","a.region=b.config_option2")
            ->join("zjmf_finance_api c","a.api_id=c.id")
            ->where("a.id","=",$_GET['id'])
            ->where("a.uid","=",$User)
            ->find();
        if(empty($DomainList)){
            $this->assign('msg',"产品不存在");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>86400*3 ){
            $this->assign('msg',"产品已过期，无法管理");
            return $this->fetchTemplete('/error');
        }
        if( time()-strtotime($DomainList['end_time'])>0 ){
            $this->assign('msg',"产品已过期，请先续费");
            return $this->fetchTemplete('/error');
        }
        $CachePath=CMF_DATA."gzhx_domain_cache";
        if(!is_dir($CachePath."/cloud/")){
            mkdir($CachePath."/cloud/",0755,true);
        }

        $CloudCache=$CachePath."/cloud/{$DomainList['id']}.cache";


        if( !class_exists("{$DomainList['hostname']}_class") ){
            if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                $this->assign('msg',"插件不存在");
                return $this->fetchTemplete('/error');
            }
            require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
        }
        $domain_app="\\{$DomainList['hostname']}_class";
        $domain_api=new $domain_app();
        $domain_api->setConfig([
            'aid'=>$DomainList['api_aid'],
            'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
        ]);

        $data=$this->Decrypt("{$CloudCache}");

        if(empty($data)){
            $data=$domain_api->DescribeInstanceFull([
                'region'=>$DomainList['region'],
                'vid'=>$DomainList['vid']
            ]);


            if($data['status']==0){
                $this->assign('msg',$data['info']);
                return $this->fetchTemplete('/error');
            }
            $this->encryption("{$CloudCache}",$data);
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "MonitorData":{
                    $query=[
                        'region'=>$DomainList['region'],
                        'zone'=>$data['info']['info']['工作区']
                    ];
                    $DescribeDisksCategory=$domain_api->InternetMonitorData($DomainList,$this->data);

                    if($DescribeDisksCategory['status']==0){
                        $this->error($DescribeDisksCategory['info']);
                    }

                    $this->success($DescribeDisksCategory['info']);
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }



        $DomainList['Info']=$data['info']['disk'];

        $this->assign('DomainList',$DomainList);
        $this->assign('CloudTag','internet');
        $this->assign('Title',"{$DomainList['domain']}");

        if(!method_exists($domain_api,"InternetMonitorData")){
            $this->assign('msg','此主机不支持网络监控');
            return $this->fetchTemplete('/monitorerror');
        }

        return $this->fetchTemplete('/monitor');
    }
    public function Reg(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetchTemplete('/error');
            }
        }
        $certifi_person=Db::name("certifi_person")
            ->where("auth_user_id","=",$User)
            ->value("status");
        if(intval($certifi_person)!=1){
            $certifi_person=Db::name("certifi_company")
                ->where("auth_user_id","=",$User)
                ->value("status");
            if(intval($certifi_person)!=1){
                $this->assign('msg',"<a href='/verified'>当前帐号未实名，请先此实名认证后再开通</a>");
                return $this->fetchTemplete('/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "RunInstances":{
                    $DomainList=Db::name("products")->alias("a")
                        ->field("a.*,c.name as api_name,c.username as api_aid,c.password as api_ak,c.hostname,c.gzhx_domain_rebet,c.gzhx_domain_grade")

                        ->leftJoin("zjmf_finance_api c","a.upper_reaches_id=c.id")

                        ->where("a.config_option2","=",$this->data['data']['region'])
                        ->where("c.id","=",$this->data['data']['api_id'])
                        ->find();

                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                     $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
                    $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
                    if(intval($UserGroupid)>0){
                        $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
                        if(intval($gzhx_domain_grade[$UserGroupid])>0){
                            $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
                        }
                    }


                    $result= $domain_api->DescribePrice($this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $PayPrice=$result['info'];

                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("购买年限不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }
                    $regId=0;
                    $this->data['data']['password']="GzLtd!".mt_rand(100000,999999);
                    $this->data['data']['InstanceName']="GZ_{$User}_".date("YmdHis");
                    $this->data['data']['PayPrice']=$PayPrice;
                    $operate=[
                      'op'=>'RunInstances',
                      'data'=>$this->data['data']
                    ];
                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"购买云服务器{$DomainList["api_name"]}{$this->data['manual']}年限{$domain_api->Period()[$this->data['data']['period']]}",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);




                        $save=[
                            'region'=>$this->data['data']['region'],
                            'domain'=>$this->data['data']['InstanceName'],
                            'uid'=>$User,
                            'api_id'=>$this->data['data']['api_id'],
                            'active'=>'开通中',
                           // 'years'=>$this->data['data']['period'],
                            'start_time'=>date("Y-m-d H:i:s"),
                            'end_time'=>date("Y-m-d H:i:s"),
                            'templete_info'=>"",
                            'password'=>$this->data['data']['password']
                        ];


                        if(empty($DomainList['config_option1'])){
                            $save['active']='等待更新';
                            $regId= Db::name("gzhx_cloud")->insertGetId($save);

                        }else{
                            $regId= Db::name("gzhx_cloud")->insertGetId($save);
                        }
                        $log=[
                            'log_id'=>'open',
                            'aid'=>$regId,
                            'type'=>'新购',
                            'add_time'=>date("Y-m-d H:i:s"),
                            'status'=>'执行中',
                            'domain'=>$this->data['data']['InstanceName'],
                            'api_id'=>$this->data['data']['api_id'],
                            'op'=>serialize($operate)
                        ];
                        $logId= Db::name("gzhx_cloud_log")->insertGetId($log);
                        if(empty($DomainList['config_option1'])){
                            Db::name("gzhx_cloud_manual")->insert([
                                'aid'=>$logId,
                                'config'=>$this->data['manual'],
                                'status'=>'购买处理中',
                                'add_time'=>date("Y-m-d H:i:s")
                            ]);
                        }
                        Db::commit();
                        if(empty($DomainList['config_option1'])){
                            $this->success("当前为人工开通，请联系客服处理谢谢");
                        }
                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                    $operate['data']['LogId']=$logId;
                    $regResult=$domain_api->RunInstances($operate['data']);
                    if($regResult['status']!=1){

                        Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                            'status'=>'执行失败',
                            'msg'=>$regResult['info']
                        ]);

                        $this->success($regResult['info']);
                    }
                    Db::name("gzhx_cloud_log")->where("id","=",$logId)->update([
                        'log_id'=>$regResult['info']['vid']
                    ]);
                    Db::name("gzhx_cloud")->where("id","=",$regId)->update([
                        'vid'=>$regResult['info']['vid']
                    ]);
                    $this->success($regResult['info']);
                }
                case "price":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data['data']["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $domain_api->Discount=$DomainList['gzhx_domain_rebet'];
                    $UserGroupid=Db::name("clients")->where("id","=",$User)->value("groupid");
                    if(intval($UserGroupid)>0){
                        $gzhx_domain_grade=unserialize($DomainList['gzhx_domain_grade'])?:[];
                        if(intval($gzhx_domain_grade[$UserGroupid])>0){
                            $domain_api->Discount=$gzhx_domain_grade[$UserGroupid];
                        }
                    }
                    $result= $domain_api->DescribePrice($this->data['data']);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }

                    $this->success($result['info']);
                }
                case "DescribeImages":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $this->data['rebet']=$DomainList['gzhx_domain_rebet'];
                    $result= $domain_api->DescribeImages($this->data);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']);
                }
                case "Setting":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);

                    $this->success([
                      //  'DescribeDisksCategory'=>$domain_api->DescribeDisksCategory(),
                        'Period'=>$domain_api->Period(),
                        'Service'=>$domain_api->Service(),
                    ]);
                }
                case "diskType":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);

                    $result= $domain_api->DescribeDisksCategory($this->data);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }
                    $this->success($result['info']);
                }
                case "Instance":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $result= $domain_api->Instance($this->data);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }


                    $this->success($result['info']);

                }
                case "zone":{
                    $DomainList=Db::name("zjmf_finance_api")

                        ->where("id","=",$this->data["api_id"])
                        ->where('hostname','LIKE','%_'.$this->pluginName)->find();
                    if(empty($DomainList)){
                        $this->error("接口不存在");die;
                    }

                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){
                            $this->error("插件不存在");

                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['username'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['password']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $result= $domain_api->Zone($this->data);
                    if($result['status']!=1){
                        $this->error($result['info']);
                    }


                    $this->success($result['info']);
                }
                case "templete":{
                    $DomainList=Db::name('gzhx_domain_template')->alias("a")
                        ->field("b.username,c.name,a.*")
                        ->join("clients b","a.uid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("c.id","=",$this->data["api_id"])
                        ->where("a.uid","=",$User)
                        ->order("a.id desc")

                        ->select()->toArray();
                    $this->success($DomainList);
                    break;
                }



                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        $DbConfig=Db::getConfig();
        $COLUMNS=Db::name("zjmf_finance_api")->getTableFields();

        if(!in_array("gzhx_domain_rebet",$COLUMNS)){
            Db::query("ALTER TABLE `{$DbConfig["prefix"]}zjmf_finance_api` ADD COLUMN `gzhx_domain_rebet` int NULL DEFAULT 0;");
        }
        $server_groups=Db::name("zjmf_finance_api")
            ->field("id,name,gzhx_lighthouse")
            ->where("status","=",2)
            ->where('hostname','LIKE','%_'.$this->pluginName)->select()->toArray();
        $server_groups_list=$server_groups;
        
        if(empty($server_groups_list)) $server_groups_list=[
          ['id'=>-1]
        ];


        $this->assign('server_groups',$server_groups);

        $this->assign('Title','新购');
        if(empty($_GET['api_id'])){
            $Server=$server_groups[0];
        }else{
            $Server=Db::name("zjmf_finance_api")
                ->field("id,name,gzhx_lighthouse")
                ->where("status","=",2)
                ->where("id","=",$_GET['api_id'])
                ->where('hostname','LIKE','%_'.$this->pluginName)->find();

            if(empty($Server)){
                $Server=$server_groups[0];
            }
        }
        $list=Db::name("products")->alias("a")
            ->field("a.name,a.config_option2,a.upper_reaches_id")
            ->where("a.upper_reaches_id","=",$Server['id'])
            ->where("a.api_type","=",'manual')
            ->select()->toArray();

        $this->assign('products',$list);
        $this->assign('ServerID',$Server['id']);
        if(intval($Server['gzhx_lighthouse'])==1){
            return $this->fetchTemplete('/lighthouse');
        }else{
            return $this->fetchTemplete('/reg');
        }

    }
    public function SpecialOfferBuy(){
        $_GET['_action']='index';
        $this->redirect("/addons?".http_build_query($_GET)."#_action=specialoffer",301);die;
    }
    public function Log(){
        $_GET['_action']='index';
        $this->redirect("/addons?".http_build_query($_GET)."#_action=operate_log",301);die;
    }
    public function OperateLog(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetch($this->theme.'/error');
            }
        }

        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){

                case "Refresh":{


                    $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                        ->field("a.*,b.id as domain_id,c.username as api_aid,c.password as api_ak,c.hostname,b.region")
                        ->join("gzhx_cloud b","a.aid=b.id")
                        ->join("zjmf_finance_api c","a.api_id=c.id")
                        ->where("a.id","=",$this->data['id'])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("信息不存在");
                    }
                    if( !class_exists("{$DomainList['hostname']}_class") ){
                        if(!file_exists(CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php")){

                            $this->error("插件不存在".CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php");
                        }
                        require_once CMF_ROOT."public/plugins/addons/{$DomainList['hostname']}/{$DomainList['hostname']}_class.php";
                    }
                    $domain_app="\\{$DomainList['hostname']}_class";
                    $domain_api=new $domain_app();
                    $domain_api->setConfig([
                        'aid'=>$DomainList['api_aid'],
                        'ak'=>openssl_decrypt(hex2bin($DomainList['api_ak']),'aes-128-cbc',  mb_substr(md5("hjio^*(uihkjh"),8,16))
                    ]);
                    $operate=unserialize($DomainList['op']);
                    if($DomainList['type']=="新购"){
                        $domainInfo=$domain_api->DescribeInstance([
                            'region'=>$operate['data']['region'],
                            'vid'=>$DomainList['log_id']
                        ]);
                    }else{
                        $domainInfo=$domain_api->DescribeInstance([
                            'region'=>$DomainList['region'],
                            'vid'=>$DomainList['log_id']
                        ]);
                    }


                    if($domainInfo['status']!=1){
                        $this->error("获取信息失败：{$domainInfo['info']}");
                    }
                    $save=$domainInfo['info'];
                    $save['active']="正常";

                    Db::name("gzhx_cloud")->where("id","=",$DomainList['domain_id'])->update($save);

                    if($DomainList['type']=="挂载磁盘"){
                        $domainInfo=$domain_api->AttachDisks(unserialize($DomainList['op'])['data']);
                        if($domainInfo['status']!=1){
                            $this->error($domainInfo['info']);
                        }
                    }

                    Db::name("gzhx_cloud_log")->where("id","=",$DomainList['id'])->update([
                        'status'=>"执行完成"
                    ]);
                    $this->success("获取成功");
                    break;
                }

                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }


        $Page=isset($_GET['page'])?intval($_GET['page']):1;
        if(!empty($_GET['status'])){
            $count=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->where("b.uid", "=", $User)
                ->count();

            $DomainList=Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,d.username,a.*")
                ->join("gzhx_cloud b","a.aid=b.id")
                ->join("zjmf_finance_api c","a.api_id=c.id")
                ->join("clients d","d.id=b.uid")
                ->where("a.status","=",$_GET['status'])
                ->where("b.uid", "=", $User)
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }else {
            $count = Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_cloud b", "a.aid=b.id")
                ->join("zjmf_finance_api c", "a.api_id=c.id")
                ->where("b.uid", "=", $User)
                ->count();

            $DomainList = Db::name('gzhx_cloud_log')->alias("a")
                ->field("c.name,a.*")
                ->join("gzhx_cloud b", "a.aid=b.id")
                ->join("zjmf_finance_api c", "a.api_id=c.id")
                ->where("b.uid", "=", $User)
                ->order("a.id desc")
                ->page("{$Page},20")
                ->select()->toArray();
        }
        $this->assign('DomainList',$DomainList);
        //  var_dump(Db::name('gzhx_domain')->getLastSql());die;
        $this->assign('count',$count);
        $this->assign('Page',$Page);
        $this->assign('Title','域名操作日志');

        $domainCount=[
            [
                'day'=>'',
                'num'=>'',
                'count'=>Db::name("gzhx_cloud_log")->alias("a")
                    ->join("gzhx_cloud b","a.aid=b.id")
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'等待执行',
                'num'=>30,
                'count'=>Db::name("gzhx_cloud_log")->alias("a")
                    ->join("gzhx_cloud b","a.aid=b.id")
                    ->where("a.status","=", '等待执行')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>"执行中",
                'num'=>7,
                'count'=>Db::name("gzhx_cloud_log")->alias("a")
                    ->join("gzhx_cloud b","a.aid=b.id")
                    ->where("a.status","=", '执行中')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'执行完成',
                'num'=>1,
                'count'=>Db::name("gzhx_cloud_log")->alias("a")
                    ->join("gzhx_cloud b","a.aid=b.id")
                    ->where("a.status","=", '执行完成')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
            [
                'day'=>'执行失败',
                'num'=>1,
                'count'=>Db::name("gzhx_cloud_log")->alias("a")
                    ->join("gzhx_cloud b","a.aid=b.id")
                    ->where("a.status","=", '执行失败')
                    ->where("b.uid","=",$User)
                    ->count()?:0
            ],
        ];
        $this->assign('domainCount',$domainCount);
      //  $PageContent=$this->fetch($this->theme.'/log');
     //   var_dump($this->fetchTemplete($PageContent));die;
       // $this->view->engine->layout(false);
        return $this->fetchTemplete('/log');
    }

    public function Specialoffer(){
        $User=request()->uid;
        if(empty($User)){

            if(empty($User)){
                $this->assign('msg',"登录失效，请重新登录");
                return $this->fetch($this->theme.'/error');
            }
        }
        if(!empty($this->data)){
            $action=$this->data['action'];
            if(empty($action)) $action="";

            switch ($action){
                case "buy":{
                    $DomainList=Db::name("gzhx_cloud_specialoffer")
                        ->where("status","=","正常")
                        ->where("id","=",$this->data["id"])
                        ->find();
                    if(empty($DomainList)){
                        $this->error("产品不存在或者已下架");
                    }
                    if(intval($DomainList['stock'])<1){
                        $this->error("产品售罄");
                    }
                    $PayPrice=floatval($DomainList['price']);

                    if( empty( $PayPrice ) ||floatval($PayPrice)<=0 ){
                        $this->error("购买金额不正确");
                    }
                    $UserMoney= Db::name("Clients")->where("id","EQ",$User)->value("credit");
                    if(floatval($UserMoney)-$PayPrice<0){
                        $this->error("余额不足，无法支付");die;
                    }

                    Db::startTrans();
                    try{

                        $InvoicesId=Db::name("Invoices")->insertGetId([
                            'uid'=>$User,
                            'invoice_num'=>date("YmdHis").mt_rand(10000,999999),
                            'create_time'=>time(),
                            'subtotal'=>$PayPrice,
                            'status'=>'Paid',
                            'credit'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'product',
                        ]);




                        $InvoicesItemsId=Db::name("InvoiceItems")->insertGetId([
                            'uid'=>$User,
                            'invoice_id'=>$InvoicesId,
                            'description'=>"购买特价云服务器{$DomainList["title"]}{$DomainList["setting"]}年限{$DomainList["period"]}",
                            'rel_id'=>0,
                            'amount'=>$PayPrice,
                            'payment'=>'UserCustom',
                            'type'=>'host',
                        ]);


                        $CreditId=Db::name("Credit")->insertGetId([
                            'uid'=>$User,

                            'create_time'=>time(),

                            'description'=>"Credit Applied to Invoice #{$InvoicesId}",

                            'relid'=>$InvoicesId,
                            'amount'=>$PayPrice,

                        ]);


                        Db::name("Clients")->where("id","EQ",$User)->setDec("credit",$PayPrice);




                        $save=[
                            'aid'=>$DomainList['id'],
                            'uid'=>$User,
                            'status'=>'开通中',
                            'add_time'=>date("Y-m-d H:i:s"),
                        ];
                        Db::name("gzhx_cloud_specialoffer")->where("id","=",$DomainList['id'])->setDec("stock",1);

                        Db::name("gzhx_cloud_specialoffer_list")->insertGetId($save);

                        Db::commit();
                        $this->success("当前为人工开通，请联系客服处理谢谢");
                    }catch (Exception $e){

                        Db::rollback();
                        $this->error(var_export($e,true));
                    }
                }


                default:{
                    $this->error("参数不存在");
                    break;
                }
            }

        }
        $List=Db::name("gzhx_cloud_specialoffer")
            ->where("status","=","正常")
            ->select()->toArray();

        $this->assign('DomainList',$List);
        $this->assign('Title','特价机器');
        return $this->fetchTemplete('/specialoffer');
    }

}