
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content">
                            <table class="table table-bordered table-hover">
                                <caption>选中的项目： <button type="button" class="btn btn-danger btn-sm update-files">批量更新</button></caption>
                                <thead class="thead-light">
                                <tr>
                                    <th class="checkbox">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input" id="customCheckHead" name="headCheckbox">
                                            <label class="custom-control-label" for="customCheckHead">&nbsp;</label>
                                        </div>
                                    </th>

                                    <th>文件名</th>
                                    <th>状态</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $List as $key=>$item}
                                <tr>
                                    <td class="checkbox">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input row-checkbox" data-file="{$item}" id="customCheck{$key}">
                                            <label class="custom-control-label" for="customCheck{$key}">&nbsp;</label>
                                        </div>
                                    </td>
                                    <td>{$item}</td>
                                    <td>未修复</td>
                                </tr>
                               {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="table-body">文档说明：<a href="https://html5code.org/type/zjmf.html" target="_blank">https://html5code.org/type/zjmf.html</a> </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {



                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) option.error(t.info);
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) option.error("网络错误，请重试");
                }
            }
        );
    }
    $(function (){
        $('#customCheckHead').off("click").on('click',function () {
            let checked=$(this).prop("checked");
            $(this).closest('table').find('input[type="checkbox"]').prop("checked",checked);
        })
        let update=function (i,dom){
            if(i>=dom.length){
                return false;
            }
            let self=dom.eq(i);
            let file=dom.eq(i).data('file');
            i++;
            ajax({
                data:{
                    file:file
                },
                success:function (r){
                    self.closest('tr').find('td:eq(2)').html('<span>'+r+'</span>')
                    setTimeout(function (){
                        update(i,dom)
                    },500)
                },error:function (r){
                    self.closest('tr').find('td:eq(2)').html('<span style="color: #ff0000">'+r+'</span>')
                    setTimeout(function (){
                        update(i,dom)
                    },500)
                }
            })
        }
        $('.update-files').off("click").on("click",function (){
            $('#renewMsg').html('');
            let count=$(this).closest('table').find('input[data-file][type="checkbox"]:checked');
            if(!count.length){
                $('#renewMsg').html('请选择要更新的文件');
                return false;
            }
            update(0,count);
        })
    })
</script>