<style>
  .pagination {
    display: flex;
    justify-content: center;
    padding-left: 0;
    margin: 20px 0;
    border-radius: 4px;

  }
  .pagination > li {
    display: inline;
  }
  .pagination > li > a, .pagination > li > span {
    position: relative;
    float: left;
    padding: 6px 12px;
    margin-left: -1px;
    line-height: 1.42857143;
    color: #337ab7;
    text-decoration: none;
    background-color: #fff;
    border: 1px solid #ddd;
  }
  .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
    z-index: 2;
    color: #fff;
    cursor: default;
    background-color: #337ab7;
    border-color: #337ab7;
  }
</style>
<section class="admin-main">
  <div class="container-fluid">
    <div class="page-container">
      <div class="card">
        <div class="card-body">
          <!-- class="col-lg-1 col-md-12 col-sm-12" -->
          <div class="card-title row">
            <div class="pl-4 pr-4">{$Title}</div>
            <div class="col-lg-8 col-md-12 col-sm-12">
              {foreach $PluginsAdminMenu as $v}
                {if $v['custom']}
                  <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                {else/}
                  <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                {/if}
              {/foreach}
            </div>
          </div>
          <div class="tab-content mt-4">

            <div class="table-body auto-login-content">

              <table class="table table-bordered table-hover">
                <thead class="thead-light">
                <tr>

                  <th>接口</th>
                  <th>域名</th>
                  <th>操作内容</th>
                  <th>错误原因</th>
                  <th>操作</th>

                </tr>
                </thead>
                <tbody>
                {foreach $DomainList as $key=>$item}
                  <tr>

                    <td>{$item.name}</td>
                    <td>{$item.domain}</td>
                    <td>{$item.type}</td>
                    <td>
                      {$item.msg}


                    </td>
                    <td>
                      {if $item.status==1}
                      <a href="javascript:;" class="btn btn-danger get-md5" data-task="{$item.id}" style="color: #ffffff!important;"><i class="far fa-cog"></i> 处理</a>
                      <a href="javascript:;" class="btn btn-default get-md5" data-manual="{$item.id}"><i class="far fa-cog"></i> 已手动处理转正</a>
                      {else /}
                        已处理
                      {/if}
                    </td>


                  </tr>
                {/foreach}
                </tbody>
              </table>
              <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

            </div>
            <div class="myPagination"></div>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/pagination.js"></script>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/layer/layer.js"></script>
<script>
  let queryToJson=function (hash){
    let str=hash?window.location.hash:window.location.search
    if( !str ) return { };
    if(str) str=str.substr(1);
    if( !str ) return { };
    let arr = str.split('&');
    let data={ };
    $.each( arr, function (k,v) {

      if(v.indexOf("=")>-1){
        let d=v.indexOf("=");
        data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

      }

    } );
    return data;
  }
  let jsonToQuery=function (json){
    return  Object.keys(json).map(function (key) {
      return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
    }).join("&");
  }
  let ajax=function (option){
    let loadIndex=layer.load();
    $.ajax({
              dataType: "json",
              type: option.type||"post",

              headers: {
                "X-Requested-With": "XMLHttpRequest",

              },
              url: option.url||"",
              data:option.data,
              async:true,
              success: function (t) {

                layer.close(loadIndex);

                if( t.status==1 ){
                  if(option.success)  option.success(t.info);
                }else{
                  if(option.error) {
                    option.error(t.info);
                  }
                  else{
                    layer.msg(t.info);
                  }
                }
              },

              error: function (request, status, errorThrown) {
                layer.close(loadIndex);
                if(option.error) {
                  option.error("网络错误，请重试");
                }
                else{
                  layer.msg("网络错误，请重试");
                }
              }
            }
    );
  }
  $(function (){
    $('[data-task]').off("click").on('click',function () {
      let id=$(this).data("task");
      ajax({
        data:{
          action:'task',
          id:id
        },
        success:function (r){
          window.location.reload();
        },
        error:function (r){
          layer.alert(r);
        }
      })
    })
    $('[data-manual]').off("click").on('click',function () {
      let id=$(this).data("manual");
      layer.confirm('<div style="padding: 20px;">确认已经手动处理了此问题并更新</div>',{
        type:1,
        btn: ['提交转正', '关闭']
      }, function(index, layero){
        ajax({
          data:{
            action:'manual',
            id:id
          },
          success:function (r){
            window.location.reload();
          },
          error:function (r){
            layer.alert(r);
          }
        })
      }, function(index){
        //按钮【按钮二】的回调
      });

    })
    let count="{$count}";
    let pageNumber="{$Page}";
    $(".myPagination").Pagination({
      page:parseInt(pageNumber),
      count:parseInt(count),
      groups: 10,
      prev:'上一页',
      next:'下一页',
      first:'首页',
      last:'末页',
      limit:20,
      onPageChange:function (page) {
        if(parseInt(pageNumber)!=parseInt(page)){
          let query=queryToJson();
          query.page=page;
          top.location.href="./addons?"+jsonToQuery(query)
        }

      }
    });
  })
</script>