<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content">
                            <table class="table table-bordered table-hover">
                                <thead class="thead-light">
                                <tr>

                                    <th>接口</th>
                                    <th>用户</th>
                                    <th>标志</th>
                                    <th>说明</th>


                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>
                                            {$item.name}
                                        </td>
                                        <td>
                                            {$item.username}
                                        </td>
                                        <td>
                                            {neq name="item.status" value="购买处理中"}
                                                <b>{$item.vid}</b>({$item.domain})
                                            {/neq}
                                        </td>
                                        <td>{$item.config}</td>

                                        <td>
                                            {if $item.status=='执行完成'}执行完成{else /}
                                            {eq name="item.status" value="购买处理中"}
                                            <div style="display: flex;">
                                                <input type="text" name="distributeusername" value="" placeholder="产品标志" style="border-right: 0;border-bottom-right-radius: 0;border-top-right-radius: 0;"> <button type="button" class="btn btn-danger btn-sm update-file" style="border-left: 0;border-bottom-left-radius: 0;border-top-left-radius: 0;" data-id="{$item.id}">录入产品标志确认</button>
                                            </div>
                                                {else /}
                                            <a href="javascript:;" class="btn btn-danger getRegistrantInfo" data-id="{$item.id}" style="color: #ffffff!important;">更新续费结果</a> </td>
                                            {/eq}
                                        {/if}


                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>
                        <div class="table-body">文档说明：<a href="https://html5code.org/type/zjmf.html" target="_blank">https://html5code.org/type/zjmf.html</a> </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/pagination.js"></script>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/layer/layer.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {



                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) {
                            option.error(t.info);
                        }
                        else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) {
                        option.error("网络错误，请重试");
                    }
                    else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }
    $(function (){
        $('.update-file').off("click").on("click",function (){
            $('#renewMsg').html('');
            let self=$(this),id=self.data("id"),username=self.prev("input").val();
            if(!username){
                layer.msg('请输入要分配的产品标志');
                return false;
            }

            ajax({
                data:{
                    action:'getRegistrantInfo',
                    id:id,
                    vid:username
                },
                success:function (r){
                    self.closest("tr").remove();
                }
            })
            // update(0,count);
        })
        $('.getRegistrantInfo').off("click").on("click",function (){

            let self=$(this),id=self.data("id");
            ajax({
                data:{
                    action:'getRegistrantInfo',
                    id:id
                },
                success:function (r){
                    self.closest("tr").remove();
                }
            })
        })
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    })
</script>