<meta content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0;" name="viewport" />
<link href="/plugins/addons/{$GzhxPluginPath}/template/js/layui/css/layui.css" rel="stylesheet" />
<style>
    .pagination {
        display: flex;
        justify-content: center;
        padding-left: 0;
        margin: 20px 0;
        border-radius: 4px;

    }
    .pagination > li {
        display: inline;
    }
    .pagination > li > a, .pagination > li > span {
        position: relative;
        float: left;
        padding: 6px 12px;
        margin-left: -1px;
        line-height: 1.42857143;
        color: #337ab7;
        text-decoration: none;
        background-color: #fff;
        border: 1px solid #ddd;
    }
    .pagination > .active > a, .pagination > .active > span, .pagination > .active > a:hover, .pagination > .active > span:hover, .pagination > .active > a:focus, .pagination > .active > span:focus {
        z-index: 2;
        color: #fff;
        cursor: default;
        background-color: #337ab7;
        border-color: #337ab7;
    }
</style>
<section class="admin-main">
    <div class="container-fluid">
        <div class="page-container">
            <div class="card">
                <div class="card-body">
                    <!-- class="col-lg-1 col-md-12 col-sm-12" -->
                    <div class="card-title row">
                        <div class="pl-4 pr-4">{$Title}</div>
                        <div class="col-lg-8 col-md-12 col-sm-12">
                            {foreach $PluginsAdminMenu as $v}
                                {if $v['custom']}
                                    <span  class="ml-2"><a  class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                                {else/}
                                    <span  class="ml-2"> <a  class="h5" href="{$v.url}">{$v.name}</a></span>
                                {/if}
                            {/foreach}
                        </div>
                    </div>
                    <div class="tab-content mt-4">

                        <div class="table-body auto-login-content">
                            <table class="table table-bordered table-hover">
                                <thead class="thead-light">
                                <tr>

                                    <th>接口</th>
                                    <th>用户</th>
                                    <th>配置</th>
                                    <th>价格/周期</th>
                                    <th>操作</th>
                                </tr>
                                </thead>
                                <tbody>
                                {foreach $DomainList as $key=>$item}
                                    <tr>

                                        <td>
                                            {$item.plugin_name}
                                        </td>
                                        <td>
                                            {$item.username}
                                        </td>
                                        <td>
                                            {$item.setting}
                                        </td>
                                        <td>{$item.price}/{$item.period}</td>

                                        <td>
                                            {if $item.specialoffer_status=='已完成'}已完成{else /}
                                            <a href="javascript:;" class="btn btn-danger getRegistrantInfo" data-id="{$item.a_id}" style="color: #ffffff!important;">处理</a> </td>
                                        {/if}


                                    </tr>
                                {/foreach}
                                </tbody>
                            </table>
                            <div class="table-body" id="renewMsg" style="color: #ff0000;"></div>

                        </div>
                        <div class="myPagination"></div>
                        <div class="table-body">文档说明：<a href="https://html5code.org/type/zjmf.html" target="_blank">https://html5code.org/type/zjmf.html</a> </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/pagination.js"></script>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/layer/layer.js"></script>
<script src="/plugins/addons/{$GzhxPluginPath}/template/js/layui/layui.js"></script>
<script>
    let queryToJson=function (hash){
        let str=hash?window.location.hash:window.location.search
        if( !str ) return { };
        if(str) str=str.substr(1);
        if( !str ) return { };
        let arr = str.split('&');
        let data={ };
        $.each( arr, function (k,v) {

            if(v.indexOf("=")>-1){
                let d=v.indexOf("=");
                data[ decodeURIComponent(v.substr(0,d)) ]=decodeURIComponent(v.substr(d+1));

            }

        } );
        return data;
    }
    let jsonToQuery=function (json){
        return  Object.keys(json).map(function (key) {
            return json[key]? (key + "=" + encodeURIComponent(json[key])):"";
        }).join("&");
    }
    let ajax=function (option){
        $.ajax({
                dataType: "json",
                type: option.type||"post",

                headers: {
                    "X-Requested-With": "XMLHttpRequest",

                },
                url: option.url||"",
                data:option.data,
                async:true,
                success: function (t) {



                    if( t.status==1 ){
                        if(option.success)  option.success(t.info);
                    }else{
                        if(option.error) {
                            option.error(t.info);
                        }
                        else{
                            layer.msg(t.info);
                        }
                    }
                },

                error: function (request, status, errorThrown) {
                    if(option.error) {
                        option.error("网络错误，请重试");
                    }
                    else{
                        layer.msg("网络错误，请重试");
                    }
                }
            }
        );
    }
    layui.use('form',function (){
        $('.getRegistrantInfo').off("click").on("click",function (){

            let self=$(this),id=self.data("id");
            ajax({
                data:{
                    action:'Servers',
                    id:id
                },
                success:function (r){
                    let option='<option value="">请选择接口</option>';
                    $.each(r,function (k,v){
                        option +='<option value="'+v.id+'">'+v.name+'('+v.gzhx_user_id+')</option>';
                    })

                    let html='<div style="padding: 20px;box-sizing: border-box;"><form class="layui-form lay-cloud-config" action="" style="display: flex;flex-direction: column;align-items: stretch;">' +
                        '<select name="api_id" lay-filter="ApiFilter">'+option+'</select>' +
                        '<select name="region"><option value="">请选择区域</option></select>' +
                        '<input type="text" name="vid" required  lay-verify="required" placeholder="请输入服务器ID或IP" autocomplete="off" class="layui-input">' +
                        '<button type="submit" class="btn btn-primary btn-lg btn-block" style="margin-top: 20px;" lay-submit lay-filter="formDemo">处理此订单</button></form>' +
                        '<button type="button" class="btn btn-default btn-lg btn-block btnn-close" style="margin-top: 20px;">关闭</button>' +
                        '</div>';
                    let w=$(window).width();
                    if(w>600) w=600;
                    layer.open({
                        type:1,
                        area:w+'px',
                        title:'处理订单',
                        content:html,
                        btn:false,
                        success:function (b,a){
                            layui.form.render();
                            b.find('.btnn-close').off('click').on('click',function (){
                                layer.close(a);
                            })
                            layui.form.on('select(ApiFilter)', function(data){
                                ajax({
                                    data:{
                                        action:'region',
                                        api_id:data.value
                                    },
                                    success:function (region){
                                        let regionOption='<option value="">请选择区域</option>';
                                        $.each(region,function (k,v){
                                            regionOption +='<option value="'+k+'">'+v+'</option>';
                                        })
                                        b.find('select[name="region"]').html(regionOption)
                                        layui.form.render();
                                    }
                                })
                            });
                            layui.form.on('submit(formDemo)', function(data){


                                data.field.id=id
                                /**
                                 * **/
                                let _Update=function (){
                                    data.field.action="info";
                                    ajax({
                                        data:data.field,
                                        success:function (res){
                                            layer.close(a);
                                            layer.alert("处理完成",{
                                                end:function (){
                                                    self.closest('td').html('处理完成');
                                                }
                                            });

                                        }
                                    });
                                }
                                data.field.action="check";
                                ajax({
                                    data:data.field,
                                    success:function (res){
                                        if(res){
                                            layer.confirm('当前机器已有分配给其他用户，是否强制分给此用户?', {icon: 3, title:'提示'}, function(index){

                                                layer.close(index);
                                                _Update();
                                            });
                                        }else{
                                            _Update();
                                        }

                                    }
                                })

                                return false;
                            });

                        }
                    })
                }
            })
        })
        let count="{$count}";
        let pageNumber="{$Page}";
        $(".myPagination").Pagination({
            page:parseInt(pageNumber),
            count:parseInt(count),
            groups: 10,
            prev:'上一页',
            next:'下一页',
            first:'首页',
            last:'末页',
            limit:20,
            onPageChange:function (page) {
                if(parseInt(pageNumber)!=parseInt(page)){
                    let query=queryToJson();
                    query.page=page;
                    top.location.href="./addons?"+jsonToQuery(query)
                }

            }
        });
    })
</script>