<?php
class comtop_dominbygzhx_class
{
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "http://api.zgsj.com/agentserver/";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = mb_substr(md5($data["ak"]), 8, 16);
    }
    private function curl($option)
    {
        $option["data"]["u_name"] = $this->uid;
        $option["data"]["act"] = $option["method"];
        $option["data"]["checkTime"] = date("YmdHis");
        $option["data"]["checkSum"] = strtolower(md5($option["data"]["u_name"] . $this->APiKey . $option["data"]["act"] . $option["data"]["checkTime"]));
        $rData = [];
        foreach ($option["data"] as $key => $item) {
            $rData[$key] = mb_convert_encoding($item, "GBK", "UTF-8");
        }
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->ApiUrl . "/" . ($option["data"]["sub_uri"] ?: "assist") . "/");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($option["data"])) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($rData));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        $result = mb_convert_encoding($result, "UTF-8", "GBK");
        return $result;
    }
    private function get($Action, $option)
    {
        $option["method"] = $Action;
        $result = $this->curl($option);
        $myarray = json_decode(json_encode((array) simplexml_load_string($result)), true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("returnvalue", $myarray)) {
            return ["status" => 0, "info" => "没有参数【ret】"];
        }
        if ($myarray["returnvalue"] != "true") {
            return ["status" => 0, "info" => $myarray["returninfo"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    private function CheckDomain($query)
    {
        $DomainName = $query["DomainName"];
        $r = $this->get("domaincheck", ["data" => ["d_name" => $DomainName]]);
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["info"]["returninfo"] == "err") {
            return ["status" => 0, "info" => "超时，请稍候再试"];
        }
        $r["info"]["Avail"] = $r["info"]["returninfo"] == "no" ? 1 : 2;
        return $r;
    }
    public function SaveRegistrantProfile($query)
    {
        $post = ["d_type" => 200, "d_mouldName" => $query["RegistrantProfileId"] ?: "T" . date("YmdHis") . $query["RegistrantType"], "d_owner_type" => $query["RegistrantType"] == 1 ? 1 : 2, "d_owner_zh" => $query["ZhRegistrantOrganization"], "d_owner_ln_zh" => mb_substr($query["ZhRegistrantName"], 0, 1, "utf-8"), "d_owner_fn_zh" => mb_substr($query["ZhRegistrantName"], 1, NULL, "utf-8"), "d_owner_province_zh" => "浙江省", "d_owner_city_zh" => "杭州市", "d_owner_street_zh" => mb_substr($query["ZhAddress"], 0, 10, "UTF-8"), "d_owner" => $query["RegistrantOrganization"], "d_owner_ln" => explode(" ", $query["RegistrantName"])[0], "d_owner_fn" => explode(" ", $query["RegistrantName"])[1], "d_owner_province" => "zhejiangsheng", "d_owner_city" => "hangzhoushi", "d_owner_street" => mb_substr($query["Address"], 0, 50, "UTF-8"), "d_owner_country" => "CN", "d_owner_zip" => $query["PostalCode"], "d_owner_telC" => "86", "d_owner_telA" => "0", "d_owner_telN" => $query["Telephone"], "d_owner_faxC" => "86", "d_owner_faxA" => "0", "d_owner_faxN" => $query["Telephone"], "d_owner_email" => $query["Email"]];
        if (!empty($query["RegistrantProfileId"])) {
            $r = ["status" => 1, "info" => ["returninfo" => $query["RegistrantProfileId"]]];
        } else {
            $r = $this->get("domaintempcreate", ["data" => $post]);
        }
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["status"] == 1) {
            $r["info"]["RegistrantProfileId"] = $r["info"]["returninfo"];
        }
        switch ($query["IdentityCredentialType"]) {
            case "SFZ":
                $f_type_org = "SFZ";
                break;
            case "HZ":
                $f_type_org = "HZ";
                break;
            case "TXZ":
                $f_type_org = "HKJMTXZ";
                break;
            case "YYZZ":
                $f_type_org = "YYZZ";
                break;
            case "ORG":
                $f_type_org = "ORG";
                break;
            case "TYDMZ":
                $f_type_org = "TYXYDMZ2";
                break;
            default:
                switch ($query["IdentityRegistrantType"]) {
                    case "SFZ":
                        $f_type_org2 = "SFZ";
                        break;
                    case "HZ":
                        $f_type_org2 = "HZ";
                        break;
                    case "TXZ":
                        $f_type_org2 = "HKJMTXZ";
                        break;
                    case "YYZZ":
                        $f_type_org2 = "YYZZ";
                        break;
                    case "ORG":
                        $f_type_org2 = "ORG";
                        break;
                    case "TYDMZ":
                        $f_type_org2 = "TYXYDMZ2";
                        break;
                    default:
                        $upload = $this->get("domaintempsmupload", ["data" => ["d_contactid" => $r["info"]["returninfo"], "orgtype" => $f_type_org, "orgcode" => $query["IdentityCredentialNo"], "orgimg" => $query["RegistrantProfilePic"], "contacttype" => $f_type_org2, "contactcode" => $query["IdentityRegistrantNo"], "contactimg" => $query["IdentityRegistrantPic"]]]);
                        $r["upload"] = $upload;
                        return $r;
                }
        }
    }
    private function TemplateData($data)
    {
        $status = "未知";
        strval($data["cnnicsmstatus"]);
        switch (strval($data["cnnicsmstatus"])) {
            case "待提交实名资料":
                $status = "未实名认证";
                break;
            case "模板审核中":
                $status = "审核中";
                break;
            case "模板审核通过":
                $status = "已实名认证";
                break;
            case "模板审核失败":
                $status = "实名失败";
                break;
            default:
                parse_str($data["info"], $arr);
                $info = ["TemplateId" => $arr["tname"], "Email" => $data["uemail"], "RegistrantType" => $data["utype"] == "P" ? 1 : 2, "ZhRegistrantName" => (string) $data["uname1"], "AuditStatus" => $status, "RegistrantName" => $data["uname2"], "Province" => $data["uprov"], "City" => $data["ucity2"], "Address" => $data["uaddr2"], "Country" => "CN", "TelArea" => "86", "Telephone" => $data["uteln"], "TelExt" => "1234", "PostalCode" => $data["uzip"]];
                if ($status == "实名失败" && !empty($data["auditUnpassReason"])) {
                    $info["AuditStatus"] = (string) $data["auditUnpassReason"];
                }
                return $info;
        }
    }
    public function DescribeTemplate($query)
    {
        $r = $this->get("domaintempinfo", ["data" => ["d_contactid" => $query["vid"], "d_infotype" => "allstatus"]]);
        if ($r["status"] == 1) {
            $status = "未知";
            strval($r["info"]["cnnicsmstatus"]);
            switch (strval($r["info"]["cnnicsmstatus"])) {
                case "待提交实名资料":
                    $status = "未实名认证";
                    break;
                case "模板审核中":
                    $status = "审核中";
                    break;
                case "模板审核通过":
                    $status = "已实名认证";
                    break;
                case "模板审核失败":
                    $status = "实名失败";
                    break;
                default:
                    $r["AuditStatus"] = $status;
                    return ["status" => 1, "AuditStatus" => $status];
            }
        } else {
            return $r;
        }
    }
    public function DescribeTemplateList($Offset)
    {
        $r = $this->get("/audit/?act=auditlist", ["pageno" => $Offset + 1, "pagesize" => 100]);
        if ($r["status"] != 1) {
            return $r;
        }
        $info = ["status" => 1, "info" => ["TemplateSet" => [], "TotalCount" => $r["info"]["data"]["pagelist"]["total"]]];
        foreach ($r["info"]["data"]["info"] as $key => $value) {
            $info["info"]["TemplateSet"][] = $this->TemplateData($value);
        }
        return $info;
    }
    public function DescribeDomainNameList($Offset = 0)
    {
        $r = $this->get("domaingetoutputlist", []);
        if ($r["status"] != 1) {
            return $r;
        }
        $data = [];
        $list = explode(",", $r["info"]["returninfo"]);
        foreach ($list as $item) {
            $data[] = ["DomainId" => $item, "DomainName" => $item, "BuyStatus" => "ok"];
        }
        return ["status" => 1, "info" => ["DomainSet" => $data, "TotalCount" => count($list)]];
    }
    public function DomainPassword($query)
    {
        $r = $this->get("domaingetproductkey", ["data" => ["d_name" => $query["DomainName"], "productkey" => "password"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["password"] = $r["info"]["returninfo"];
        $domainlogincp = $this->get("domainlogincp", ["data" => ["d_name" => $query["DomainName"]]]);
        if ($domainlogincp["status"] == 0) {
            return $domainlogincp;
        }
        $r["info"]["uri"] = $domainlogincp["info"]["returninfo"];
        return $r;
    }
    public function QueryDomainList($query)
    {
        $r = $this->get("domaingetproductkey", ["data" => ["d_name" => $query["DomainName"], "productkey" => "expiredate"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $regdate = $this->get("domaingetproductkey", ["data" => ["d_name" => $query["DomainName"], "productkey" => "regdate"]]);
        if ($regdate["status"] != 1) {
            return $regdate;
        }
        $result = ["status" => 1, "info" => ["Data" => ["Domain" => [["vid" => $query["DomainName"], "DomainId" => $query["DomainName"], "DomainName" => $query["DomainName"], "ExpirationDate" => $r["info"]["returninfo"], "RegistrationDate" => $regdate["info"]["returninfo"]]]]]];
        return $result;
    }
    public function queryDomainVerifyStatus($query)
    {
        $checksum = [];
        $checksum[] = "queryDomainVerifyStatus";
        $checksum[] = $this->uid;
        $checksum[] = $this->APiKey;
        $checksum[] = $query["DomainName"];
        $r = $this->get("queryDomainVerifyStatus", ["data" => ["dn" => $query["DomainName"]], "checksum" => ["name"], "token" => strtolower(md5(implode("", $checksum)))]);
        if ($r["status"] != 1) {
            return $r;
        }
        parse_str($r["info"]["info"], $arr);
        $status = "未知";
        strval($arr["auditStatus"]);
        switch (strval($arr["auditStatus"])) {
            case "00":
                $status = "未实名认证";
                break;
            case "04":
                $status = "审核中";
                break;
            case "06":
                $status = "已实名认证";
                break;
            case "07":
                $status = "实名失败";
                break;
            case "05":
                $status = "实名失败";
                break;
            default:
                $r["AuditStatus"] = $status;
                return $r;
        }
    }
    private function SaveSingleTaskForCreatingOrderActivate($query)
    {
        $r = $this->get("domainbuywithtemp", ["data" => ["d_name" => $query["DomainName"], "d_password" => "Gz!" . mt_rand(10000, 999999), "d_period" => $query["Period"], "d_contactid" => $query["RegistrantProfileId"], "sub_uri" => "product"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["active"] = "正常";
        return $r;
    }
    public function beforeReg($query)
    {
        $r = $this->DescribeTemplate(["vid" => $query["RegistrantProfileId"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        if ($r["AuditStatus"] != "已实名认证") {
            return ["status" => 0, "info" => "当前信息模版" . $r["AuditStatus"] . "，暂时无法注册域名"];
        }
        return $r;
    }
    private function SaveBatchTaskForModifyingDomainDns($query)
    {
        $arr = ["domain" => $query["DomainName.1"]];
        if (!empty($query["DomainNameServer.1"]) && !empty($query["DomainNameServer.2"])) {
            $arr["dns1"] = $query["DomainNameServer.1"];
            $arr["dns2"] = $query["DomainNameServer.2"];
        } else {
            $arr["dns1"] = "dns3.4cun.com";
            $arr["dns2"] = "dns4.51dns.top";
        }
        $r = $this->get("domainmoddns", ["data" => ["d_name" => $query["DomainName.1"], "d_dns1" => $arr["dns1"], "d_dns2" => $arr["dns2"]]]);
        return $r;
    }
    public function DescribeDomainNs($query)
    {
        $r = $this->get("domaingetproductkey", ["data" => ["d_name" => $query["DomainName"], "productkey" => "dns"]]);
        return ["status" => 1, "info" => [$r["info"]["d_dns1"], $r["info"]["d_dns2"]]];
    }
    private function SaveBatchTaskForCreatingOrderRenew($query)
    {
        $expiredate = $this->get("domaingetproductkey", ["data" => ["d_name" => $query["OrderRenewParam.1.DomainName"], "productkey" => "expiredate"]]);
        if ($expiredate["status"] != 1) {
            return $expiredate;
        }
        $r = $this->get("domainrenew", ["data" => ["d_name" => $query["OrderRenewParam.1.DomainName"], "d_period" => intval($query["OrderRenewParam.1.SubscriptionDuration"]), "d_deaddate" => date("Y-m-d", strtotime($expiredate["info"]["returninfo"])), "sub_uri" => "product"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        $r["info"]["expiredate"] = date("Y-m-d H:i:s", strtotime("+" . $query["OrderRenewParam.1.SubscriptionDuration"] . " year", strtotime($expiredate["info"]["returninfo"])));
        return $r;
    }
}

?>