<?php
class comtop_dominbygzhx_dns
{
    public $ttl = 900;
    private $uid = "";
    private $APiKey = "";
    private $ApiUrl = "http://api.zgsj.com/agentserver/assist/";
    public function config()
    {
        return ["discount" => 2, "integral" => 0];
    }
    public function setConfig($data)
    {
        $this->uid = $data["aid"];
        $this->APiKey = mb_substr(md5($data["ak"]), 8, 16);
    }
    private function curl($option)
    {
        $option["data"]["u_name"] = $this->uid;
        $option["data"]["act"] = $option["method"];
        $option["data"]["checkTime"] = date("YmdHis");
        $option["data"]["checkSum"] = strtolower(md5($option["data"]["u_name"] . $this->APiKey . $option["data"]["act"] . $option["data"]["checkTime"]));
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->ApiUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        if (!empty($option["data"])) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, mb_convert_encoding(http_build_query($option["data"]), "GBK", "UTF-8"));
        }
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 20);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        $result = curl_exec($ch);
        $info = curl_getinfo($ch);
        $curl_error = curl_error($ch);
        curl_close($ch);
        $result = mb_convert_encoding($result, "UTF-8", "GBK");
        return $result;
    }
    private function get($Action, $option)
    {
        $option["method"] = $Action;
        $result = $this->curl($option);
        $myarray = json_decode(json_encode((array) simplexml_load_string($result)), true);
        if (!is_array($myarray)) {
            return ["status" => 0, "info" => "数据解析失败" . $result];
        }
        if (!array_key_exists("returnvalue", $myarray)) {
            return ["status" => 0, "info" => "没有参数【ret】"];
        }
        if ($myarray["returnvalue"] != "true") {
            return ["status" => 0, "info" => $myarray["returninfo"]];
        }
        return ["status" => 1, "info" => $myarray];
    }
    public function YunApi($Action, $query, $product = NULL)
    {
        if (empty($product)) {
            $data = $this->get($Action, $query);
        } else {
            $data = $this->{$product}($Action, $query);
        }
        $data["Config"] = $this->config();
        return $data;
    }
    public function init($Action, $query, $data = NULL)
    {
        return $this->{$Action}($query);
    }
    public function recordType()
    {
        return ["A" => "A", "CNAME" => "CNAME", "MX" => "MX", "TXT" => "TXT", "AAAA" => "AAAA", "SRV" => "SRV"];
    }
    public function Line()
    {
        return ["default" => "默认"];
    }
    public function GetRecords($DomainName, $page = 1)
    {
        $r = $this->get("domainlogincp", ["data" => ["d_name" => $DomainName]]);
        if ($r["status"] == 0) {
            return $r;
        }
        return ["status" => 0, "info" => "<h3 style='text-align: center;margin: 10px;'><a href=\"" . $r["info"]["returninfo"] . "\" target='_blank'>请点此登录官方面板进行解析操作</a></h3>"];
    }
    public function DescribeDomainRecords($query)
    {
        $r = $this->GetRecords($query["DomainName"]);
        if ($r["status"] != 1) {
            return $r;
        }
        $totalpages = $r["info"]["totalpages"];
        $Records = $r["info"];
        if (1 < $totalpages) {
            for ($i = 2; $i <= $totalpages; $i++) {
                $rr = $this->GetRecords($query["DomainName"], $i);
                if ($rr["status"] == 1) {
                    $Records = array_merge($Records, $rr["info"]);
                }
            }
        }
        return ["status" => 1, "info" => ["DomainRecords" => ["Record" => $Records]]];
    }
    public function AddDomainRecord($query)
    {
        $r = $this->get("DomainDNSAdd", ["data" => ["name" => $query["DomainName"], "recordname" => empty($query["RR"]) ? $query["DomainName"] : $query["RR"] . "." . $query["DomainName"], "type" => $query["Type"], "content" => $query["Value"], "ttl" => 900, "prio" => 0], "checksum" => ["name"]]);
        if ($r["status"] != 1) {
            if (strstr($r["info"], "实名")) {
                return ["status" => 0, "info" => "当前域名通过实名认证，请通过官方面板提交实名信息"];
            }
            return $r;
        }
        return ["status" => 1, "info" => ["RecordId" => base64_encode($query["Type"] . "#" . $query["RR"])]];
    }
    public function UpdateDomainRecord($query)
    {
        return ["status" => 0, "info" => "请删除后重新添加"];
    }
    public function SetDomainRecordStatus($query)
    {
        return ["status" => 0, "info" => "不支持"];
    }
    public function DeleteDomainRecord($query)
    {
        $id = explode("#", base64_decode($query["RecordId"]));
        $r = $this->get("DomainDNSDel", ["data" => ["name" => $query["DomainName"], "recordname" => empty($id[1]) ? $query["DomainName"] : $id[1] . "." . $query["DomainName"], "type" => $id[0]], "checksum" => ["name"]]);
        if ($r["status"] != 1) {
            return $r;
        }
        return ["status" => 1, "info" => "删除成功"];
    }
    public function DescribeDomainNs($query)
    {
        return ["status" => 1, "info" => ["ExpectDnsServers" => ["ExpectDnsServer" => ["", ""]]]];
    }
    public function AddDomain($query)
    {
        return ["status" => 0, "info" => "新网解析只允许西部数码的域名，请联系客服处理"];
    }
}

?>