<?php
namespace addons\coupon_yby;

class CouponYbyPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "CouponYby", "title" => "领券中心", "description" => "领券中心可发布优惠券活动，由用户自行领取，可设置使用条件，限新人领取条件，限用户组领取，限指定用户领取，内部发放，公域领取，注册领取，开通指定产品返利返现", "status" => 1, "author" => "<a href=\"http://www.yunbuyun.com\">云步云计算</a>", "version" => "1.1.6", "module" => "addons", "lang" => ["chinese" => "领券中心", "chinese_tw" => "领券中心", "english" => "Coupon Promotion"]];
    public function install()
    {
        $fieldsToAddTable1 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "open_is", "type" => "TINYINT NOT NULL"], ["name" => "weburl", "type" => "VARCHAR(255)"], ["name" => "gifts", "type" => "TINYINT NOT NULL"], ["name" => "register", "type" => "TINYINT NOT NULL"], ["name" => "fanli", "type" => "TINYINT NOT NULL"], ["name" => "activityid", "type" => "INT"], ["name" => "zzqq", "type" => "VARCHAR(255)"], ["name" => "mfauth", "type" => "VARCHAR(255)"], ["name" => "zzemail", "type" => "VARCHAR(255)"], ["name" => "smtp_host", "type" => "VARCHAR(255)"], ["name" => "smtp_name", "type" => "VARCHAR(255)"], ["name" => "smtp_pass", "type" => "VARCHAR(255)"], ["name" => "smtp_port", "type" => "INT"], ["name" => "smtp_secure", "type" => "VARCHAR(255)"], ["name" => "from_name", "type" => "TEXT"], ["name" => "smtp_is", "type" => "TINYINT NOT NULL"], ["name" => "emailsubject", "type" => "TEXT"], ["name" => "email_content", "type" => "TEXT"], ["name" => "smtp_is2", "type" => "TINYINT NOT NULL"], ["name" => "emailsubject2", "type" => "TEXT"], ["name" => "email_content2", "type" => "TEXT"], ["name" => "smtp_is3", "type" => "TINYINT NOT NULL"], ["name" => "emailsubject3", "type" => "TEXT"], ["name" => "email_content3", "type" => "TEXT"], ["name" => "smtp_is4", "type" => "TINYINT NOT NULL"], ["name" => "emailsubject4", "type" => "TEXT"], ["name" => "email_content4", "type" => "TEXT"]];
        $fieldsToAddTable2 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "activityname", "type" => "VARCHAR(255)"], ["name" => "total_quantity", "type" => "INT"], ["name" => "claim_count", "type" => "INT", "default" => 0], ["name" => "max_usage_per_user", "type" => "INT"], ["name" => "start_time", "type" => "INT"], ["name" => "end_time", "type" => "INT"], ["name" => "validity", "type" => "INT"], ["name" => "certification", "type" => "INT"], ["name" => "Distribution", "type" => "INT"], ["name" => "client_group_id", "type" => "VARCHAR(50)"], ["name" => "clientid", "type" => "VARCHAR(50)"], ["name" => "cycle", "type" => "VARCHAR(50)"], ["name" => "amount", "type" => "VARCHAR(50)"], ["name" => "applicable_products", "type" => "TEXT"], ["name" => "ding_products", "type" => "TEXT"], ["name" => "discount_type", "type" => "ENUM('percent', 'fixed')"], ["name" => "face_value", "type" => "DECIMAL(10, 2)"], ["name" => "settlementCycle", "type" => "VARCHAR(50)"], ["name" => "is_recurring", "type" => "TINYINT(1)"], ["name" => "is_available_for_agents", "type" => "TINYINT(1)"], ["name" => "max_usage_per_code", "type" => "INT"], ["name" => "is_one_time_valid", "type" => "TINYINT(1)"], ["name" => "is_for_new_users", "type" => "TINYINT(1)"], ["name" => "is_for_existing_users", "type" => "TINYINT(1)"], ["name" => "is_single_use_per_user", "type" => "TINYINT(1)"], ["name" => "is_for_upgrade_downgrade", "type" => "TINYINT(1)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable3 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "activityname", "type" => "VARCHAR(255)"], ["name" => "total_quantity", "type" => "INT"], ["name" => "claim_count", "type" => "INT DEFAULT 0"], ["name" => "max_usage_per_user", "type" => "INT"], ["name" => "start_time", "type" => "INT"], ["name" => "end_time", "type" => "INT"], ["name" => "validity", "type" => "INT"], ["name" => "certification", "type" => "INT"], ["name" => "Distribution", "type" => "INT"], ["name" => "mode", "type" => "INT"], ["name" => "client_group_id", "type" => "VARCHAR(50)"], ["name" => "clientid", "type" => "VARCHAR(50)"], ["name" => "fan_products", "type" => "TEXT"], ["name" => "applicable_products", "type" => "TEXT"], ["name" => "discount_type", "type" => "ENUM('percent', 'fixed')"], ["name" => "face_value", "type" => "DECIMAL(10, 2)"], ["name" => "settlementCycle", "type" => "VARCHAR(50)"], ["name" => "is_recurring", "type" => "TINYINT(1)"], ["name" => "is_available_for_agents", "type" => "TINYINT(1)"], ["name" => "max_usage_per_code", "type" => "INT"], ["name" => "is_one_time_valid", "type" => "TINYINT(1)"], ["name" => "is_for_new_users", "type" => "TINYINT(1)"], ["name" => "is_for_existing_users", "type" => "TINYINT(1)"], ["name" => "is_single_use_per_user", "type" => "TINYINT(1)"], ["name" => "is_for_upgrade_downgrade", "type" => "TINYINT(1)"], ["name" => "created_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP"], ["name" => "updated_at", "type" => "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP"]];
        $fieldsToAddTable4 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "INT"], ["name" => "activity_id", "type" => "INT"], ["name" => "received_at", "type" => "INT"], ["name" => "coupon_code", "type" => "VARCHAR(255)"], ["name" => "activityname", "type" => "VARCHAR(255)"], ["name" => "total_quantity", "type" => "INT"], ["name" => "max_usage_per_user", "type" => "INT"], ["name" => "start_time", "type" => "INT"], ["name" => "end_time", "type" => "INT"], ["name" => "validity", "type" => "INT"], ["name" => "applicable_products", "type" => "TEXT"], ["name" => "discount_type", "type" => "ENUM('percent', 'fixed', 'fanpercent', 'fanfixed')"], ["name" => "face_value", "type" => "DECIMAL(10, 2)"], ["name" => "settlementCycle", "type" => "VARCHAR(50)"], ["name" => "is_recurring", "type" => "TINYINT(1)"], ["name" => "is_available_for_agents", "type" => "TINYINT(1)"], ["name" => "max_usage_per_code", "type" => "INT"], ["name" => "is_one_time_valid", "type" => "TINYINT(1)"], ["name" => "is_for_new_users", "type" => "TINYINT(1)"], ["name" => "is_for_existing_users", "type" => "TINYINT(1)"], ["name" => "is_single_use_per_user", "type" => "TINYINT(1)"], ["name" => "is_for_upgrade_downgrade", "type" => "TINYINT(1)"], ["name" => "registration", "type" => "INT"], ["name" => "hostid", "type" => "INT"], ["name" => "source", "type" => "VARCHAR(255)"]];
        $fieldsToAddTable5 = [["name" => "id", "type" => "INT AUTO_INCREMENT PRIMARY KEY"], ["name" => "user_id", "type" => "VARCHAR(50)"], ["name" => "activity_id", "type" => "VARCHAR(50)"], ["name" => "activityname", "type" => "VARCHAR(50)"], ["name" => "product", "type" => "INT"], ["name" => "name", "type" => "INT"], ["name" => "back_time", "type" => "INT"], ["name" => "regdate", "type" => "INT"], ["name" => "start_time", "type" => "INT"], ["name" => "end_time", "type" => "INT"], ["name" => "discount_type", "type" => "VARCHAR(255)"], ["name" => "face_value", "type" => "DECIMAL(10, 2)"], ["name" => "hostid", "type" => "INT"], ["name" => "source", "type" => "VARCHAR(255)"]];
        $tableName1 = "shd_coupon_configurations";
        $tableExists1 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName1 . "'");
        if (empty($tableExists1)) {
            $sql1 = "\n            CREATE TABLE " . $tableName1 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable1)) . "\n            );\n        ";
            \Think\Db::execute($sql1);
        } else {
            foreach ($fieldsToAddTable1 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName1 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql1 = "\n                    ALTER TABLE " . $tableName1 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql1);
                }
            }
        }
        $tableName2 = "shd_coupon_yby_list";
        $tableExists2 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName2 . "'");
        if (empty($tableExists2)) {
            $sql2 = "\n            CREATE TABLE " . $tableName2 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable2)) . "\n            );\n        ";
            \Think\Db::execute($sql2);
        } else {
            foreach ($fieldsToAddTable2 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName2 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql2 = "\n                    ALTER TABLE " . $tableName2 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql2);
                }
            }
        }
        $tableName3 = "shd_coupon_yby_fanlilist";
        $tableExists3 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName3 . "'");
        if (empty($tableExists3)) {
            $sql3 = "\n            CREATE TABLE " . $tableName3 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable3)) . "\n            );\n        ";
            \Think\Db::execute($sql3);
        } else {
            foreach ($fieldsToAddTable3 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName3 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql3 = "\n                    ALTER TABLE " . $tableName3 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql3);
                }
            }
        }
        $tableName4 = "shd_coupon_yby_receive";
        $tableExists4 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName4 . "'");
        if (empty($tableExists4)) {
            $sql4 = "\n            CREATE TABLE " . $tableName4 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable4)) . "\n            );\n        ";
            \Think\Db::execute($sql4);
        } else {
            foreach ($fieldsToAddTable4 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName4 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql4 = "\n                    ALTER TABLE " . $tableName4 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql4);
                }
            }
        }
        $tableName5 = "shd_coupon_yby_cashback";
        $tableExists5 = \Think\Db::query("SHOW TABLES LIKE '" . $tableName5 . "'");
        if (empty($tableExists5)) {
            $sql5 = "\n            CREATE TABLE " . $tableName5 . " (\n                " . implode(",\n", array_map(function ($fieldInfo) {
                return $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "'";
            }, $fieldsToAddTable5)) . "\n            );\n        ";
            \Think\Db::execute($sql5);
        } else {
            foreach ($fieldsToAddTable5 as $fieldInfo) {
                $fieldName = $fieldInfo["name"];
                $fieldExists = \Think\Db::query("SHOW COLUMNS FROM " . $tableName5 . " LIKE '" . $fieldName . "'");
                if (empty($fieldExists)) {
                    $sql5 = "\n                    ALTER TABLE " . $tableName5 . "\n                    ADD COLUMN " . $fieldInfo["name"] . " " . $fieldInfo["type"] . " COMMENT '" . $fieldInfo["comment"] . "';\n                ";
                    \Think\Db::execute($sql5);
                }
            }
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function clientAdd($params)
    {
        if (request()->isPost()) {
            $data = \Think\Db::name("coupon_configurations")->where("id", 1)->field("open_is, gifts, activityid")->find();
            if ($data) {
                $open_is = $data["open_is"];
                $gifts = $data["gifts"];
                $id = $data["activityid"];
                if ($open_is != 1) {
                    return json(["code" => 400, "msg" => "活动未开启"]);
                }
                if ($gifts != 1) {
                    return json(["code" => 400, "msg" => "未开启注册自动赠送"]);
                }
                $activity = \Think\Db::name("coupon_yby_list")->where("id", $id)->find();
                if (!$activity) {
                    return json(["code" => 404, "msg" => "活动不存在"]);
                }
                $endTime = $activity["end_time"];
                $currentTime = time();
                $timeDifference = $endTime - $currentTime;
                if ($endTime <= $currentTime) {
                    return json(["code" => 400, "msg" => "当前活动已过期"]);
                }
                if ($timeDifference <= 3600) {
                    return json(["code" => 400, "msg" => "该活动距离过期不足1小时，禁止继续发放该活动"]);
                }
                if ($activity["total_quantity"] <= $activity["claim_count"]) {
                    return json(["code" => 400, "msg" => "发放的数量已达本次活动发行数量设置上限"]);
                }
                $user_id = \Think\Db::name("clients")->order("id", "desc")->value("id");
                $receptionSuccess = true;
                if ($receptionSuccess) {
                    $couponCode = $this->generateRandomCouponCode1();
                    $count = \Think\Db::name("coupon_yby_list")->where("id", $id)->value("claim_count");
                    if ($count === NULL) {
                        \Think\Db::name("coupon_yby_list")->where("id", $id)->update(["claim_count" => 1]);
                    } else {
                        \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                    }
                    $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => $activity["validity"], "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "source" => "系统发放"]);
                    if ($result) {
                        $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：管理员在后台添加客户，用户ID：" . $user_id . "，活动名称：" . $activity["activityname"] . " (活动ID：" . $id . ")，发放时间：" . date("Y-m-d H:i:s", time()) . ",已开启注册赠送功能，系统发放", "is_discount" => $activity["is_available_for_agents"]];
                        \Think\Db::name("promo_code")->insert($bTableData);
                        if ($result) {
                            return json(["code" => 200, "msg" => "优惠码发送成功"]);
                        }
                        return json(["code" => 500, "msg" => "发送失败"]);
                    }
                }
            } else {
                return json(["code" => 400, "msg" => "未找到配置记录"]);
            }
        }
    }
    public function afterCron()
    {
        $data = \Think\Db::name("coupon_configurations")->where("id", 1)->field("open_is, gifts, activityid")->find();
        if ($data) {
            $open_is = $data["open_is"];
            $gifts = $data["gifts"];
            $id = $data["activityid"];
            if ($open_is != 1) {
                return json(["code" => 400, "msg" => "活动未开启"]);
            }
            if ($gifts != 1) {
                return json(["code" => 400, "msg" => "未开启注册自动赠送"]);
            }
            $activity = \Think\Db::name("coupon_yby_list")->where("id", $id)->find();
            if (!$activity) {
                return json(["code" => 404, "msg" => "活动不存在"]);
            }
            $endTime = $activity["end_time"];
            $currentTime = time();
            $timeDifference = $endTime - $currentTime;
            if ($endTime <= $currentTime) {
                return json(["code" => 400, "msg" => "当前活动已过期"]);
            }
            if ($timeDifference <= 3600) {
                return json(["code" => 400, "msg" => "该活动距离过期不足1小时，禁止继续发放该活动"]);
            }
            if ($activity["total_quantity"] <= $activity["claim_count"]) {
                return json(["code" => 400, "msg" => "发放的数量已达本次活动发行数量设置上限"]);
            }
            $currentTime = time();
            $todayStartTime = strtotime(date("Y-m-d 00:00:00"));
            $idsToday = \Think\Db::name("clients")->where("create_time", ">=", $todayStartTime)->where("create_time", "<=", $currentTime)->column("id");
            $thirtyMinutesAgo = $currentTime - 1800;
            $idsThirtyMinutes = \Think\Db::name("clients")->where("create_time", ">=", $thirtyMinutesAgo)->where("create_time", "<=", $currentTime)->column("id");
            $ids = array_unique(array_merge($idsToday, $idsThirtyMinutes));
            $f = date("Y-m-d H:i:s", $currentTime);
            $g = date("Y-m-d H:i:s", $todayStartTime);
            foreach ($ids as $user_id) {
                $exist = \Think\Db::name("coupon_yby_receive")->where("registration", $user_id)->find();
                if (!$exist) {
                    $receptionSuccess = true;
                    if ($receptionSuccess) {
                        $couponCode = $this->generateRandomCouponCode1();
                        $count = \Think\Db::name("coupon_yby_list")->where("id", $id)->value("claim_count");
                        if ($count === NULL) {
                            \Think\Db::name("coupon_yby_list")->where("id", $id)->update(["claim_count" => 1]);
                        } else {
                            \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                        }
                        $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => time() + $activity["validity"] * 3600, "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "registration" => $user_id, "source" => "注册赠送"]);
                        if ($result) {
                            $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：前端注册赠送，用户ID：" . $user_id . "，活动名称：" . $activity["activityname"] . " (活动ID：" . $id . ")，领取时间：" . date("Y-m-d H:i:s", time()), "is_discount" => $activity["is_available_for_agents"]];
                        }
                        if ($result) {
                            \Think\Db::name("promo_code")->insert($bTableData);
                            $recentlyInsertedUserId = \Think\Db::name("coupon_yby_receive")->order("id", "desc")->value("user_id");
                            $recipientQuery = \Think\Db::name("clients")->where("id", $recentlyInsertedUserId)->value("email");
                            $emailsConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
                            if (!$emailsConfig) {
                                return false;
                            }
                            $code = $couponCode;
                            $type = $activity["discount_type"] === "percent" ? "折扣" : ($activity["discount_type"] === "fixed" ? "立减" : "未知类型");
                            $discount = $activity["discount_type"];
                            $value = $discount === "percent" ? 100 - $activity["face_value"] . "%" : ($discount === "fixed" ? $activity["face_value"] . "元" : "未知值");
                            $cyclesMapping = ["day" => "日付", "monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付"];
                            $cycles = isset($cyclesMapping[$activity["settlementCycle"]]) ? $cyclesMapping[$activity["settlementCycle"]] : "不限";
                            $products = $activity["applicable_products"];
                            if (!empty($products)) {
                                $productIDs = explode(",", $products);
                                $productNames = [];
                                foreach ($productIDs as $productID) {
                                    $productName = \Think\Db::name("products")->where("id", $productID)->value("name");
                                    if ($productName) {
                                        $productNames[] = $productName;
                                    }
                                }
                                $products = implode(", ", $productNames);
                            } else {
                                $products = "所有产品可用";
                            }
                            $start_time = date("Y-m-d H:i:s", $activity["start_time"]);
                            $end_time = date("Y-m-d H:i:s", $activity["end_time"]);
                            $time = date("Y-m-d H:i:s", time());
                            $validity = date("Y-m-d H:i:s", time() + $activity["validity"] * 3600);
                            $notes = "注册赠送";
                            $activityname = $activity["activityname"];
                            $clientInfo = \Think\Db::name("clients")->where("id", $user_id)->field("email, username")->find();
                            $recipientEmail = $clientInfo["email"];
                            $email = $clientInfo["email"];
                            $name = $clientInfo["username"];
                            $emailSubject = $emailsConfig["emailsubject3"];
                            $emailSubject = str_replace("\$start_time", $start_time, $emailSubject);
                            $emailSubject = str_replace("\$end_time", $end_time, $emailSubject);
                            $emailSubject = str_replace("\$products", $products, $emailSubject);
                            $emailSubject = str_replace("\$type", $type, $emailSubject);
                            $emailSubject = str_replace("\$validity", $validity, $emailSubject);
                            $emailSubject = str_replace("\$value", $value, $emailSubject);
                            $emailSubject = str_replace("\$code", $code, $emailSubject);
                            $emailSubject = str_replace("\$activityname", $activityname, $emailSubject);
                            $emailMessage = $emailsConfig["email_content3"];
                            $emailMessage = html_entity_decode($emailMessage);
                            $emailMessage = str_replace("\$email", $email, $emailMessage);
                            $emailMessage = str_replace("\$name", $name, $emailMessage);
                            $emailMessage = str_replace("\$code", $code, $emailMessage);
                            $emailMessage = str_replace("\$products", $products, $emailMessage);
                            $emailMessage = str_replace("\$type", $type, $emailMessage);
                            $emailMessage = str_replace("\$value", $value, $emailMessage);
                            $emailMessage = str_replace("\$cycles", $cycles, $emailMessage);
                            $emailMessage = str_replace("\$start_time", $start_time, $emailMessage);
                            $emailMessage = str_replace("\$end_time", $end_time, $emailMessage);
                            $emailMessage = str_replace("\$time", $time, $emailMessage);
                            $emailMessage = str_replace("\$validity", $validity, $emailMessage);
                            $emailMessage = str_replace("\$notes", $notes, $emailMessage);
                            $emailMessage = str_replace("\$activityname", $activityname, $emailMessage);
                            $client_ip = $_SERVER["REMOTE_ADDR"];
                            $client_port = $_SERVER["REMOTE_PORT"];
                            $url1 = $_SERVER["REQUEST_URI"];
                            $domain = dirname($url1);
                            $url = $_SERVER["REQUEST_URI"];
                            $directoryToRemove = "/provision";
                            $cleanedUrl = preg_replace("~" . $directoryToRemove . "/.*~", "", $url);
                            $activity_log = ["uid" => $user_id, "description" => "新用户注册赠送，<a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a> 活动：" . $activity["activityname"] . "【ID:" . $id . "】，券码：" . $couponCode, "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($activity_log);
                            if ($emailsConfig && $emailsConfig["smtp_is3"] == 1) {
                                $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
                                try {
                                    $mail->isSMTP();
                                    $mail->isHTML(true);
                                    $mail->CharSet = "UTF-8";
                                    $mail->Host = $emailsConfig["smtp_host"];
                                    $mail->SMTPAuth = true;
                                    $mail->Username = $emailsConfig["smtp_name"];
                                    $mail->Password = $emailsConfig["smtp_pass"];
                                    $mail->SMTPSecure = $emailsConfig["smtp_secure"];
                                    $mail->Port = $emailsConfig["smtp_port"];
                                    $mail->setFrom($emailsConfig["smtp_name"], $emailsConfig["from_name"]);
                                    $mail->Subject = $emailSubject;
                                    if ($recipientQuery) {
                                        $to = $recipientQuery;
                                        $message = $emailMessage;
                                        $mail->addAddress($to);
                                        $mail->Body = $message;
                                        $mail->send();
                                        echo "邮件发送成功给用户ID " . $recentlyInsertedUserId . "<br>";
                                        $sentStatus = 1;
                                        $failReason = "发送成功";
                                        $mail->clearAddresses();
                                    } else {
                                        echo "未找到用户的邮箱地址，不发送邮件<br>";
                                    }
                                } catch (\PHPMailer\PHPMailer\Exception $e) {
                                    echo "邮件发送失败: " . $mail->ErrorInfo;
                                    $sentStatus = 0;
                                    $failReason = $e->getMessage();
                                }
                                $logData1 = ["uid" => $user_id, "subject" => $emailSubject, "message" => $emailMessage, "to" => $to, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => 0, "status" => $sentStatus, "fail_reason" => $failReason];
                                \Think\Db::name("email_log")->insert($logData1);
                            }
                        }
                    }
                }
            }
        } else {
            return json(["code" => 400, "msg" => "未找到配置记录"]);
        }
    }
    public function afterModuleCreate($param)
    {
        foreach ($param as $Create) {
            $productid = $Create["productid"];
            $names = $Create["name"];
            $uid = $Create["uid"];
            $regdate = $Create["regdate"];
            $hostid = $Create["hostid"];
            $domainstatus = $Create["domainstatus"];
            $data = \Think\Db::name("coupon_configurations")->where("id", 1)->field("open_is, fanli, activityid")->find();
            if ($data) {
                $open_is = $data["open_is"];
                $fanli = $data["fanli"];
                if ($open_is != 1) {
                    return json(["code" => 400, "msg" => "活动未开启"]);
                }
                if ($fanli != 1) {
                    return json(["code" => 400, "msg" => "未开启返利活动"]);
                }
                $activity = \Think\Db::name("coupon_yby_fanlilist")->whereRaw("FIND_IN_SET(?, fan_products)", [$productid])->order("id desc")->find();
                $id = $activity["id"];
                $user_id = $uid;
                if (!$activity) {
                    return json(["code" => 404, "msg" => "活动不存在"]);
                }
                $endTime = $activity["end_time"];
                $currentTime = time();
                $timeDifference = $endTime - $currentTime;
                if ($endTime <= $currentTime) {
                    return json(["code" => 400, "msg" => "当前活动已过期"]);
                }
                if ($timeDifference <= 3600) {
                    return json(["code" => 400, "msg" => "该活动距离过期不足1小时，禁止继续发放该活动"]);
                }
                if ($activity["total_quantity"] <= $activity["claim_count"]) {
                    return json(["code" => 400, "msg" => "发放的数量已达本次活动发行数量设置上限"]);
                }
                $fouser = $activity["is_available_for_agents"];
                if ($fouser != 1) {
                    if ($fouser == 0) {
                        $isyes = \Think\Db::name("clients")->where("id", $user_id)->find();
                        $group_id = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
                        if ($group_id != 0) {
                            return json(["code" => 400, "msg" => "禁止发放代理商"]);
                        }
                    }
                }
                $userClaims = \Think\Db::name("coupon_yby_receive")->where("user_id", $user_id)->where("activity_id", $id)->count();
                if ($activity["max_usage_per_user"] <= $userClaims) {
                    return json(["code" => 400, "msg" => "当前活动每人限领【" . $activity["max_usage_per_user"] . "】张，您领取到达上限，请选择其他活动！"]);
                }
                $existreceive = \Think\Db::name("coupon_yby_receive")->where("hostid", $hostid)->find();
                $existcashback = \Think\Db::name("coupon_yby_cashback")->where("hostid", $hostid)->find();
                if (!$existreceive && !$existcashback) {
                    $receptionSuccess = $activity["mode"];
                    if ($receptionSuccess == 1) {
                        $couponCode = $this->generateRandomCouponCode1();
                        $count = \Think\Db::name("coupon_yby_fanlilist")->where("id", $id)->value("claim_count");
                        if ($count === NULL) {
                            \Think\Db::name("coupon_yby_fanlilist")->where("id", $id)->update(["claim_count" => 1]);
                        } else {
                            \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                        }
                        $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => time() + $activity["validity"] * 3600, "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "hostid" => $hostid, "source" => "返利赠送"]);
                        if ($result) {
                            $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：用户编号：【 " . $uid . " 】在【 " . date("Y-m-d H:i:s", $regdate) . " 】开通产品【" . $names . " (产品ID:" . $productid . ")-主机ID: " . $hostid . " 】赠送，赠送时间【" . date("Y-m-d H:i:s", time()) . "】", "is_discount" => $activity["is_available_for_agents"]];
                            \Think\Db::name("promo_code")->insert($bTableData);
                            if ($result) {
                                $emailsConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
                                if (!$emailsConfig) {
                                    return false;
                                }
                                $code = $couponCode;
                                $type = $activity["discount_type"] === "percent" ? "折扣" : ($activity["discount_type"] === "fixed" ? "立减" : "未知类型");
                                $discount = $activity["discount_type"];
                                $value = $discount === "percent" ? 100 - $activity["face_value"] . "%" : ($discount === "fixed" ? $activity["face_value"] . "元" : "未知值");
                                $cyclesMapping = ["day" => "日付", "monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付"];
                                $cycles = isset($cyclesMapping[$activity["settlementCycle"]]) ? $cyclesMapping[$activity["settlementCycle"]] : "不限";
                                $products = $activity["applicable_products"];
                                if (!empty($products)) {
                                    $productIDs = explode(",", $products);
                                    $productNames = [];
                                    foreach ($productIDs as $productID) {
                                        $productName = \Think\Db::name("products")->where("id", $productID)->value("name");
                                        if ($productName) {
                                            $productNames[] = $productName;
                                        }
                                    }
                                    $products = implode(", ", $productNames);
                                } else {
                                    $products = "所有产品可用";
                                }
                                $start_time = date("Y-m-d H:i:s", $activity["start_time"]);
                                $end_time = date("Y-m-d H:i:s", $activity["end_time"]);
                                $time = date("Y-m-d H:i:s", time());
                                $validity = date("Y-m-d H:i:s", time() + $activity["validity"] * 3600);
                                $notes = "开通 " . $names . " 产品赠送";
                                $activityname = $activity["activityname"];
                                $product = $names;
                                $clientInfo = \Think\Db::name("clients")->where("id", $user_id)->field("email, username")->find();
                                $recipientEmail = $clientInfo["email"];
                                $email = $clientInfo["email"];
                                $name = $clientInfo["username"];
                                $emailSubject = $emailsConfig["emailsubject4"];
                                $emailSubject = str_replace("\$start_time", $start_time, $emailSubject);
                                $emailSubject = str_replace("\$end_time", $end_time, $emailSubject);
                                $emailSubject = str_replace("\$products", $products, $emailSubject);
                                $emailSubject = str_replace("\$type", $type, $emailSubject);
                                $emailSubject = str_replace("\$validity", $validity, $emailSubject);
                                $emailSubject = str_replace("\$value", $value, $emailSubject);
                                $emailSubject = str_replace("\$product", $product, $emailSubject);
                                $emailSubject = str_replace("\$activityname", $activityname, $emailSubject);
                                $emailSubject = str_replace("\$code", $code, $emailSubject);
                                $emailMessage = $emailsConfig["email_content4"];
                                $emailMessage = html_entity_decode($emailMessage);
                                $emailMessage = str_replace("\$email", $email, $emailMessage);
                                $emailMessage = str_replace("\$name", $name, $emailMessage);
                                $emailMessage = str_replace("\$code", $code, $emailMessage);
                                $emailMessage = str_replace("\$products", $products, $emailMessage);
                                $emailMessage = str_replace("\$type", $type, $emailMessage);
                                $emailMessage = str_replace("\$value", $value, $emailMessage);
                                $emailMessage = str_replace("\$cycles", $cycles, $emailMessage);
                                $emailMessage = str_replace("\$start_time", $start_time, $emailMessage);
                                $emailMessage = str_replace("\$end_time", $end_time, $emailMessage);
                                $emailMessage = str_replace("\$time", $time, $emailMessage);
                                $emailMessage = str_replace("\$validity", $validity, $emailMessage);
                                $emailMessage = str_replace("\$product", $product, $emailMessage);
                                $emailMessage = str_replace("\$activityname", $activityname, $emailMessage);
                                $emailMessage = str_replace("\$notes", $notes, $emailMessage);
                                $emailSent = $this->sendEmails($recipientEmail, $emailSubject, $emailMessage);
                                $client_ip = $_SERVER["REMOTE_ADDR"];
                                $client_port = $_SERVER["REMOTE_PORT"];
                                $url1 = $_SERVER["REQUEST_URI"];
                                $domain = dirname($url1);
                                $url = $_SERVER["REQUEST_URI"];
                                $directoryToRemove = "/provision";
                                $cleanedUrl = preg_replace("~" . $directoryToRemove . "/.*~", "", $url);
                                $activity_log = ["uid" => $user_id, "description" => "返券模式，开通 " . $names . " (产品ID:" . $productid . " )-<a href=\"#/customer-view/product-innerpage?hid=" . $hostid . "&id=" . $user_id . "\">Host ID:" . $hostid . " </a> 产品赠送，<a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a> 返利模式活动：" . $activity["activityname"] . "【ID:" . $id . "】，<a href=\"" . $cleanedUrl . "/addons?_plugin=coupon_yby&_controller=admin_index&_action=claimlist\">查看领取列表</a>，券码：" . $couponCode, "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                                \Think\Db::name("activity_log")->insert($activity_log);
                                if (!$emailsConfig || $emailsConfig["smtp_is4"] != 1) {
                                    if ($emailSent) {
                                        return true;
                                    }
                                    return false;
                                }
                                $sentStatus = $emailSent ? 1 : 0;
                                $failReason = $sentStatus ? "发送成功" : "发送失败-SMTP信息错误";
                                $logData = ["uid" => $user_id, "subject" => $emailSubject, "message" => $emailMessage, "to" => $recipientEmail, "create_time" => time(), "is_admin" => 0, "ip" => "0.0.0.0", "port" => 0, "status" => $sentStatus, "fail_reason" => $failReason];
                                \Think\Db::name("email_log")->insert($logData);
                                if ($emailSent) {
                                    return true;
                                }
                                return false;
                            } else {
                                return false;
                            }
                        }
                    } else {
                        if ($receptionSuccess == 2) {
                            $clients = \Think\Db::name("clients")->where("id", $user_id)->find();
                            $host = \Think\Db::name("host")->where("id", $hostid)->find();
                            $firstpaymentamount = $host["firstpaymentamount"];
                            if ($activity["discount_type"] === "percent") {
                                $percentage_discount = $activity["face_value"];
                                $withdrawalamount = $firstpaymentamount * $percentage_discount / 100;
                                $amount = round($withdrawalamount, 2);
                                $fanlei = "fanpercent";
                                $fan_type = "比例" . $activity["face_value"] . "%";
                            } else {
                                if ($activity["discount_type"] === "fixed") {
                                    $fixed_discount = $activity["face_value"];
                                    $amount = $fixed_discount;
                                    $fanlei = "fanfixed";
                                    $fan_type = "固定金额";
                                }
                            }
                            $newcredit = $clients["credit"] + $amount;
                            \Think\Db::name("clients")->where("id", $user_id)->update(["credit" => $newcredit]);
                            $count = \Think\Db::name("coupon_yby_fanlilist")->where("id", $id)->value("claim_count");
                            if ($count === NULL) {
                                \Think\Db::name("coupon_yby_list")->where("id", $id)->update(["claim_count" => 1]);
                            } else {
                                \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                            }
                            $result = \Think\Db::name("coupon_yby_cashback")->insert(["user_id" => $user_id, "activity_id" => $id, "back_time" => time(), "product" => $productid, "name" => $names, "regdate" => $regdate, "activityname" => $activity["activityname"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "discount_type" => $fanlei, "face_value" => $amount, "hostid" => $hostid, "source" => "产品返现"]);
                            $datacredit = ["uid" => $user_id, "create_time" => time(), "description" => "开通产品：" . $names . "(主机ID：" . $hostid . ")返现", "amount" => $amount, "notes" => "主机ID：" . $hostid . "，首付金额：" . $firstpaymentamount . "元，按" . $fan_type . "返现" . $amount . "元", "balance" => $newcredit];
                            \Think\Db::name("credit")->insert($datacredit);
                            $client_ip = $_SERVER["REMOTE_ADDR"];
                            $client_port = $_SERVER["REMOTE_PORT"];
                            $url1 = $_SERVER["REQUEST_URI"];
                            $domain = dirname($url1);
                            $url = $_SERVER["REQUEST_URI"];
                            $directoryToRemove = "/provision";
                            $cleanedUrl = preg_replace("~" . $directoryToRemove . "/.*~", "", $url);
                            $activity_log = ["uid" => $user_id, "description" => "返现模式，开通【" . $names . " (产品ID:" . $productid . " )】- <a href=\"#/customer-view/product-innerpage?hid=" . $hostid . "&id=" . $user_id . "\">Host ID:" . $hostid . " </a>，<a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a> 返现活动：" . $activity["activityname"] . "【ID:" . $id . "】，<a href=\"" . $cleanedUrl . "/addons?_plugin=coupon_yby&_controller=admin_index&_action=claimlist\">查看领取列表</a>，首付金额：" . $firstpaymentamount . " 元，按" . $fan_type . " 返现" . $amount . " 元", "user" => "System", "port" => "", "create_time" => time(), "ipaddr" => "0.0.0.0", "type" => 0, "activeid" => 0, "usertype" => "System", "type_data_id" => ""];
                            \Think\Db::name("activity_log")->insert($activity_log);
                        } else {
                            $response = ["code" => 400, "msg" => "不支持的请求类型。"];
                        }
                    }
                }
            } else {
                return json(["code" => 400, "msg" => "未找到配置记录"]);
            }
        }
    }
    private function generateRandomCouponCode1($length = 12)
    {
        $characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $couponCode = "";
        for ($i = 0; $i < $length; $i++) {
            $couponCode .= $characters[random_int(0, strlen($characters) - 1)];
        }
        return $couponCode;
    }
    private function sendEmail($recipient, $subject, $message)
    {
        $emailConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
        if (!$emailConfig || $emailConfig["smtp_is3"] != 1) {
            return false;
        }
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->CharSet = "UTF-8";
            $mail->Host = $emailConfig["smtp_host"];
            $mail->SMTPAuth = true;
            $mail->Username = $emailConfig["smtp_name"];
            $mail->Password = $emailConfig["smtp_pass"];
            $mail->SMTPSecure = $emailConfig["smtp_secure"];
            $mail->Port = $emailConfig["smtp_port"];
            $mail->setFrom($emailConfig["smtp_name"], $emailConfig["from_name"]);
            $mail->addAddress($recipient);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->send();
            return true;
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            return false;
        }
    }
    private function sendEmails($recipient, $subject, $message)
    {
        $emailConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
        if (!$emailConfig || $emailConfig["smtp_is4"] != 1) {
            return false;
        }
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->CharSet = "UTF-8";
            $mail->Host = $emailConfig["smtp_host"];
            $mail->SMTPAuth = true;
            $mail->Username = $emailConfig["smtp_name"];
            $mail->Password = $emailConfig["smtp_pass"];
            $mail->SMTPSecure = $emailConfig["smtp_secure"];
            $mail->Port = $emailConfig["smtp_port"];
            $mail->setFrom($emailConfig["smtp_name"], $emailConfig["from_name"]);
            $mail->addAddress($recipient);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->send();
            return true;
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            return false;
        }
    }
}

?>