<?php
namespace addons\coupon_yby\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    public function submitActivitys()
    {
        $data = $this->request->post();
        $activityname = isset($data["activityname"]) ? $data["activityname"] : NULL;
        $totalQuantity = isset($data["total_quantity"]) ? $data["total_quantity"] : NULL;
        $maxUsagePerUser = isset($data["max_usage_per_user"]) ? $data["max_usage_per_user"] : NULL;
        $startTime = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $endTime = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $validity = isset($data["validity"]) ? $data["validity"] : NULL;
        $applicableProducts = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $dingProducts = isset($data["ding_product"]) ? $data["ding_product"] : NULL;
        $clientGroupIds = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $clientGroupIdsString = implode(",", $clientGroupIds);
        $client_group_id = trim($clientGroupIdsString);
        $cycle = isset($data["cycle"]) ? $data["cycle"] : NULL;
        $amount = isset($data["amount"]) ? $data["amount"] : NULL;
        $certification = isset($data["certification"]) ? $data["certification"] : [];
        $Distribution = isset($data["Distribution"]) ? $data["Distribution"] : [];
        $clientid = isset($data["clientid"]) ? $data["clientid"] : [];
        $discountType = isset($data["discount_type"]) ? $data["discount_type"] : NULL;
        $discountValue = isset($data["face_value"]) ? $data["face_value"] : NULL;
        $settlementCycle = isset($data["settlementCycle"]) ? $data["settlementCycle"] : NULL;
        $isRecurring = isset($data["is_recurring"]) ? $data["is_recurring"] : NULL;
        $isAgentAvailable = isset($data["is_agent_available"]) ? $data["is_agent_available"] : NULL;
        $maxUsagePerCode = isset($data["max_usage_per_code"]) ? $data["max_usage_per_code"] : NULL;
        $isOneTime = isset($data["is_one_time_valid"]) ? $data["is_one_time_valid"] : NULL;
        $isNewUserApplicable = isset($data["is_for_new_users"]) ? $data["is_for_new_users"] : NULL;
        $isExistingUserApplicable = isset($data["is_for_existing_users"]) ? $data["is_for_existing_users"] : NULL;
        $isSingleUsePerUser = isset($data["is_single_use_per_user"]) ? $data["is_single_use_per_user"] : NULL;
        $isUpgradeDowngradeApplicable = isset($data["is_upgrade_downgrade_applicable"]) ? $data["is_upgrade_downgrade_applicable"] : NULL;
        if (empty($data["activityname"])) {
            $response = ["code" => 400, "msg" => "活动名称是必填的，用户可见"];
            return json($response);
        }
        if (empty($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量是必填的。"];
            return json($response);
        }
        if (!isset($data["total_quantity"]) || !is_numeric($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["validity"])) {
            $response = ["code" => 400, "msg" => "请填写领取后有效期，单位为小时。"];
            return json($response);
        }
        if (!isset($data["validity"]) || !is_numeric($data["validity"])) {
            $response = ["code" => 400, "msg" => "领取后有效期字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领次数是必填的。"];
            return json($response);
        }
        if (!isset($data["max_usage_per_user"]) || !is_numeric($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领字段必须是有效的数值，您当前输入的为 【" . $data["max_usage_per_user"] . "】"];
            return json($response);
        }
        if (empty($data["start_time"])) {
            $response = ["code" => 400, "msg" => "活动开始时间是必填的。"];
            return json($response);
        }
        if (empty($data["end_time"])) {
            $response = ["code" => 400, "msg" => "活动结束时间是必填的。"];
            return json($response);
        }
        if (empty($data["face_value"])) {
            $response = ["code" => 400, "msg" => "面值是必填的，注意优惠类型的选择，以免造成损失。"];
            return json($response);
        }
        if (!isset($data["face_value"]) || !is_numeric($data["face_value"])) {
            $response = ["code" => 400, "msg" => "优惠面值字段必须是有效的数值，您当前输入的为 【" . $data["face_value"] . "】"];
            return json($response);
        }
        if (!empty($data["cycle"]) || !empty($data["amount"])) {
            if (empty($data["cycle"])) {
                $response = ["code" => 400, "msg" => "您输入消费金额，该条件需要同时输入消费周期，如不使用，消费金额留空。"];
                return json($response);
            }
            if (!is_int($data["cycle"]) && !ctype_digit((string) $data["cycle"])) {
                $response = ["code" => 400, "msg" => "消费周期必须为正整数。"];
                return json($response);
            }
            if (empty($data["amount"])) {
                $response = ["code" => 400, "msg" => "您输入消费周期，该条件需要同时输入消费金额，如不使用，消费周期留空。"];
                return json($response);
            }
            if (!is_numeric($data["amount"]) || !preg_match("/^\\d+(\\.\\d{1,2})?\$/", $data["amount"])) {
                $response = ["code" => 400, "msg" => "消费金额必须为数字，最多保留两位小数。"];
                return json($response);
            }
            if ($data["amount"] <= 0) {
                $response = ["code" => 400, "msg" => "消费金额必须为正值，最多保留两位小数。"];
                return json($response);
            }
        }
        if (!(count($clientGroupIds) == 1 && in_array("0", $clientGroupIds))) {
            if (in_array("0", $clientGroupIds)) {
                $response = ["code" => 400, "msg" => "不限制用户组不能同时与其他用户组存在"];
                return json($response);
            }
            if (!$isAgentAvailable) {
                $response = ["code" => 400, "msg" => "选择了【定向发放】客户组，请选择“代理商是否可用”为“是”，否则定向用户组将无法领取"];
                return json($response);
            }
        }
        $dbData = ["activityname" => $activityname, "total_quantity" => $totalQuantity, "max_usage_per_user" => $maxUsagePerUser, "start_time" => $startTime, "end_time" => $endTime, "validity" => $validity, "applicable_products" => $applicableProducts, "ding_products" => $dingProducts, "discount_type" => $discountType, "face_value" => $discountValue, "cycle" => $cycle, "amount" => $amount, "settlementCycle" => $settlementCycle, "is_recurring" => $isRecurring, "is_available_for_agents" => $isAgentAvailable, "max_usage_per_code" => 1, "is_one_time_valid" => $isOneTime, "is_for_new_users" => $isNewUserApplicable, "is_for_existing_users" => $isExistingUserApplicable, "is_single_use_per_user" => $isSingleUsePerUser, "is_for_upgrade_downgrade" => $isUpgradeDowngradeApplicable, "clientid" => $clientid, "client_group_id" => $client_group_id, "Distribution" => $Distribution, "certification" => $certification];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("coupon_yby_list")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "活动配置添加成功，请务必测试一遍，是否满足您设置的领券条件。"];
        } else {
            $response = ["code" => 400, "msg" => "活动配置添加失败。"];
        }
        return json($response);
    }
    public function adds()
    {
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $keproducts = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $resultWithNames = [];
        foreach ($keproducts as $record) {
            $productid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("keproducts", $resultWithNames);
        $this->assign("Title", "添加活动");
        return $this->fetch("/adds", ["clientGroups" => $clientGroups]);
    }
    public function listActivities()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $activities = \Think\Db::name("coupon_yby_list")->alias("a")->leftJoin("products p", "FIND_IN_SET(p.id, a.applicable_products)")->field("a.*, IFNULL(GROUP_CONCAT(p.name SEPARATOR '， '), '全场可用') as product_names")->group("a.id")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $this->assign("Title", "活动列表");
        return $this->fetch("/listActivities", ["List" => $activities]);
    }
    public function fanlist()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $activities = \Think\Db::name("coupon_yby_fanlilist")->alias("a")->leftJoin("products p1", "FIND_IN_SET(p1.id, a.applicable_products)")->leftJoin("products p2", "FIND_IN_SET(p2.id, a.fan_products)")->field("a.*, IFNULL(GROUP_CONCAT(DISTINCT p1.name SEPARATOR '， '), '全场可用') as product_names, IFNULL(GROUP_CONCAT(DISTINCT p2.name SEPARATOR '， '), '全场可用') as fan_product_names")->group("a.id")->order("id", "desc")->paginate($pageSize, false, ["page" => $page]);
        $this->assign("Title", "返利活动");
        return $this->fetch("/fanlist", ["List" => $activities]);
    }
    public function fanlisubmit()
    {
        $data = $this->request->post();
        $activityname = isset($data["activityname"]) ? $data["activityname"] : NULL;
        $totalQuantity = isset($data["total_quantity"]) ? $data["total_quantity"] : NULL;
        $maxUsagePerUser = isset($data["max_usage_per_user"]) ? $data["max_usage_per_user"] : NULL;
        $startTime = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $endTime = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $validity = isset($data["validity"]) ? $data["validity"] : NULL;
        $mode = isset($data["mode"]) ? $data["mode"] : NULL;
        $applicableProducts = isset($data["selected_applicable_products"]) ? $data["selected_applicable_products"] : NULL;
        $fan_products = isset($data["selected_fan_products"]) ? $data["selected_fan_products"] : NULL;
        $certification = isset($data["certification"]) ? $data["certification"] : [];
        $Distribution = isset($data["Distribution"]) ? $data["Distribution"] : [];
        $client_group_id = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $clientid = isset($data["clientid"]) ? $data["clientid"] : [];
        $discountType = isset($data["discount_type"]) ? $data["discount_type"] : NULL;
        $discountValue = isset($data["face_value"]) ? $data["face_value"] : NULL;
        $settlementCycle = isset($data["settlementCycle"]) ? $data["settlementCycle"] : NULL;
        $isRecurring = isset($data["is_recurring"]) ? $data["is_recurring"] : NULL;
        $isAgentAvailable = isset($data["is_agent_available"]) ? $data["is_agent_available"] : NULL;
        $maxUsagePerCode = isset($data["max_usage_per_code"]) ? $data["max_usage_per_code"] : NULL;
        $isOneTime = isset($data["is_one_time_valid"]) ? $data["is_one_time_valid"] : NULL;
        $isNewUserApplicable = isset($data["is_for_new_users"]) ? $data["is_for_new_users"] : NULL;
        $isExistingUserApplicable = isset($data["is_for_existing_users"]) ? $data["is_for_existing_users"] : NULL;
        $isSingleUsePerUser = isset($data["is_single_use_per_user"]) ? $data["is_single_use_per_user"] : NULL;
        $isUpgradeDowngradeApplicable = isset($data["is_upgrade_downgrade_applicable"]) ? $data["is_upgrade_downgrade_applicable"] : NULL;
        if (empty($data["activityname"])) {
            $response = ["code" => 400, "msg" => "活动名称是必填的，用户可见"];
            return json($response);
        }
        if (empty($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量是必填的。"];
            return json($response);
        }
        if (!isset($data["total_quantity"]) || !is_numeric($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领次数是必填的。"];
            return json($response);
        }
        if (!isset($data["max_usage_per_user"]) || !is_numeric($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领字段必须是有效的数值，您当前输入的为 【" . $data["max_usage_per_user"] . "】"];
            return json($response);
        }
        if (empty($data["start_time"])) {
            $response = ["code" => 400, "msg" => "活动开始时间是必填的。"];
            return json($response);
        }
        if (empty($data["end_time"])) {
            $response = ["code" => 400, "msg" => "活动结束时间是必填的。"];
            return json($response);
        }
        if (empty($data["face_value"])) {
            $response = ["code" => 400, "msg" => "面值是必填的，注意优惠类型的选择，以免造成损失。"];
            return json($response);
        }
        if (!isset($data["face_value"]) || !is_numeric($data["face_value"])) {
            $response = ["code" => 400, "msg" => "优惠面值字段必须是有效的数值，您当前输入的为 【" . $data["face_value"] . "】"];
            return json($response);
        }
        $fanProducts = explode(",", $fan_products);
        $productExists = false;
        $existingProductFanProducts = [];
        \Think\Db::startTrans();
        try {
            foreach ($fanProducts as $product) {
                $productResult = \Think\Db::name("coupon_yby_fanlilist")->where("fan_products", "like", "%" . $product . "%")->where("start_time", "<=", time())->where("end_time", ">=", time())->find();
                if ($productResult) {
                    $productExists = true;
                    $existingProductFanProducts[] = $productResult["fan_products"];
                    if ($productExists) {
                        $response = ["code" => 400, "msg" => "选择产品已存在活动中且未结束，ID为: " . implode(", ", $existingProductFanProducts) . "，请重新选取"];
                        return json($response);
                    }
                    \Think\Db::commit();
                }
            }
        } catch (\Exception $e) {
            \Think\Db::rollback();
            throw $e;
        }
        $dbData = ["activityname" => $activityname, "total_quantity" => $totalQuantity, "max_usage_per_user" => $maxUsagePerUser, "start_time" => $startTime, "end_time" => $endTime, "validity" => $validity, "applicable_products" => $applicableProducts, "ding_products" => $dingProducts, "fan_products" => $fan_products, "discount_type" => $discountType, "face_value" => $discountValue, "settlementCycle" => $settlementCycle, "is_recurring" => $isRecurring, "is_available_for_agents" => $isAgentAvailable, "max_usage_per_code" => 1, "is_one_time_valid" => $isOneTime, "is_for_new_users" => 0, "is_for_existing_users" => 0, "is_single_use_per_user" => $isSingleUsePerUser, "is_for_upgrade_downgrade" => $isUpgradeDowngradeApplicable, "clientid" => $clientid, "client_group_id" => $client_group_id, "Distribution" => $Distribution, "mode" => $mode, "certification" => $certification];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("coupon_yby_fanlilist")->insert($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "返利活动配置添加成功，请务必测试一遍，是否满足您设置的领券条件。"];
        } else {
            $response = ["code" => 400, "msg" => "返利活动配置添加失败。"];
        }
        return json($response);
    }
    public function claimlist()
    {
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $page = input("page", 1);
        $pageSize = 10;
        $activities = \Think\Db::name("coupon_yby_receive")->alias("acr")->join("clients c", "acr.user_id = c.id", "LEFT")->leftJoin("products p", "FIND_IN_SET(p.id, acr.applicable_products)")->leftJoin("promo_code pc", "acr.coupon_code = pc.code", "LEFT")->field("acr.*, c.username, IFNULL(GROUP_CONCAT(p.name SEPARATOR '， '), '全场可用') as applicable_product_names, pc.used as promo_code_used")->order("acr.id desc")->group("acr.id")->paginate($pageSize, false, ["page" => $page]);
        $this->assign("Title", "领取列表");
        $this->assign("domain", $domain);
        return $this->fetch("/claimlist", ["List" => $activities]);
    }
    public function fanxian()
    {
        $page = input("page", 1);
        $pageSize = 10;
        $activities = \Think\Db::name("coupon_yby_cashback")->order("id desc")->paginate($pageSize, false, ["page" => $page]);
        $url = $_SERVER["REQUEST_URI"];
        $domain = dirname($url);
        $this->assign("Title", "返现记录");
        $this->assign("domain", $domain);
        return $this->fetch("/fanxian", ["List" => $activities]);
    }
    public function deletelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("coupon_yby_list")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function deletefanlists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $result = \Think\Db::name("coupon_yby_fanlilist")->where("id", $id)->delete();
            if ($result !== false) {
                return json(["code" => 200, "msg" => "活动删除成功"]);
            }
            return json(["code" => 500, "msg" => "活动删除失败"]);
        }
    }
    public function setting()
    {
        $configurationsModel = \Think\Db::name("coupon_configurations");
        $configData = $configurationsModel->find();
        $authorize = \Think\Db::name("coupon_configurations")->where("id", 1)->value("mfauth");
        $system_license = \Think\Db::name("configuration")->where("setting", "system_license")->value("value");
        $isMismatch = $authorize !== $system_license;
        if (empty($authorize)) {
            $mismatchMessage = "请输入魔方授权码";
        } else {
            if ($isMismatch) {
                $mismatchMessage = "授权失败，请检查，有疑问请联系Q群758068758 了解详情";
            } else {
                $mismatchMessage = "恭喜您，授权成功";
            }
        }
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        $this->assign("IsMismatch", $isMismatch);
        $this->assign("MismatchMessage", $mismatchMessage);
        return $this->fetch("/setting");
    }
    public function setmail()
    {
        $configurationsModel = \Think\Db::name("coupon_configurations");
        $configData = $configurationsModel->find();
        $this->assign("Title", "功能设置");
        $this->assign("Data", $configData);
        return $this->fetch("/setmail");
    }
    public function submit()
    {
        $data = $this->request->post();
        $open_is = isset($data["open_is"]) ? $data["open_is"] : NULL;
        $gifts = isset($data["gifts"]) ? $data["gifts"] : NULL;
        $register = isset($data["register"]) ? $data["register"] : NULL;
        $fanli = isset($data["fanli"]) ? $data["fanli"] : NULL;
        $activityid = isset($data["activityid"]) ? $data["activityid"] : NULL;
        $zzemail = isset($data["zzemail"]) ? $data["zzemail"] : NULL;
        $zzqq = isset($data["zzqq"]) ? $data["zzqq"] : NULL;
        $mfauth = isset($data["mfauth"]) ? $data["mfauth"] : NULL;
        $smtp_host = isset($data["smtp_host"]) ? $data["smtp_host"] : NULL;
        $smtp_name = isset($data["smtp_name"]) ? $data["smtp_name"] : NULL;
        $smtp_pass = isset($data["smtp_pass"]) ? $data["smtp_pass"] : NULL;
        $smtp_port = isset($data["smtp_port"]) ? $data["smtp_port"] : NULL;
        $smtp_secure = isset($data["smtp_secure"]) ? $data["smtp_secure"] : NULL;
        $from_name = isset($data["from_name"]) ? $data["from_name"] : NULL;
        $dbConfig = ["open_is" => $open_is, "gifts" => $gifts, "register" => $register, "fanli" => $fanli, "activityid" => $activityid, "zzemail" => $zzemail, "zzqq" => $zzqq, "mfauth" => $mfauth, "smtp_host" => $smtp_host, "smtp_name" => $smtp_name, "smtp_pass" => $smtp_pass, "smtp_port" => $smtp_port, "smtp_secure" => $smtp_secure, "from_name" => $from_name, "weburl" => $_SERVER["HTTP_HOST"]];
        $result = \Think\Db::name("coupon_configurations")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("coupon_configurations")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("coupon_configurations")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function submitmail()
    {
        $data = $this->request->post();
        $smtp_is = isset($data["smtp_is"]) ? $data["smtp_is"] : NULL;
        $smtp_is2 = isset($data["smtp_is2"]) ? $data["smtp_is2"] : NULL;
        $smtp_is3 = isset($data["smtp_is3"]) ? $data["smtp_is3"] : NULL;
        $smtp_is4 = isset($data["smtp_is4"]) ? $data["smtp_is4"] : NULL;
        $emailsubject = isset($data["emailsubject"]) ? $data["emailsubject"] : NULL;
        $email_content = isset($data["email_content"]) ? $data["email_content"] : "";
        $emailsubject2 = isset($data["emailsubject2"]) ? $data["emailsubject2"] : NULL;
        $email_content2 = isset($data["email_content2"]) ? $data["email_content2"] : NULL;
        $emailsubject3 = isset($data["emailsubject3"]) ? $data["emailsubject3"] : NULL;
        $email_content3 = isset($data["email_content3"]) ? $data["email_content3"] : NULL;
        $emailsubject4 = isset($data["emailsubject4"]) ? $data["emailsubject4"] : NULL;
        $email_content4 = isset($data["email_content4"]) ? $data["email_content4"] : NULL;
        $dbConfig = ["smtp_is" => $smtp_is, "smtp_is2" => $smtp_is2, "smtp_is3" => $smtp_is3, "smtp_is4" => $smtp_is4, "emailsubject" => $emailsubject, "email_content" => $email_content, "emailsubject2" => $emailsubject2, "email_content2" => $email_content2, "emailsubject3" => $emailsubject3, "email_content3" => $email_content3, "emailsubject4" => $emailsubject4, "email_content4" => $email_content4];
        $result = \Think\Db::name("coupon_configurations")->where("id", 1)->find();
        if ($result) {
            $updateResult = \Think\Db::name("coupon_configurations")->where("id", 1)->update($dbConfig);
            if ($updateResult !== false) {
                $response = ["code" => 200, "msg" => "设置已成功更新。"];
            } else {
                $response = ["code" => 500, "msg" => "更新设置时出错。"];
            }
        } else {
            $dbConfig["id"] = 1;
            $insertResult = \Think\Db::name("coupon_configurations")->insert($dbConfig);
            if ($insertResult !== false) {
                $response = ["code" => 200, "msg" => "设置首次配置已成功。"];
            } else {
                $response = ["code" => 500, "msg" => "设置首次配置时出错。"];
            }
        }
        return json($response);
    }
    public function Officialdistribution()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $user_id = input("post.uid");
            $activity = \Think\Db::name("coupon_yby_list")->where("id", $id)->find();
            if (!$activity) {
                return json(["code" => 404, "msg" => "活动不存在"]);
            }
            $endTime = $activity["end_time"];
            $currentTime = time();
            $timeDifference = $endTime - $currentTime;
            if ($endTime <= $currentTime) {
                return json(["code" => 400, "msg" => "当前活动已过期"]);
            }
            if ($timeDifference <= 3600) {
                return json(["code" => 400, "msg" => "该活动距离过期不足1小时，禁止继续发放该活动"]);
            }
            if ($activity["total_quantity"] <= $activity["claim_count"]) {
                return json(["code" => 400, "msg" => "发放的数量已达本次活动发行数量设置上限"]);
            }
            $fouser = $activity["is_available_for_agents"];
            if ($fouser != 1) {
                if ($fouser == 0) {
                    $isyes = \Think\Db::name("clients")->where("id", $user_id)->find();
                    $group_id = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
                    $groupname = \Think\Db::name("client_groups")->where("id", $group_id)->value("group_name");
                    if ($group_id != 0) {
                        return json(["code" => 400, "msg" => "抱歉，该活动仅限普通用户参与，您发放的用户等级为：" . $groupname]);
                    }
                }
            }
            $userClaims = \Think\Db::name("coupon_yby_receive")->where("user_id", $user_id)->where("activity_id", $id)->count();
            if ($activity["max_usage_per_user"] <= $userClaims) {
                return json(["code" => 400, "msg" => "当前活动每人限领【" . $activity["max_usage_per_user"] . "】张，您领取到达上限，请选择其他活动！"]);
            }
            $admin_id = cmf_get_current_admin_id();
            $user = \Think\Db::name("user")->where("id", $admin_id)->value("user_nickname");
            $receptionSuccess = true;
            if ($receptionSuccess) {
                $couponCode = $this->generateRandomCouponCode1();
                $count = \Think\Db::name("coupon_yby_list")->where("id", $id)->value("claim_count");
                if ($count === NULL) {
                    \Think\Db::name("coupon_yby_list")->where("id", $id)->update(["claim_count" => 1]);
                } else {
                    \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                }
                $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => time() + $activity["validity"] * 3600, "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "source" => "官方发放"]);
                if ($result) {
                    $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：官方发放[操作人：" . $user . " (ID:" . $admin_id . ")]，用户ID：" . $user_id . "，活动名称：" . $activity["activityname"] . " (活动ID：" . $id . ")，领取时间：" . date("Y-m-d H:i:s", time()), "is_discount" => $activity["is_available_for_agents"]];
                    \Think\Db::name("promo_code")->insert($bTableData);
                    if ($result) {
                        $emailsConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
                        if (!$emailsConfig) {
                            return false;
                        }
                        $code = $couponCode;
                        $type = $activity["discount_type"] === "percent" ? "折扣" : ($activity["discount_type"] === "fixed" ? "立减" : "未知类型");
                        $discount = $activity["discount_type"];
                        $value = $discount === "percent" ? 100 - $activity["face_value"] . "%" : ($discount === "fixed" ? $activity["face_value"] . "元" : "未知值");
                        $cyclesMapping = ["day" => "日付", "monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付"];
                        $cycles = isset($cyclesMapping[$activity["settlementCycle"]]) ? $cyclesMapping[$activity["settlementCycle"]] : "不限";
                        $products = $activity["applicable_products"];
                        if (!empty($products)) {
                            $productIDs = explode(",", $products);
                            $productNames = [];
                            foreach ($productIDs as $productID) {
                                $productName = \Think\Db::name("products")->where("id", $productID)->value("name");
                                if ($productName) {
                                    $productNames[] = $productName;
                                }
                            }
                            $products = implode(", ", $productNames);
                        } else {
                            $products = "所有产品可用";
                        }
                        $start_time = date("Y-m-d H:i:s", $activity["start_time"]);
                        $end_time = date("Y-m-d H:i:s", $activity["end_time"]);
                        $time = date("Y-m-d H:i:s", time());
                        $validity = date("Y-m-d H:i:s", time() + $activity["validity"] * 3600);
                        $notes = "官方发放";
                        $activityname = $activity["activityname"];
                        $clientInfo = \Think\Db::name("clients")->where("id", $user_id)->field("email, username")->find();
                        $recipientEmail = $clientInfo["email"];
                        $email = $clientInfo["email"];
                        $name = $clientInfo["username"];
                        $emailSubject = $emailsConfig["emailsubject"];
                        $emailSubject = str_replace("\$start_time", $start_time, $emailSubject);
                        $emailSubject = str_replace("\$end_time", $end_time, $emailSubject);
                        $emailSubject = str_replace("\$products", $products, $emailSubject);
                        $emailSubject = str_replace("\$type", $type, $emailSubject);
                        $emailSubject = str_replace("\$validity", $validity, $emailSubject);
                        $emailSubject = str_replace("\$value", $value, $emailSubject);
                        $emailSubject = str_replace("\$activityname", $activityname, $emailSubject);
                        $emailSubject = str_replace("\$code", $code, $emailSubject);
                        $emailMessage = $emailsConfig["email_content"];
                        $emailMessage = html_entity_decode($emailMessage);
                        $emailMessage = str_replace("\$email", $email, $emailMessage);
                        $emailMessage = str_replace("\$name", $name, $emailMessage);
                        $emailMessage = str_replace("\$code", $code, $emailMessage);
                        $emailMessage = str_replace("\$products", $products, $emailMessage);
                        $emailMessage = str_replace("\$type", $type, $emailMessage);
                        $emailMessage = str_replace("\$value", $value, $emailMessage);
                        $emailMessage = str_replace("\$cycles", $cycles, $emailMessage);
                        $emailMessage = str_replace("\$start_time", $start_time, $emailMessage);
                        $emailMessage = str_replace("\$end_time", $end_time, $emailMessage);
                        $emailMessage = str_replace("\$time", $time, $emailMessage);
                        $emailMessage = str_replace("\$validity", $validity, $emailMessage);
                        $emailMessage = str_replace("\$activityname", $activityname, $emailMessage);
                        $emailMessage = str_replace("\$notes", $notes, $emailMessage);
                        $emailSent = $this->sendEmail($recipientEmail, $emailSubject, $emailMessage);
                        $url = $_SERVER["REQUEST_URI"];
                        $domain = dirname($url);
                        $client_port = $_SERVER["REMOTE_PORT"];
                        $client_ip = "";
                        if (isset($_SERVER["HTTP_CLIENT_IP"])) {
                            $client_ip = $_SERVER["HTTP_CLIENT_IP"];
                        } else {
                            if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                                $client_ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
                            } else {
                                if (isset($_SERVER["HTTP_X_FORWARDED"])) {
                                    $client_ip = $_SERVER["HTTP_X_FORWARDED"];
                                } else {
                                    if (isset($_SERVER["HTTP_FORWARDED_FOR"])) {
                                        $client_ip = $_SERVER["HTTP_FORWARDED_FOR"];
                                    } else {
                                        if (isset($_SERVER["HTTP_FORWARDED"])) {
                                            $client_ip = $_SERVER["HTTP_FORWARDED"];
                                        } else {
                                            if (isset($_SERVER["REMOTE_ADDR"])) {
                                                $client_ip = $_SERVER["REMOTE_ADDR"];
                                            } else {
                                                $client_ip = "UNKNOWN";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        $activity_log = ["uid" => $user_id, "description" => "后台【" . $user . " (ID:" . $admin_id . ")】管理发放，<a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a> 活动：" . $activity["activityname"] . "【ID:" . $id . "】，<a href=\"" . $domain . "/addons?_plugin=coupon_yby&_controller=admin_index&_action=claimlist\">查看领取列表</a>，券码：" . $code, "user" => $user, "port" => $client_port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 0, "activeid" => $admin_id, "usertype" => "Admin", "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($activity_log);
                        if (!$emailsConfig || $emailsConfig["smtp_is"] != 1) {
                            if ($emailSent) {
                                return json(["code" => 200, "msg" => "优惠码发送成功，但内部券送发邮件未开启，未发送电子邮件"]);
                            }
                            return json(["code" => 200, "msg" => "优惠码发送成功，但内部券送发邮件未开启，未发送电子邮件"]);
                        }
                        $sentStatus = $emailSent ? 1 : 0;
                        $failReason = $sentStatus ? "发送成功" : "发送失败-SMTP信息错误";
                        $logData = ["uid" => $user_id, "subject" => $emailSubject, "message" => $emailMessage, "to" => $recipientEmail, "create_time" => time(), "is_admin" => 0, "ip" => $client_ip, "port" => $client_port, "status" => $sentStatus, "fail_reason" => $failReason];
                        \Think\Db::name("email_log")->insert($logData);
                        if ($emailSent) {
                            return json(["code" => 200, "msg" => "优惠码发送成功，并已发送电子邮件"]);
                        }
                        return json(["code" => 200, "msg" => "优惠码发送成功，但发送电子邮件失败[SMTP信息错误]"]);
                    } else {
                        return json(["code" => 500, "msg" => "发送失败"]);
                    }
                }
            }
        }
    }
    private function generateRandomCouponCode1($length = 12)
    {
        $characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $couponCode = "";
        for ($i = 0; $i < $length; $i++) {
            $couponCode .= $characters[random_int(0, strlen($characters) - 1)];
        }
        return $couponCode;
    }
    private function sendEmail($recipient, $subject, $message)
    {
        $emailConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
        if (!$emailConfig || $emailConfig["smtp_is"] != 1) {
            return false;
        }
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->CharSet = "UTF-8";
            $mail->Host = $emailConfig["smtp_host"];
            $mail->SMTPAuth = true;
            $mail->Username = $emailConfig["smtp_name"];
            $mail->Password = $emailConfig["smtp_pass"];
            $mail->SMTPSecure = $emailConfig["smtp_secure"];
            $mail->Port = $emailConfig["smtp_port"];
            $mail->setFrom($emailConfig["smtp_name"], $emailConfig["from_name"]);
            $mail->addAddress($recipient);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->send();
            return true;
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            return false;
        }
    }
    public function receivelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $user_id = input("post.uid");
            $activity = \Think\Db::name("coupon_yby_list")->where("id", $id)->find();
            if (!$activity) {
                return json(["code" => 404, "msg" => "活动不存在"]);
            }
            $open_is = \Think\Db::name("coupon_configurations")->where("id", 1)->value("open_is");
            if ($open_is != 1) {
                return json(["code" => 400, "msg" => "活动未开启，请联系网站客服"]);
            }
            $currentTime = time();
            $activityStartTime = $activity["start_time"];
            $activityEndTime = $activity["end_time"];
            if ($currentTime < $activityStartTime) {
                return json(["code" => 400, "msg" => "活动还未开始，敬请等待！！"]);
            }
            if ($activityEndTime < $currentTime) {
                return json(["code" => 400, "msg" => "【" . $activity["activityname"] . "】活动已经结束，下次请赶早！！！"]);
            }
            $isForNewUsers = $activity["is_for_new_users"];
            if ($isForNewUsers == 1) {
                $userExistsInHost = \Think\Db::name("host")->where("uid", $user_id)->find();
                if ($userExistsInHost) {
                    return json(["code" => 400, "msg" => "新用户专属活动，您不符合该活动的领取条件。"]);
                }
            }
            $userGroupResult = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
            if ($userGroupResult === NULL) {
                return json(["code" => 400, "msg" => "用户不存在"]);
            }
            $activityClientGroupId = $activity["client_group_id"];
            if ($activityClientGroupId != "0") {
                $allowedGroupIds = explode(",", $activityClientGroupId);
                if (!in_array($userGroupResult, $allowedGroupIds)) {
                    return json(["code" => 400, "msg" => "本活动为专属活动，您非本次活动的邀请对象，请参与其他活动"]);
                }
            }
            $activityClientId = $activity["clientid"];
            if ($activityClientId !== NULL) {
                if ($activityClientId != "") {
                    if ($user_id != $activityClientId) {
                        return json(["code" => 400, "msg" => "本活动为专属用户活动，您非本次活动的邀请对象，请参与其他活动"]);
                    }
                }
            }
            $certification = $activity["certification"];
            if ($certification != 0) {
                if ($certification == 1) {
                    $certifi_person = \Think\Db::name("certifi_person")->where("auth_user_id", $user_id)->find();
                    $certifi_company = \Think\Db::name("certifi_company")->where("auth_user_id", $user_id)->find();
                    $can_receive = false;
                    if ($certifi_person) {
                        $can_receive = $certifi_person["status"] == 1;
                    }
                    if (!$can_receive && $certifi_company) {
                        $can_receive = $certifi_company["status"] == 1;
                    }
                    if (!$certifi_person && !$certifi_company) {
                        return json(["code" => 403, "msg" => "本活动仅限实名认证用户领取，请实名认证后再参与活动！"]);
                    }
                    if (!$can_receive) {
                        return json(["code" => 403, "msg" => "本活动仅限实名认证用户领取，您的账号目前暂未通过认证！"]);
                    }
                }
            }
            $fouser = $activity["is_available_for_agents"];
            if ($fouser != 1) {
                if ($fouser == 0) {
                    $isyes = \Think\Db::name("clients")->where("id", $user_id)->find();
                    $group_id = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
                    $groupname = \Think\Db::name("client_groups")->where("id", $group_id)->value("group_name");
                    if ($group_id != 0) {
                        return json(["code" => 400, "msg" => "抱歉，该活动仅限普通用户参与，您的等级为：" . $groupname]);
                    }
                }
            }
            $userClaims = \Think\Db::name("coupon_yby_receive")->where("user_id", $user_id)->where("activity_id", $id)->count();
            if ($activity["max_usage_per_user"] <= $userClaims) {
                return json(["code" => 400, "msg" => "当前活动每人限领【" . $activity["max_usage_per_user"] . "】张，您领取到达上限，请选择其他活动！"]);
            }
            if ($activity["total_quantity"] <= $activity["claim_count"]) {
                return json(["code" => 400, "msg" => "活动已领取的数量已达上限"]);
            }
            $receptionSuccess = true;
            if ($receptionSuccess) {
                $couponCode = $this->generateRandomCouponCode();
                \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => time() + $activity["validity"] * 3600, "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "source" => "主动领取"]);
                if ($result) {
                    $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：领券中心，用户ID：" . $user_id . "，活动名称：" . $activity["activityname"] . " (活动ID：" . $id . ")，领取时间：" . date("Y-m-d H:i:s", time()), "is_discount" => $activity["is_available_for_agents"]];
                    $applicableProducts = $activity["applicable_products"];
                    $applicableProductsArray = explode(",", $applicableProducts);
                    \Think\Db::name("promo_code")->insert($bTableData);
                    if ($result) {
                        $message = "领取成功";
                        if (!empty($applicableProductsArray)) {
                            $links = [];
                            foreach ($applicableProductsArray as $product) {
                                $productId = \Think\Db::name("products")->where("id", $product)->value("id");
                                if ($productId) {
                                    $productName = \Think\Db::name("products")->where("id", $productId)->value("name");
                                    $link = "/cart?action=configureproduct&pid=" . $product . "&promocode=" . $couponCode;
                                    $links[] = "<a href=\"" . $link . "\" target=\"_blank\"> " . $productName . "</a>";
                                } else {
                                    $links[] = "全场可用";
                                }
                            }
                            $message = "领取成功，优惠码适用以下产品：<br>" . implode("，", $links);
                        }
                        return json(["code" => 200, "msg" => $message]);
                    } else {
                        return json(["code" => 500, "msg" => "领取结果写入失败"]);
                    }
                }
            }
        }
    }
    private function generateRandomCouponCode($length = 10)
    {
        $characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $couponCode = "";
        for ($i = 0; $i < $length; $i++) {
            $couponCode .= $characters[random_int(0, strlen($characters) - 1)];
        }
        return $couponCode;
    }
    public function fanli()
    {
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $products = \Think\Db::name("products")->field("id, gid, name")->select();
        $productsByGroupId = [];
        foreach ($products as $product) {
            $id = $product["id"];
            $gids = $product["gid"];
            $name = $product["name"];
            $gid = \Think\Db::name("product_groups")->where("id", $gids)->value("name");
            if (!isset($productsByGroupId[$id])) {
                $productsByGroupId[$id] = [];
            }
            $productsByGroupId[$id][] = $gid;
            $productsByGroupId[$id][] = $name;
        }
        $products = \Think\Db::name("products")->field("id, gid, name")->select();
        $productsByfan = [];
        foreach ($products as $product) {
            $id = $product["id"];
            $gids = $product["gid"];
            $name = $product["name"];
            $gid = \Think\Db::name("product_groups")->where("id", $gids)->value("name");
            if (!isset($productsByfan[$id])) {
                $productsByfan[$id] = [];
            }
            $fanProducts = \Think\Db::name("coupon_yby_fanlilist")->where("fan_products", "like", "%" . $id . "%")->find();
            if (!$fanProducts) {
                $productsByfan[$id][] = $gid;
                $productsByfan[$id][] = $name;
            } else {
                $endTimestamp = $fanProducts["end_time"];
                if ($endTimestamp < time()) {
                    $productsByfan[$id][] = $gid;
                    $productsByfan[$id][] = $name;
                }
            }
        }
        $products = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        foreach ($products as $key => $product) {
            $fanProducts = \Think\Db::name("coupon_yby_fanlilist")->where("fan_products", "LIKE", "%" . $product["id"] . "%")->order("id desc")->find();
            if ($fanProducts && time() < $fanProducts["end_time"]) {
                unset($products[$key]);
            }
        }
        $this->assign("products", $products);
        $keproducts = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $resultWithNames = [];
        foreach ($keproducts as $record) {
            $productid = $record["id"];
            $name = \Think\Db::name("products")->where("id", $productid)->find();
            $name1 = \Think\Db::name("products")->where(["id" => $productid, "api_type" => "zjmf_api"])->find();
            $zjmf_finance_api = \Think\Db::name("zjmf_finance_api")->where(["id" => $name1["server_group"]])->find();
            if ($name !== NULL) {
                $record["name"] = $name["name"];
                $record["hosttype"] = $name["type"];
                $record["hidden"] = $name["hidden"];
                $record["api_name"] = $zjmf_finance_api["name"];
                $resultWithNames[] = $record;
            }
        }
        $this->assign("keproducts", $resultWithNames);
        $this->assign("Title", "返利模式");
        return $this->fetch("/fanli", ["clientGroups" => $clientGroups, "productsByfan" => $productsByfan, "productsByGroupId" => $productsByGroupId]);
    }
    public function fanlistsetting()
    {
        $id = input("get.id");
        $configurationsModel = \Think\Db::name("coupon_yby_fanlilist");
        $configData = $configurationsModel->where("id", $id)->find();
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $products = \Think\Db::name("products")->field("id, gid, name")->select();
        $productsByGroupId = [];
        foreach ($products as $product) {
            $id = $product["id"];
            $gids = $product["gid"];
            $name = $product["name"];
            $gid = \Think\Db::name("product_groups")->where("id", $gids)->value("name");
            if (!isset($productsByGroupId[$id])) {
                $productsByGroupId[$id] = [];
            }
            $productsByGroupId[$id][] = $gid;
            $productsByGroupId[$id][] = $name;
        }
        $products = \Think\Db::name("products")->field("id, gid, name")->select();
        $productsByfan = [];
        foreach ($products as $product) {
            $id = $product["id"];
            $gids = $product["gid"];
            $name = $product["name"];
            $gid = \Think\Db::name("product_groups")->where("id", $gids)->value("name");
            if (!isset($productsByfan[$id])) {
                $productsByfan[$id] = [];
            }
            $fanProducts = \Think\Db::name("coupon_yby_fanlilist")->where("fan_products", "like", "%" . $id . "%")->find();
            if (!$fanProducts) {
                $productsByfan[$id][] = $gid;
                $productsByfan[$id][] = $name;
            } else {
                $endTimestamp = $fanProducts["end_time"];
                if ($endTimestamp < time()) {
                    $productsByfan[$id][] = $gid;
                    $productsByfan[$id][] = $name;
                }
            }
        }
        $products = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        foreach ($products as $key => $product) {
            $fanProducts = \Think\Db::name("coupon_yby_fanlilist")->where("fan_products", "LIKE", "%" . $product["id"] . "%")->order("id desc")->find();
            if ($fanProducts && time() < $fanProducts["end_time"]) {
                unset($products[$key]);
            }
        }
        $this->assign("products", $products);
        $keproducts = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $this->assign("keproducts", $keproducts);
        $this->assign("Data", $configData);
        $this->assign("Title", "返利模式");
        return $this->fetch("/fanlistsetting", ["clientGroups" => $clientGroups, "productsByfan" => $productsByfan, "productsByGroupId" => $productsByGroupId]);
    }
    public function submitfanli()
    {
        $data = $this->request->post();
        $activityid = isset($data["id"]) ? $data["id"] : NULL;
        $activityname = isset($data["activityname"]) ? $data["activityname"] : NULL;
        $totalQuantity = isset($data["total_quantity"]) ? $data["total_quantity"] : NULL;
        $maxUsagePerUser = isset($data["max_usage_per_user"]) ? $data["max_usage_per_user"] : NULL;
        $startTime = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $endTime = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $validity = isset($data["validity"]) ? $data["validity"] : NULL;
        $mode = isset($data["mode"]) ? $data["mode"] : NULL;
        $applicableProducts = isset($data["selected_applicable_products"]) ? $data["selected_applicable_products"] : NULL;
        $fan_products = isset($data["selected_fan_products"]) ? $data["selected_fan_products"] : NULL;
        $certification = isset($data["certification"]) ? $data["certification"] : [];
        $Distribution = isset($data["Distribution"]) ? $data["Distribution"] : [];
        $client_group_id = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $clientid = isset($data["clientid"]) ? $data["clientid"] : [];
        $discountType = isset($data["discount_type"]) ? $data["discount_type"] : NULL;
        $discountValue = isset($data["face_value"]) ? $data["face_value"] : NULL;
        $settlementCycle = isset($data["settlementCycle"]) ? $data["settlementCycle"] : NULL;
        $isRecurring = isset($data["is_recurring"]) ? $data["is_recurring"] : NULL;
        $isAgentAvailable = isset($data["is_agent_available"]) ? $data["is_agent_available"] : NULL;
        $maxUsagePerCode = isset($data["max_usage_per_code"]) ? $data["max_usage_per_code"] : NULL;
        $isOneTime = isset($data["is_one_time_valid"]) ? $data["is_one_time_valid"] : NULL;
        $isNewUserApplicable = isset($data["is_for_new_users"]) ? $data["is_for_new_users"] : NULL;
        $isExistingUserApplicable = isset($data["is_for_existing_users"]) ? $data["is_for_existing_users"] : NULL;
        $isSingleUsePerUser = isset($data["is_single_use_per_user"]) ? $data["is_single_use_per_user"] : NULL;
        $isUpgradeDowngradeApplicable = isset($data["is_upgrade_downgrade_applicable"]) ? $data["is_upgrade_downgrade_applicable"] : NULL;
        if (empty($data["id"])) {
            $response = ["code" => 400, "msg" => "活动ID不存在，请在返利活动列表操作修改"];
            return json($response);
        }
        if (empty($data["activityname"])) {
            $response = ["code" => 400, "msg" => "活动名称是必填的，用户可见"];
            return json($response);
        }
        if (empty($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量是必填的。"];
            return json($response);
        }
        if (!isset($data["total_quantity"]) || !is_numeric($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领次数是必填的。"];
            return json($response);
        }
        if (!isset($data["max_usage_per_user"]) || !is_numeric($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领字段必须是有效的数值，您当前输入的为 【" . $data["max_usage_per_user"] . "】"];
            return json($response);
        }
        if (empty($data["start_time"])) {
            $response = ["code" => 400, "msg" => "活动开始时间是必填的。"];
            return json($response);
        }
        if (empty($data["end_time"])) {
            $response = ["code" => 400, "msg" => "活动结束时间是必填的。"];
            return json($response);
        }
        if (empty($data["face_value"])) {
            $response = ["code" => 400, "msg" => "面值是必填的，注意返利类型的选择，以免造成损失。"];
            return json($response);
        }
        if (!isset($data["face_value"]) || !is_numeric($data["face_value"])) {
            $response = ["code" => 400, "msg" => "优惠面值字段必须是有效的数值，您当前输入的为 【" . $data["face_value"] . "】"];
            return json($response);
        }
        $dbData = ["activityname" => $activityname, "total_quantity" => $totalQuantity, "max_usage_per_user" => $maxUsagePerUser, "start_time" => $startTime, "end_time" => $endTime, "validity" => $validity, "applicable_products" => $applicableProducts, "ding_products" => $dingProducts, "fan_products" => $fan_products, "discount_type" => $discountType, "face_value" => $discountValue, "settlementCycle" => $settlementCycle, "is_recurring" => $isRecurring, "is_available_for_agents" => $isAgentAvailable, "max_usage_per_code" => 1, "is_one_time_valid" => $isOneTime, "is_for_new_users" => 0, "is_for_existing_users" => 0, "is_single_use_per_user" => $isSingleUsePerUser, "is_for_upgrade_downgrade" => $isUpgradeDowngradeApplicable, "clientid" => $clientid, "client_group_id" => $client_group_id, "Distribution" => $Distribution, "certification" => $certification, "mode" => $mode];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("coupon_yby_fanlilist")->where("id", $activityid)->update($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "返利活动ID：" . $activityid . " 活动更新成功"];
        } else {
            $response = ["code" => 400, "msg" => "返利活动ID：" . $activityid . " 活动更新失败【原因：活动参数未变化】"];
        }
        return json($response);
    }
    public function listsetting()
    {
        $id = input("get.id");
        $configurationsModel = \Think\Db::name("coupon_yby_list");
        $configData = $configurationsModel->where("id", $id)->find();
        $clientGroups = \Think\Db::name("client_groups")->field("id, group_name")->select();
        $keproducts = \Think\Db::name("products")->alias("p")->field("p.id, p.gid, p.name, g.name as group_name")->join("product_groups g", "p.gid = g.id", "LEFT")->order("p.gid ASC")->order("p.id ASC")->select();
        $this->assign("keproducts", $keproducts);
        $this->assign("Data", $configData);
        $this->assign("clientGroups", $clientGroups);
        $this->assign("Title", "功能设置");
        return $this->fetch("/listsetting");
    }
    public function submitlist()
    {
        $data = $this->request->post();
        $activityid = isset($data["id"]) ? $data["id"] : NULL;
        $activityname = isset($data["activityname"]) ? $data["activityname"] : NULL;
        $totalQuantity = isset($data["total_quantity"]) ? $data["total_quantity"] : NULL;
        $maxUsagePerUser = isset($data["max_usage_per_user"]) ? $data["max_usage_per_user"] : NULL;
        $startTime = isset($data["start_time"]) ? strtotime($data["start_time"]) : NULL;
        $endTime = isset($data["end_time"]) ? strtotime($data["end_time"]) : NULL;
        $validity = isset($data["validity"]) ? $data["validity"] : NULL;
        $applicableProducts = isset($data["selected_product"]) ? $data["selected_product"] : NULL;
        $dingProducts = isset($data["ding_product"]) ? $data["ding_product"] : NULL;
        $clientGroupIds = isset($data["client_group_id"]) ? $data["client_group_id"] : [];
        $clientGroupIdsString = implode(",", $clientGroupIds);
        $client_group_id = trim($clientGroupIdsString);
        $cycle = isset($data["cycle"]) ? $data["cycle"] : NULL;
        $amount = isset($data["amount"]) ? $data["amount"] : NULL;
        $certification = isset($data["certification"]) ? $data["certification"] : [];
        $Distribution = isset($data["Distribution"]) ? $data["Distribution"] : [];
        $clientid = isset($data["clientid"]) ? $data["clientid"] : [];
        $discountType = isset($data["discount_type"]) ? $data["discount_type"] : NULL;
        $discountValue = isset($data["face_value"]) ? $data["face_value"] : NULL;
        $settlementCycle = isset($data["settlementCycle"]) ? $data["settlementCycle"] : NULL;
        $isRecurring = isset($data["is_recurring"]) ? $data["is_recurring"] : NULL;
        $isAgentAvailable = isset($data["is_agent_available"]) ? $data["is_agent_available"] : NULL;
        $maxUsagePerCode = isset($data["max_usage_per_code"]) ? $data["max_usage_per_code"] : NULL;
        $isOneTime = isset($data["is_one_time_valid"]) ? $data["is_one_time_valid"] : NULL;
        $isNewUserApplicable = isset($data["is_for_new_users"]) ? $data["is_for_new_users"] : NULL;
        $isExistingUserApplicable = isset($data["is_for_existing_users"]) ? $data["is_for_existing_users"] : NULL;
        $isSingleUsePerUser = isset($data["is_single_use_per_user"]) ? $data["is_single_use_per_user"] : NULL;
        $isUpgradeDowngradeApplicable = isset($data["is_upgrade_downgrade_applicable"]) ? $data["is_upgrade_downgrade_applicable"] : NULL;
        if (empty($data["id"])) {
            $response = ["code" => 400, "msg" => "活动ID不存在，请在活动列表操作修改"];
            return json($response);
        }
        if (empty($data["activityname"])) {
            $response = ["code" => 400, "msg" => "活动名称是必填的，用户可见"];
            return json($response);
        }
        if (empty($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量是必填的。"];
            return json($response);
        }
        if (!isset($data["total_quantity"]) || !is_numeric($data["total_quantity"])) {
            $response = ["code" => 400, "msg" => "优惠券发行量字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["validity"])) {
            $response = ["code" => 400, "msg" => "请填写领取后有效期，单位为小时。"];
            return json($response);
        }
        if (!isset($data["validity"]) || !is_numeric($data["validity"])) {
            $response = ["code" => 400, "msg" => "领取后有效期字段必须是有效的数值，您当前输入的为 【" . $data["total_quantity"] . "】"];
            return json($response);
        }
        if (empty($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领次数是必填的。"];
            return json($response);
        }
        if (!isset($data["max_usage_per_user"]) || !is_numeric($data["max_usage_per_user"])) {
            $response = ["code" => 400, "msg" => "每人限领字段必须是有效的数值，您当前输入的为 【" . $data["max_usage_per_user"] . "】"];
            return json($response);
        }
        if (empty($data["start_time"])) {
            $response = ["code" => 400, "msg" => "活动开始时间是必填的。"];
            return json($response);
        }
        if (empty($data["end_time"])) {
            $response = ["code" => 400, "msg" => "活动结束时间是必填的。"];
            return json($response);
        }
        if (empty($data["face_value"])) {
            $response = ["code" => 400, "msg" => "面值是必填的，注意优惠类型的选择，以免造成损失。"];
            return json($response);
        }
        if (!isset($data["face_value"]) || !is_numeric($data["face_value"])) {
            $response = ["code" => 400, "msg" => "优惠面值字段必须是有效的数值，您当前输入的为 【" . $data["face_value"] . "】"];
            return json($response);
        }
        if (!empty($data["cycle"]) || !empty($data["amount"])) {
            if (empty($data["cycle"])) {
                $response = ["code" => 400, "msg" => "您输入消费金额，该条件需要同时输入消费周期，如不使用，消费金额留空。"];
                return json($response);
            }
            if (!is_int($data["cycle"]) && !ctype_digit((string) $data["cycle"])) {
                $response = ["code" => 400, "msg" => "消费周期必须为正整数。"];
                return json($response);
            }
            if (empty($data["amount"])) {
                $response = ["code" => 400, "msg" => "您输入消费周期，该条件需要同时输入消费金额，如不使用，消费周期留空。"];
                return json($response);
            }
            if (!is_numeric($data["amount"]) || !preg_match("/^\\d+(\\.\\d{1,2})?\$/", $data["amount"])) {
                $response = ["code" => 400, "msg" => "消费金额必须为数字，最多保留两位小数。"];
                return json($response);
            }
            if ($data["amount"] <= 0) {
                $response = ["code" => 400, "msg" => "消费金额必须为正值，最多保留两位小数。"];
                return json($response);
            }
        }
        if (!(count($clientGroupIds) == 1 && in_array("0", $clientGroupIds))) {
            if (in_array("0", $clientGroupIds)) {
                $response = ["code" => 400, "msg" => "不限制用户组不能同时与其他用户组存在"];
                return json($response);
            }
            if (!$isAgentAvailable) {
                $response = ["code" => 400, "msg" => "选择了【定向发放】客户组，请选择“代理商是否可用”为“是”，否则定向用户组将无法领取"];
                return json($response);
            }
        }
        $dbData = ["activityname" => $activityname, "total_quantity" => $totalQuantity, "max_usage_per_user" => $maxUsagePerUser, "start_time" => $startTime, "end_time" => $endTime, "validity" => $validity, "applicable_products" => $applicableProducts, "ding_products" => $dingProducts, "discount_type" => $discountType, "face_value" => $discountValue, "cycle" => $cycle, "amount" => $amount, "settlementCycle" => $settlementCycle, "is_recurring" => $isRecurring, "is_available_for_agents" => $isAgentAvailable, "max_usage_per_code" => 1, "is_one_time_valid" => $isOneTime, "is_for_new_users" => $isNewUserApplicable, "is_for_existing_users" => $isExistingUserApplicable, "is_single_use_per_user" => $isSingleUsePerUser, "is_for_upgrade_downgrade" => $isUpgradeDowngradeApplicable, "clientid" => $clientid, "client_group_id" => $client_group_id, "Distribution" => $Distribution, "certification" => $certification];
        $dbData = array_filter($dbData, function ($value) {
            return $value !== NULL;
        });
        $result = \Think\Db::name("coupon_yby_list")->where("id", $activityid)->update($dbData);
        if ($result) {
            $response = ["code" => 200, "msg" => "普通活动ID：" . $activityid . " 活动更新成功"];
        } else {
            $response = ["code" => 400, "msg" => "普通活动ID：" . $activityid . " 活动更新失败【原因：活动参数未变化】"];
        }
        return json($response);
    }
}

?>