
<head>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
            font-family: Arial, sans-serif;
        }
        
        th, td {
            border: 1px solid #dddddd;
            text-align: left;
            padding: 8px;
        }
        
        th {
            background-color: #f2f2f2;
        }
        
        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
        
        th:first-child,
        td:first-child {
            border-left: none;
        }
        
        th:last-child,
        td:last-child {
            border-right: none;
        }
    .product-cell {
        max-width: 200px;
        white-space: normal;
    }
    .product-name {
        overflow: hidden;
        text-overflow: ellipsis;
    }
    .navigation {
        background-color: #f2f2f2;
        padding: 10px;
        display: flex;
        justify-content: center;
    }

    .navigation span {
        margin-left: 10px;
    }

    .navigation a {
        text-decoration: none;
        color: #333;
        font-size: 18px;
    }

    .navigation a:hover {
        text-decoration: underline;
    }
    
/*标题样式*/
    .activity-name {
        display: inline-block;
        padding: 8px 12px;
        border: 2px solid #3498db;
        border-radius: 5px;
        font-weight: bold;
        color: #3498db;
        text-transform: uppercase;
        background-color: #f0f0f0;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .activity-name:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    
/*折扣样式开始*/
    .discount-type {
        display: inline-block;
        padding: 8px 15px;
        border-radius: 20px;
        font-weight: bold;
        text-transform: uppercase;
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .percent {
        background: linear-gradient(to right, #4CAF50, #4CAF50);
        color: white;
        box-shadow: 0 20px 4px rgba(0, 0, 0, 0.1);
    }

    .fixed {
        background: linear-gradient(to right, #6699ff, #3366ff);
        color: white;
        box-shadow: 0 20px 4px rgba(0, 0, 0, 0.1);
    }

    .unknown {
        background: linear-gradient(to right, #cccccc, #999999);
        color: white;
        box-shadow: 0 20px 4px rgba(0, 0, 0, 0.1);
    }

    .discount-type:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.15);
    }
/*折扣样式结束*/

/*面值样式开始*/
    .discount-info {
        display: inline-block;
        padding: 8px 15px;
        border-radius: 5px;
        font-weight: bold;
    }

    .percent {
        background-color: #4CAF50;
        color: white;
    }

    .fixed {
        background-color: #3498db;
        color: white;
    }
    .fanpercent {
        background-color: #4CAF50;
        color: white;
    }

    .fanfixed {
        background-color: #b369b1;
        color: white;
    }
    .unknown {
        background-color: #808080;
        color: white;
    }
/*面值样式结束*/

/*优惠码样式*/
    .coupon-code {
        display: inline-block;
        padding: 8px 16px;
        background-color: #f39c12;
        color: white;
        border-radius: 5px;
        font-weight: bold;
        text-transform: uppercase;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
    }

    .coupon-code:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }
    
    
/*优惠码样式结束*/


/*付款周期样式*/
    .settlement-cycle {
        display: inline-block;
        padding: 5px 10px;
        border-radius: 5px;
        font-weight: bold;
    }

    .day {
        background-color: #4CAF50;
        color: white;
    }

    .monthly {
        background-color: #3498db;
        color: white;
    }

    .quarterly {
        background-color: #f39c12;
        color: white;
    }

    .semiannually {
        background-color: #e74c3c;
        color: white;
    }

    .annually {
        background-color: #9b59b6;
        color: white;
    }

    .unlimited {
        background-color: #95a5a6;
        color: white;
    }
/*付款周期样式结束*/

/*时间样式*/
    .received-date {
        display: inline-block;
        padding: 5px 10px;
        border-radius: 5px;
        font-weight: bold;
        background-color: #3498db;
        color: white;
    }
    .end-time {
        display: inline-block;
        padding: 5px 10px;
        border-radius: 5px;
        font-weight: bold;
        background-color: #e74c3c;
        color: white;
    }
/*时间样式结束*/

    .product-name {
        max-width: 300px; /* Set your desired maximum width */
        padding: 8px 12px;
        border-radius: 5px;
        font-weight: bold;
        background-color: #3498db;
        color: white;
        text-align: center;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        transition: transform 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        word-wrap: break-word; /* Automatically wrap long words */
    }

    .product-name.empty {
        background-color: #e74c3c;
    }

    .product-name:hover {
        transform: scale(1.05);
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    }

/*优惠码状态开始*/
    .promo-status {
        padding: 10px 20px;
        border-radius: 5px;
        font-weight: bold;
        text-transform: uppercase;
        letter-spacing: 1px;
        display: inline-block;
    }
    
    .used {
        background: linear-gradient(to bottom, #FF5757, #E60000);
        color: white;
        box-shadow: 0px 3px 5px rgba(0, 0, 0, 0.2);
    }
    
    .unused {
        background: linear-gradient(to bottom, #6EE786, #2ECC71);
        color: white;
        box-shadow: 0px 3px 5px rgba(0, 0, 0, 0.2);
    }
    
    .expired {
        background: linear-gradient(to bottom, #D3D3D3, #A9A9A9);
        color: white;
        box-shadow: 0px 3px 5px rgba(0, 0, 0, 0.2);
    }
/*优惠码状态结束*/

            /* 将表格包装在一个水平滚动容器内开始 */
        @media (max-width: 480px) {
            /* 将表格包装在一个水平滚动容器内 */
            .table-container {
                overflow-x: auto; /* 横向滚动 */
                margin: 0 auto; /* 居中对齐 */
                max-width: 100%; /* 最大宽度 */
            }

            table {
                font-size: 12px; /* 在小屏幕上减小字体大小 */
            }
            th, td {
                padding: 6px; /* 在小屏幕上减小内边距 */
            }
            .product-cell {
                max-width: none; /* 删除产品单元格的最大宽度限制 */
                white-space: nowrap; /* 防止产品名称在小屏幕上换行 */
            }
            /* 根据需要进行其他样式调整 */
        }
            /* 将表格包装在一个水平滚动容器内结束 */
            
.pagination {
    text-align: right; /* Align the pagination to the right */
    margin-top: 20px;
}

.pagination-link {
    margin: 0 5px;
    text-decoration: none;
    color: #333;
    border: 1px solid #ccc;
    padding: 5px 10px;
    border-radius: 5px;
}

.jump-input {
    width: 40px;
    padding: 2px;
    text-align: center;
}

.jump-button {
    padding: 2px 8px;
    background-color: #007bff;
    border: none;
    color: #fff;
    border-radius: 5px;
    cursor: pointer;
}

.jump-button:hover {
    background-color: #0056b3;
}



    </style>
</head>
<body>
<div class="navigation">
    <h1>{$Title}</h1>
    </div>
            <div class="navigation">
            <span class="ml-2"><a class="h5" href="/addons?_plugin=coupon_yby&_controller=index&_action=activitylist">领券中心</a></span>
            <span class="ml-2 underline"><a class="h5" href="/addons?_plugin=coupon_yby&_controller=index&_action=myactivity">我的优惠码</a></span>
            <span class="ml-2 underline"><a class="h5" href="/addons?_plugin=coupon_yby&_controller=index&_action=fanactivity">返现活动</a></span>
            <span class="ml-2"><a class="h5" href="/addons?_plugin=coupon_yby&_controller=index&_action=fanxian">返现列表</a></span>
            </div>
            <div class="table-container">
    <table>
        <tr>
            <th>活动名称</th>
            <th>产品名称</th>
            <th>主机ID</th>
            <th>返现类型</th>
            <th>返现金额</th>
            <th>返现时间</th>
            <th>来源</th>
            
        </tr>
        {foreach $userActivities as $claimRecord}
            <tr>
            <td>
            <span class="activity-name">{$claimRecord.activityname}</span>
            </td>
            <td>
            <span class="coupon-code">{$claimRecord.name}</span>
            </td>
            <td>
            <span class="activity-name"><a href="/servicedetail?id={$claimRecord.hostid}">{$claimRecord.hostid}</span>
            </td>
            <td>
            {if $claimRecord.discount_type == 'percent'}
            <span class="discount-type percent">折扣</span>
            {elseif $claimRecord.discount_type == 'fixed'}
            <span class="discount-type fixed">立减</span>
            {elseif $claimRecord.discount_type == 'fanpercent'}
            <span class="discount-type fanpercent">比例返现</span>
            {elseif $claimRecord.discount_type == 'fanfixed'}
            <span class="discount-type fanfixed">固定金额</span>
            {else}
            <span class="discount-type unknown">未知类型</span>
            {/if}
            </td>
            <td>
            {if $claimRecord.discount_type == 'percent'}
            <span class="discount-info percent">{$discount = 100 - $claimRecord.face_value}%</span>
            {elseif $claimRecord.discount_type == 'fixed'}
            <span class="discount-info fixed">{$claimRecord.face_value}元</span>
            {elseif $claimRecord.discount_type == 'fanpercent'}
            <span class="discount-info fanpercent">{$claimRecord.face_value}元</span>
            {elseif $claimRecord.discount_type == 'fanfixed'}
            <span class="discount-info fanfixed">{$claimRecord.face_value}元</span>
            {else}
            <span class="discount-info unknown">未知类型</span>
            {/if}
            </td>


            <td>
            <span class="received-date">{$claimRecord.back_time|date='Y-m-d H:i:s'}</span>
            </td>
            
            
            <td>
            <span class="activity-name">{$claimRecord.source}</span>
            </td>

            
            </tr>
        {/foreach}
        
        {if count($userActivities) == 0}
            <tr>
                <td colspan="10" class="fas fa-info-circle" style="text-align: center;">您暂时没有返现记录</td>
                
            </tr>
        {/if}
        
    </table>

<div class="pagination">
当前页码：{$currentPage = $userActivities->currentPage()}
总页码：{$totalPages = $userActivities->lastPage()}
    {if $currentPage > 1}
        <a href="/addons?_plugin=coupon_yby&_controller=index&_action=fanxian&page={$currentPage - 1}" class="pagination-link">上一页</a>
    {/if}
    {if $currentPage < $totalPages}
        <a href="/addons?_plugin=coupon_yby&_controller=index&_action=fanxian&page={$currentPage + 1}" class="pagination-link">下一页</a>
    {/if}
    <div class="pagination-jump">
        跳转到第
        <input type="number" id="jumpToPage" min="1" max="{$totalPages}" value="{$currentPage + 1}" style="width: 40px;"> 
        页
        <button onclick="jumpToPage()" class="jump-button">跳转</button> 
    </div>
    </div>




</body>



<script>
    function jumpToPage() {
        var jumpInput = document.getElementById('jumpToPage');
        var targetPage = parseInt(jumpInput.value); 
        if (targetPage >= 1 && targetPage <= <?php echo $totalPages; ?>) {
            var targetUrl = "/addons?_plugin=coupon_yby&_controller=index&_action=fanxian&page=" + targetPage;
            window.location.href = targetUrl;
        }
    }
</script>

