<?php
namespace addons\coupon_yby\controller\clientarea;

class IndexController extends \app\home\controller\PluginHomeBaseController
{
    public function activitylist()
    {
        $pastTimestamp = time() - 172800;
        $activities = \Think\Db::name("coupon_yby_list")->order("start_time desc")->select();
        $validActivityIds = [];
        foreach ($activities as $activity) {
            if ($pastTimestamp <= $activity["end_time"]) {
                $validActivityIds[] = $activity["id"];
            }
        }
        $page = input("page", 1);
        $pageSize = 9;
        $validActivities = \Think\Db::name("coupon_yby_list")->alias("a")->whereIn("a.id", $validActivityIds)->where("a.Distribution", 0)->leftJoin("products p", "FIND_IN_SET(p.id, a.applicable_products)")->field("a.*, IFNULL(GROUP_CONCAT(p.name SEPARATOR '， '), '全场可用') as product_names")->group("a.id")->order("a.start_time desc")->paginate($pageSize, false, ["page" => $page]);
        $renderedActivities = [];
        foreach ($validActivities as $activity) {
            if ($activity["Distribution"] == 0) {
                $renderedActivities[] = $activity;
            }
        }
        $data = \Think\Db::name("coupon_configurations")->where("id", 1)->find();
        $this->assign("data", $data);
        $this->assign("Title", "会员领券中心");
        $this->assign("Lists", $validActivities);
        return $this->fetch("/activitylist", ["List" => $renderedActivities]);
    }
    public function fanxian()
    {
        $user_id = request()->uid;
        $page = input("page", 1);
        $pageSize = 10;
        $userActivities = \Think\Db::name("coupon_yby_cashback")->where("user_id", $user_id)->paginate($pageSize, false, ["page" => $page]);
        $this->assign("Title", "返现记录");
        return $this->fetch("/fanxian", ["userActivities" => $userActivities]);
    }
    public function fanactivity()
    {
        $user_id = request()->uid;
        $pastTimestamp = time() - 172800;
        $activities = \Think\Db::name("coupon_yby_fanlilist")->where("mode", "=", 2)->order("start_time desc")->select();
        $validActivityIds = [];
        foreach ($activities as $activity) {
            if ($pastTimestamp <= $activity["end_time"]) {
                $fanProducts = explode(",", $activity["fan_products"]);
                $productNames = \Think\Db::name("products")->whereIn("id", $fanProducts)->column("name");
                $activity["product_names"] = [];
                foreach ($productNames as $key => $productName) {
                    $productId = $fanProducts[$key];
                    $productLink = url("/cart?action=configureproduct&pid=" . $productId);
                    $activity["product_names"][] = "<a href='" . $productLink . "'>" . $productName . "</a>";
                }
                $validActivityIds[] = $activity;
            }
        }
        $this->assign("Title", "返现活动");
        return $this->fetch("/fanactivity", ["List" => $validActivityIds, "user_id" => $user_id]);
    }
    public function myactivity()
    {
        $user_id = request()->uid;
        $userActivities = $this->getUserActivities($user_id);
        $this->assign("Title", "我的优惠码");
        return $this->fetch("/myactivity", ["userActivities" => $userActivities]);
    }
    private function getUserActivities($user_id)
    {
        $page = input("page", 1);
        $pageSize = 10;
        $userActivities = \Think\Db::name("coupon_yby_receive")->alias("acr")->leftJoin("products p", "FIND_IN_SET(p.id, acr.applicable_products)")->leftJoin("promo_code pc", "acr.coupon_code = pc.code")->where("acr.user_id", $user_id)->field("acr.*, GROUP_CONCAT(p.name) as applicable_product_names, pc.used as promo_code_used")->group("acr.id")->order("acr.received_at DESC")->paginate($pageSize, false, ["page" => $page]);
        return $userActivities;
    }
    public function receivelists()
    {
        if (request()->isPost()) {
            $id = input("post.id");
            $user_id = input("uid");
            $activity = \Think\Db::name("coupon_yby_list")->where("id", $id)->find();
            if (!$activity) {
                return json(["code" => 404, "msg" => "活动不存在"]);
            }
            $open_is = \Think\Db::name("coupon_configurations")->where("id", 1)->value("open_is");
            if ($open_is != 1) {
                return json(["code" => 400, "msg" => "活动功能未开启，请联系网站客服"]);
            }
            if (empty($user_id)) {
                $response = ["code" => 400, "msg" => "您未登录或登录已失效，请刷新页面"];
                return json($response);
            }
            $currentTime = time();
            $activityStartTime = $activity["start_time"];
            $activityEndTime = $activity["end_time"];
            if ($currentTime < $activityStartTime) {
                return json(["code" => 400, "msg" => "活动还未开始，敬请等待！！"]);
            }
            if ($activityEndTime < $currentTime) {
                return json(["code" => 400, "msg" => "【" . $activity["activityname"] . "】活动已经结束，下次请赶早！！！"]);
            }
            $isForNewUsers = $activity["is_for_new_users"];
            if ($isForNewUsers == 1) {
                $userExistsInHost = \Think\Db::name("host")->where("uid", $user_id)->find();
                if ($userExistsInHost) {
                    return json(["code" => 400, "msg" => "新用户专属活动，您不符合该活动的领取条件。"]);
                }
            }
            $fouser = $activity["is_available_for_agents"];
            if ($fouser != 1) {
                if ($fouser == 0) {
                    $isyes = \Think\Db::name("clients")->where("id", $user_id)->find();
                    $group_id = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
                    $groupname = \Think\Db::name("client_groups")->where("id", $group_id)->value("group_name");
                    if ($group_id != 0) {
                        return json(["code" => 400, "msg" => "抱歉，该活动仅限普通用户参与，您的等级为：" . $groupname]);
                    }
                }
            }
            $certification = $activity["certification"];
            if ($certification != 0) {
                if ($certification == 1) {
                    $certifi_person = \Think\Db::name("certifi_person")->where("auth_user_id", $user_id)->find();
                    $certifi_company = \Think\Db::name("certifi_company")->where("auth_user_id", $user_id)->find();
                    $can_receive = false;
                    if ($certifi_person) {
                        $can_receive = $certifi_person["status"] == 1;
                    }
                    if (!$can_receive && $certifi_company) {
                        $can_receive = $certifi_company["status"] == 1;
                    }
                    if (!$certifi_person && !$certifi_company) {
                        return json(["code" => 403, "msg" => "本活动仅限实名认证用户领取，请实名认证后再参与活动！"]);
                    }
                    if (!$can_receive) {
                        return json(["code" => 403, "msg" => "本活动仅限实名认证用户领取，您的账号目前暂未通过认证！"]);
                    }
                }
            }
            $userGroupResult = \Think\Db::name("clients")->where("id", $user_id)->value("groupid");
            if ($userGroupResult === NULL) {
                return json(["code" => 400, "msg" => "用户不存在"]);
            }
            $activityClientGroupId = $activity["client_group_id"];
            if ($activityClientGroupId != "0") {
                $allowedGroupIds = explode(",", $activityClientGroupId);
                if (!in_array($userGroupResult, $allowedGroupIds)) {
                    return json(["code" => 400, "msg" => "本活动为专属活动，您非本次活动的邀请对象，请参与其他活动"]);
                }
            }
            $activityClientId = $activity["clientid"];
            if ($activityClientId !== NULL) {
                if ($activityClientId != "") {
                    if ($user_id != $activityClientId) {
                        return json(["code" => 400, "msg" => "本活动为专属用户活动，您非本次活动的邀请对象，请参与其他活动"]);
                    }
                }
            }
            $ding_products = $activity["ding_products"];
            if ($ding_products) {
                $allowedGroupIds = explode(",", $ding_products);
                $productsResult = \Think\Db::name("host")->where("uid", $user_id)->where("productid", "in", $allowedGroupIds)->where("domainstatus", "Active")->find();
                $productNames = \Think\Db::name("products")->where("id", "in", $allowedGroupIds)->column("name");
                $productNamesStr = implode("， ", $productNames);
                if (!$productsResult) {
                    return json(["code" => 400, "msg" => "您当前不拥有以下正在使用中的产品：" . $productNamesStr . " ，请参与其他活动"]);
                }
            }
            if (!empty($activity["cycle"])) {
                $total_monthpaid = \Think\Db::name("invoices")->where("uid", $user_id)->where("status", "Paid")->where("paid_time", ">", strtotime("-" . $activity["cycle"] . " days"))->where("type", "<>", "recharge")->sum("subtotal");
                if ($total_monthpaid <= $activity["amount"]) {
                    $response = ["code" => 400, "msg" => "领取该券需要" . $activity["cycle"] . "天内消费金额满" . $activity["amount"] . "元，您当前消费金额为" . $total_monthpaid . " 元"];
                    return json($response);
                }
            }
            $userClaims = \Think\Db::name("coupon_yby_receive")->where("user_id", $user_id)->where("activity_id", $id)->count();
            if ($activity["max_usage_per_user"] <= $userClaims) {
                return json(["code" => 400, "msg" => "当前活动每人限领【" . $activity["max_usage_per_user"] . "】张，您领取到达上限，请选择其他活动！"]);
            }
            if ($activity["total_quantity"] <= $activity["claim_count"]) {
                return json(["code" => 400, "msg" => "活动已领取的数量已达上限"]);
            }
            $receptionSuccess = true;
            if ($receptionSuccess) {
                $couponCode = $this->generateRandomCouponCode();
                $count = \Think\Db::name("coupon_yby_list")->where("id", $id)->value("claim_count");
                if ($count === NULL) {
                    \Think\Db::name("coupon_yby_list")->where("id", $id)->update(["claim_count" => 1]);
                } else {
                    \Think\Db::name("coupon_yby_list")->where("id", $id)->setInc("claim_count");
                }
                $result = \Think\Db::name("coupon_yby_receive")->insert(["user_id" => $user_id, "activity_id" => $id, "received_at" => time(), "coupon_code" => $couponCode, "activityname" => $activity["activityname"], "total_quantity" => $activity["total_quantity"], "max_usage_per_user" => $activity["max_usage_per_user"], "start_time" => $activity["start_time"], "end_time" => $activity["end_time"], "validity" => time() + $activity["validity"] * 3600, "applicable_products" => $activity["applicable_products"], "discount_type" => $activity["discount_type"], "face_value" => $activity["face_value"], "settlementCycle" => $activity["settlementCycle"], "is_recurring" => $activity["is_recurring"], "is_available_for_agents" => $activity["is_available_for_agents"], "max_usage_per_code" => $activity["max_usage_per_code"], "is_one_time_valid" => $activity["is_one_time_valid"], "is_for_new_users" => $activity["is_for_new_users"], "is_for_existing_users" => $activity["is_for_existing_users"], "is_single_use_per_user" => $activity["is_single_use_per_user"], "is_for_upgrade_downgrade" => $activity["is_for_upgrade_downgrade"], "source" => "领券中心"]);
                if ($result) {
                    $bTableData = ["code" => $couponCode, "type" => $activity["discount_type"], "recurring" => $activity["is_recurring"], "value" => $activity["face_value"], "cycles" => $activity["settlementCycle"], "appliesto" => $activity["applicable_products"], "start_time" => $activity["start_time"], "expiration_time" => time() + $activity["validity"] * 3600, "max_times" => $activity["max_usage_per_code"], "lifelong" => $activity["is_for_upgrade_downgrade"], "one_time" => $activity["is_one_time_valid"], "only_new_client" => $activity["is_for_new_users"], "only_old_client" => $activity["is_for_existing_users"], "once_per_client" => $activity["is_single_use_per_user"], "notes" => "来源：领券中心，用户ID：" . $user_id . "，活动名称：" . $activity["activityname"] . " (活动ID：" . $id . ")，领取时间：" . date("Y-m-d H:i:s", time()), "is_discount" => $activity["is_available_for_agents"]];
                    $applicableProducts = $activity["applicable_products"];
                    $applicableProductsArray = explode(",", $applicableProducts);
                    \Think\Db::name("promo_code")->insert($bTableData);
                }
                if ($result) {
                    $message = "领取成功";
                    if (!empty($applicableProductsArray)) {
                        $links = [];
                        foreach ($applicableProductsArray as $product) {
                            $productId = \Think\Db::name("products")->where("id", $product)->value("id");
                            if ($productId) {
                                $productName = \Think\Db::name("products")->where("id", $productId)->value("name");
                                $link = "/cart?action=configureproduct&pid=" . $product . "&promocode=" . $couponCode;
                                $links[] = "<a href=\"" . $link . "\" target=\"_blank\"> " . $productName . "</a>";
                            } else {
                                $links[] = "全场可用";
                            }
                        }
                        $message = "领取成功，优惠码适用以下产品：<br>" . implode("，", $links);
                        $emailsConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
                        if (!$emailsConfig) {
                            return false;
                        }
                        $code = $couponCode;
                        $type = $activity["discount_type"] === "percent" ? "折扣" : ($activity["discount_type"] === "fixed" ? "立减" : "未知类型");
                        $discount = $activity["discount_type"];
                        $value = $discount === "percent" ? 100 - $activity["face_value"] . "%" : ($discount === "fixed" ? $activity["face_value"] . "元" : "未知值");
                        $cyclesMapping = ["day" => "日付", "monthly" => "月付", "quarterly" => "季付", "semiannually" => "半年付", "annually" => "年付"];
                        $cycles = isset($cyclesMapping[$activity["settlementCycle"]]) ? $cyclesMapping[$activity["settlementCycle"]] : "不限";
                        $products = $activity["applicable_products"];
                        if (!empty($products)) {
                            $productIDs = explode(",", $products);
                            $productNames = [];
                            foreach ($productIDs as $productID) {
                                $productName = \Think\Db::name("products")->where("id", $productID)->value("name");
                                if ($productName) {
                                    $productNames[] = $productName;
                                }
                            }
                            $products = implode(", ", $productNames);
                        } else {
                            $products = "所有产品可用";
                        }
                        $start_time = date("Y-m-d H:i:s", $activity["start_time"]);
                        $end_time = date("Y-m-d H:i:s", $activity["end_time"]);
                        $time = date("Y-m-d H:i:s", time());
                        $validity = date("Y-m-d H:i:s", time() + $activity["validity"] * 3600);
                        $notes = "领券中心领取";
                        $activityname = $activity["activityname"];
                        $clientInfo = \Think\Db::name("clients")->where("id", $user_id)->field("email, username")->find();
                        $recipientEmail = $clientInfo["email"];
                        $email = $clientInfo["email"];
                        $name = $clientInfo["username"];
                        $emailSubject = $emailsConfig["emailsubject2"];
                        $emailSubject = str_replace("\$start_time", $start_time, $emailSubject);
                        $emailSubject = str_replace("\$end_time", $end_time, $emailSubject);
                        $emailSubject = str_replace("\$products", $products, $emailSubject);
                        $emailSubject = str_replace("\$type", $type, $emailSubject);
                        $emailSubject = str_replace("\$validity", $validity, $emailSubject);
                        $emailSubject = str_replace("\$value", $value, $emailSubject);
                        $emailSubject = str_replace("\$activityname", $activityname, $emailSubject);
                        $emailSubject = str_replace("\$code", $code, $emailSubject);
                        $emailMessage = $emailsConfig["email_content2"];
                        $emailMessage = html_entity_decode($emailMessage);
                        $emailMessage = str_replace("\$email", $email, $emailMessage);
                        $emailMessage = str_replace("\$name", $name, $emailMessage);
                        $emailMessage = str_replace("\$code", $code, $emailMessage);
                        $emailMessage = str_replace("\$products", $products, $emailMessage);
                        $emailMessage = str_replace("\$type", $type, $emailMessage);
                        $emailMessage = str_replace("\$value", $value, $emailMessage);
                        $emailMessage = str_replace("\$cycles", $cycles, $emailMessage);
                        $emailMessage = str_replace("\$start_time", $start_time, $emailMessage);
                        $emailMessage = str_replace("\$end_time", $end_time, $emailMessage);
                        $emailMessage = str_replace("\$time", $time, $emailMessage);
                        $emailMessage = str_replace("\$validity", $validity, $emailMessage);
                        $emailMessage = str_replace("\$activityname", $activityname, $emailMessage);
                        $emailMessage = str_replace("\$notes", $notes, $emailMessage);
                        $emailSent = $this->sendEmail($recipientEmail, $emailSubject, $emailMessage);
                        $client_ip = "";
                        if (isset($_SERVER["HTTP_CLIENT_IP"])) {
                            $client_ip = $_SERVER["HTTP_CLIENT_IP"];
                        } else {
                            if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
                                $client_ip = $_SERVER["HTTP_X_FORWARDED_FOR"];
                            } else {
                                if (isset($_SERVER["HTTP_X_FORWARDED"])) {
                                    $client_ip = $_SERVER["HTTP_X_FORWARDED"];
                                } else {
                                    if (isset($_SERVER["HTTP_FORWARDED_FOR"])) {
                                        $client_ip = $_SERVER["HTTP_FORWARDED_FOR"];
                                    } else {
                                        if (isset($_SERVER["HTTP_FORWARDED"])) {
                                            $client_ip = $_SERVER["HTTP_FORWARDED"];
                                        } else {
                                            if (isset($_SERVER["REMOTE_ADDR"])) {
                                                $client_ip = $_SERVER["REMOTE_ADDR"];
                                            } else {
                                                $client_ip = "UNKNOWN";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        $client_port = $_SERVER["REMOTE_PORT"];
                        $activity_log = ["uid" => $user_id, "description" => "前端领券中心，<a href=\"#/customer-view/abstract?id=" . $user_id . "\">User ID:" . $user_id . "</a> 活动：" . $activity["activityname"] . "【ID:" . $id . "】，券码：" . $code, "user" => $name, "port" => $client_port, "create_time" => time(), "ipaddr" => $client_ip, "type" => 1, "activeid" => $user_id, "usertype" => "Client", "type_data_id" => ""];
                        \Think\Db::name("activity_log")->insert($activity_log);
                        if (!$emailsConfig || $emailsConfig["smtp_is2"] != 1) {
                            if ($emailSent) {
                                return json(["code" => 200, "msg" => $message]);
                            }
                            return json(["code" => 200, "msg" => $message]);
                        }
                        $sentStatus = $emailSent ? 1 : 0;
                        $failReason = $sentStatus ? "发送成功" : "发送失败-SMTP信息错误";
                        $logData = ["uid" => $user_id, "subject" => $emailSubject, "message" => $emailMessage, "to" => $recipientEmail, "create_time" => time(), "is_admin" => 0, "ip" => $client_ip, "port" => $client_port, "status" => $sentStatus, "fail_reason" => $failReason];
                        \Think\Db::name("email_log")->insert($logData);
                        if ($emailSent) {
                            return json(["code" => 200, "msg" => $message]);
                        }
                        return json(["code" => 200, "msg" => $message]);
                    } else {
                        return json(["code" => 500, "msg" => "领取结果写入失败"]);
                    }
                }
            }
        }
    }
    private function generateRandomCouponCode($length = 10)
    {
        $characters = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $couponCode = "";
        for ($i = 0; $i < $length; $i++) {
            $couponCode .= $characters[random_int(0, strlen($characters) - 1)];
        }
        return $couponCode;
    }
    private function sendEmail($recipient, $subject, $message)
    {
        $emailConfig = \Think\Db::name("coupon_configurations")->where("id", "1")->find();
        if (!$emailConfig || $emailConfig["smtp_is2"] != 1) {
            return false;
        }
        $mail = new \PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->CharSet = "UTF-8";
            $mail->Host = $emailConfig["smtp_host"];
            $mail->SMTPAuth = true;
            $mail->Username = $emailConfig["smtp_name"];
            $mail->Password = $emailConfig["smtp_pass"];
            $mail->SMTPSecure = $emailConfig["smtp_secure"];
            $mail->Port = $emailConfig["smtp_port"];
            $mail->setFrom($emailConfig["smtp_name"], $emailConfig["from_name"]);
            $mail->addAddress($recipient);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $message;
            $mail->send();
            return true;
        } catch (\PHPMailer\PHPMailer\Exception $e) {
            return $e->getMessage();
        }
    }
}

?>