<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>优惠活动</title>
    <link rel="stylesheet" href="path/to/bootstrap.min.css">
    <link rel="stylesheet" href="path/to/fontawesome.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .card {
            border: none;
            border-radius: 5px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .card-title {
            font-size: 1.5rem;
            color: #333;
            margin-bottom: 0.5rem;
        }
        .head-title {
            font-size: 1.5rem;
            color: #333;
            margin-bottom: 0.5rem;
        }
        .card-text {
            font-size: 1rem;
            color: #555;
            margin-bottom: 0.25rem;
        }
        .btn-link {
            color: #d9534f;
            text-decoration: none;
            transition: color 0.3s;
        }
        .btn-link:hover {
            color: #c9302c;
        }
        
    .navigation {
        background-color: #f2f2f2;
        padding: 10px;
        display: flex;
        justify-content: center;
    }

    .navigation span {
        margin-left: 10px;
    }

    .navigation a {
        text-decoration: none;
        color: #333;
        font-size: 18px;
    }

    .navigation a:hover {
        text-decoration: underline;
    }
    
    .admin-navigation {
      background-color: #343a40;
      color: #ffffff;
      padding: 15px 0;
      text-align: center;
    }
    .h5-navigation {
      color: #ffffff;
      text-decoration: underline;
    }
    </style>
</head>
<body>
<script src="/plugins/addons/coupon_yby/assets/layer.js"></script>
<section class="admin-main">
  <div class="container-fluid">
    <div class="page-container">
      <div class="card">
        <div class="card-body">
          <div class="head-title rows">
          <div class="navigation">
          <h1>{$Title}</h1>
          </div>
            <div class="navigation">
            <span class="ml-2"><a class="h5-navigation" href="/addons?_plugin=coupon_yby&_controller=index&_action=activitylist">领券中心</a></span>
            <span class="ml-2 underline"><a class="h5-navigation" href="/addons?_plugin=coupon_yby&_controller=index&_action=myactivity">我的优惠码</a></span>
            <span class="ml-2 underline"><a class="h5-navigation" href="/addons?_plugin=coupon_yby&_controller=index&_action=fanactivity">返现活动</a></span>
            <span class="ml-2"><a class="h5-navigation" href="/addons?_plugin=coupon_yby&_controller=index&_action=fanxian">返现列表</a></span>
            </div>
            
            <div class="col-lg-8 col-md-12 col-sm-12">
              {foreach $PluginsAdminMenu as $v}
                {if $v['custom']}
                  <span class="ml-2"><a class="h5" href="{$v.url}" target="_blank">{$v.name}</a></span>
                {else/}
                  <span class="ml-2"><a class="h5" href="{$v.url}">{$v.name}</a></span>
                {/if}
              {/foreach}
            </div>
          </div>
          
          

<div class="tab-content mt-4">
    {if empty($List)}
        <h2 style="text-align: center;">
    <i class="fas fa-info-circle"></i> 暂无活动信息。
</h2>
    {else}
    <div class="table-body table-responsive">
        <div class="scrollable-container" style="max-height: 550px; overflow: auto;">
            <div class="row">
                {volist name='List' id='v'}
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="card mb-4" style="background: linear-gradient(to bottom, #ced0d2, #fff); border: 1px solid #ced4da; border-radius: 5px; position: relative;">
                        <div class="activity-status" style="position: absolute; top: 10px; right: 10px;">
                            {if $v.start_time > time()}
                                <span class="badge badge-primary">未开始</span>
                            {elseif $v.end_time < time()}
                                <span class="badge badge-secondary">已结束</span>
                            {elseif ($v.total_quantity - $v.claim_count) <= 0}
                                <span class="badge badge-warning">名额已满</span>
                            {else}
                                <span class="badge badge-success">进行中</span>
                            {/if}
                        </div>
                        <div class="card-body">
                            <h5 class="card-title">{$v.activityname}</h5>
                            <p class="card-text">返现类型： 
                                {if $v.discount_type == 'percent'}
                                    比例返现
                                {elseif $v.discount_type == 'fixed'}
                                    固定金额
                                {/if}
                            </p>
                            <p class="card-text">返现金额： 
                                {if $v.discount_type == 'percent'}
                                    {$discount =$v.face_value}%
                                {elseif $v.discount_type == 'fixed'}
                                    {$v.face_value}元
                                {/if}
                            </p>
                            <p class="card-text">返现方式： 账户余额</p>
                            <p class="card-text">参与用户： 
                                {if $v.is_available_for_agents == '0'}
                                    普通用户
                                {elseif $v.is_available_for_agents == '1'}
                                    全部用户
                                {/if}
                            </p>
                            <p class="card-text">限制次数： {$v.max_usage_per_user} 次/每人</p>
                            <p class="card-text">剩余数量： {$v.total_quantity - $v.claim_count} 名</p>
                            
                            <p class="card-text">返现产品： 
                                {foreach $v['product_names'] as $productLink}
                                    {$productLink} 
                                {/foreach}
                            </p>
                            <p class="card-text">开始时间： {$v.start_time|date="Y-m-d H:i:s"}</p>
                            <p class="card-text">结束时间： {$v.end_time|date="Y-m-d H:i:s"}</p>
                            
                        </div>
                        </div>
                    </div>
                {/volist}
            </div>
        </div>
    </div>
    {/if}
</div>


</body>
</html>
