<?php
namespace addons\customer_service_gzhx;

class CustomerServiceGzhxPlugin extends \app\admin\lib\Plugin
{
    public $info = ["name" => "CustomerServiceGzhx", "title" => "自动分配客服", "description" => "自动为用户分配销售客服", "status" => 1, "author" => "GZHX Technology", "version" => "1.0.2", "module" => "addons"];
    public function install()
    {
        $DbConfig = \Think\Db::getConfig();
        $CacheDbName = $DbConfig["prefix"] . "customer_service_gzhx";
        $tableList = \Think\Db::query("SELECT table_name FROM information_schema.TABLES WHERE TABLE_SCHEMA='" . $DbConfig["database"] . "'");
        $tableList = array_column($tableList, "table_name");
        if (!in_array($CacheDbName, $tableList)) {
            \Think\Db::query("CREATE TABLE `" . $CacheDbName . "`  (`id` int NOT NULL,`face` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`qq` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`info` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`tel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`wechat_pic` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`wechat` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL,`last` tinyint(2) NULL DEFAULT 1,`status` tinyint(2) NULL DEFAULT 1,PRIMARY KEY (`id`),UNIQUE INDEX `id`(`id`));");
        }
        return true;
    }
    public function uninstall()
    {
        return true;
    }
    public function getCustomerService($uid)
    {
        $CustomerService = \Think\Db::name("customer_service_gzhx")->alias("a")->join("user b", "a.id=b.id")->join("clients c", "c.sale_id=a.id")->where("b.is_sale", "=", 1)->where("a.status", "=", 2)->where("c.id", "=", $uid)->field("a.*,b.user_nickname")->find();
        if (empty($CustomerService)) {
            $CustomerService = \Think\Db::name("customer_service_gzhx")->alias("a")->join("user b", "a.id=b.id")->where("b.is_sale", "=", 1)->where("a.status", "=", 2)->where("a.last", "=", 2)->field("a.*,b.user_nickname")->find();
            if (empty($CustomerService)) {
                $CustomerService = \Think\Db::name("customer_service_gzhx")->alias("a")->join("user b", "a.id=b.id")->where("b.is_sale", "=", 1)->where("a.status", "=", 2)->field("a.*,b.user_nickname")->order("a.id asc")->find();
            } else {
                $CustomerService = \Think\Db::name("customer_service_gzhx")->alias("a")->join("user b", "a.id=b.id")->where("b.is_sale", "=", 1)->where("a.status", "=", 2)->where("a.last", "=", 1)->where("a.id", ">", $CustomerService["id"])->field("a.*,b.user_nickname")->order("a.id asc")->find();
            }
            if (empty($CustomerService)) {
                $CustomerService = \Think\Db::name("customer_service_gzhx")->alias("a")->join("user b", "a.id=b.id")->where("b.is_sale", "=", 1)->where("a.status", "=", 2)->field("a.*,b.user_nickname")->order("a.id asc")->find();
            }
            if (!empty($CustomerService)) {
                \Think\Db::name("clients")->where("id", "=", $uid)->update(["sale_id" => $CustomerService["id"]]);
                \Think\Db::name("customer_service_gzhx")->where("last", "=", 2)->update(["last" => 1]);
                \Think\Db::name("customer_service_gzhx")->where("id", "=", $CustomerService["id"])->update(["last" => 2]);
            }
        }
        return $CustomerService;
    }
    public function clientLogin($param)
    {
        $this->getCustomerService($param["uid"]);
    }
}

?>