<?php
namespace addons\dailizs\controller;

class AdminIndexController extends \app\admin\controller\PluginAdminBaseController
{
    private $_config = [];
    private $lang;
    public function initialize()
    {
        parent::initialize();
        if (file_exists(dirname(__DIR__) . "/config/config.php")) {
            $con = (require dirname(__DIR__) . "/config/config.php");
        } else {
            $con = [];
        }
        $this->_config = array_merge($con, $this->getPlugin()->getConfig());
        $lang = request()->languagesys;
        if (empty($lang)) {
            $lang = configuration("language") ? configuration("language") : config("default_lang");
        }
        if ($lang == "CN") {
            $lang = "chinese";
        } else {
            if ($lang == "US") {
                $lang = "english";
            } else {
                if ($lang == "HK") {
                    $lang = "chinese_tw";
                }
            }
        }
        $this->lang = $lang;
    }
    public function gxkucun()
    {
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch();
        }
        $ku = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->select();
        $this->assign("ku", $ku);
        $this->assign("Title", "同步更新上级库存");
        return $this->fetch();
    }
    public function kucun()
    {
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch();
        }
        $ku = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->where("upstream_qty", ">", "0")->select();
        $this->assign("ku", $ku);
        $this->assign("Title", "显示上级库存不为0");
        return $this->fetch();
    }
    public function jilu()
    {
        $this->assign("Title", "清理记录");
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch("/jilu");
        }
        $dlzs = \think\Db::table("shd_dailizs")->where("key", 1)->order("time desc")->limit(1000)->select();
        $this->assign("dlzs", $dlzs);
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        $ffzj = \think\Db::table("shd_dailizs")->select();
        $zjls = count($ffzj);
        $this->assign("ff", $ff);
        $this->assign("zjls", $zjls);
        return $this->fetch("/jilu");
    }
    public function jlql()
    {
        $gx = \think\Db::table("shd_dailizs")->delete(true);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "清理条数" . $gx . "条！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有清理的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function shangpin()
    {
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch("/shangpin");
        }
        $yjfl = \think\Db::table("shd_product_first_groups")->order("order asc")->select()->toArray();
        $fl = \think\Db::table("shd_product_groups")->order("order asc")->select()->toArray();
        $flid = input("param.fl/d");
        $spyc = input("param.yc/d");
        if (0 < $flid && 0 <= $spyc) {
            $ku = \think\Db::table("shd_products")->where("gid", $flid)->where("hidden", $spyc)->order("order asc")->select()->toArray();
            $hostActive = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) as shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid WHERE shd_host.domainstatus='Active' GROUP BY shd_products.id");
            $hostAll = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) AS shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid GROUP BY shd_products.id");
        } else {
            if (0 < $flid && $spyc < 0) {
                $ku = \think\Db::table("shd_products")->where("gid", $flid)->order("order asc")->select()->toArray();
                $hostActive = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) as shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid WHERE shd_host.domainstatus='Active' GROUP BY shd_products.id");
                $hostAll = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) AS shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid GROUP BY shd_products.id");
            } else {
                if ($flid < 0 && 0 <= $spyc) {
                    $ku = \think\Db::table("shd_products")->where("hidden", $spyc)->order("order asc")->select()->toArray();
                    $hostActive = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) as shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid WHERE shd_host.domainstatus='Active' GROUP BY shd_products.id");
                    $hostAll = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) AS shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid GROUP BY shd_products.id");
                } else {
                    $flid = -1;
                    $spyc = -1;
                    $ku = \think\Db::table("shd_products")->order("order asc")->select()->toArray();
                    $hostActive = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) as shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid WHERE shd_host.domainstatus='Active' GROUP BY shd_products.id");
                    $hostAll = \think\Db::query("SELECT shd_products.id,shd_products.name,shd_host.domainstatus,COUNT(shd_products.id) AS shu FROM shd_products INNER JOIN shd_host ON shd_products.id=shd_host.productid GROUP BY shd_products.id");
                }
            }
        }
        $apiname = \think\Db::table("shd_zjmf_finance_api")->select();
        for ($i = 0; $i < count($ku); $i++) {
            $ku[$i]["total"] = 0;
            $ku[$i]["Active"] = 0;
            for ($j = 0; $j < count($hostAll); $j++) {
                if ($hostAll[$j]["id"] === $ku[$i]["id"]) {
                    $ku[$i]["total"] = $hostAll[$j]["shu"];
                    break;
                }
            }
            for ($l = 0; $l < count($hostActive); $l++) {
                if ($hostActive[$l]["id"] === $ku[$i]["id"]) {
                    $ku[$i]["Active"] = $hostActive[$l]["shu"];
                    break;
                }
            }
        }
        $this->assign("ku", $ku);
        $this->assign("apiname", $apiname);
        $this->assign("sp", $sp);
        $this->assign("yjfl", $yjfl);
        $this->assign("fl", $fl);
        $this->assign("spyc", $spyc);
        $this->assign("flid", $flid);
        $this->assign("Title", "商品管理");
        return $this->fetch("/shangpin");
    }
    public function yjgx()
    {
        $gx = \think\Db::table("shd_products")->where("upstream_stock_control", 1)->update(["stock_control" => \think\Db::raw("upstream_stock_control"), "qty" => \think\Db::raw("upstream_qty")]);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "同步条数" . $gx . "同步成功！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有同步的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function yjhy()
    {
        $gx = \think\Db::table("shd_products")->where("upstream_stock_control", ">", "0")->where("upstream_qty", ">", "0")->update(["stock_control" => 0, "qty" => 0]);
        if (0 < $gx) {
            $jgjson = ["code" => "1", "msg" => "还原条数" . $gx . "还原成功！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "0", "msg" => "没有还原的数据！"];
            echo json_encode($jgjson);
        }
    }
    public function gxkc()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入id");
        }
        foreach ($ids as $id) {
            $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
            $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["stock_control" => $gxkc["upstream_stock_control"], "qty" => $gxkc["upstream_qty"]]);
        }
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "同步条数" . strval($gxjg) . "同步失败,没有可同步的数据！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "同步条数" . strval($gxjg) . "同步成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
    public function hy()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入id");
        }
        foreach ($ids as $id) {
            $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
            $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["stock_control" => 0, "qty" => 0]);
        }
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原失败,没有可还原的数据！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
    public function zidong()
    {
        $this->assign("Title", "自动同步");
        $ffidc = $_SERVER["HTTP_HOST"];
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ffidc !== $ff["ffidc"]) {
            $ffb = "请用第一次安装域名使用本插件";
            $this->assign("ffb", $ffb);
            return $this->fetch("/zidong");
        }
        $dirww = $_SERVER["DOCUMENT_ROOT"];
        $file = $dirww . "/plugins/addons/dailizs/template/zidong.php";
        $file_new = $dirww . "/dailizs/zidong.php";
        $dir = iconv("UTF-8", "GBK", "dailizs");
        if (!file_exists($dir)) {
            mkdir($dir, 511, true);
        }
        if (!file_exists($file_new)) {
            copy($file, $file_new);
        }
        $dlzs = \think\Db::table("shd_dailizs")->where("key", 1)->order("time desc")->limit(1000)->select();
        $this->assign("dlzs", $dlzs);
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        $this->assign("ff", $ff);
        return $this->fetch("/zidong");
    }
    public function dlzscf()
    {
        $ids = explode(",", input("param.ids"));
        if (empty($ids)) {
            $this->error("请传入key");
        }
        $ff = \think\Db::table("shd_dailizs_cf")->where("id", 1)->find();
        if ($ff["key"] == $ids[0]) {
            $jgjson = ["code" => "0", "msg" => "请输入新的key"];
            echo json_encode($jgjson);
            exit;
        }
        $gxjg = \think\Db::table("shd_dailizs_cf")->where("id", 1)->update(["key" => $ids[0]]);
        if ($gxjg == 0) {
            $jgjson = ["code" => "0", "msg" => "修改失败！"];
            echo json_encode($jgjson);
        } else {
            $jgjson = ["code" => "1", "msg" => "修改成功！"];
            echo json_encode($jgjson);
        }
        exit;
    }
    public function tjyc()
    {
        $txt = "";
        $ids = input("param.ids");
        $txt = input("param.txt");
        if (empty($ids) || empty($txt)) {
            $this->error("请传入值或方法");
            exit;
        }
        switch ($txt) {
            case "yc":
                $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $ids)->update(["hidden" => 1]);
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "没有隐藏的数据或本商品已是隐藏！"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => "隐藏成功！"];
                    echo json_encode($jgjson);
                }
                break;
            case "hy":
                $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $ids)->update(["hidden" => 0]);
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "没有还原的数据或本商品已是未隐藏！"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => " 还原成功！"];
                    echo json_encode($jgjson);
                }
                break;
            case "sc":
                $gxkc = \think\Db::table("shd_host")->where("productid", $ids)->find();
                if ($gxkc) {
                    $jgjson = ["code" => "0", "msg" => "不能删除已开通主机的产品。如果要删除，请先重新分配或者删除使用了该产品的主机。"];
                    echo json_encode($jgjson);
                    exit;
                }
                $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $ids)->delete();
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "删除失败或已删除了本商品"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => "删除成功"];
                    echo json_encode($jgjson);
                }
                break;
            case "plyc":
                $ids = explode(",", input("param.ids"));
                foreach ($ids as $id) {
                    $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
                    $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["hidden" => 1]);
                }
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "隐藏条数" . strval($gxjg) . "隐藏失败,没有可隐藏的数据！"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "隐藏条数" . strval($gxjg) . "隐藏成功！"];
                    echo json_encode($jgjson);
                }
                break;
            case "plhy":
                $ids = explode(",", input("param.ids"));
                foreach ($ids as $id) {
                    $gxkc = \think\Db::table("shd_products")->where("id", $id)->find();
                    $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->update(["hidden" => 0]);
                }
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原失败,没有可隐藏的数据！"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "还原条数" . strval($gxjg) . "还原成功！"];
                    echo json_encode($jgjson);
                }
                break;
            case "plsc":
                $ids = explode(",", input("param.ids"));
                foreach ($ids as $id) {
                    $gxkc = \think\Db::table("shd_host")->where("productid", $id)->find();
                    if (!$gxkc) {
                        $gxjg = $gxjg + \think\Db::table("shd_products")->where("id", $id)->delete();
                    }
                }
                if ($gxjg == 0) {
                    $jgjson = ["code" => "0", "msg" => "选择条数" . strval(count($ids)) . "删除条数" . strval($gxjg) . "删除失败,没有可删除的数据或已开通主机商品不能删除！"];
                    echo json_encode($jgjson);
                } else {
                    $jgjson = ["code" => "1", "msg" => "选择条数" . strval(count($ids)) . "删除条数" . strval($gxjg) . "删除成功！"];
                    echo json_encode($jgjson);
                }
                break;
            default:
                $jgjson = ["code" => "0", "msg" => "操作失败,非法操作！"];
                echo json_encode($jgjson);
                exit;
        }
    }
}

?>