<script src="/plugins/addons/delete_user/assets/layer.js"></script>
    <style>
        table {
            border-collapse: collapse;
            width: 100%;
        }

        th, td {
            border: 1px solid #ddd;
            text-align: left;
            padding: 8px;
        }

        th {
            background-color: #f2f2f2;
        }

        tr:nth-child(even) {
            background-color: #f2f2f2;
        }
.img-fluid {
    max-height: 100%; 
    max-width: 100%; 
    display: block; 
    margin: 0 auto; 
}
.pending {
    background-color: #FFD700; 
    color: #333; 
    padding: 5px 10px; 
    border-radius: 5px; 
    display: inline-block; 
}
.approved {
    background-color: #008000; 
    color: #fff; 
    padding: 5px 10px;
    border-radius: 5px;
    display: inline-block;
}
.rejected {
    background-color: #FF0000; 
    color: #fff; 
    padding: 5px 10px;
    border-radius: 5px;
    display: inline-block;
}
.circle {
    background-color: #800080; 
    color: #fff; 
    padding: 5px 10px;
    border-radius: 5px;
    display: inline-block;
}
    .center {
        text-align: center;
    }
    .coupon-code-cell {
        padding: 10px;
        border: 1px solid #ccc;
        font-size: 14px;
        color: #333;
        background-color: #f5f5f5;
        border-radius: 6px;
        display: inline-block;
        transition: transform 0.3s, background-color 0.3s;
        cursor: pointer;
    }
    .coupon-code-cell:hover {
        transform: scale(1.05);
        background-color: #f0f0f0;
    }
    .center {
        text-align: center;
    }
    .product-names-cell {
        max-width: 500px;
        padding: 10px;
        border: 1px solid #ccc;
        font-size: 14px;
        color: #333;
        border-radius: 6px;
        display: inline-block;
        word-wrap: break-word;
    }
.discount-type {
    font-weight: bold;
    text-align: center; 
    padding: 10px;
    border: 1px solid #ccc;
    display: flex; 
    justify-content: center; 
    align-items: center; 
}
.discount-types {
    font-weight: bold;
    text-align: center; 
}
    .discount-cell {
        font-weight: bold;
        text-align: center;
        padding: 10px;
        border: 1px solid #ccc;
    }
    .discount-label {
        display: inline-block;
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 14px;
    }
    .percent-discount {
        background-color: #ffbc21;
        color: #333;
    }
    .fixed-discount {
        background-color: green;
        color: white;
    }
    .ali-discount {
        background-color: #007bff;
        color: #fff;
    }
    .wx-discount {
        background-color: green;
        color: white;
    }
    .qq-discount {
        background-color: red;
        color: white;
    }
    .bank-discount {
        background-color: #d0b03e;
        color: white;
    }
.status-label {
  position: relative;
}
.status-label::before {
  content: attr(data-tooltip); 
  position: absolute;
  background-color: #333;
  color: white;
  padding: 5px;
  border-radius: 5px;
  display: none;
  z-index: 1;
  top: 100%; 
  left: 50%;
  transform: translateX(-50%);
}
.status-label:hover::before {
  display: block; 
}
.pagination {
    text-align: right; 
    margin-top: 20px;
}
.pagination-link {
    margin: 0 5px;
    text-decoration: none;
    color: #333;
    border: 1px solid #ccc;
    padding: 5px 10px;
    border-radius: 5px;
}
.jump-input {
    width: 40px;
    padding: 2px;
    text-align: center;
}
.jump-button {
    padding: 2px 8px;
    background-color: #007bff;
    border: none;
    color: #fff;
    border-radius: 5px;
    cursor: pointer;
}
.jump-button:hover {
    background-color: #0056b3;
}




    </style>

<body>
  <section class="admin-main">
    <div class="container-fluid">
      <div class="page-container">
        <div class="card">
          <div class="card-body">
            <div class="card-title row"> <div style="padding:0 15px;">{$Title}</div>
              <div class="col-lg-8 col-md-12 col-sm-12">
                {foreach $PluginsAdminMenu as $Admin}
                  {if $Admin['custom']}
                    <span  class="ml-2"><a  class="h5" href="{$Admin.url}" target="_blank">{$Admin.name}</a></span>
                  {else/}
                    <span  class="ml-2"> <a  class="h5" href="{$Admin.url}">{$Admin.name}</a></span>
                  {/if}
                {/foreach}
              </div>
            </div>
    <table>
        <thead>
            <tr>
                <th class="center t1">ID</th>
                <th class="center">用户UID</th>
                <th class="center">用户名</th>
                <th class="center">邮件地址</th>
                
                <th class="center">申请时间</th>
                <th class="center">申请地址</th>
                <th class="center">注销协议</th>
                <th class="center">删除状态</th>
                <th class="center">执行时间</th>
            </tr>
        </thead>
        <tbody>
            {volist name='data' id='info'}
            <tr>
                <td class="center t1">{$info.id}</td>
                <td class="center"><span class="product-names-cell">{$info.user_id}</span></td>
                <td class="center">
                    <span class="username-cell"><span class="product-names-cell"><a href="{$domain}/#/customer-view/abstract?id={$info.user_id}">{$info.user_name}</span></span>
                </td>
                
                <td class="center">
                    <span class="product-names-cell">{$info.email}</span>
                </td>
                
                <td class="center">
                    <span class="product-names-cell">{:date('Y-m-d H:i:s',$info['apply_time'])}</span>
                </td>
                
                <td class="center">
                    <span class="product-names-cell">{$info.ip}</span>
                </td>
                
                <td class="discount-types">
                    {if $info.agree == '0'}
                    <span class="discount-label ali-discount">不同意</span>
                    {elseif $info.agree == '1'}
                    <span class="discount-label wx-discount">同意</span>
                    {else}
                    <span class="discount-label unknown-discount">未知类型</span>
                    {/if}
                </td>
                
                <td class="discount-types">
                    {if $info.status == '1'}
                    <span class="discount-label ali-discount">已执行</span>
                    {elseif $info.status == '2'}
                    <span class="discount-label wx-discount">取消申请</span>
                    {elseif $info.status == '0'}
                    <span class="discount-label qq-discount">待执行</span>
                    {else}
                    <span class="discount-label unknown-discount">未知类型</span>
                    {/if}
                </td>
                
                <td class="center">
                <span class="product-names-cell">
                    <?php
                    $audittime = $info['delete_time'];
                    if (!empty($audittime)) {
                        echo date('Y-m-d H:i:s', $audittime);
                    } else {
                        echo "待执行"; 
                    }
                    ?>
                    </span>
                </td>
                
            </tr>
            {/volist}
        </tbody>
        
    </table>
            
            <div class="pagination">
            当前页码：{$currentPage = $data->currentPage()}
            总页码：{$totalPages = $data->lastPage()}
            {if $currentPage > 1}
                <a href="{:shd_addon_url('DeleteUser://AdminIndex/lists')}&page={$currentPage - 1}&languagesys=CN" class="pagination-link">上一页</a>
            {/if}
            {if $currentPage < $totalPages}
                <a href="{:shd_addon_url('DeleteUser://AdminIndex/lists')}&page={$currentPage + 1}&languagesys=CN" class="pagination-link">下一页</a>
            {/if}
            <div>
                跳转到第
                <input type="number" id="jumpToPage" min="1" max="{$totalPages}" value="{$currentPage + 1}" style="width: 40px;"> 
                页
                <button onclick="jumpToPage()" class="jump-button">跳转</button> 
            </div>
        </div>
    </div>
</div>

</section>



<script>
    function jumpToPage() {
        var jumpInput = document.getElementById('jumpToPage');
        var targetPage = parseInt(jumpInput.value); 
        if (targetPage >= 1 && targetPage <= <?php echo $totalPages; ?>) {
            var targetUrl = "{:shd_addon_url('DeleteUser://AdminIndex/lists')}&page=" + targetPage;
            window.location.href = targetUrl;
        }
    }
</script>
    
</body>
</html>
